/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.cardview.widget.CardView;
import com.yy.appbase.R;

public class RadiusCardView
extends CardView {
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private float tlRadiu;
    private float trRadiu;
    private float brRadiu;
    private float blRadiu;
    private int borderWidth = 0;
    private int borderColor = -16777216;
    private final Path borderPath = new Path();
    private final RectF clipRectF = new RectF();

    public RadiusCardView(Context context) {
        this(context, null);
    }

    public RadiusCardView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.materialCardViewStyle);
    }

    public RadiusCardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setRadius(0.0f);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.RadiusCardView);
        this.tlRadiu = array.getDimension(R.styleable.RadiusCardView_rcv_topLeftRadius, 0.0f);
        this.trRadiu = array.getDimension(R.styleable.RadiusCardView_rcv_topRightRadius, 0.0f);
        this.brRadiu = array.getDimension(R.styleable.RadiusCardView_rcv_bottomRightRadius, 0.0f);
        this.blRadiu = array.getDimension(R.styleable.RadiusCardView_rcv_bottomLeftRadius, 0.0f);
        this.borderWidth = array.getDimensionPixelSize(R.styleable.RadiusCardView_rcv_border_width, 0);
        this.borderColor = array.getColor(R.styleable.RadiusCardView_rcv_border_color, -16777216);
        this.setBackground((Drawable)new ColorDrawable());
    }

    protected void onDraw(Canvas canvas) {
        Path path = new Path();
        RectF rectF = this.getRectF();
        float[] readius = new float[]{this.tlRadiu, this.tlRadiu, this.trRadiu, this.trRadiu, this.brRadiu, this.brRadiu, this.blRadiu, this.blRadiu};
        path.addRoundRect(rectF, readius, Path.Direction.CW);
        canvas.clipPath(path, Region.Op.INTERSECT);
        if (this.borderWidth > 0) {
            RectF clipRect = this.getClipRectF(rectF);
            canvas.save();
            this.borderPath.reset();
            this.borderPath.addRoundRect(clipRect, readius, Path.Direction.CW);
            canvas.clipPath(this.borderPath, Region.Op.DIFFERENCE);
            canvas.drawColor(this.borderColor);
            canvas.restore();
            canvas.clipPath(this.borderPath, Region.Op.INTERSECT);
        }
        super.onDraw(canvas);
    }

    public void setRadius(float tlRadiu, float trRadiu, float blRadiu, float brRadiu) {
        this.tlRadiu = tlRadiu;
        this.trRadiu = trRadiu;
        this.blRadiu = blRadiu;
        this.brRadiu = brRadiu;
        this.requestLayout();
    }

    private RectF getRectF() {
        Rect rect = new Rect();
        this.getDrawingRect(rect);
        RectF rectF = new RectF(rect);
        return rectF;
    }

    private RectF getClipRectF(RectF rectF) {
        this.clipRectF.set(rectF.left + (float)this.borderWidth, rectF.top + (float)this.borderWidth, rectF.right - (float)this.borderWidth, rectF.bottom - (float)this.borderWidth);
        return this.clipRectF;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.invalidate();
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.invalidate();
    }
}

