/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.appbase.R;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.ResolutionUtils;

public class MoveSpotLayout
extends YYRelativeLayout {
    private YYLinearLayout mLlytSpots;
    private YYImageView mIvSmoothSpot;
    private float mItemWidth;
    private int mLayoutPadding;
    private int mSpotHorizontalPadding = 5;
    private int mPhotoWallSpotResId = R.drawable.photo_wall_spot;

    public MoveSpotLayout(Context context) {
        this(context, null);
    }

    public MoveSpotLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        MoveSpotLayout.inflate((Context)context, (int)R.layout.layout_vp_move_spot, (ViewGroup)this);
        this.mLlytSpots = (YYLinearLayout)this.findViewById(R.id.llyt_spots);
        this.mIvSmoothSpot = (YYImageView)this.findViewById(R.id.iv_smooth_spot);
        this.mLayoutPadding = ResolutionUtils.dip2Px((float)5.0f);
        this.mLlytSpots.setPadding(this.mLayoutPadding, 0, this.mLayoutPadding, 0);
    }

    private YYImageView getSingleSpotImageView() {
        YYImageView imageView = new YYImageView(this.getContext());
        imageView.setImageResource(this.mPhotoWallSpotResId);
        imageView.setPadding(this.mSpotHorizontalPadding, 0, this.mSpotHorizontalPadding, 0);
        return imageView;
    }

    public void setSpotHorizontalPadding(int padding) {
        this.mSpotHorizontalPadding = padding;
    }

    public void setSpots(int spotCount, final int curItemPos) {
        if (spotCount == 1) {
            this.mIvSmoothSpot.setVisibility(8);
            this.mLlytSpots.removeAllViews();
            return;
        }
        this.mIvSmoothSpot.setVisibility(0);
        this.mLlytSpots.removeAllViews();
        for (int i = 0; i < spotCount; ++i) {
            YYImageView singleSpotImageView = this.getSingleSpotImageView();
            this.mLlytSpots.addView((View)singleSpotImageView);
        }
        this.mLlytSpots.post(new Runnable(){

            @Override
            public void run() {
                MoveSpotLayout.this.setMoveSpotPosition(curItemPos, 0.0f);
            }
        });
    }

    public void setMoveSpotPosition(int position, float positionOffset) {
        if (this.mLlytSpots.getChildCount() == 0) {
            return;
        }
        View childAt = this.mLlytSpots.getChildAt(0);
        if (childAt.getWidth() > 0) {
            this.mItemWidth = childAt.getWidth();
        }
        float left = this.mLayoutPadding;
        float leftMargin = left + this.mItemWidth * ((float)position + positionOffset) - ((float)this.mIvSmoothSpot.getWidth() - this.mItemWidth) / 2.0f;
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mIvSmoothSpot.getLayoutParams();
        params.leftMargin = Math.round(leftMargin);
        this.mIvSmoothSpot.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setSmoothSpotSelectRes(int resid) {
        this.mIvSmoothSpot.setImageResource(resid);
    }

    public void setSmoothSpotNormalRes(int resid) {
        this.mPhotoWallSpotResId = resid;
    }
}

