/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;

public class CustomImageSpan
extends ImageSpan {
    public static final int ALIGN_VERTICAL_CENTER = 2;
    public static final int ALIGN_TOP = 3;
    public float mMarginLeft = 0.0f;
    public float mMarginRight = 0.0f;
    public float mMargin = 0.0f;

    public CustomImageSpan(Drawable d, int verticalAlignment, float marginLeft, float marginRight) {
        super(d, verticalAlignment);
        this.mMarginLeft = marginLeft;
        this.mMarginRight = marginRight;
    }

    public CustomImageSpan(Drawable d, int verticalAlignment, float margin) {
        super(d, verticalAlignment);
        this.mMargin = margin;
    }

    public CustomImageSpan(Drawable d, float marginLeft, float marginRight) {
        super(d, 2);
        this.mMarginLeft = marginLeft;
        this.mMarginRight = marginRight;
    }

    public CustomImageSpan(Drawable d, float margin) {
        super(d, 2);
        this.mMargin = margin;
    }

    public CustomImageSpan(Context context, int resourceId) {
        super(context, resourceId, 2);
    }

    public CustomImageSpan(Drawable d) {
        super(d, 2);
    }

    public CustomImageSpan(Drawable d, String source) {
        super(d, source, 2);
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        Drawable d = this.getDrawable();
        Rect rect = d.getBounds();
        if (fm != null) {
            if (this.mVerticalAlignment == 2) {
                Paint.FontMetricsInt fmPaint = paint.getFontMetricsInt();
                int fontHeight = fmPaint.bottom - fmPaint.top;
                int drHeight = rect.bottom - rect.top;
                int top = drHeight / 2 - fontHeight / 4;
                int bottom = drHeight / 2 + fontHeight / 4;
                fm.ascent = -bottom;
                fm.top = -bottom;
                fm.bottom = top;
                fm.descent = top;
            } else {
                fm.ascent = -rect.bottom;
                fm.descent = 0;
                fm.top = fm.ascent;
                fm.bottom = 0;
            }
        }
        if (this.mMarginLeft == 0.0f && this.mMarginRight == 0.0f) {
            return (int)((float)rect.right + this.mMargin * 2.0f);
        }
        return (int)((float)rect.right + this.mMarginLeft + this.mMarginRight);
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        Drawable d = this.getDrawable();
        canvas.save();
        int transY = 0;
        if (this.mVerticalAlignment == 0) {
            transY = bottom - d.getBounds().bottom;
        } else if (this.mVerticalAlignment == 1) {
            transY -= paint.getFontMetricsInt().descent;
        } else if (this.mVerticalAlignment == 2) {
            transY = (bottom - top - d.getBounds().bottom) / 2 + top;
        } else if (this.mVerticalAlignment == 3) {
            transY = 0;
        }
        if (this.mMarginLeft == 0.0f && this.mMarginRight == 0.0f) {
            x += this.mMargin;
        }
        canvas.translate(x += this.mMarginLeft, (float)transY);
        d.draw(canvas);
        canvas.restore();
    }
}

