/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.appbase.data.MenuItemData;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import java.util.List;

public class CommonShareWidget
extends YYLinearLayout {
    private GridView mGridView;
    private TextView mTitle;
    private List<MenuItemData> mDatas;
    private ICallBack mCallBack;

    public CommonShareWidget(Context context, ICallBack callBack) {
        super(context);
        this.mCallBack = callBack;
        this.init();
    }

    private void init() {
        int leftPadding = ResourceUtils.getDimen((int)R.dimen.share_panel_left_padding);
        int titleTextSize = ResourceUtils.getDimen((int)R.dimen.share_panel_title_textsize);
        int titleBottomMargin = ResourceUtils.getDimen((int)R.dimen.share_panel_title_bottom_margin);
        int itemRightMargin = ResourceUtils.getDimen((int)R.dimen.share_panel_item_right_padding);
        int itemBottomMargin = ResourceUtils.getDimen((int)R.dimen.share_panel_item_bottom_padding);
        this.mGridView = new GridView(this.getContext());
        this.mTitle = new YYTextView(this.getContext());
        this.mTitle.setGravity(17);
        this.setOrientation(1);
        this.setPadding(leftPadding, leftPadding, leftPadding, leftPadding);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 1;
        layoutParams.bottomMargin = titleBottomMargin;
        this.mTitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 1;
        this.mGridView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mTitle.setTextSize(0, (float)titleTextSize);
        this.mTitle.setTextColor(ResourceUtils.getColor((int)this.mCallBack.getItemTextColor()));
        this.mGridView.setHorizontalSpacing(itemRightMargin);
        this.mGridView.setVerticalSpacing(itemBottomMargin);
        this.mGridView.setNumColumns(this.mCallBack.getNumColumns());
        this.mGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4) {
                MenuItemData data2;
                if (var2 instanceof TextView && (data2 = (MenuItemData)var2.getTag()) != null) {
                    CommonShareWidget.this.mCallBack.onItemClicked(data2.itemId);
                }
            }
        });
        this.setBackgroundColor(ResourceUtils.getColor((int)this.mCallBack.getBgColor()));
        this.addView((View)this.mTitle);
        this.addView((View)this.mGridView);
        this.mGridView.setAdapter((ListAdapter)new BaseAdapter(){

            public boolean areAllItemsEnabled() {
                return true;
            }

            public boolean isEnabled(int i) {
                return true;
            }

            public int getCount() {
                if (CommonShareWidget.this.mDatas != null) {
                    return CommonShareWidget.this.mDatas.size();
                }
                return 0;
            }

            public Object getItem(int i) {
                if (CommonShareWidget.this.mDatas != null && i < CommonShareWidget.this.mDatas.size()) {
                    CommonShareWidget.this.mDatas.get(i);
                }
                return null;
            }

            public long getItemId(int i) {
                return i;
            }

            public boolean hasStableIds() {
                return false;
            }

            public View getView(int i, View view, ViewGroup viewGroup) {
                if (CommonShareWidget.this.mDatas == null || CommonShareWidget.this.mDatas.size() == 0) {
                    return null;
                }
                if (view == null) {
                    view = CommonShareWidget.this.getItemView((MenuItemData)CommonShareWidget.this.mDatas.get(i));
                }
                CommonShareWidget.this.updateItem((MenuItemData)CommonShareWidget.this.mDatas.get(i), (TextView)view);
                return view;
            }

            public int getItemViewType(int i) {
                return 0;
            }

            public int getViewTypeCount() {
                return 1;
            }

            public boolean isEmpty() {
                return CommonShareWidget.this.mDatas == null || CommonShareWidget.this.mDatas.size() == 0;
            }
        });
        this.mGridView.setSelector((Drawable)new ColorDrawable(0));
    }

    private TextView getItemView(MenuItemData item) {
        int itemTextSize = ResourceUtils.getDimen((int)R.dimen.share_panel_item_textsize);
        YYTextView itemView = new YYTextView(this.getContext());
        itemView.setTextColor(ResourceUtils.getColor((int)this.mCallBack.getItemTextColor()));
        itemView.setTextSize(0, (float)itemTextSize);
        itemView.setGravity(1);
        return itemView;
    }

    private void updateItem(MenuItemData item, TextView view) {
        int iconBottomMargin = ResourceUtils.getDimen((int)R.dimen.share_panel_item_icon_bottom_margin);
        int itemHeight = ResourceUtils.getDimen((int)R.dimen.share_panel_item_icon_height);
        Drawable drawable2 = ResourceUtils.getDrawable((int)item.iconRes);
        drawable2.setBounds(0, 0, itemHeight, itemHeight);
        view.setCompoundDrawables(null, drawable2, null, null);
        view.setCompoundDrawablePadding(iconBottomMargin);
        view.setText((CharSequence)item.title);
        view.setTag((Object)item);
    }

    public void updateItems(List<MenuItemData> items, String title) {
        this.mDatas = items;
        this.mTitle.setText((CharSequence)title);
        ((BaseAdapter)this.mGridView.getAdapter()).notifyDataSetChanged();
    }

    public static interface ICallBack {
        public void onItemClicked(int var1);

        public int getNumColumns();

        public int getBgColor();

        public int getItemTextColor();
    }
}

