/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.webview;

import android.app.Dialog;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.yy.appbase.R;
import com.yy.appbase.ui.webview.WebViewPage;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;

public class WebViewBottomDialog
implements BaseDialog {
    private int mDialogHeight = ResolutionUtils.dip2Px((float)280.0f);
    private WebViewPage mWebViewPage;
    private String mUrl;

    public WebViewBottomDialog() {
    }

    public WebViewBottomDialog(int height) {
        this.mDialogHeight = height;
    }

    public void init(Dialog dialog) {
        this.initDialog(dialog);
        this.createView(dialog);
    }

    public int getId() {
        return 0;
    }

    private void initDialog(Dialog dialog) {
        Window dialogWindow = dialog.getWindow();
        WindowManager.LayoutParams dialogLp = dialogWindow.getAttributes();
        dialogLp.gravity = 80;
        dialogLp.width = -1;
        dialogLp.height = this.mDialogHeight;
        dialogWindow.setAttributes(dialogLp);
        dialogWindow.getDecorView().setPadding(0, 0, 0, 0);
        dialogWindow.setWindowAnimations(R.style.bottom_dialog_anim);
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (WebViewBottomDialog.this.mWebViewPage != null) {
                    WebViewBottomDialog.this.mWebViewPage.destroy();
                }
            }
        });
    }

    private void createView(Dialog dialog) {
        this.mWebViewPage = new WebViewPage(dialog.getContext());
        if (!FP.empty((CharSequence)this.mUrl)) {
            this.mWebViewPage.setData("", this.mUrl);
        }
        ViewGroup.LayoutParams contentLp = new ViewGroup.LayoutParams(-1, -1);
        dialog.setContentView((View)this.mWebViewPage, contentLp);
    }

    public void setUrl(String url) {
        this.mUrl = url;
        if (this.mWebViewPage != null) {
            this.mWebViewPage.setData("", url);
        }
    }
}

