/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.press;

import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.FloatRange;

public class PressAlpha {
    public static void of(View view) {
        PressAlpha.of(view, 0.5f);
    }

    public static void of(View ... views) {
        for (View v : views) {
            PressAlpha.of(v, 0.5f);
        }
    }

    public static void of(final View view, final @FloatRange(from=0.0, to=1.0) float pressAlpha) {
        if (null == view) {
            return;
        }
        view.setOnTouchListener(new View.OnTouchListener(){
            final float from = 1.0f;
            final float to = pressAlpha;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        view.setAlpha(this.to);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        view.setAlpha(1.0f);
                    }
                }
                return false;
            }
        });
    }

    public static void cancel(View view) {
        view.setOnTouchListener(null);
    }
}

