/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.text.Html;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.appbase.span.SpannableUtils;
import com.yy.appbase.ui.dialog.OkDialogListener;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;

public class OkDialog
implements BaseDialog {
    private CharSequence message;
    private CharSequence okLabel;
    private int okLabelColor = 0;
    private boolean isHtmlText = false;
    private boolean cancelable;
    private boolean canceledOnClickOutside;
    private OkDialogListener listener;
    private DialogInterface.OnCancelListener cancelListener;
    private boolean mIsOkAutoDismiss = true;
    private boolean showCancel = true;
    private String mTitle = null;
    private String mOkText = null;
    private TextView mCancel;

    public OkDialog(CharSequence message, CharSequence okLabel, int okLabelColor, boolean isHtmlText, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener listener2, boolean isOkAutoDismiss) {
        this.message = message;
        this.okLabel = okLabel;
        this.okLabelColor = okLabelColor;
        this.isHtmlText = isHtmlText;
        this.cancelable = cancelable;
        this.canceledOnClickOutside = canceledOnClickOutside;
        this.listener = listener2;
        this.mIsOkAutoDismiss = isOkAutoDismiss;
    }

    public OkDialog(CharSequence message, OkDialogListener listener2) {
        this(message, "", 0, false, false, false, listener2, true);
    }

    public OkDialog(CharSequence message, boolean cancelable, OkDialogListener listener2) {
        this(message, "", 0, false, cancelable, false, listener2, true);
    }

    public OkDialog(CharSequence message, boolean isHtmlText, boolean cancelable, OkDialogListener listener2) {
        this(message, "", 0, isHtmlText, cancelable, true, listener2, true);
    }

    public OkDialog(CharSequence message, boolean isHtmlText, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener listener2) {
        this(message, "", 0, isHtmlText, cancelable, canceledOnClickOutside, listener2, true);
    }

    public OkDialog(CharSequence message, CharSequence okLabel, int okLabelColor, boolean cancelable, OkDialogListener listener2) {
        this(message, okLabel, okLabelColor, false, cancelable, cancelable, listener2, true);
    }

    public OkDialog(CharSequence message, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener listener2, boolean isHtmlText) {
        this(message, "", 0, isHtmlText, cancelable, canceledOnClickOutside, listener2, true);
    }

    public OkDialog(CharSequence message, boolean cancelable, OkDialogListener listener2, boolean isOkAutoDismiss) {
        this(message, "", 0, false, cancelable, false, listener2, isOkAutoDismiss);
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setOkListener(OkDialogListener listener2) {
        this.listener = listener2;
    }

    public void setOkText(String okText) {
        this.mOkText = okText;
    }

    public void setCancleListener(DialogInterface.OnCancelListener listener2) {
        this.cancelListener = listener2;
    }

    public void setShowCancel(boolean show2) {
        this.showCancel = show2;
        if (this.mCancel != null) {
            this.mCancel.setVisibility(show2 ? 0 : 8);
        }
    }

    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.canceledOnClickOutside);
        dialog.show();
        Window window = dialog.getWindow();
        window.setContentView(R.layout.layout_ok_dialog);
        TextView title = (TextView)window.findViewById(R.id.title);
        TextView msg = (TextView)window.findViewById(R.id.message);
        if (this.isHtmlText && this.message instanceof String && !TextUtils.isEmpty((CharSequence)this.message)) {
            msg.setText((CharSequence)Html.fromHtml((String)((String)this.message)));
            msg.setMovementMethod(LinkMovementMethod.getInstance());
            SpannableUtils.setUrlSpans(msg);
        } else if (!TextUtils.isEmpty((CharSequence)this.message)) {
            msg.setText(this.message);
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (this.okLabelColor != 0) {
            ok.setTextColor(this.okLabelColor);
        }
        if (StringUtils.isNotEmpty((String)this.mOkText)) {
            ok.setText((CharSequence)this.mOkText);
        } else if (!TextUtils.isEmpty((CharSequence)this.okLabel)) {
            ok.setText(this.okLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OkDialog.this.mIsOkAutoDismiss) {
                    dialog.dismiss();
                }
                if (OkDialog.this.listener != null) {
                    OkDialog.this.listener.onOk();
                }
            }
        });
        if (this.cancelListener != null) {
            dialog.setOnCancelListener(this.cancelListener);
        }
        this.mCancel = (TextView)dialog.findViewById(R.id.btn_cancel);
        if (this.cancelListener != null) {
            this.mCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    OkDialog.this.cancelListener.onCancel((DialogInterface)dialog);
                }
            });
        }
        if (StringUtils.isNotEmpty((String)this.mTitle)) {
            title.setText((CharSequence)this.mTitle);
            title.setVisibility(0);
        } else {
            title.setText((CharSequence)"");
            title.setVisibility(8);
        }
        this.mCancel.setVisibility(this.showCancel ? 0 : 8);
    }

    public int getId() {
        return DialogId.normalOkDialog;
    }
}

