/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Build;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;

public class OkCancelTitleDialog
implements BaseDialog {
    private CharSequence title = "";
    private CharSequence message;
    private CharSequence okLabel;
    private int okLabelColor = 0;
    private CharSequence cancelLabel;
    private int cancelLabelColor = 0;
    private float lineSpacingExtra = -1.0f;
    private float lineSpacingMultiplier = -1.0f;
    private boolean cancelable;
    private boolean outSideCancelable;
    private boolean isNeedCenter = false;
    boolean withCloseBtn = false;
    private OkCancelDialogListener listener;
    private DialogInterface.OnCancelListener cancelListener;
    private View.OnClickListener closeBtnListener;
    private View mMessageView;
    private int singleLine;
    private Dialog mDialog;

    public OkCancelTitleDialog(Builder builder) {
        this.title = builder.title;
        this.message = builder.message;
        this.okLabel = builder.okLabel;
        this.okLabelColor = builder.okLabelColor;
        this.cancelLabel = builder.cancelLabel;
        this.cancelLabelColor = builder.cancelLabelColor;
        this.lineSpacingExtra = builder.lineSpacingExtra;
        this.lineSpacingMultiplier = builder.lineSpacingMultiplier;
        this.cancelable = builder.cancelable;
        this.outSideCancelable = builder.outSideCancelable;
        this.isNeedCenter = builder.isNeedCenter;
        this.listener = builder.listener;
        this.withCloseBtn = builder.withCloseBtn;
        this.closeBtnListener = builder.closeBtnListener;
        this.cancelListener = builder.cancelListener;
        this.mMessageView = builder.mMessageView;
        this.singleLine = builder.singleLine;
    }

    public void init(final Dialog dialog) {
        this.mDialog = dialog;
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.outSideCancelable);
        Window window = dialog.getWindow();
        window.setContentView(R.layout.layout_title_ok_dialog);
        TextView titleView = (TextView)window.findViewById(R.id.title);
        if (this.mMessageView != null) {
            YYLinearLayout messageLayout = (YYLinearLayout)window.findViewById(R.id.linear_message);
            messageLayout.removeAllViews();
            messageLayout.addView(this.mMessageView);
        } else {
            TextView tip = (TextView)window.findViewById(R.id.message);
            tip.setMovementMethod(LinkMovementMethod.getInstance());
            if (this.lineSpacingExtra != -1.0f && this.lineSpacingMultiplier != -1.0f) {
                tip.setLineSpacing(this.lineSpacingExtra, this.lineSpacingMultiplier);
            }
            if (!TextUtils.isEmpty((CharSequence)this.message)) {
                tip.setText(this.message);
            }
            if (this.isNeedCenter) {
                tip.setGravity(17);
            } else {
                tip.setGravity(0x800003);
                if (Build.VERSION.SDK_INT >= 17) {
                    tip.setTextAlignment(5);
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            titleView.setVisibility(0);
            titleView.setText(this.title);
            titleView.setSingleLine(this.singleLine == 0);
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (this.okLabelColor != 0) {
            ok.setTextColor(this.okLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.okLabel)) {
            ok.setText(this.okLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (OkCancelTitleDialog.this.listener != null) {
                    OkCancelTitleDialog.this.listener.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        if (this.cancelLabelColor != 0) {
            cancel.setTextColor(this.cancelLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.cancelLabel)) {
            cancel.setText(this.cancelLabel);
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (OkCancelTitleDialog.this.listener != null) {
                    OkCancelTitleDialog.this.listener.onCancel();
                }
            }
        });
        if (this.withCloseBtn) {
            RecycleImageView closeBtn = (RecycleImageView)window.findViewById(R.id.close_icon);
            closeBtn.setVisibility(0);
            closeBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dialog.dismiss();
                    if (OkCancelTitleDialog.this.closeBtnListener != null) {
                        OkCancelTitleDialog.this.closeBtnListener.onClick(v);
                    }
                }
            });
        }
        dialog.setOnCancelListener(this.cancelListener);
    }

    public void hide() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    public int getId() {
        return DialogId.normalOkCancelDialog;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        CharSequence title;
        CharSequence message;
        CharSequence okLabel;
        int okLabelColor = 0;
        CharSequence cancelLabel;
        int cancelLabelColor = 0;
        float lineSpacingExtra = -1.0f;
        float lineSpacingMultiplier = -1.0f;
        boolean cancelable = true;
        boolean outSideCancelable;
        boolean isNeedCenter = true;
        boolean withCloseBtn = false;
        OkCancelDialogListener listener;
        View.OnClickListener closeBtnListener;
        DialogInterface.OnCancelListener cancelListener;
        int singleLine;
        View mMessageView;

        public Builder title(CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder message(CharSequence message) {
            this.message = message;
            return this;
        }

        public Builder okLabel(CharSequence okLabel) {
            this.okLabel = okLabel;
            return this;
        }

        public Builder okLabelColor(int okLabelColor) {
            this.okLabelColor = okLabelColor;
            return this;
        }

        public Builder setCancelLabel(CharSequence cancelLabel) {
            this.cancelLabel = cancelLabel;
            return this;
        }

        public Builder cancelLabelColor(int cancelLabelColor) {
            this.cancelLabelColor = cancelLabelColor;
            return this;
        }

        public Builder lineSpacingExtra(float lineSpacingExtra) {
            this.lineSpacingExtra = lineSpacingExtra;
            return this;
        }

        public Builder lineSpacingMultiplier(float lineSpacingMultiplier) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            return this;
        }

        public Builder cancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder outSideCancelable(boolean outSideCancelable) {
            this.outSideCancelable = outSideCancelable;
            return this;
        }

        public Builder needCenter(boolean needCenter) {
            this.isNeedCenter = needCenter;
            return this;
        }

        public Builder withCloseBtn(boolean withCloseBtn) {
            this.withCloseBtn = withCloseBtn;
            return this;
        }

        public Builder listener(OkCancelDialogListener listener2) {
            this.listener = listener2;
            return this;
        }

        public Builder closeBtnListener(View.OnClickListener listener2) {
            this.closeBtnListener = listener2;
            return this;
        }

        public Builder cancelListener(DialogInterface.OnCancelListener listener2) {
            this.cancelListener = listener2;
            return this;
        }

        public Builder setMessageView(View messageView) {
            this.mMessageView = messageView;
            return this;
        }

        public Builder setSingleLine(int singleLine) {
            this.singleLine = singleLine;
            return this;
        }

        public OkCancelTitleDialog build() {
            return new OkCancelTitleDialog(this);
        }
    }
}

