/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListView;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;

public class CommonPickerListView
extends ListView
implements AbsListView.OnScrollListener {
    private static final int DEFAULT_SHOW_COUNT = 3;
    private static final int DEFAULT_SHADER_HEIGHT = 100;
    private Paint paintLine;
    private Paint paintShader;
    private LinearGradient shaderTop;
    private LinearGradient shaderBottom;
    private boolean hasInit = false;
    private int mLineHeight = 6;
    private int mLinePadding = ResolutionUtils.dip2Px((float)15.0f);
    private int mLineColor = ResourceUtils.getColor((int)R.color.date_packer_ok);
    private float mScrollOffset = 0.75f;
    private int mShowCount = 3;
    private int shaderHeight = 100;
    private int mCenterTextSize = 18;
    private int mOtherTextSize = 18;
    private int mCenterTextColor = ResourceUtils.getColor((int)R.color.black);
    private int mOtherTextColor = ResourceUtils.getColor((int)R.color.txt_color_four);

    public CommonPickerListView(Context context) {
        this(context, null);
    }

    public CommonPickerListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CommonPickerListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
        this.setOnScrollListener(this);
        this.paintLine = new Paint();
        this.paintLine.setStrokeWidth((float)this.mLineHeight);
        this.paintLine.setColor(this.mLineColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        if (context == null || attrs == null || context.getTheme() == null) {
            return;
        }
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CommonPickerListView, defStyleAttr, 0);
        if (attributes == null) {
            return;
        }
        try {
            this.mLineHeight = attributes.getDimensionPixelSize(R.styleable.CommonPickerListView_pickerLineHeight, 6);
            this.mLineColor = attributes.getColor(R.styleable.CommonPickerListView_pickerLineColor, ResourceUtils.getColor((int)R.color.date_packer_ok));
            this.mScrollOffset = attributes.getFloat(R.styleable.CommonPickerListView_pickerItemScrollOffset, 0.75f);
            this.mShowCount = attributes.getInteger(R.styleable.CommonPickerListView_pickerShowCount, 3);
            this.shaderHeight = attributes.getDimensionPixelSize(R.styleable.CommonPickerListView_pickerShaderHeight, 100);
            this.mCenterTextSize = attributes.getInteger(R.styleable.CommonPickerListView_pickerCenterTextSize, 18);
            this.mOtherTextSize = attributes.getInteger(R.styleable.CommonPickerListView_pickerOtherTextSize, 18);
            this.mCenterTextColor = attributes.getColor(R.styleable.CommonPickerListView_pickerCenterTextColor, ResourceUtils.getColor((int)R.color.black));
            this.mOtherTextColor = attributes.getColor(R.styleable.CommonPickerListView_pickerOtherTextColor, ResourceUtils.getColor((int)R.color.txt_color_four));
            this.mLinePadding = attributes.getDimensionPixelSize(R.styleable.CommonPickerListView_pickerLinePadding, ResolutionUtils.dip2Px((float)15.0f));
        }
        catch (Exception e) {
            MLog.error((Object)"PickerListView", (String)e.toString(), (Object[])new Object[0]);
        }
        finally {
            attributes.recycle();
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState == 0 && view instanceof ListView) {
            int b;
            int a = 0 - view.getChildAt(0).getTop();
            float f = (float)a / (float)(b = view.getMeasuredHeight() / this.mShowCount);
            if (f < this.mScrollOffset) {
                view.setSelection(view.getFirstVisiblePosition());
            }
            if (f >= this.mScrollOffset && f < 1.0f) {
                view.setSelection(view.getFirstVisiblePosition() + 1);
            }
        }
    }

    @SuppressLint(value={"ResourceAsColor"})
    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (view instanceof ListView) {
            for (int i = 0; i < view.getChildCount(); ++i) {
                TextView textView = null;
                View child = view.getChildAt(i);
                if (child instanceof TextView) {
                    textView = (TextView)child;
                } else if (child instanceof ViewGroup) {
                    textView = (TextView)((ViewGroup)child).getChildAt(0);
                }
                if (textView == null) continue;
                int height1 = child.getHeight() / 2;
                int height2 = view.getHeight() / this.mShowCount;
                if ((double)(child.getY() + (float)height1) > (double)height2 * this.getCenterFloor() && (double)(child.getY() + (float)height1) < (double)height2 * this.getCenterCeil()) {
                    textView.setTextColor(this.mCenterTextColor);
                    textView.setTextSize((float)this.mCenterTextSize);
                    continue;
                }
                textView.setTextColor(this.mOtherTextColor);
                textView.setTextSize((float)this.mOtherTextSize);
            }
        }
    }

    private double getCenterFloor() {
        return Math.floor((double)this.mShowCount / 2.0);
    }

    private double getCenterCeil() {
        return Math.ceil((double)this.mShowCount / 2.0);
    }

    private float getTopLineY() {
        return (float)((double)(this.getHeight() / this.mShowCount) * this.getCenterFloor());
    }

    private float getBottomLineY() {
        return (float)((double)(this.getHeight() / this.mShowCount) * this.getCenterCeil());
    }

    private void initFirst() {
        if (!this.hasInit) {
            this.paintShader = new Paint();
            this.paintShader.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            this.shaderTop = new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.shaderHeight, -16777216, 0, Shader.TileMode.CLAMP);
            this.shaderBottom = new LinearGradient(0.0f, (float)(this.getHeight() - this.shaderHeight), 0.0f, (float)this.getHeight(), 0, -16777216, Shader.TileMode.CLAMP);
            this.hasInit = true;
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public void draw(Canvas canvas) {
        this.initFirst();
        canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
        super.draw(canvas);
        this.paintShader.setShader((Shader)this.shaderTop);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.shaderHeight, this.paintShader);
        this.paintShader.setShader((Shader)this.shaderBottom);
        canvas.drawRect(0.0f, (float)(this.getHeight() - this.shaderHeight), (float)this.getWidth(), (float)this.getHeight(), this.paintShader);
        canvas.drawLine((float)this.mLinePadding, this.getTopLineY(), (float)(this.getWidth() - this.mLinePadding), this.getTopLineY(), this.paintLine);
        canvas.drawLine((float)this.mLinePadding, this.getBottomLineY(), (float)(this.getWidth() - this.mLinePadding), this.getBottomLineY(), this.paintLine);
    }

    public void setShowCount(int showCount) {
        this.mShowCount = showCount;
    }

    public void setTransSelection(Long position, int listSize) {
        if (listSize > 0) {
            int d = 0x3FFFFFFF / listSize;
            int transPosition = (int)(position + (long)(d * listSize) - (long)(this.mShowCount / 2));
            this.setSelection(transPosition);
        }
    }

    public int getSelectedPosition(int listSize) {
        return this.getRealSelectedPosition(this.getFirstVisiblePosition(), listSize);
    }

    int getRealSelectedPosition(int position, int listSize) {
        int realPosition = position % listSize + this.mShowCount / 2;
        if (realPosition > listSize - 1) {
            return realPosition % listSize;
        }
        return realPosition;
    }
}

