/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Message;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.Window;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.yy.appbase.R;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.ui.dialog.MsgLeadingMarginSpan;
import com.yy.appbase.ui.webview.WebViewPage;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ReportAppealBean;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;

public class AppealDialog
implements BaseDialog {
    Context mActivity;
    private YYTextView mEditNumber;
    private YYTextView mBtnAppeal;
    private int mMaxEms = 120;
    private String roomId;
    private int mType = -1;
    private String mSerail;
    private YYRelativeLayout rl1;
    private YYRelativeLayout rl2;
    private CheckBox mCheckBox;
    private YYTextView tvTitle;
    private YYTextView tvCountDown;
    private YYTextView tvCancel;
    private YYTextView tvOk;
    private RadioGroup rgCheck;
    private boolean hasReadWebview = false;
    private int mCountDown = 6;
    private Runnable countDownRunnable;
    private boolean hasChooseType = false;
    private RadioButton checckBtn;
    private String token;
    public static final String REPORT_FEEDBACK_SUBMIT = "/inform_against/appeal";

    public void setToken(String token) {
        this.token = token;
    }

    public AppealDialog(Context activity) {
        this.mActivity = activity;
    }

    public void init(final Dialog dialog) {
        Window window = dialog.getWindow();
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        if (window == null) {
            return;
        }
        window.setContentView(R.layout.layout_appeal_dialog);
        window.clearFlags(131072);
        window.setSoftInputMode(4);
        final YYEditText editText = (YYEditText)window.findViewById(R.id.edit_appeal);
        this.mBtnAppeal = (YYTextView)window.findViewById(R.id.tv_confirm);
        this.mBtnAppeal.setText((CharSequence)ResourceUtils.getString((int)R.string.login_phone_window_next_btn));
        WebViewPage wp = (WebViewPage)window.findViewById(R.id.webview);
        wp.setData("", UriProvider.getRulesAndPolicies("") + "&notitle=1");
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"beforeTextChanged", (String)("beforeTextChanged \u88ab\u6267\u884c----> s=" + s + "----start=" + start + "----after=" + after + "----count" + count), (Object[])new Object[0]);
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"onTextChanged", (String)("onTextChanged \u88ab\u6267\u884c---->s=" + s + "----start=" + start + "----before=" + before + "----count" + count), (Object[])new Object[0]);
                }
            }

            public void afterTextChanged(Editable editable) {
                String content = editable.toString();
                if (!AppealDialog.this.hasChooseType) {
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)content)) {
                    AppealDialog.this.mBtnAppeal.setEnabled(false);
                } else {
                    AppealDialog.this.mBtnAppeal.setEnabled(true);
                }
                if (content.length() >= AppealDialog.this.mMaxEms) {
                    ImeUtil.hideIME((Context)AppealDialog.this.mActivity, (View)editText);
                }
            }
        });
        this.mBtnAppeal.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!AppealDialog.this.hasReadWebview) {
                    AppealDialog.this.hasReadWebview = true;
                    AppealDialog.this.tvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.title_appeal_description));
                    AppealDialog.this.rl1.setVisibility(8);
                    AppealDialog.this.rl2.setVisibility(0);
                    AppealDialog.this.mBtnAppeal.setEnabled(false);
                    AppealDialog.this.mBtnAppeal.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_submit));
                    return;
                }
                ImeUtil.hideIME((Context)view.getContext(), (View)view);
                dialog.dismiss();
                if (AppealDialog.this.mType != -1) {
                    AppealDialog.this.sendUploadReq(AppealDialog.this.getDesc((EditText)editText), AppealDialog.this.mSerail, AppealDialog.this.mType);
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)AppealDialog.this.roomId)) {
                    AppealDialog.this.sendUploadReq(AppealDialog.this.getDesc((EditText)editText), 1);
                } else {
                    AppealDialog.this.sendUploadReq(AppealDialog.this.getDesc((EditText)editText), 2, AppealDialog.this.roomId);
                }
            }
        });
        window.findViewById(R.id.iv_close).setOnClickListener(view -> dialog.dismiss());
        window.findViewById(R.id.tv_cancel).setOnClickListener(view -> dialog.dismiss());
        this.tvTitle = (YYTextView)window.findViewById(R.id.tv_title);
        this.tvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.title_hago_rules));
        this.rl1 = (YYRelativeLayout)window.findViewById(R.id.rl_p1);
        this.rl2 = (YYRelativeLayout)window.findViewById(R.id.rl_p2);
        this.rl2.setVisibility(8);
        this.mCheckBox = (CheckBox)window.findViewById(R.id.cb_check);
        this.mCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                AppealDialog.this.mBtnAppeal.setEnabled(b);
            }
        });
        this.mCheckBox.setEnabled(false);
        this.tvCountDown = (YYTextView)window.findViewById(R.id.tv_agree);
        this.countDownRunnable = () -> {
            String title;
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.countDownRunnable);
            --this.mCountDown;
            if (this.mCountDown > 0) {
                title = ResourceUtils.getString((int)R.string.title_agree_rule, (Object[])new Object[]{" (" + this.mCountDown + ResourceUtils.getString((int)R.string.title_seconds) + ")"});
                YYTaskExecutor.postToMainThread((Runnable)this.countDownRunnable, (long)1000L);
            } else {
                title = ResourceUtils.getString((int)R.string.title_agree_rule, (Object[])new Object[]{""});
                this.mCheckBox.setEnabled(true);
            }
            SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)title);
            MsgLeadingMarginSpan standard = new MsgLeadingMarginSpan(1, ResolutionUtils.dip2Px((float)20.0f));
            int end = builder.length();
            builder.setSpan((Object)standard, 0, end, 17);
            this.tvCountDown.setText((CharSequence)builder);
        };
        YYTaskExecutor.postToMainThread((Runnable)this.countDownRunnable);
        this.rgCheck = (RadioGroup)window.findViewById(R.id.rg);
        final RadioButton rb1 = (RadioButton)window.findViewById(R.id.rb1);
        final RadioButton rb2 = (RadioButton)window.findViewById(R.id.rb2);
        final RadioButton rb3 = (RadioButton)window.findViewById(R.id.rb3);
        this.rgCheck.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int i) {
                AppealDialog.this.hasChooseType = true;
                if (i == R.id.rb1) {
                    AppealDialog.this.checckBtn = rb1;
                } else if (i == R.id.rb2) {
                    AppealDialog.this.checckBtn = rb2;
                } else if (i == R.id.rb3) {
                    AppealDialog.this.checckBtn = rb3;
                }
                if (StringUtils.isNotEmpty((String)editText.getEditableText().toString())) {
                    AppealDialog.this.mBtnAppeal.setEnabled(true);
                }
            }
        });
        this.mBtnAppeal.setEnabled(false);
    }

    private String getDesc(EditText editText) {
        return StringUtils.formatWitUSLocal((String)"%1$s|%2$s", (Object[])new Object[]{this.checckBtn != null ? this.checckBtn.getText() : "", editText.getText().toString()});
    }

    private void sendUploadReq(String describe, String serial, int type2) {
        ReportAppealBean appealBean = new ReportAppealBean(type2, describe, serial);
        appealBean.setToken(this.token);
        Message message = new Message();
        message.obj = appealBean;
        message.what = BaseMsgDef.APPEAL_EVENT;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public void sendUploadReq(String describe, int type2) {
        ReportAppealBean appealBean = new ReportAppealBean("", describe, "", type2, "");
        appealBean.setToken(this.token);
        Message message = new Message();
        message.obj = appealBean;
        message.what = BaseMsgDef.APPEAL_EVENT;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public void sendUploadReq(String describe, int type2, String roomId) {
        ReportAppealBean appealBean = new ReportAppealBean("", describe, "", type2, roomId);
        appealBean.setToken(this.token);
        Message message = new Message();
        message.obj = appealBean;
        message.what = BaseMsgDef.APPEAL_EVENT;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setType(int type2) {
        this.mType = type2;
    }

    public void setSerial(String serial) {
        this.mSerail = serial;
    }

    public int getId() {
        return 0;
    }

    public static interface IAppeatCallBack {
        public void success();

        public void onError(int var1, String var2);
    }
}

