/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.country;

import android.content.Context;
import com.yy.appbase.ui.country.CountryHelper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import java.util.List;
import java.util.Locale;

public class CountryData {
    public String countryName;
    public String countryCode;
    private static CountryData sData;

    public static CountryData getDefault() {
        if (sData != null) {
            return sData;
        }
        String country = null;
        try {
            country = SystemServiceUtils.getTelephonyManager((Context)RuntimeContext.sApplicationContext).getSimCountryIso();
            MLog.info((Object)"CountryData", (String)country, (Object[])new Object[0]);
        }
        catch (Exception e) {
            MLog.error((Object)"CountryData", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)country)) {
            try {
                country = SystemServiceUtils.getTelephonyManager((Context)RuntimeContext.sApplicationContext).getNetworkCountryIso();
                MLog.info((Object)"CountryData", (String)country, (Object[])new Object[0]);
            }
            catch (Exception e) {
                MLog.error((Object)"CountryData", (Throwable)e);
            }
        }
        CountryData data2 = new CountryData();
        if (StringUtils.isEmpty((String)country)) {
            country = Locale.getDefault().getCountry();
        }
        if (StringUtils.isNotEmpty((String)country)) {
            if (StringUtils.equalsIgnoreCase((String)country, (String)"ID")) {
                data2.countryName = "ID";
                data2.countryCode = "62";
            } else if (StringUtils.equalsIgnoreCase((String)country, (String)"IN")) {
                data2.countryName = "IN";
                data2.countryCode = "91";
            } else if (StringUtils.equalsIgnoreCase((String)country, (String)"CN")) {
                data2.countryName = "CN";
                data2.countryCode = "86";
            } else {
                CountryHelper.CountryInfo result = null;
                List<CountryHelper.CountryInfo> infos = CountryHelper.getAllCountryList();
                if (infos != null && infos.size() > 0) {
                    for (CountryHelper.CountryInfo info : infos) {
                        if (info == null || info.isIndex || !StringUtils.equals((String)info.code, (String)country.toUpperCase())) continue;
                        result = info;
                        break;
                    }
                }
                if (result != null && StringUtils.isNotEmpty((String)result.code) && StringUtils.isNotEmpty((String)result.numberCode)) {
                    data2.countryName = result.code;
                    data2.countryCode = result.numberCode;
                } else {
                    data2.countryName = "ID";
                    data2.countryCode = "62";
                }
            }
        } else {
            data2.countryName = "ID";
            data2.countryCode = "62";
        }
        sData = data2;
        return data2;
    }
}

