/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.animator;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.Interpolator;
import com.yy.base.imageloader.view.RecycleImageView;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ.\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n\u00a8\u0006\u0010"}, d2={"Lcom/yy/appbase/ui/animator/AnimatorUtils;", "", "()V", "getScaleAnimatorSet", "Landroid/animation/AnimatorSet;", "targetView", "Lcom/yy/base/imageloader/view/RecycleImageView;", "value", "", "duration", "", "interpolator", "Landroid/view/animation/Interpolator;", "delay", "getViewScaleAnimator", "Landroid/view/View;", "appbase_release"})
public final class AnimatorUtils {
    public static final AnimatorUtils INSTANCE;

    @NotNull
    public final AnimatorSet getScaleAnimatorSet(@NotNull RecycleImageView targetView, @NotNull float[] value, long duration, @NotNull Interpolator interpolator) {
        Intrinsics.checkParameterIsNotNull((Object)targetView, (String)"targetView");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
        return this.getScaleAnimatorSet(targetView, value, duration, interpolator, 0L);
    }

    @NotNull
    public final AnimatorSet getScaleAnimatorSet(@NotNull RecycleImageView targetView, @NotNull float[] value, long duration, @NotNull Interpolator interpolator, long delay) {
        Intrinsics.checkParameterIsNotNull((Object)targetView, (String)"targetView");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
        ObjectAnimator XAnimator = ObjectAnimator.ofFloat((Object)targetView, (String)"scaleX", (float[])Arrays.copyOf(value, value.length));
        ObjectAnimator YAnimator = ObjectAnimator.ofFloat((Object)targetView, (String)"scaleY", (float[])Arrays.copyOf(value, value.length));
        ObjectAnimator objectAnimator = XAnimator;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator, (String)"XAnimator");
        objectAnimator.setInterpolator((TimeInterpolator)interpolator);
        XAnimator.setDuration(duration);
        ObjectAnimator objectAnimator2 = YAnimator;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator2, (String)"YAnimator");
        objectAnimator2.setInterpolator((TimeInterpolator)interpolator);
        YAnimator.setDuration(duration);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setStartDelay(delay);
        animatorSet.play((Animator)XAnimator).with((Animator)YAnimator);
        animatorSet.addListener(new Animator.AnimatorListener(targetView, animatorSet, XAnimator, YAnimator){
            final /* synthetic */ RecycleImageView $targetView;
            final /* synthetic */ AnimatorSet $animatorSet;
            final /* synthetic */ ObjectAnimator $XAnimator;
            final /* synthetic */ ObjectAnimator $YAnimator;

            public void onAnimationRepeat(@Nullable Animator animation) {
            }

            public void onAnimationEnd(@Nullable Animator animation) {
                this.$targetView.setVisibility(8);
                if (this.$targetView.isAttachToWindow()) {
                    this.$animatorSet.start();
                } else {
                    this.$XAnimator.cancel();
                    this.$YAnimator.cancel();
                    this.$targetView.clearAnimation();
                    this.$animatorSet.removeAllListeners();
                    this.$animatorSet.cancel();
                }
            }

            public void onAnimationCancel(@Nullable Animator animation) {
            }

            public void onAnimationStart(@Nullable Animator animation) {
                this.$targetView.setVisibility(0);
            }
            {
                this.$targetView = $captured_local_variable$0;
                this.$animatorSet = $captured_local_variable$1;
                this.$XAnimator = $captured_local_variable$2;
                this.$YAnimator = $captured_local_variable$3;
            }
        });
        return animatorSet;
    }

    @NotNull
    public final AnimatorSet getViewScaleAnimator(@NotNull View targetView, @NotNull float[] value, long duration, @NotNull Interpolator interpolator, long delay) {
        Intrinsics.checkParameterIsNotNull((Object)targetView, (String)"targetView");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
        ObjectAnimator XAnimator = ObjectAnimator.ofFloat((Object)targetView, (String)"scaleX", (float[])Arrays.copyOf(value, value.length));
        ObjectAnimator YAnimator = ObjectAnimator.ofFloat((Object)targetView, (String)"scaleY", (float[])Arrays.copyOf(value, value.length));
        ObjectAnimator objectAnimator = XAnimator;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator, (String)"XAnimator");
        objectAnimator.setInterpolator((TimeInterpolator)interpolator);
        XAnimator.setDuration(duration);
        ObjectAnimator objectAnimator2 = YAnimator;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator2, (String)"YAnimator");
        objectAnimator2.setInterpolator((TimeInterpolator)interpolator);
        YAnimator.setDuration(duration);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setStartDelay(delay);
        animatorSet.play((Animator)XAnimator).with((Animator)YAnimator);
        return animatorSet;
    }

    private AnimatorUtils() {
    }

    static {
        AnimatorUtils animatorUtils;
        INSTANCE = animatorUtils = new AnimatorUtils();
    }
}

