/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Keep;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.utils.FP;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;

public abstract class BaseItemBinder<T, H extends ViewHolder<T>>
extends ItemViewBinder<T, H> {
    protected View createItemView(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent, @LayoutRes int id2) {
        return inflater.inflate(id2, parent, false);
    }

    protected void onViewDetachedFromWindow(@NonNull H holder) {
        super.onViewDetachedFromWindow(holder);
        ((ViewHolder)((Object)holder)).onViewDetach();
    }

    protected void onViewAttachedToWindow(@NonNull H holder) {
        super.onViewAttachedToWindow(holder);
        ((ViewHolder)((Object)holder)).onViewAttach();
    }

    @NonNull
    protected abstract H onCreateViewHolder(@NonNull LayoutInflater var1, @NonNull ViewGroup var2);

    protected void onBindViewHolder(@NonNull H holder, @NonNull T item) {
        ((ViewHolder)((Object)holder)).setData(item);
    }

    protected void onBindViewHolder(@NonNull H holder, @NonNull T item, @NonNull List<Object> payloads) {
        if (FP.empty(payloads)) {
            super.onBindViewHolder(holder, item, payloads);
        } else {
            ((ViewHolder)((Object)holder)).onPartialUpdate(item, payloads);
        }
    }

    public static class ItemClickViewHolder<T>
    extends ViewHolder<T> {
        public ItemClickViewHolder(View itemView) {
            super(itemView);
        }

        public void setItemClickListener(View.OnClickListener l) {
            this.itemView.setOnClickListener(v -> l.onClick(v));
        }
    }

    public static class ViewHolder<T>
    extends RecyclerView.ViewHolder {
        private T itemData;

        @Keep
        public ViewHolder(View itemView) {
            super(itemView);
        }

        public void setData(T data2) {
            this.itemData = data2;
        }

        public T getData() {
            return this.itemData;
        }

        public void onViewDetach() {
        }

        public void onViewAttach() {
        }

        public void onPartialUpdate(T item, List<Object> payloads) {
        }
    }
}

