/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.ScaleAnimation;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.opensource.svgaplayer.hago.utils.SVGARange;
import com.yy.base.logger.MLog;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class HiddenAnimUtils {
    public static final int ANIMATION_TYPE_ABOVE = 0;
    public static final int ANIMATION_TYPE_EQUAL = 1;
    private int mHeight;
    private View hideView;
    private View content;
    private SVGAImageView smilingFace;
    private ScaleAnimation scaleAnimation;
    private ObjectAnimator animator;
    private PropertyValuesHolder valuesHolderX;
    private PropertyValuesHolder valuesHolderY;
    private List<View> shareBoxIcons;
    private float curTranslationX;
    private float curTranslationY;
    private int shareBoxIconsCount = 0;
    private DResource faceUrl;
    private DResource faceSmilineUrl;
    private int width;
    private int height;
    private PropertyValuesHolder valuesHolderScaleY;
    private PropertyValuesHolder valuesHolderScaleX;
    private int bubbleToTextViewDistance = 40;
    private int bubbleToRightDistance = 6;
    private int scaleBigFaceHeight;
    private int faceNormalHeight;
    private int mAnimationType;
    private int curTranslationEndX;
    private float pivotXValue = 1.0f;

    public void init(View hideView, View bubble, SVGAImageView smilingFace, List<View> shareBoxIcons, DResource faceUrl, DResource faceSmilineUrl) {
        this.init(hideView, bubble, smilingFace, shareBoxIcons, faceUrl, faceSmilineUrl, 0);
    }

    public void init(View hideView, View bubble, SVGAImageView smilingFace, List<View> shareBoxIcons, DResource faceUrl, DResource faceSmilineUrl, int type2) {
        this.hideView = hideView;
        this.smilingFace = smilingFace;
        this.content = bubble;
        this.shareBoxIcons = shareBoxIcons;
        this.faceUrl = faceUrl;
        this.faceSmilineUrl = faceSmilineUrl;
        this.faceNormalHeight = smilingFace.getHeight();
        this.scaleBigFaceHeight = (int)((double)this.faceNormalHeight * 1.2);
        this.width = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.height = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        hideView.measure(this.width, this.height);
        this.mHeight = hideView.getMeasuredHeight();
        this.mAnimationType = type2;
        if (LanguageUtils.isRtl()) {
            this.pivotXValue = 0.0f;
        }
    }

    public void toggle() {
        this.startAnimation();
        if (0 == this.hideView.getVisibility()) {
            this.closeAnimate(this.hideView);
        } else {
            this.openAnim(this.hideView);
            if (this.shareBoxIcons != null) {
                this.shareBoxIconsCount = this.shareBoxIcons.size();
                for (int i = 0; i < this.shareBoxIconsCount; ++i) {
                    this.createAndStartBoxAnimation(this.shareBoxIcons.get(i), i);
                }
            }
        }
    }

    private void startAnimation() {
        this.animator = this.createTranslateAnimator();
        this.animator.setDuration(400L);
        this.animator.start();
    }

    private ObjectAnimator createTranslateAnimator() {
        if (8 == this.hideView.getVisibility()) {
            int sign;
            this.curTranslationX = this.smilingFace.getTranslationX();
            this.curTranslationY = this.smilingFace.getTranslationY();
            int n = sign = LanguageUtils.isRtl() ? 1 : -1;
            if (this.mAnimationType == 0) {
                this.valuesHolderX = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{this.curTranslationX, (ResolutionUtils.dip2Px((float)this.bubbleToRightDistance) + this.scaleBigFaceHeight / 2) * sign});
                this.valuesHolderY = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{this.curTranslationY, this.mHeight - (this.faceNormalHeight - ResolutionUtils.dip2Px((float)this.bubbleToTextViewDistance) - (this.scaleBigFaceHeight - this.faceNormalHeight) / 2)});
            } else {
                this.valuesHolderX = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{this.curTranslationX, (ResolutionUtils.dip2Px((float)this.bubbleToRightDistance) + this.scaleBigFaceHeight / 4) * sign});
                this.valuesHolderY = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{this.curTranslationY, 0.0f});
            }
            this.valuesHolderScaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 1.2f});
            this.valuesHolderScaleY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 1.2f});
            this.smilingFace.stepToFrame(0, false);
            this.animator = ObjectAnimator.ofPropertyValuesHolder((Object)this.smilingFace, (PropertyValuesHolder[])new PropertyValuesHolder[]{this.valuesHolderX, this.valuesHolderY, this.valuesHolderScaleX, this.valuesHolderScaleY});
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    DyResLoader.INSTANCE.loadSvga(HiddenAnimUtils.this.smilingFace, HiddenAnimUtils.this.faceSmilineUrl, new ISvgaLoadCallback(){

                        public void onFinished(SVGAVideoEntity entity) {
                            if (HiddenAnimUtils.this.smilingFace != null) {
                                HiddenAnimUtils.this.smilingFace.setLoopCount(1);
                                HiddenAnimUtils.this.smilingFace.setFillMode(SVGAImageView.FillMode.Forward);
                                HiddenAnimUtils.this.smilingFace.setClearsAfterStop(false);
                                HiddenAnimUtils.this.smilingFace.startAnimation();
                            }
                        }

                        public void onFailed(Exception e) {
                            MLog.error((Object)"HiddenAnimUtils", (Throwable)e);
                        }
                    });
                }
            });
        } else {
            this.valuesHolderX = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{this.smilingFace.getTranslationX(), this.curTranslationX});
            this.valuesHolderY = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{this.smilingFace.getTranslationY(), this.curTranslationY});
            this.valuesHolderScaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f});
            this.valuesHolderScaleY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f});
            this.animator = ObjectAnimator.ofPropertyValuesHolder((Object)this.smilingFace, (PropertyValuesHolder[])new PropertyValuesHolder[]{this.valuesHolderX, this.valuesHolderY, this.valuesHolderScaleY, this.valuesHolderScaleX});
            SVGARange svgaRange = new SVGARange(0, 17);
            this.smilingFace.setFillMode(SVGAImageView.FillMode.Backward);
            this.smilingFace.startAnimation(svgaRange, true);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    DyResLoader.INSTANCE.loadSvga(HiddenAnimUtils.this.smilingFace, HiddenAnimUtils.this.faceUrl, new ISvgaLoadCallback(){

                        public void onFinished(SVGAVideoEntity entity) {
                            if (HiddenAnimUtils.this.smilingFace != null) {
                                HiddenAnimUtils.this.smilingFace.setLoopCount(0);
                                HiddenAnimUtils.this.smilingFace.startAnimation();
                            }
                        }

                        public void onFailed(Exception e) {
                            MLog.error((Object)"HiddenAnimUtils", (Throwable)e);
                        }
                    });
                }
            });
        }
        return this.animator;
    }

    private void createAndStartBoxAnimation(View child, int index) {
        this.valuesHolderX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 1.2f, 1.0f});
        this.valuesHolderY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 1.2f, 1.0f});
        this.animator = ObjectAnimator.ofPropertyValuesHolder((Object)child, (PropertyValuesHolder[])new PropertyValuesHolder[]{this.valuesHolderX, this.valuesHolderY});
        this.animator.setDuration(400L);
        this.animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.animator.setStartDelay((long)(300 * (index + 2)));
        this.animator.start();
    }

    private void openContentAnimation() {
        this.scaleAnimation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, this.pivotXValue, 1, 1.0f);
        this.scaleAnimation.setDuration(400L);
        this.scaleAnimation.setRepeatCount(0);
        this.scaleAnimation.setInterpolator((Interpolator)new OvershootInterpolator(1.0f));
        this.scaleAnimation.setFillAfter(true);
        this.content.startAnimation((Animation)this.scaleAnimation);
    }

    private void openAnim(View v) {
        v.setVisibility(0);
        this.content.setVisibility(8);
        if (this.mAnimationType == 0) {
            ValueAnimator animator = this.createDropAnimator(v, 0, this.mHeight);
            animator.setDuration(400L);
            animator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    HiddenAnimUtils.this.content.setVisibility(0);
                    HiddenAnimUtils.this.openContentAnimation();
                    HiddenAnimUtils.this.smilingFace.setEnabled(true);
                    HiddenAnimUtils.this.content.setEnabled(true);
                }
            });
            animator.start();
        } else {
            this.content.setVisibility(0);
            this.openContentAnimation();
            this.smilingFace.setEnabled(true);
            this.content.setEnabled(true);
        }
    }

    private void closeAnimate(final View view) {
        int origHeight = view.getHeight();
        this.closeContentAnimation();
        if (this.mAnimationType == 0) {
            ValueAnimator animator = this.createDropAnimator(view, origHeight, 0);
            animator.setDuration(400L);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    view.setVisibility(8);
                    HiddenAnimUtils.this.smilingFace.setEnabled(true);
                    HiddenAnimUtils.this.content.setEnabled(true);
                }
            });
            animator.start();
        } else {
            view.setVisibility(8);
            this.smilingFace.setEnabled(true);
            this.content.setEnabled(true);
        }
    }

    private void closeContentAnimation() {
        this.scaleAnimation = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1, this.pivotXValue, 1, 1.0f);
        this.scaleAnimation.setDuration(100L);
        this.scaleAnimation.setFillAfter(true);
        this.content.startAnimation((Animation)this.scaleAnimation);
    }

    private ValueAnimator createDropAnimator(final View v, int start, int end) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{start, end});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                int value = (Integer)arg0.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = v.getLayoutParams();
                layoutParams.height = value;
                v.setLayoutParams(layoutParams);
            }
        });
        return animator;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationType {
    }
}

