/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.yy.appbase.R;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.x2c.X2CUtils;

public class CommonFooter
extends InternalAbstract
implements RefreshFooter {
    ProgressBar mLoadingView;
    YYTextView mNoMoreDataView;
    private boolean mNoMoreData = false;
    private View rootView;

    public CommonFooter(Context context) {
        this(context, null);
    }

    public CommonFooter(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CommonFooter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.rootView = X2CUtils.inflate((Context)context, (int)R.layout.layout_common_footer, (ViewGroup)this);
        this.initView(this.rootView);
        this.stopAnimatable();
    }

    private void initView(View view) {
        this.mLoadingView = (ProgressBar)view.findViewById(R.id.pb_loading);
        this.mNoMoreDataView = (YYTextView)view.findViewById(R.id.tv_no_more_data);
    }

    public CommonFooter(@NonNull View wrapper) {
        super(wrapper);
        this.initView(wrapper);
    }

    public boolean setNoMoreData(boolean noMoreData) {
        this.mNoMoreData = noMoreData;
        if (noMoreData) {
            this.mNoMoreDataView.setVisibility(0);
            this.mLoadingView.setVisibility(8);
        } else {
            this.mNoMoreDataView.setVisibility(8);
            this.mLoadingView.setVisibility(0);
        }
        this.stopAnimatable();
        return true;
    }

    private void stopAnimatable() {
        this.rootView.setVisibility(8);
    }

    private void starAnimatable() {
        this.rootView.setVisibility(0);
    }

    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        if (!this.mNoMoreData) {
            this.starAnimatable();
            super.onStartAnimator(refreshLayout, height, maxDragHeight);
        }
    }

    public int onFinish(@NonNull RefreshLayout layout2, boolean success) {
        int result = 0;
        if (!this.mNoMoreData) {
            result = super.onFinish(layout2, success);
            this.stopAnimatable();
        }
        return result;
    }

    public void setNoMoreText(String string2) {
        if (this.mNoMoreDataView != null) {
            this.mNoMoreDataView.setText((CharSequence)string2);
        }
    }

    public void setNoMoreText(@StringRes int stringId) {
        if (this.mNoMoreDataView != null) {
            this.mNoMoreDataView.setText((CharSequence)ResourceUtils.getString((int)stringId));
        }
    }

    public void setNoMoreTextColor(int colorId) {
        if (this.mNoMoreDataView != null) {
            this.mNoMoreDataView.setTextColor(ResourceUtils.getColor((int)colorId));
        }
    }

    public void setNoMoreTextSize(int textSize) {
        if (this.mNoMoreDataView != null) {
            this.mNoMoreDataView.setTextSize((float)textSize);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        MLog.debug((Object)"TEST!!!", (String)("changedView=" + changedView + ", visibility=" + visibility), (Object[])new Object[0]);
    }
}

