/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.service.audioplay;

import android.app.Activity;
import android.media.MediaPlayer;
import android.media.audiofx.Visualizer;
import android.text.TextUtils;
import com.squareup.wire.internal.Internal;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.audioplay.AudioPlayerService;
import com.yy.appbase.service.audioplay.IAudioPlayerListener;
import com.yy.appbase.service.audioplay.IAudioPlayerService;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\b\u0010 \u001a\u00020\u0014H\u0002J\u0012\u0010!\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\u0014H\u0002J\b\u0010%\u001a\u00020\u0014H\u0016J\u0012\u0010&\u001a\u00020\u00142\b\u0010'\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010(\u001a\u00020\u0014H\u0016J\b\u0010)\u001a\u00020\u0014H\u0016J\u0012\u0010*\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010+\u001a\u00020\u0014H\u0016J\b\u0010,\u001a\u00020\u0014H\u0016J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\rH\u0016J\u0010\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\rH\u0016J\b\u00101\u001a\u00020\u0014H\u0002J\b\u00102\u001a\u00020\u0014H\u0016J\u0010\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0018H\u0002J\b\u00105\u001a\u00020\u0014H\u0016J\b\u00106\u001a\u00020\u0014H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/yy/appbase/service/audioplay/AudioPlayerService;", "Lcom/yy/appbase/service/audioplay/IAudioPlayerService;", "Lcom/yy/framework/core/INotify;", "()V", "mListeners", "", "Ljava/lang/ref/WeakReference;", "Lcom/yy/appbase/service/audioplay/IAudioPlayerListener;", "mMediaPlayer", "Landroid/media/MediaPlayer;", "mPath", "", "mPlayingPage", "", "mProgressUpdateTask", "Ljava/lang/Runnable;", "mStatus", "mVisualizer", "Landroid/media/audiofx/Visualizer;", "addAudioPlayerListener", "", "l", "enableVisualizer", "enable", "", "activity", "Landroid/app/Activity;", "getCurrentAudioPath", "getCurrentState", "getPlayingPage", "initMediaPlayer", "isPlaying", "mediaPrepareComplete", "notify", "notification", "Lcom/yy/framework/core/Notification;", "notifyStatusChanged", "pause", "play", "path", "registerEnterMediaChannelNotify", "release", "removeAudioPlayerListener", "reset", "resume", "seekTo", "position", "setPlayingPage", "page", "startProgressUpdateTask", "stop", "stopProgressUpdateTask", "resetProgress", "unregisterEnterMediaChannelNotify", "updateProgress", "Companion", "appbase_release"})
public final class AudioPlayerService
implements IAudioPlayerService,
INotify {
    private MediaPlayer mMediaPlayer;
    private Visualizer mVisualizer;
    private final List<WeakReference<IAudioPlayerListener>> mListeners;
    private Runnable mProgressUpdateTask;
    private String mPath;
    private int mStatus;
    private int mPlayingPage;
    @NotNull
    public static final String TAG = "AudioPlayerService";
    public static final Companion Companion = new Companion(null);

    private final void initMediaPlayer() {
        block3: {
            if (this.mMediaPlayer != null) break block3;
            MediaPlayer mediaPlayer = this.mMediaPlayer = new MediaPlayer();
            if (mediaPlayer != null) {
                mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(this){
                    final /* synthetic */ AudioPlayerService this$0;

                    public final void onCompletion(MediaPlayer it) {
                        AudioPlayerService.access$stopProgressUpdateTask(this.this$0, true);
                        AudioPlayerService.access$setMStatus$p(this.this$0, 5);
                        AudioPlayerService.access$notifyStatusChanged(this.this$0);
                        List list = Internal.copyOf((List)AudioPlayerService.access$getMListeners$p(this.this$0));
                        for (WeakReference item : list) {
                            Object object = item;
                            if (object == null || (object = (IAudioPlayerListener)((Reference)object).get()) == null) continue;
                            object.onPlayComplete();
                        }
                    }
                    {
                        this.this$0 = audioPlayerService;
                    }
                });
            }
            MediaPlayer mediaPlayer2 = this.mMediaPlayer;
            if (mediaPlayer2 != null) {
                mediaPlayer2.setOnPreparedListener(new MediaPlayer.OnPreparedListener(this){
                    final /* synthetic */ AudioPlayerService this$0;

                    public final void onPrepared(MediaPlayer it) {
                        AudioPlayerService.access$mediaPrepareComplete(this.this$0);
                        if (!TextUtils.isEmpty((CharSequence)AudioPlayerService.access$getMPath$p(this.this$0))) {
                            this.this$0.resume();
                        }
                    }
                    {
                        this.this$0 = audioPlayerService;
                    }
                });
            }
            MediaPlayer mediaPlayer3 = this.mMediaPlayer;
            if (mediaPlayer3 != null) {
                mediaPlayer3.setOnErrorListener(new MediaPlayer.OnErrorListener(this){
                    final /* synthetic */ AudioPlayerService this$0;

                    public final boolean onError(@Nullable MediaPlayer mp, int what, int extra) {
                        MLog.error((Object)"AudioPlayerService", (String)("OnError - Error code: " + what + " Extra code: " + extra), (Object[])new Object[0]);
                        AudioPlayerService.access$setMStatus$p(this.this$0, -1);
                        this.this$0.release();
                        return false;
                    }
                    {
                        this.this$0 = audioPlayerService;
                    }
                });
            }
        }
    }

    @Override
    public void play(@Nullable String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            MLog.error((Object)TAG, (String)"play path is empty", (Object[])new Object[0]);
            return;
        }
        if (Intrinsics.areEqual((Object)path, (Object)this.mPath) && this.mStatus == 1) {
            MLog.error((Object)TAG, (String)("same resource loading path: " + path), (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)("play path: " + path), (Object[])new Object[0]);
        this.mPath = path;
        this.initMediaPlayer();
        this.mStatus = 1;
        this.notifyStatusChanged();
        try {
            MediaPlayer mediaPlayer = this.mMediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.reset();
            }
            MediaPlayer mediaPlayer2 = this.mMediaPlayer;
            if (mediaPlayer2 != null) {
                mediaPlayer2.setDataSource(path);
            }
            MediaPlayer mediaPlayer3 = this.mMediaPlayer;
            if (mediaPlayer3 != null) {
                mediaPlayer3.prepareAsync();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.mStatus == 3 || this.mStatus == 4;
    }

    @Override
    public void resume() {
        MLog.info((Object)TAG, (String)("resume path: " + this.mPath), (Object[])new Object[0]);
        if (this.mMediaPlayer == null) {
            return;
        }
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer == null) {
            Intrinsics.throwNpe();
        }
        mediaPlayer.start();
        this.startProgressUpdateTask();
        this.mStatus = 3;
        this.notifyStatusChanged();
    }

    @Override
    public void pause() {
        MLog.info((Object)TAG, (String)("pause path: " + this.mPath), (Object[])new Object[0]);
        if (this.mMediaPlayer == null) {
            return;
        }
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer == null) {
            Intrinsics.throwNpe();
        }
        if (mediaPlayer.isPlaying()) {
            MediaPlayer mediaPlayer2 = this.mMediaPlayer;
            if (mediaPlayer2 == null) {
                Intrinsics.throwNpe();
            }
            mediaPlayer2.pause();
            this.stopProgressUpdateTask(false);
            this.mStatus = 4;
            this.notifyStatusChanged();
        }
    }

    @Override
    public void stop() {
        MLog.info((Object)TAG, (String)("stop path: " + this.mPath), (Object[])new Object[0]);
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            MediaPlayer mediaPlayer2 = mediaPlayer;
            boolean bl = false;
            boolean bl2 = false;
            MediaPlayer $this$apply = mediaPlayer2;
            boolean bl3 = false;
            $this$apply.stop();
        }
        this.stopProgressUpdateTask(true);
        this.mStatus = 7;
        this.notifyStatusChanged();
    }

    @Override
    public void reset() {
        MLog.info((Object)TAG, (String)("reset path: " + this.mPath), (Object[])new Object[0]);
        if (this.mMediaPlayer == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mPath)) {
            MLog.info((Object)TAG, (String)"reset path is empty", (Object[])new Object[0]);
            return;
        }
        this.mStatus = 6;
        this.notifyStatusChanged();
        this.stopProgressUpdateTask(true);
        this.play(this.mPath);
    }

    @Override
    public void release() {
        MLog.info((Object)TAG, (String)("release path: " + this.mPath), (Object[])new Object[0]);
        if (this.mMediaPlayer == null) {
            return;
        }
        this.unregisterEnterMediaChannelNotify();
        this.mStatus = 8;
        this.notifyStatusChanged();
        this.stopProgressUpdateTask(true);
        Visualizer visualizer = this.mVisualizer;
        if (visualizer != null) {
            visualizer.release();
        }
        this.mVisualizer = null;
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
        }
        MediaPlayer mediaPlayer2 = this.mMediaPlayer;
        if (mediaPlayer2 != null) {
            mediaPlayer2.release();
        }
        this.mMediaPlayer = null;
        this.mPath = "";
        this.mPlayingPage = -1;
        this.mListeners.clear();
    }

    private final void mediaPrepareComplete() {
        if (this.mMediaPlayer == null) {
            return;
        }
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer == null) {
            Intrinsics.throwNpe();
        }
        int duration = mediaPlayer.getDuration();
        List list = Internal.copyOf(this.mListeners);
        for (WeakReference item : list) {
            Object object;
            Object object2 = item;
            if (object2 != null && (object2 = (IAudioPlayerListener)((Reference)object2).get()) != null) {
                object2.onDurationChanged(duration);
            }
            if ((object = item) == null || (object = (IAudioPlayerListener)((Reference)object).get()) == null) continue;
            object.onProgressChanged(0);
        }
        this.mStatus = 2;
        this.notifyStatusChanged();
    }

    @Override
    public void seekTo(int position) {
        block0: {
            MediaPlayer mediaPlayer = this.mMediaPlayer;
            if (mediaPlayer == null) break block0;
            mediaPlayer.seekTo(position);
        }
    }

    @Override
    public int getCurrentState() {
        return this.mStatus;
    }

    @Override
    @Nullable
    public String getCurrentAudioPath() {
        return this.mPath;
    }

    @Override
    public void addAudioPlayerListener(@Nullable IAudioPlayerListener l) {
        if (l == null) {
            return;
        }
        for (WeakReference<IAudioPlayerListener> item : this.mListeners) {
            IAudioPlayerListener listenerReal;
            if (item == null || (listenerReal = (IAudioPlayerListener)item.get()) != l) continue;
            return;
        }
        this.mListeners.add(new WeakReference<IAudioPlayerListener>(l));
    }

    @Override
    public void removeAudioPlayerListener(@Nullable IAudioPlayerListener l) {
        if (l == null || this.mListeners.size() <= 0) {
            return;
        }
        for (WeakReference<IAudioPlayerListener> item : this.mListeners) {
            IAudioPlayerListener listenerReal;
            if (item == null || (listenerReal = (IAudioPlayerListener)item.get()) != l) continue;
            this.mListeners.remove(item);
            return;
        }
    }

    @Override
    public void enableVisualizer(boolean enable, @NotNull Activity activity) {
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                Visualizer visualizer = this.mVisualizer;
                if (visualizer != null) {
                    if (visualizer.getEnabled() == enable) {
                        return;
                    }
                }
                if (!enable) break block2;
                PermissionHelper.requestRecordAudioPermission(activity, new IPermissionListener(this){
                    final /* synthetic */ AudioPlayerService this$0;

                    public void onPermissionGranted(@NotNull String[] permission) {
                        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                        if (AudioPlayerService.access$getMMediaPlayer$p(this.this$0) == null) {
                            MLog.info((Object)"AudioPlayerService", (String)"enableVisualizer onPermissionGranted mMediaPlayer = null", (Object[])new Object[0]);
                            AudioPlayerService.access$initMediaPlayer(this.this$0);
                        }
                        if (AudioPlayerService.access$getMVisualizer$p(this.this$0) != null) {
                            Visualizer visualizer = AudioPlayerService.access$getMVisualizer$p(this.this$0);
                            if (visualizer != null) {
                                visualizer.release();
                            }
                            AudioPlayerService.access$setMVisualizer$p(this.this$0, null);
                        }
                        MediaPlayer mediaPlayer = AudioPlayerService.access$getMMediaPlayer$p(this.this$0);
                        if (mediaPlayer == null) {
                            Intrinsics.throwNpe();
                        }
                        AudioPlayerService.access$setMVisualizer$p(this.this$0, new Visualizer(mediaPlayer.getAudioSessionId()));
                        Visualizer visualizer = AudioPlayerService.access$getMVisualizer$p(this.this$0);
                        if (visualizer != null) {
                            visualizer.setCaptureSize(Visualizer.getCaptureSizeRange()[0]);
                        }
                        Visualizer visualizer2 = AudioPlayerService.access$getMVisualizer$p(this.this$0);
                        if (visualizer2 != null) {
                            visualizer2.setDataCaptureListener(new Visualizer.OnDataCaptureListener(this){
                                final /* synthetic */ enableVisualizer.1 this$0;

                                public void onFftDataCapture(@Nullable Visualizer visualizer, @Nullable byte[] fft, int samplingRate) {
                                    List list = Internal.copyOf((List)AudioPlayerService.access$getMListeners$p(this.this$0.this$0));
                                    for (WeakReference item : list) {
                                        Object object = item;
                                        if (object == null || (object = (IAudioPlayerListener)((Reference)object).get()) == null) continue;
                                        object.onDataCapture(fft);
                                    }
                                }

                                public void onWaveFormDataCapture(@Nullable Visualizer visualizer, @Nullable byte[] waveform, int samplingRate) {
                                }
                                {
                                    this.this$0 = $outer;
                                }
                            }, Visualizer.getMaxCaptureRate() / 2, false, true);
                        }
                        try {
                            Visualizer visualizer3 = AudioPlayerService.access$getMVisualizer$p(this.this$0);
                            if (visualizer3 != null) {
                                visualizer3.setEnabled(true);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"AudioPlayerService", (String)("enableVisualizer error: " + e), (Object[])new Object[0]);
                        }
                    }

                    public void onPermissionDenied(@NotNull String[] permission) {
                        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                        MLog.error((Object)"AudioPlayerService", (String)"enableVisualizer no record permission", (Object[])new Object[0]);
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
                break block3;
            }
            Visualizer visualizer = this.mVisualizer;
            if (visualizer == null) break block3;
            visualizer.setEnabled(false);
        }
    }

    @Override
    public void registerEnterMediaChannelNotify() {
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.TRY_JOIN_MEDIA_CHANNEL, (INotify)this);
    }

    @Override
    public void unregisterEnterMediaChannelNotify() {
        NotificationCenter.getGlobalInstance().unregister(NotificationIdDef.TRY_JOIN_MEDIA_CHANNEL, (INotify)this);
    }

    @Override
    public void setPlayingPage(int page) {
        this.mPlayingPage = page;
    }

    @Override
    public int getPlayingPage() {
        return this.mPlayingPage;
    }

    public void notify(@Nullable Notification notification) {
        Notification notification2 = notification;
        if (notification2 != null) {
            if (notification2.id == NotificationIdDef.TRY_JOIN_MEDIA_CHANNEL) {
                this.release();
            }
        }
    }

    private final void startProgressUpdateTask() {
        if (this.mProgressUpdateTask == null) {
            this.mProgressUpdateTask = new Runnable(this){
                final /* synthetic */ AudioPlayerService this$0;

                public final void run() {
                    AudioPlayerService.access$updateProgress(this.this$0);
                    YYTaskExecutor.postToMainThread((Runnable)AudioPlayerService.access$getMProgressUpdateTask$p(this.this$0), (long)1000L);
                }
                {
                    this.this$0 = audioPlayerService;
                }
            };
        }
        YYTaskExecutor.postToMainThread((Runnable)this.mProgressUpdateTask);
    }

    private final void updateProgress() {
        if (this.mMediaPlayer != null) {
            MediaPlayer mediaPlayer = this.mMediaPlayer;
            if (mediaPlayer == null) {
                Intrinsics.throwNpe();
            }
            if (mediaPlayer.isPlaying()) {
                MediaPlayer mediaPlayer2 = this.mMediaPlayer;
                if (mediaPlayer2 == null) {
                    Intrinsics.throwNpe();
                }
                int currentPosition = mediaPlayer2.getCurrentPosition();
                List list = Internal.copyOf(this.mListeners);
                for (WeakReference item : list) {
                    Object object = item;
                    if (object != null && (object = (IAudioPlayerListener)((Reference)object).get()) != null) {
                        object.onProgressChanged(currentPosition);
                    }
                }
            }
        }
    }

    private final void stopProgressUpdateTask(boolean resetProgress) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mProgressUpdateTask);
        if (resetProgress) {
            List list = Internal.copyOf(this.mListeners);
            for (WeakReference item : list) {
                Object object = item;
                if (object != null && (object = (IAudioPlayerListener)((Reference)object).get()) != null) {
                    object.onProgressChanged(0);
                }
            }
        }
    }

    private final void notifyStatusChanged() {
        MLog.info((Object)TAG, (String)("notifyStatusChanged status: " + this.mStatus), (Object[])new Object[0]);
        List list = Internal.copyOf(this.mListeners);
        for (WeakReference item : list) {
            Object object = item;
            if (object == null || (object = (IAudioPlayerListener)((Reference)object).get()) == null) continue;
            object.onStateChanged(this.mStatus);
        }
    }

    public AudioPlayerService() {
        List list;
        AudioPlayerService audioPlayerService = this;
        boolean bl = false;
        audioPlayerService.mListeners = list = (List)new ArrayList();
        this.mPlayingPage = -1;
    }

    public static final /* synthetic */ void access$stopProgressUpdateTask(AudioPlayerService $this, boolean resetProgress) {
        $this.stopProgressUpdateTask(resetProgress);
    }

    public static final /* synthetic */ int access$getMStatus$p(AudioPlayerService $this) {
        return $this.mStatus;
    }

    public static final /* synthetic */ void access$setMStatus$p(AudioPlayerService $this, int n) {
        $this.mStatus = n;
    }

    public static final /* synthetic */ void access$notifyStatusChanged(AudioPlayerService $this) {
        $this.notifyStatusChanged();
    }

    public static final /* synthetic */ List access$getMListeners$p(AudioPlayerService $this) {
        return $this.mListeners;
    }

    public static final /* synthetic */ void access$mediaPrepareComplete(AudioPlayerService $this) {
        $this.mediaPrepareComplete();
    }

    public static final /* synthetic */ String access$getMPath$p(AudioPlayerService $this) {
        return $this.mPath;
    }

    public static final /* synthetic */ void access$setMPath$p(AudioPlayerService $this, String string2) {
        $this.mPath = string2;
    }

    public static final /* synthetic */ MediaPlayer access$getMMediaPlayer$p(AudioPlayerService $this) {
        return $this.mMediaPlayer;
    }

    public static final /* synthetic */ void access$setMMediaPlayer$p(AudioPlayerService $this, MediaPlayer mediaPlayer) {
        $this.mMediaPlayer = mediaPlayer;
    }

    public static final /* synthetic */ void access$initMediaPlayer(AudioPlayerService $this) {
        $this.initMediaPlayer();
    }

    public static final /* synthetic */ Visualizer access$getMVisualizer$p(AudioPlayerService $this) {
        return $this.mVisualizer;
    }

    public static final /* synthetic */ void access$setMVisualizer$p(AudioPlayerService $this, Visualizer visualizer) {
        $this.mVisualizer = visualizer;
    }

    public static final /* synthetic */ void access$updateProgress(AudioPlayerService $this) {
        $this.updateProgress();
    }

    public static final /* synthetic */ Runnable access$getMProgressUpdateTask$p(AudioPlayerService $this) {
        return $this.mProgressUpdateTask;
    }

    public static final /* synthetic */ void access$setMProgressUpdateTask$p(AudioPlayerService $this, Runnable runnable) {
        $this.mProgressUpdateTask = runnable;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/appbase/service/audioplay/AudioPlayerService$Companion;", "", "()V", "TAG", "", "appbase_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

