/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.screenshot;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.screenshot.ScreenShotView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.ui.AbstractWindowManager;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class ScreenShotManager
implements ScreenShotView.OnPushLayoutAnimateListener {
    private String mPreFileName = "";
    private ScreenShotView mScreenShotView;
    private boolean isShowScreenShotView = true;
    private long mUid;
    private static final String TYPE_PAGE_ROOM = "1";
    private static final String TYPE_PAGE_PROFILE = "2";
    private static final String FUNCTION_REPORT_FLOAT_SHOW = "report_float_show";
    private static final String FUNCTION_REPORT_FLOAT_BUT_CLICK = "report_float_but_click";
    private static final String KEY_PAGE_TYPE = "page_type";
    private static final int MAX_TIME = 5000;
    private static final int MIN_WAIT_TIME = 600;
    private static final int MAX_WAIT_TIME = 2000;
    private int mWaitFileChangeTime = 600;
    private String mRoomId = "";
    private static final String[] KEYWORDS = new String[]{"screenshot", "screen_shot", "screen-shot", "screen shot", "screencapture", "screen_capture", "screen-capture", "screen capture", "screencap", "screen_cap", "screen-cap", "screen cap", "\u622a\u5c4f"};
    private static final String[] MEDIA_PROJECTIONS = new String[]{"_data", "datetaken"};
    private MediaContentObserver mInternalObserver;
    private MediaContentObserver mExternalObserver;
    private Handler mHandler;
    private Context mContext;
    private AbstractWindowManager mWindowManager;
    private IScreenShotListener mScreenShotListener;
    private int mType;
    private Runnable mHideNotifyTask = new Runnable(){

        @Override
        public void run() {
            if (ScreenShotManager.this.mScreenShotView != null) {
                FeatureLog.i((String)"FTScreenShot", (String)"hideNotify", (Object[])new Object[0]);
                ScreenShotManager.this.mScreenShotView.onTimeOutExit();
            }
        }
    };
    private static IScreenShotStatListener sStatListener;

    public ScreenShotManager(Context context, long uid, int type2, String roomId) {
        this.mContext = context;
        this.mType = type2;
        this.mUid = uid;
        this.mRoomId = roomId;
    }

    public ScreenShotManager(Context context, int type2, String roomId) {
        this(context, 0L, type2, roomId);
    }

    public void setScreenShotListener(IScreenShotListener listener2) {
        this.mScreenShotListener = listener2;
    }

    public void start(AbstractWindowManager root) {
        MLog.info((Object)"ScreenShotManager", (String)"start", (Object[])new Object[0]);
        this.mWindowManager = root;
        if (this.mHandler == null) {
            this.mHandler = YYTaskExecutor.getLooperThreadHandler();
        }
        if (this.mInternalObserver == null && this.mHandler != null && this.mContext != null) {
            this.mInternalObserver = new MediaContentObserver(MediaStore.Images.Media.INTERNAL_CONTENT_URI, this.mHandler, this.mContext);
        }
        if (this.mExternalObserver == null && this.mHandler != null && this.mContext != null) {
            this.mExternalObserver = new MediaContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.mHandler, this.mContext);
        }
        if (this.mContext == null) {
            FeatureLog.i((String)"FTScreenShot", (String)"context null", (Object[])new Object[0]);
        }
        if (this.mContext != null) {
            MLog.info((Object)"ScreenShotManager", (String)"add listener", (Object[])new Object[0]);
            if (this.mInternalObserver != null) {
                this.mContext.getContentResolver().registerContentObserver(MediaStore.Images.Media.INTERNAL_CONTENT_URI, this.isAboveAndroidO(), (ContentObserver)this.mInternalObserver);
            }
            if (this.mExternalObserver != null) {
                this.mContext.getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.isAboveAndroidO(), (ContentObserver)this.mExternalObserver);
            }
        }
        if (RuntimeContext.isPhoneSuperLow()) {
            FeatureLog.i((String)"FTScreenShot", (String)"isPhoneSuperLow", (Object[])new Object[0]);
            this.mWaitFileChangeTime = 2000;
        }
    }

    private void handleMediaContentChange(Uri contentUri, Context context) {
        this.realCheckChange(contentUri, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realCheckChange(Uri contentUri, Context context) {
        Cursor cursor = null;
        try {
            FeatureLog.i((String)"FTScreenShot", (String)"handleMediaContentChange", (Object[])new Object[0]);
            if (this.isAboveAndroidO()) {
                Bundle queryArgs = new Bundle();
                queryArgs.putInt("android:query-arg-limit", 1);
                queryArgs.putString("android:query-arg-sql-sort-order", "date_added desc");
                cursor = context.getContentResolver().query(contentUri, MEDIA_PROJECTIONS, queryArgs, null);
            } else {
                cursor = context.getContentResolver().query(contentUri, MEDIA_PROJECTIONS, null, null, "date_added desc limit 1");
            }
            if (cursor == null) {
                return;
            }
            if (!cursor.moveToFirst()) {
                return;
            }
            int dataIndex = cursor.getColumnIndex("_data");
            int dateTakenIndex = cursor.getColumnIndex("datetaken");
            String data2 = cursor.getString(dataIndex);
            long dateTaken = cursor.getLong(dateTakenIndex);
            this.handleMediaRowData(data2, dateTaken);
        }
        catch (Exception e) {
            FeatureLog.i((String)"FTScreenShot", (String)"handleMediaContentChange error:%s", (Object[])new Object[]{e.toString()});
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    public void stop() {
        if (this.mInternalObserver == null) {
            return;
        }
        MLog.info((Object)"ScreenShotManager", (String)"stop", (Object[])new Object[0]);
        this.hideNotifyToast();
        if (this.mContext != null && this.mContext.getContentResolver() != null && this.mInternalObserver != null && this.mExternalObserver != null) {
            this.mInternalObserver.removeRunnable();
            this.mExternalObserver.removeRunnable();
            MLog.info((Object)"ScreenShotManager", (String)"remove listener", (Object[])new Object[0]);
            this.mContext.getContentResolver().unregisterContentObserver((ContentObserver)this.mInternalObserver);
            this.mContext.getContentResolver().unregisterContentObserver((ContentObserver)this.mExternalObserver);
        }
        this.mHandler = null;
        this.mExternalObserver = null;
        this.mInternalObserver = null;
    }

    private void hideNotifyToast() {
        if (this.mScreenShotView != null && this.mWindowManager != null) {
            FeatureLog.i((String)"FTScreenShot", (String)"removeView", (Object[])new Object[0]);
            this.mWindowManager.removeExtLayerContent((View)this.mScreenShotView);
        }
    }

    private void handleMediaRowData(final String data2, long dateTaken) {
        if (this.mContext == null) {
            return;
        }
        if (this.checkScreenShot(data2, dateTaken)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ScreenShotManager.this.mContext == null) {
                        FeatureLog.i((String)"FTScreenShot", (String)"show context null", (Object[])new Object[0]);
                        return;
                    }
                    if (TextUtils.isEmpty((CharSequence)data2)) {
                        FeatureLog.i((String)"FTScreenShot", (String)"show data null", (Object[])new Object[0]);
                        return;
                    }
                    if (RuntimeContext.sIsForeground) {
                        if (ScreenShotManager.this.mWindowManager != null) {
                            FeatureLog.i((String)"FTScreenShot", (String)"show", (Object[])new Object[0]);
                            if (ScreenShotManager.this.mType == 1) {
                                ScreenShotManager.this.reportFloatShow(ScreenShotManager.this.mRoomId, ScreenShotManager.TYPE_PAGE_PROFILE);
                            } else if (ScreenShotManager.this.mType == 2) {
                                ScreenShotManager.this.reportFloatShow(ScreenShotManager.this.mRoomId, ScreenShotManager.TYPE_PAGE_ROOM);
                            }
                            ScreenShotManager.this.hideNotifyToast();
                            ScreenShotManager.this.mScreenShotView = new ScreenShotView(ScreenShotManager.this.mContext, data2, ScreenShotManager.this.mUid, ScreenShotManager.this.mType, ScreenShotManager.this);
                            ScreenShotManager.this.mScreenShotView.setScreenShotListener(ScreenShotManager.this.mScreenShotListener);
                            if (ScreenShotManager.this.isShowScreenShotView) {
                                ScreenShotManager.this.mWindowManager.addExtLayerContent((View)ScreenShotManager.this.mScreenShotView);
                            } else if (ScreenShotManager.this.mScreenShotListener != null) {
                                ScreenShotManager.this.mScreenShotListener.onScreenShotImage(2, data2);
                            }
                            YYTaskExecutor.removeRunnableFromMainThread((Runnable)ScreenShotManager.this.mHideNotifyTask);
                            YYTaskExecutor.postToMainThread((Runnable)ScreenShotManager.this.mHideNotifyTask, (long)5000L);
                        }
                    } else {
                        FeatureLog.i((String)"FTScreenShot", (String)" handleMediaRowData not foreground", (Object[])new Object[0]);
                    }
                }
            });
        } else {
            FeatureLog.i((String)"FTScreenShot", (String)"error file:%s", (Object[])new Object[]{data2});
        }
    }

    private boolean checkScreenShot(String data2, long dateTaken) {
        if (this.mPreFileName.equals(data2 = data2.toLowerCase())) {
            FeatureLog.i((String)"FTScreenShot", (String)"same file", (Object[])new Object[0]);
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime > dateTaken && currentTime - dateTaken > 10000L && dateTaken > 0L) {
            FeatureLog.i((String)"FTScreenShot", (String)"time not right:%s, to large", (Object[])new Object[]{currentTime - dateTaken});
            return false;
        }
        for (String keyWork : KEYWORDS) {
            if (!data2.contains(keyWork)) continue;
            FeatureLog.i((String)"FTScreenShot", (String)"right file", (Object[])new Object[0]);
            this.mPreFileName = data2;
            return true;
        }
        return false;
    }

    @Override
    public void onExit(View v) {
        FeatureLog.i((String)"FTScreenShot", (String)"onExit", (Object[])new Object[0]);
        this.hideNotifyToast();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
    }

    @Override
    public void onReportClick() {
        if (this.mType == 1) {
            this.reportFloatButClick(this.mRoomId, TYPE_PAGE_PROFILE);
        } else if (this.mType == 2) {
            this.reportFloatButClick(this.mRoomId, TYPE_PAGE_ROOM);
        }
    }

    public void isShowScreenShotView(boolean isShowScreenShotView) {
        this.isShowScreenShotView = isShowScreenShotView;
    }

    private boolean isAboveAndroidO() {
        return Build.VERSION.SDK_INT >= 26;
    }

    private void reportFloatShow(String roomId, String pageType) {
        int userRole = sStatListener != null ? sStatListener.getUserRole(roomId) : -1;
        String gid = sStatListener != null ? sStatListener.getPluginId(roomId) : "";
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", FUNCTION_REPORT_FLOAT_SHOW).put("room_id", roomId).put(KEY_PAGE_TYPE, pageType).put("mode_key", RuntimeContext.useOldRoom() ? TYPE_PAGE_ROOM : TYPE_PAGE_PROFILE).put("user_role", String.valueOf(userRole)).put("gid", gid));
    }

    private void reportFloatButClick(String roomId, String pageType) {
        int userRole = sStatListener != null ? sStatListener.getUserRole(roomId) : -1;
        String gid = sStatListener != null ? sStatListener.getPluginId(roomId) : "";
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", FUNCTION_REPORT_FLOAT_BUT_CLICK).put("room_id", roomId).put(KEY_PAGE_TYPE, pageType).put("mode_key", RuntimeContext.useOldRoom() ? TYPE_PAGE_ROOM : TYPE_PAGE_PROFILE).put("gid", gid).put("user_role", String.valueOf(userRole)));
    }

    public static void setStatListener(IScreenShotStatListener listener2) {
        sStatListener = listener2;
    }

    public static interface IScreenShotStatListener {
        public int getUserRole(String var1);

        public String getPluginId(String var1);
    }

    public static interface IScreenShotListener {
        public void onScreenShotSuccess(int var1);

        default public void onScreenShotImage(int type2, String imagePath) {
        }
    }

    private class MediaContentObserver
    extends ContentObserver {
        private Context mContext;
        private Uri mContentUri;
        private Runnable mHandleMediaRunnable;

        public MediaContentObserver(Uri contentUri, Handler handler, Context context) {
            super(handler);
            this.mHandleMediaRunnable = new Runnable(){

                @Override
                public void run() {
                    FeatureLog.i((String)"FTScreenShot", (String)"onChange", (Object[])new Object[0]);
                    ScreenShotManager.this.handleMediaContentChange(MediaContentObserver.this.mContentUri, MediaContentObserver.this.mContext);
                }
            };
            this.mContentUri = contentUri;
            this.mContext = context;
        }

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            if (!RuntimeContext.sIsForeground) {
                FeatureLog.i((String)"FTScreenShot", (String)" onChange not foreground", (Object[])new Object[0]);
                return;
            }
            YYTaskExecutor.removeTask((Runnable)this.mHandleMediaRunnable);
            FeatureLog.i((String)"FTScreenShot", (String)"waitTime:%s", (Object[])new Object[]{ScreenShotManager.this.mWaitFileChangeTime});
            YYTaskExecutor.execute((Runnable)this.mHandleMediaRunnable, (long)ScreenShotManager.this.mWaitFileChangeTime);
        }

        public void removeRunnable() {
            YYTaskExecutor.removeTask((Runnable)this.mHandleMediaRunnable);
        }
    }
}

