/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.reddot;

import com.yy.appbase.reddot.IRedDot;
import com.yy.appbase.reddot.IRedDotChangedListener;
import com.yy.appbase.reddot.IRedDotContainer;
import com.yy.base.utils.FP;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RedDotContainer
implements IRedDotContainer,
IRedDotChangedListener {
    private Set<IRedDot> mRedDotList;
    private List<IRedDotChangedListener> mListeners;
    private Boolean isVisible = null;

    public RedDotContainer() {
        this.init();
    }

    @Override
    public void init() {
        this.mRedDotList = new HashSet<IRedDot>();
        this.mListeners = new ArrayList<IRedDotChangedListener>();
    }

    @Override
    public void addRedDot(IRedDot redDot) {
        if (redDot != null) {
            this.mRedDotList.add(redDot);
            redDot.setChangedListener(this);
        }
        this.checkVisible();
    }

    @Override
    public void removeRedDot(IRedDot redDot) {
        if (redDot != null) {
            this.mRedDotList.remove(redDot);
        }
        this.checkVisible();
    }

    @Override
    public void addListener(IRedDotChangedListener listener2) {
        this.mListeners.add(listener2);
        if (this.isVisible != null) {
            listener2.onRedDotChanged(this.isVisible);
        }
    }

    @Override
    public boolean isVisible() {
        for (IRedDot item : this.mRedDotList) {
            if (!item.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onDestroy() {
        this.mRedDotList.clear();
        this.isVisible = false;
    }

    @Override
    public void onRedDotChanged(boolean isVisible) {
        this.checkVisible();
    }

    private void checkVisible() {
        if (!FP.empty(this.mRedDotList)) {
            boolean temp = this.isVisible();
            if (this.isVisible == null || temp != this.isVisible) {
                this.isVisible = temp;
                this.dispatch(this.isVisible);
            }
        }
    }

    private void dispatch(boolean isVisible) {
        for (IRedDotChangedListener item : this.mListeners) {
            item.onRedDotChanged(isVisible);
        }
    }
}

