/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.record;

import android.util.Base64;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;

public class RecordUtils {
    private static final String RECORD_DIR_NAME = "recordtmp";
    private static final String RECORD = "record/";
    private static final int BASE64_FLAG = 2;
    private static long mCurTimeMillis;

    @NonNull
    public static String genLocalId(@NonNull String business, @NonNull String subBusiness) {
        long uid = AccountUtil.getUid();
        String localId = StringUtils.formatWitUSLocal((String)"%s|%s|%s", (Object[])new Object[]{business, subBusiness, uid + RecordUtils.genTimeMillis()});
        String encode = Base64.encodeToString((byte[])localId.getBytes(), (int)2);
        return encode.trim();
    }

    public static String decodeLocalId(@NonNull String encodeLocalId) {
        String decode = new String(Base64.decode((String)encodeLocalId, (int)2));
        return decode;
    }

    private static String[] parseLocalId(@NonNull String encodeLocalId) {
        String decode = new String(Base64.decode((String)encodeLocalId, (int)2));
        String[] decodes = decode.split("[|]");
        return decodes;
    }

    public static String getRecordPath(@NonNull String localId) {
        return RecordUtils.getRecordTmpDir() + "/" + localId;
    }

    public static String getRecordTmpDir() {
        return RecordUtils.getRootDir() + RECORD_DIR_NAME;
    }

    public static String getUrlPath(@NonNull String localId) {
        String[] parse = RecordUtils.parseLocalId(localId);
        if (parse != null && parse.length > 2) {
            return RECORD + parse[0] + "/" + parse[1] + "/" + parse[2];
        }
        return RECORD + localId;
    }

    public static String getFilePathFromUrl(@NonNull String url) {
        String business = "unknown";
        String subBusiness = "unknown";
        int index = 0;
        if (url.contains(RECORD)) {
            String[] parse;
            for (String s : parse = url.split("/")) {
                ++index;
                if ("record".equals(s)) break;
            }
            if (parse.length > index + 1) {
                business = parse[index];
                subBusiness = parse[index + 1];
            }
        }
        return RecordUtils.getRootDir(business, subBusiness);
    }

    private static synchronized long genTimeMillis() {
        long cur = System.currentTimeMillis();
        if (cur == mCurTimeMillis) {
            ++cur;
        }
        mCurTimeMillis = cur;
        return mCurTimeMillis;
    }

    private static String getRootDir(String business, String subBusiness) {
        return RecordUtils.getRootDir() + business + "/" + subBusiness + "/";
    }

    public static String getRootDir() {
        return FileStorageUtils.getInstance().getInternalCacheRootDir() + "/" + RECORD + AccountUtil.getUid() + "/";
    }
}

