/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.push.lockscreen;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.push.PushNotificationData;
import com.yy.appbase.push.PushPref;
import com.yy.appbase.push.ScreenBroadcastReceiver;
import com.yy.appbase.push.ScreenStateListener;
import com.yy.appbase.push.lockscreen.LockScreenInfo;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import ikxd.msg.StyleType;
import java.util.LinkedList;

public class LockScreenPushManager {
    public static final String TAG = "LockScreenPushManager";
    public static final String DATA_KEY = "lock_data_info";
    private Gson mGson;
    private boolean isShowingLockActivity = false;
    private LinkedList<LockScreenInfo> mLockScreenInfoList = new LinkedList();
    private ScreenStateListener mScreenStateListener = new ScreenStateListener(){

        @Override
        public void screenOnCallBack(Context context) {
            LockScreenPushManager.this.onScreenOn();
        }

        @Override
        public void screenOffCallBack(Context context) {
            LockScreenPushManager.this.onScreenOff();
        }

        @Override
        public void screenPresentCallBack(Context context) {
        }
    };

    public static LockScreenPushManager getInstance() {
        return SingleHolder.mInstance;
    }

    private LockScreenPushManager() {
        this.mGson = new Gson();
    }

    public void setShowingLockActivity(boolean showingLockActivity) {
        MLog.info((Object)TAG, (String)"setShowingLockActivity: %s", (Object[])new Object[]{showingLockActivity});
        this.isShowingLockActivity = showingLockActivity;
    }

    public void registerScreenReceiver() {
        MLog.info((Object)TAG, (String)"registerScreenReceiver", (Object[])new Object[0]);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        RuntimeContext.sApplicationContext.registerReceiver((BroadcastReceiver)new ScreenBroadcastReceiver(this.mScreenStateListener), filter);
    }

    private void onScreenOff() {
        MLog.debug((Object)TAG, (String)"onScreenOff", (Object[])new Object[0]);
    }

    private void onScreenOn() {
        if (this.isShowingLockActivity) {
            MLog.info((Object)TAG, (String)"onScreenOn isShowingLockActivity!!!", (Object[])new Object[0]);
            return;
        }
        LockScreenInfo info = this.consumeLockScreenInfo();
        if (info == null) {
            MLog.info((Object)TAG, (String)"onScreenOn info is empty!!!", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"onScreenOn showLockPush style: %s title: %s  content: %s", (Object[])new Object[]{info.style, info.title, info.content});
        Intent intent = new Intent();
        ComponentName cn = new ComponentName(AppKeysDef.getAppPackageName(), "com.yy.hiyo.module.push.lockscreen.LockScreenPushActivity");
        intent.setComponent(cn);
        intent.addFlags(0x10000000);
        intent.addFlags(0x4000000);
        intent.addFlags(0x800000);
        intent.putExtra(DATA_KEY, (Parcelable)info);
        RuntimeContext.sApplicationContext.startActivity(intent);
    }

    public boolean isFilterLockScreenPush(int style2) {
        return style2 == StyleType.StyleTypeLockScreen1.getValue() || style2 == StyleType.StyleTypeLockScreen2.getValue();
    }

    public void addLockScreenPush(PushNotificationData data2) {
        if (data2 == null) {
            return;
        }
        try {
            String payloadString = data2.getPayloadString();
            MLog.info((Object)TAG, (String)"addLockScreenPush style: %s title: %s content: %s payload: %s", (Object[])new Object[]{data2.getStyle(), data2.getTitle(), data2.getContent(), payloadString});
            LockScreenInfo lockScreenInfo = new LockScreenInfo(data2.getStyle(), String.valueOf(data2.getPushSource().getValue()), data2.getContent(), data2.getTitle(), data2.getAvatar(), payloadString, data2.getUid(), data2.getPushId(), data2.getFromChannel(), data2.getShowPush(), data2.isOffline());
            this.mLockScreenInfoList.addFirst(lockScreenInfo);
            this.saveToCache(lockScreenInfo);
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (String)"addLockScreenPush error", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    private LockScreenInfo consumeLockScreenInfo() {
        LockScreenInfo lockScreenInfo = !FP.empty(this.mLockScreenInfoList) ? this.mLockScreenInfoList.removeFirst() : this.getFromCache();
        if (lockScreenInfo != null) {
            this.clearCache();
        }
        return lockScreenInfo;
    }

    private void clearCache() {
        PushPref.getDefaultPrf().edit().remove("lock_sceen_info").apply();
    }

    private void saveToCache(LockScreenInfo info) {
        PushPref.getDefaultPrf().edit().putString("lock_sceen_info", this.mGson.toJson((Object)info)).apply();
    }

    private LockScreenInfo getFromCache() {
        String jsonString = PushPref.getDefaultPrf().getString("lock_sceen_info", "");
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        return (LockScreenInfo)this.mGson.fromJson(jsonString, LockScreenInfo.class);
    }

    private static class SingleHolder {
        public static LockScreenPushManager mInstance = new LockScreenPushManager();

        private SingleHolder() {
        }
    }
}

