/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.push;

import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.extensions.BaseExtensionKt;
import com.yy.appbase.extensions.EventExtensionsKt;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DateFormatUtils;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u000bH\u0002J\b\u0010$\u001a\u00020\"H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\tH\u0002J\n\u0010&\u001a\u0004\u0018\u00010\tH\u0002J\n\u0010'\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010(\u001a\u00020)H\u0007J\u0010\u0010*\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u000bH\u0002J\b\u0010+\u001a\u00020\"H\u0002J\b\u0010,\u001a\u00020)H\u0007J\b\u0010-\u001a\u00020)H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00078B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R&\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/yy/appbase/push/PushShowLimitManager;", "", "()V", "LIMIT_TIME_THRESHOLD", "", "activeUserShieldPushIdList", "", "", "mActiveUserTest", "Lcom/yy/appbase/abtest/IAB;", "value", "", "mContinuousLastPushClickDate", "getMContinuousLastPushClickDate", "()J", "setMContinuousLastPushClickDate", "(J)V", "mLastPushClickDate", "getMLastPushClickDate", "()Ljava/lang/String;", "setMLastPushClickDate", "(Ljava/lang/String;)V", "mLastPushShowDate", "getMLastPushShowDate", "setMLastPushShowDate", "mNoClickTest", "mShowLimitTest", "shownCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "splashFinishedTime", "checkRestrict", "Lcom/yy/appbase/push/PushShowLimitManager$LimitType;", "pushId", "checkRestrictByState", "", "checkRestrictForActiveUser", "checkRestrictForNoClick", "getActiveUserTest", "getNoClickTest", "getShowLimitTest", "init", "", "isActivePushHit", "isActiveUser", "updateForPushClick", "updateForPushShow", "LimitType", "appbase_release"})
public final class PushShowLimitManager {
    private static final int LIMIT_TIME_THRESHOLD = 3000;
    private static IAB mShowLimitTest;
    private static IAB mNoClickTest;
    private static IAB mActiveUserTest;
    private static long mLastPushShowDate;
    private static String mLastPushClickDate;
    private static long mContinuousLastPushClickDate;
    private static final List<String> activeUserShieldPushIdList;
    private static AtomicInteger shownCount;
    private static volatile long splashFinishedTime;
    public static final PushShowLimitManager INSTANCE;

    private final long getMLastPushShowDate() {
        if (mLastPushShowDate < 0L) {
            mLastPushShowDate = SettingFlags.getLongValue((String)"key_push_last_show_day", (long)System.currentTimeMillis());
        }
        return mLastPushShowDate;
    }

    private final void setMLastPushShowDate(long value) {
        if (mLastPushShowDate != value && value > 0L) {
            mLastPushShowDate = value;
            SettingFlags.setLongValue((String)"key_push_last_show_day", (long)value);
        }
    }

    private final String getMLastPushClickDate() {
        if (mLastPushClickDate == null) {
            mLastPushClickDate = SettingFlags.getStringValue((String)"key_push_click_data", (String)"");
        }
        return mLastPushClickDate;
    }

    private final void setMLastPushClickDate(String value) {
        if (Intrinsics.areEqual((Object)mLastPushClickDate, (Object)value) ^ true && value != null) {
            mLastPushClickDate = value;
            SettingFlags.setStringValue((String)"key_push_click_data", (String)value);
        }
    }

    private final long getMContinuousLastPushClickDate() {
        if (mContinuousLastPushClickDate < 0L && (mContinuousLastPushClickDate = SettingFlags.getLongValue((String)"key_continuous_push_no_click_date", (long)0L)) == 0L) {
            MLog.debug((Object)BaseExtensionKt.getTAG(this), (String)"init PUSH_CONTINUOUS_NO_CLICK_DATE", (Object[])new Object[0]);
            mContinuousLastPushClickDate = System.currentTimeMillis();
            SettingFlags.setLongValue((String)"key_continuous_push_no_click_date", (long)mContinuousLastPushClickDate);
        }
        return mContinuousLastPushClickDate;
    }

    private final void setMContinuousLastPushClickDate(long value) {
        if (mContinuousLastPushClickDate != value && value > 0L) {
            mContinuousLastPushClickDate = value;
            SettingFlags.setLongValue((String)"key_continuous_push_no_click_date", (long)value);
        }
    }

    private final IAB getShowLimitTest() {
        if (mShowLimitTest == null && NewABDefine.PUSH_SHOW_LIMIT.isTestValid()) {
            mShowLimitTest = NewABDefine.PUSH_SHOW_LIMIT.getTest();
        }
        return mShowLimitTest;
    }

    private final IAB getNoClickTest() {
        if (mNoClickTest == null && NewABDefine.CONTINUOUS_NO_CLICK_USER_PUSH_SHIELD.isTestValid()) {
            mNoClickTest = NewABDefine.CONTINUOUS_NO_CLICK_USER_PUSH_SHIELD.getTest();
        }
        return mNoClickTest;
    }

    private final IAB getActiveUserTest() {
        if (mActiveUserTest == null && NewABDefine.ACTIVE_USER_PUSH_SHIELD.isTestValid()) {
            mActiveUserTest = NewABDefine.ACTIVE_USER_PUSH_SHIELD.getTest();
        }
        return mActiveUserTest;
    }

    @JvmStatic
    @NotNull
    public static final LimitType checkRestrict(long pushId) {
        boolean isRestrict = INSTANCE.checkRestrictByState(pushId);
        MLog.info((Object)BaseExtensionKt.getTAG(INSTANCE), (String)("checkRestrictByState: " + isRestrict), (Object[])new Object[0]);
        if (isRestrict) {
            return LimitType.LIMIT_SHOW;
        }
        IAB abValue = INSTANCE.getShowLimitTest();
        MLog.info((Object)BaseExtensionKt.getTAG(INSTANCE), (String)("check show limit ab: " + abValue), (Object[])new Object[0]);
        if (abValue == null || Intrinsics.areEqual((Object)abValue, (Object)NAB.A)) {
            return LimitType.NO_LIMIT;
        }
        int limitCount = Intrinsics.areEqual((Object)abValue, (Object)NAB.B) || Intrinsics.areEqual((Object)abValue, (Object)NAB.C) ? 3 : 0;
        long duration = splashFinishedTime == 0L ? 0L : System.currentTimeMillis() - splashFinishedTime;
        MLog.info((Object)BaseExtensionKt.getTAG(INSTANCE), (String)("check limit: showCount = " + shownCount.get() + ", duration = " + duration), (Object[])new Object[0]);
        if (duration <= (long)3000) {
            if (shownCount.getAndIncrement() >= limitCount) {
                return Intrinsics.areEqual((Object)abValue, (Object)NAB.C) ? LimitType.LIMIT_PRIORITY : LimitType.LIMIT_SHOW;
            }
        } else {
            shownCount.set(0);
        }
        return LimitType.NO_LIMIT;
    }

    @JvmStatic
    public static final void updateForPushShow() {
        long today = System.currentTimeMillis();
        MLog.info((Object)BaseExtensionKt.getTAG(INSTANCE), (String)"push show, last show time: %s, new show time: %s", (Object[])new Object[]{DateUtils.dateToString((long)INSTANCE.getMLastPushShowDate(), (String)"yyyy-MM-dd"), DateUtils.dateToString((long)today, (String)"yyyy-MM-dd")});
        INSTANCE.setMLastPushShowDate(today);
    }

    @JvmStatic
    public static final void updateForPushClick() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        String today = DateFormatUtils.dateToString((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        MLog.info((Object)BaseExtensionKt.getTAG(INSTANCE), (String)("push click, today: " + today), (Object[])new Object[0]);
        INSTANCE.setMLastPushClickDate(today);
        INSTANCE.setMContinuousLastPushClickDate(System.currentTimeMillis());
        SettingFlags.setLongValue((String)"key_push_click_time", (long)System.currentTimeMillis());
    }

    @JvmStatic
    public static final void init() {
        MLog.info((Object)BaseExtensionKt.getTAG(INSTANCE), (String)"init splash finish time", (Object[])new Object[0]);
        splashFinishedTime = System.currentTimeMillis();
    }

    private final boolean checkRestrictByState(long pushId) {
        return this.checkRestrictForActiveUser(pushId) || this.checkRestrictForNoClick();
    }

    private final boolean checkRestrictForActiveUser(long pushId) {
        if (Intrinsics.areEqual((Object)this.getActiveUserTest(), (Object)NAB.B) ^ true) {
            MLog.info((Object)BaseExtensionKt.getTAG(this), (String)"checkRestrictForActiveUser: active_user_push_shield ab not hit", (Object[])new Object[0]);
            return false;
        }
        boolean isActiveUser = this.isActiveUser();
        MLog.info((Object)BaseExtensionKt.getTAG(this), (String)("checkActiveUser: is active user: " + isActiveUser), (Object[])new Object[0]);
        if (!isActiveUser) {
            return false;
        }
        MLog.info((Object)BaseExtensionKt.getTAG(this), (String)("checkActiveUser: last push click day : " + this.getMLastPushClickDate()), (Object[])new Object[0]);
        String string2 = this.getMLastPushClickDate();
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        boolean isTodayHasClicked = Intrinsics.areEqual((Object)string2, (Object)DateFormatUtils.dateToString((Date)calendar.getTime(), (String)"yyyy-MM-dd"));
        if (isTodayHasClicked && this.isActivePushHit(pushId)) {
            MLog.info((Object)BaseExtensionKt.getTAG(this), (String)"checkActiveUser: limited !!!!", (Object[])new Object[0]);
            HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20025571").put("function_id", "show_limit").put("limit", "1");
            Intrinsics.checkExpressionValueIsNotNull((Object)hiidoEvent, (String)"HiidoEvent.obtain().even\u2026       .put(\"limit\", \"1\")");
            EventExtensionsKt.report(hiidoEvent);
            return true;
        }
        return false;
    }

    private final boolean isActivePushHit(long pushId) {
        return activeUserShieldPushIdList.contains(StringsKt.take((String)String.valueOf(pushId), (int)3));
    }

    private final boolean checkRestrictForNoClick() {
        int n;
        boolean bl;
        String string2;
        IAB abValue = this.getNoClickTest();
        if (abValue == null || Intrinsics.areEqual((Object)abValue, (Object)NAB.A)) {
            return false;
        }
        String dayConfig = SettingFlags.getStringValue((String)"key_push_continuous_day_list");
        MLog.info((Object)BaseExtensionKt.getTAG(this), (String)("checkContinuousNoClickUser: ab = " + abValue + ", dayConfig = " + dayConfig), (Object[])new Object[0]);
        String string3 = dayConfig;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dayConfig");
        List countList = StringsKt.split$default((CharSequence)string3, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        Collection collection = countList;
        boolean bl2 = false;
        boolean bl3 = false;
        if (collection == null || collection.isEmpty() || countList.size() != 3) {
            return false;
        }
        IAB iAB = abValue;
        if (Intrinsics.areEqual((Object)iAB, (Object)NAB.B)) {
            string2 = (String)countList.get(0);
            bl = false;
            n = Integer.parseInt(string2);
        } else if (Intrinsics.areEqual((Object)iAB, (Object)NAB.C)) {
            string2 = (String)countList.get(1);
            bl = false;
            n = Integer.parseInt(string2);
        } else {
            string2 = (String)countList.get(2);
            bl = false;
            n = Integer.parseInt(string2);
        }
        int continuousLimitDay = n;
        int noClickDays = DateUtils.getIntervalDays((long)this.getMContinuousLastPushClickDate(), (long)System.currentTimeMillis());
        MLog.info((Object)BaseExtensionKt.getTAG(this), (String)("checkContinuousNoClickUser: no click days: " + noClickDays), (Object[])new Object[0]);
        if (noClickDays == continuousLimitDay) {
            MLog.error((Object)BaseExtensionKt.getTAG(this), (String)"checkContinuousNoClickUser: limited !!!!", (Object[])new Object[0]);
            HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20025571").put("function_id", "show_limit").put("limit", "2");
            Intrinsics.checkExpressionValueIsNotNull((Object)hiidoEvent, (String)"HiidoEvent.obtain().even\u2026       .put(\"limit\", \"2\")");
            EventExtensionsKt.report(hiidoEvent);
            return true;
        }
        return false;
    }

    private final boolean isActiveUser() {
        long firstInstalledTime = SettingFlags.getLongValue((String)"key_first_install_time", (long)0L);
        int installedDay = DateUtils.getIntervalDays((long)firstInstalledTime, (long)System.currentTimeMillis());
        MLog.info((Object)BaseExtensionKt.getTAG(this), (String)("installed day  = " + installedDay), (Object[])new Object[0]);
        if (installedDay < 3) {
            return false;
        }
        long lastForegroundTime = SettingFlags.getLongValue((String)"key_last_foreground_time", (long)0L);
        if (lastForegroundTime > 0L) {
            int lastForegroundDuring = DateUtils.getIntervalDays((long)lastForegroundTime, (long)System.currentTimeMillis());
            MLog.info((Object)BaseExtensionKt.getTAG(this), (String)("last foreground day difference: " + lastForegroundDuring), (Object[])new Object[0]);
            if (lastForegroundDuring < 3) {
                return true;
            }
        }
        return false;
    }

    private PushShowLimitManager() {
    }

    static {
        PushShowLimitManager pushShowLimitManager;
        INSTANCE = pushShowLimitManager = new PushShowLimitManager();
        mLastPushShowDate = -1L;
        mContinuousLastPushClickDate = -1L;
        activeUserShieldPushIdList = CollectionsKt.listOf((Object[])new String[]{"718", "720", "728", "512"});
        shownCount = new AtomicInteger(0);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/yy/appbase/push/PushShowLimitManager$LimitType;", "", "type", "", "(Ljava/lang/String;II)V", "getType", "()I", "NO_LIMIT", "LIMIT_SHOW", "LIMIT_PRIORITY", "appbase_release"})
    public static final class LimitType
    extends Enum<LimitType> {
        public static final /* enum */ LimitType NO_LIMIT;
        public static final /* enum */ LimitType LIMIT_SHOW;
        public static final /* enum */ LimitType LIMIT_PRIORITY;
        private static final /* synthetic */ LimitType[] $VALUES;
        private final int type;

        static {
            LimitType[] limitTypeArray = new LimitType[3];
            LimitType[] limitTypeArray2 = limitTypeArray;
            limitTypeArray[0] = NO_LIMIT = new LimitType(0);
            limitTypeArray[1] = LIMIT_SHOW = new LimitType(1);
            limitTypeArray[2] = LIMIT_PRIORITY = new LimitType(2);
            $VALUES = limitTypeArray;
        }

        public final int getType() {
            return this.type;
        }

        private LimitType(int type2) {
            this.type = type2;
        }

        public static LimitType[] values() {
            return (LimitType[])$VALUES.clone();
        }

        public static LimitType valueOf(String string2) {
            return Enum.valueOf(LimitType.class, string2);
        }
    }
}

