/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.push;

import androidx.annotation.NonNull;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.push.PushClearConfig;
import com.yy.appbase.push.PushNotificationData;
import com.yy.appbase.push.pushhiido.ISimpleCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.PushClearBossConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import ikxd.msg.PushSourceType;
import java.util.concurrent.locks.ReentrantLock;

public class PushClearManager {
    private static final String TAG = "PushClearManager";
    private ReentrantLock mReentrantLock = new ReentrantLock();
    private PushClearConfig mPushClearConfig;
    private static final int CONFIG_UNINITIALIZED = -1;
    private static final int CONFIG_FROM_FILE = 0;
    private static final int CONFIG_FROM_BOSS = 1;
    private int readFrom = -1;

    public static PushClearManager getInstance() {
        return SingleHolder.mInstance;
    }

    private PushClearManager() {
    }

    public void getPushOngoingValue(PushNotificationData pushNotificationData, @NonNull ISimpleCallback<Boolean> simpleCallback) {
        MLog.info((Object)TAG, (String)"getPushOngoingValue pushSource: %s", (Object[])new Object[]{pushNotificationData.getPushSource()});
        if (pushNotificationData.getPushSource() == PushSourceType.kPushSourceChannel || PushSourceType.kPushSourceFloatPush == pushNotificationData.getPushSource()) {
            simpleCallback.onSuccess(false);
            return;
        }
        this.getPushClearConfig(config -> {
            MLog.info((Object)TAG, (String)"getPushClearConfig AB: %s config: %s", (Object[])new Object[]{NewABDefine.HAGO_PUSH_DISMISS_ANDROID.getTest(), config});
            PushClearConfig.NotifyClearConfig clearConfig = this.getClearConfigByABTest(config);
            if (clearConfig == null) {
                MLog.info((Object)TAG, (String)"getPushClearConfig clearConfig is null", (Object[])new Object[0]);
                simpleCallback.onSuccess(true);
            } else {
                boolean ongoingValue = this.judgeOngoingValue(clearConfig, pushNotificationData);
                MLog.info((Object)TAG, (String)"getPushClearConfig ongoingValue: %s", (Object[])new Object[]{ongoingValue});
                simpleCallback.onSuccess(ongoingValue);
            }
        });
    }

    private void getPushClearConfig(@NonNull IGetPushClearConfigCallback callback) {
        if (this.readFrom == 1) {
            callback.completed(this.mPushClearConfig);
            return;
        }
        AConfigData data2 = UnifyConfig.INSTANCE.getConfigData(BssCode.PUSH_CLEAR_CONFIG);
        if (data2 instanceof PushClearBossConfig) {
            this.mPushClearConfig = ((PushClearBossConfig)data2).getPushClearConfig();
            this.readFrom = 1;
            callback.completed(this.mPushClearConfig);
            return;
        }
        if (this.readFrom == 0) {
            callback.completed(this.mPushClearConfig);
            return;
        }
        this.readFromFile(callback::completed);
    }

    private void readFromFile(IGetPushClearConfigCallback callback) {
        YYTaskExecutor.execute(() -> {
            try {
                this.mReentrantLock.lock();
                if (this.mPushClearConfig == null) {
                    String json = FileStorageUtils.getInstance().getStrFromFile(true, "PushClearBossConfig");
                    this.mPushClearConfig = (PushClearConfig)JsonParser.parseJsonObject((String)json, PushClearConfig.class);
                    this.readFrom = 0;
                }
                YYTaskExecutor.postToMainThread(() -> callback.completed(this.mPushClearConfig));
            }
            catch (Exception e) {
                MLog.info((Object)TAG, (String)"getPushClearConfig ex: %s", (Object[])new Object[]{e});
            }
            finally {
                this.mReentrantLock.unlock();
            }
        });
    }

    private boolean judgeOngoingValue(PushClearConfig.NotifyClearConfig clearConfig, PushNotificationData pushNotificationData) {
        if (pushNotificationData == null) {
            return false;
        }
        int pushSourceType = pushNotificationData.getPushSource().getValue();
        if (!FP.empty(clearConfig.notCanClearPushSource) && clearConfig.notCanClearPushSource.contains(pushSourceType)) {
            MLog.info((Object)TAG, (String)"judgeOngoingValue config notCanClearPushSource : %s", (Object[])new Object[]{pushSourceType});
            return true;
        }
        if (!FP.empty(clearConfig.canClearPushSource) && clearConfig.canClearPushSource.contains(pushSourceType)) {
            MLog.info((Object)TAG, (String)"judgeOngoingValue config canClearPushSource : %s", (Object[])new Object[]{pushSourceType});
            return false;
        }
        if (FP.empty(clearConfig.canClearChannel)) {
            return true;
        }
        int channelId = pushNotificationData.getGroup().getId();
        MLog.info((Object)TAG, (String)"judgeOngoingValue get channelId: %s", (Object[])new Object[]{channelId});
        for (int i = 0; i < clearConfig.canClearChannel.size(); ++i) {
            PushClearConfig.ClearChannelConfig channel = clearConfig.canClearChannel.get(i);
            if (channel == null || channel.channelId != channelId) continue;
            MLog.info((Object)TAG, (String)"judgeOngoingValue needOpen: %s  openTimes: %s", (Object[])new Object[]{channel.needOpenApp, RuntimeContext.getTodayOpenTimes()});
            return channel.needOpenApp && RuntimeContext.getTodayOpenTimes() < 1;
        }
        return true;
    }

    private PushClearConfig.NotifyClearConfig getClearConfigByABTest(PushClearConfig config) {
        String plan = this.getUserPlan();
        MLog.info((Object)TAG, (String)"getClearConfigByABTest plan: %s", (Object[])new Object[]{plan});
        if (FP.empty((CharSequence)plan)) {
            return null;
        }
        if (config == null || FP.empty(config.notifyClearConfigList)) {
            return null;
        }
        for (int i = 0; i < config.notifyClearConfigList.size(); ++i) {
            PushClearConfig.NotifyClearConfig clearConfig = config.notifyClearConfigList.get(i);
            if (clearConfig == null || !StringUtils.equalsIgnoreCase((String)plan, (String)clearConfig.testPlan)) continue;
            return clearConfig;
        }
        return null;
    }

    private String getUserPlan() {
        if (NAB.A.equals(NewABDefine.HAGO_PUSH_DISMISS_ANDROID.getTest())) {
            return "A";
        }
        if (NAB.B.equals(NewABDefine.HAGO_PUSH_DISMISS_ANDROID.getTest())) {
            return "B";
        }
        if (NAB.C.equals(NewABDefine.HAGO_PUSH_DISMISS_ANDROID.getTest())) {
            return "C";
        }
        return "";
    }

    public static interface IGetPushClearConfigCallback {
        public void completed(PushClearConfig var1);
    }

    private static class SingleHolder {
        public static PushClearManager mInstance = new PushClearManager();

        private SingleHolder() {
        }
    }
}

