/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.push;

import android.os.Build;
import android.text.TextUtils;
import android.util.LongSparseArray;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.push.GroupType;
import com.yy.appbase.push.PushChannelAndGroupKt;
import com.yy.appbase.push.PushNotificationData;
import com.yy.base.logger.MLog;
import ikxd.msg.PushSourceType;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class NotificationIdGenerator {
    public static final String TAG = "NotificationIdGenerator";
    private static final int PUSH_BACKSTAGE_ID_START = 10000;
    private static final int PUSH_BACKSTAGE_MAX_COUNT = 3;
    private static final int MIUI_PUSH_ADD = 0x999999;
    private LongSparseArray<Integer> mNotifyIdMap = new LongSparseArray();
    private AtomicInteger mBackstageAtomic = new AtomicInteger(10000);
    private AtomicInteger mDefaultAtomic = new AtomicInteger();

    private NotificationIdGenerator() {
    }

    public static NotificationIdGenerator getInstance() {
        return SingletonLoader.INSTANCE;
    }

    public int getId(PushNotificationData data2) {
        if (data2 == null) {
            return -1;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return this.getNotifyIdAboveN(data2);
        }
        return this.getNotifyIdBelowN(data2);
    }

    private int getNotifyIdAboveN(PushNotificationData data2) {
        if (this.isMIUI()) {
            return data2.getGroup().getId() + 0x999999;
        }
        if (PushChannelAndGroupKt.isImPayload(data2.getPushSource(), data2.getPayloadJson()) || data2.getPushSource() == PushSourceType.kPushSourceGameInvite) {
            return (int)data2.getUid();
        }
        if (data2.getPushSource() == PushSourceType.kPushSourceChannel) {
            String cid = data2.getCid();
            if (!TextUtils.isEmpty((CharSequence)cid)) {
                return cid.hashCode();
            }
            return (int)AccountUtil.getUid();
        }
        if (data2.getGroup() == GroupType.PUSH_BACKSTAGE) {
            int pushBackstageId = this.mBackstageAtomic.incrementAndGet();
            if (pushBackstageId > 10003) {
                this.mBackstageAtomic.set(10000);
                pushBackstageId = this.mBackstageAtomic.incrementAndGet();
            }
            return pushBackstageId;
        }
        if (data2.getPushSource() == PushSourceType.kPushSourceChannelInvite) {
            return this.getChannelInvitePushId(data2);
        }
        return this.mDefaultAtomic.incrementAndGet();
    }

    private int getNotifyIdBelowN(PushNotificationData data2) {
        long uid = data2.getUid();
        if (uid <= 0L) {
            return this.mDefaultAtomic.incrementAndGet();
        }
        if (this.mNotifyIdMap.indexOfKey(uid) > 0) {
            return (Integer)this.mNotifyIdMap.get(uid);
        }
        int id2 = this.mDefaultAtomic.incrementAndGet();
        this.mNotifyIdMap.put(uid, (Object)id2);
        return id2;
    }

    private int getChannelInvitePushId(PushNotificationData data2) {
        JSONObject vchatJson = data2 == null ? null : data2.getPayloadJson().optJSONObject("vchat");
        String roomId = "";
        if (vchatJson != null) {
            roomId = vchatJson.optString("roomid");
        }
        if (!TextUtils.isEmpty((CharSequence)roomId)) {
            return roomId.concat("invite").hashCode();
        }
        return (int)AccountUtil.getUid();
    }

    private boolean isMIUI() {
        boolean isXiaomi = "xiaomi".equalsIgnoreCase(Build.MANUFACTURER);
        MLog.info((Object)TAG, (String)("isMIui:" + isXiaomi), (Object[])new Object[0]);
        return isXiaomi;
    }

    private static class SingletonLoader {
        private static final NotificationIdGenerator INSTANCE = new NotificationIdGenerator();

        private SingletonLoader() {
        }
    }
}

