/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.source;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import java.lang.reflect.Method;

public abstract class Source {
    public abstract Context getContext();

    public abstract void startActivity(Intent var1);

    public abstract void startActivityForResult(Intent var1, int var2);

    public abstract void requestPermission(String[] var1, PermissionListener var2);

    public final boolean isShowRationalePermission(String permission) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        PackageManager packageManager = this.getContext().getPackageManager();
        Class<?> pkManagerClass = packageManager.getClass();
        try {
            Method method = pkManagerClass.getMethod("shouldShowRequestPermissionRationale", String.class);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (Boolean)method.invoke((Object)packageManager, permission);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static interface PermissionListener {
        public void onRequestPermissionsResult(@NonNull String[] var1);
    }
}

