/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.setting;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import com.yy.appbase.permission.SettingService;
import com.yy.appbase.permission.source.Source;
import com.yy.base.logger.MLog;

public class PermissionSetting
implements SettingService {
    private static final String MARK = Build.MANUFACTURER.toLowerCase();
    private Source mSource;

    public PermissionSetting(@NonNull Source source) {
        this.mSource = source;
    }

    @Override
    public void execute() {
        Intent intent = this.obtainSettingIntent();
        try {
            this.mSource.startActivity(intent);
        }
        catch (Exception e) {
            try {
                this.mSource.startActivity(PermissionSetting.defaultApi(this.mSource.getContext()));
            }
            catch (Exception e2) {
                MLog.error((Object)"PermissionSetting", (Throwable)e2);
            }
        }
    }

    @Override
    public void execute(int requestCode) {
        Intent intent = this.obtainSettingIntent();
        try {
            this.mSource.startActivityForResult(intent, requestCode);
        }
        catch (Exception e) {
            this.mSource.startActivityForResult(PermissionSetting.defaultApi(this.mSource.getContext()), requestCode);
        }
    }

    @Override
    public void cancel() {
    }

    private Intent obtainSettingIntent() {
        if (MARK.contains("huawei")) {
            return PermissionSetting.huaweiApi(this.mSource.getContext());
        }
        if (MARK.contains("xiaomi")) {
            return PermissionSetting.xiaomiApi(this.mSource.getContext());
        }
        if (MARK.contains("oppo")) {
            return PermissionSetting.oppoApi(this.mSource.getContext());
        }
        if (MARK.contains("vivo")) {
            return PermissionSetting.vivoApi(this.mSource.getContext());
        }
        if (MARK.contains("samsung")) {
            return PermissionSetting.samsungApi(this.mSource.getContext());
        }
        if (MARK.contains("meizu")) {
            return PermissionSetting.meizuApi(this.mSource.getContext());
        }
        if (MARK.contains("smartisan")) {
            return PermissionSetting.smartisanApi(this.mSource.getContext());
        }
        return PermissionSetting.defaultApi(this.mSource.getContext());
    }

    private static Intent defaultApi(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        return intent;
    }

    private static Intent huaweiApi(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return PermissionSetting.defaultApi(context);
        }
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity"));
        return intent;
    }

    private static Intent xiaomiApi(Context context) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        return intent;
    }

    private static Intent vivoApi(Context context) {
        Intent intent = new Intent();
        intent.putExtra("packagename", context.getPackageName());
        if (Build.VERSION.SDK_INT >= 25) {
            intent.setComponent(new ComponentName("com.vivo.permissionmanager", "com.vivo.permissionmanager.activity.SoftPermissionDetailActivity"));
        } else {
            intent.setComponent(new ComponentName("com.iqoo.secure", "com.iqoo.secure.safeguard.SoftPermissionDetailActivity"));
        }
        return intent;
    }

    private static Intent oppoApi(Context context) {
        return PermissionSetting.defaultApi(context);
    }

    private static Intent meizuApi(Context context) {
        if (Build.VERSION.SDK_INT >= 25) {
            return PermissionSetting.defaultApi(context);
        }
        Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
        intent.putExtra("packageName", context.getPackageName());
        intent.setComponent(new ComponentName("com.meizu.safe", "com.meizu.safe.security.AppSecActivity"));
        return intent;
    }

    private static Intent smartisanApi(Context context) {
        return PermissionSetting.defaultApi(context);
    }

    private static Intent samsungApi(Context context) {
        return PermissionSetting.defaultApi(context);
    }
}

