/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.helper;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.R;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.permission.Action;
import com.yy.appbase.permission.AndPermission;
import com.yy.appbase.permission.Permission;
import com.yy.appbase.permission.SettingService;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionGuideDialog;
import com.yy.appbase.permission.helper.PermissionHelperUtil;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class PermissionHelperController
implements INotify {
    private boolean mIsRequireCheck;
    private boolean mCanShowRemind;
    private String[] mPermissions;
    private String mListenerKey;
    private String mIllustateTip;
    private String mRemindTip;
    private String mAlwaysDenyiedTip;
    private boolean mFromHasPermission;
    private Activity mContext;
    private PermissionGuideDialog mGuideDialog;
    private DialogLinkManager mDialogLinkManager;
    private static String TAG = "PermissionHelperController";

    public PermissionHelperController(Activity activity) {
        this.mContext = activity;
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationIdDef.PERMISSION_ON_RESUME) {
            this.checkPermissionOnResume();
        } else if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.closeDialog();
        }
    }

    private void closeDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.permissionsDenied();
        this.reportPermissionEvent("click_cancel");
        if (PermissionHelperUtil.permissionContact(this.mPermissions)) {
            SettingFlags.setBoolean((String)"show_contacts_use_tips", (boolean)true);
        }
    }

    public void actionToCheckPermission(String illustateTip, String remindTip, String alwaysDenyiedTip, String listenerKey, String[] permissions, boolean fromHasPermission) {
        this.mRemindTip = remindTip;
        this.mAlwaysDenyiedTip = alwaysDenyiedTip;
        this.mIllustateTip = illustateTip;
        this.mPermissions = permissions;
        this.mListenerKey = listenerKey;
        this.mFromHasPermission = fromHasPermission;
        if (this.mPermissions == null) {
            return;
        }
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.PERMISSION_ON_RESUME, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        this.mIsRequireCheck = true;
        this.mCanShowRemind = true;
        if (TextUtils.isEmpty((CharSequence)this.mIllustateTip)) {
            this.checkPermission();
        } else {
            this.showPermissionIllustateDialog(this.mIllustateTip);
        }
    }

    private void checkPermission() {
        MLog.info((Object)TAG, (String)("checkPermission mIsRequireCheck= " + this.mIsRequireCheck + " key=" + this.mListenerKey), (Object[])new Object[0]);
        if (this.mIsRequireCheck) {
            if (this.hasPermission()) {
                this.permissionsGranted();
            } else if (!this.mFromHasPermission) {
                this.requestThePermissions();
                this.mIsRequireCheck = false;
            } else {
                this.permissionsDenied();
            }
        }
    }

    private void checkPermissionOnResume() {
        MLog.info((Object)TAG, (String)("checkPermissionOnResume== mIsRequireCheck = " + this.mIsRequireCheck + " key= " + this.mListenerKey), (Object[])new Object[0]);
        if (this.mIsRequireCheck) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    final boolean permission = PermissionHelperController.this.hasPermission();
                    MLog.info((Object)TAG, (String)("checkPermissionOnResume== haspermission = " + permission), (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (permission) {
                                PermissionHelperController.this.permissionsGranted();
                            } else {
                                PermissionHelperController.this.permissionsDenied();
                                PermissionHelperController.this.mIsRequireCheck = false;
                                PermissionHelperController.this.unregisterNotify();
                            }
                        }
                    });
                }
            });
        }
    }

    private boolean needDoubleCheck() {
        if (this.mPermissions == null || this.mPermissions.length <= 0) {
            return false;
        }
        String permission = this.mPermissions[0];
        return this.mPermissions == Permission.Group.STORAGE || StringUtils.equal((String)permission, (String)Permission.Group.STORAGE[0]);
    }

    private boolean hasPermission() {
        if (this.needDoubleCheck()) {
            return PermissionHelperUtil.hasPermissioWithDoubleCheck(this.mContext, this.mPermissions);
        }
        return PermissionHelperUtil.hasPermission(this.mContext, this.mPermissions);
    }

    private void requestThePermissions() {
        if (PermissionHelperUtil.permissionContact(this.mPermissions)) {
            this.requestContactPermission();
            return;
        }
        if (PermissionHelperUtil.permissionRecordAudio(this.mPermissions)) {
            this.requestRecordAudioPermission();
            return;
        }
        this.startRequestPermissions();
    }

    private void startRequestPermissions() {
        this.eventNotify(NotificationDef.N_PERMISSION_REQUEST_SHOW);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PermissionHelperController.this.startRequestPermissionsAsync();
            }
        });
    }

    private void startRequestPermissionsAsync() {
        AndPermission.with(this.mContext).permission(this.mPermissions).onGranted(new Action(){

            @Override
            public void onAction(List<String> permissions) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PermissionHelperController.this.onGranted();
                    }
                });
            }
        }).onDenied(new Action(){

            @Override
            public void onAction(@NonNull List<String> permissions) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PermissionHelperController.this.onDenied();
                    }
                });
            }
        }).start();
        if (!PermissionHelperUtil.permissionContact(this.mPermissions) && !PermissionHelperUtil.permissionLocation(this.mPermissions)) {
            this.reportPermissionEvent("show");
        }
    }

    private void onGranted() {
        this.permissionsGranted();
        if (!PermissionHelperUtil.permissionContact(this.mPermissions) && !PermissionHelperUtil.permissionLocation(this.mPermissions)) {
            this.reportPermissionEvent("click_ok");
        }
        this.eventNotify(NotificationDef.N_PERMISSION_REQUEST_ANSWERED);
    }

    private void onDenied() {
        boolean isShow = this.showAlwaysDeniedPermissionDialog(this.mContext);
        if (!isShow) {
            if (!this.mCanShowRemind) {
                this.permissionsDenied();
            } else if (!TextUtils.isEmpty((CharSequence)this.mRemindTip)) {
                this.mCanShowRemind = false;
                this.showPermissionRemindDialog();
            } else {
                this.permissionsDenied();
            }
        }
        if (!PermissionHelperUtil.permissionContact(this.mPermissions) && !PermissionHelperUtil.permissionLocation(this.mPermissions)) {
            this.reportPermissionEvent("click_cancel");
        }
        this.eventNotify(NotificationDef.N_PERMISSION_REQUEST_ANSWERED);
    }

    private void eventNotify(final int notificationId) {
        if (YYTaskExecutor.isMainThread()) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)notificationId));
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)notificationId));
                }
            });
        }
    }

    private void requestContactPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.startRequestPermissions();
        } else {
            this.showGoSettingDialog(ResourceUtils.getString((int)R.string.contact_pemission_tips));
        }
    }

    private void requestRecordAudioPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.startRequestPermissions();
        } else {
            this.showGoSettingDialog(ResourceUtils.getString((int)R.string.permission_record_audio_setting_instructions));
        }
    }

    private void showPermissionIllustateDialog(String illustrateTip) {
        if (PermissionHelperUtil.permissionContact(this.mPermissions) || PermissionHelperUtil.permissionLocation(this.mPermissions)) {
            this.showPermissionGuideDialog();
        }
        if (this.mGuideDialog != null) {
            if (this.mDialogLinkManager == null) {
                this.mDialogLinkManager = new DialogLinkManager((Context)this.mContext);
            }
            this.mDialogLinkManager.showDialog((BaseDialog)this.mGuideDialog);
            if (!TextUtils.isEmpty((CharSequence)illustrateTip)) {
                this.mGuideDialog.setIllustrateTip(illustrateTip);
            }
            this.reportPermissionEvent("show");
            if (PermissionHelperUtil.permissionContact(this.mPermissions)) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024335").put("function_id", "contact_show").put("refer", String.valueOf(1)));
            }
            return;
        }
        DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)this.mContext);
        OkCancelDialog tipsDialog = new OkCancelDialog(this.mIllustateTip, ResourceUtils.getString((int)R.string.contact_dialog_ok), ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, false, new OkCancelDialogListener(){

            @Override
            public void onCancel() {
                PermissionHelperController.this.permissionsDenied();
                PermissionHelperController.this.reportPermissionEvent("click_cancel");
            }

            @Override
            public void onOk() {
                PermissionHelperController.this.checkPermission();
                PermissionHelperController.this.reportPermissionEvent("click_ok");
            }
        });
        tipsDialog.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                PermissionHelperController.this.permissionsDenied();
                PermissionHelperController.this.reportPermissionEvent("click_cancel");
            }
        });
        dialogLinkManager.showDialog((BaseDialog)tipsDialog);
        this.reportPermissionEvent("show");
    }

    private void showPermissionGuideDialog() {
        int type2 = 0;
        if (PermissionHelperUtil.permissionLocation(this.mPermissions)) {
            type2 = 1;
        }
        if (PermissionHelperUtil.permissionContact(this.mPermissions)) {
            type2 = 0;
        }
        this.mGuideDialog = new PermissionGuideDialog(type2, new PermissionGuideDialog.PermissionGuideCallback(){

            @Override
            public void onClickClose() {
                PermissionHelperController.this.closeDialog();
            }

            @Override
            public void onClickAgree() {
                if (PermissionHelperController.this.mDialogLinkManager != null) {
                    PermissionHelperController.this.mDialogLinkManager.dismissDialog();
                }
                PermissionHelperController.this.checkPermission();
                PermissionHelperController.this.reportPermissionEvent("click_ok");
                if (PermissionHelperUtil.permissionContact(PermissionHelperController.this.mPermissions)) {
                    SettingFlags.setBoolean((String)"show_contacts_use_tips", (boolean)true);
                }
            }
        });
    }

    private void showPermissionRemindDialog() {
        DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)this.mContext);
        OkCancelDialog tipsDialog = new OkCancelDialog(this.mRemindTip, ResourceUtils.getString((int)R.string.contact_dialog_ok), ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, false, new OkCancelDialogListener(){

            @Override
            public void onCancel() {
                PermissionHelperController.this.permissionsDenied();
            }

            @Override
            public void onOk() {
                PermissionHelperController.this.mIsRequireCheck = true;
                PermissionHelperController.this.checkPermission();
            }
        });
        tipsDialog.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                PermissionHelperController.this.permissionsDenied();
            }
        });
        dialogLinkManager.showDialog((BaseDialog)tipsDialog);
    }

    private boolean showAlwaysDeniedPermissionDialog(Activity activity) {
        if (TextUtils.isEmpty((CharSequence)this.mAlwaysDenyiedTip)) {
            return false;
        }
        if (AndPermission.hasAlwaysDeniedPermission(activity, this.mPermissions)) {
            final SettingService settingService = AndPermission.permissionSetting(activity);
            DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)activity);
            OkCancelDialog tipsDialog = new OkCancelDialog(this.mAlwaysDenyiedTip, ResourceUtils.getString((int)R.string.contact_dialog_ok), ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, false, new OkCancelDialogListener(){

                @Override
                public void onCancel() {
                    settingService.cancel();
                    PermissionHelperController.this.permissionsDenied();
                }

                @Override
                public void onOk() {
                    PermissionHelperController.this.mIsRequireCheck = true;
                    settingService.execute();
                }
            });
            tipsDialog.setCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    settingService.cancel();
                    PermissionHelperController.this.permissionsDenied();
                }
            });
            dialogLinkManager.showDialog((BaseDialog)tipsDialog);
            return true;
        }
        return false;
    }

    private void showGoSettingDialog(String msg) {
        final SettingService settingService = AndPermission.permissionSetting(this.mContext);
        DialogLinkManager dialogLinkManager = new DialogLinkManager((Context)this.mContext);
        OkCancelDialog tipsDialog = new OkCancelDialog(msg, ResourceUtils.getString((int)R.string.contact_dialog_ok), ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, false, new OkCancelDialogListener(){

            @Override
            public void onCancel() {
                PermissionHelperController.this.permissionsDenied();
                PermissionHelperController.this.unregisterNotify();
            }

            @Override
            public void onOk() {
                PermissionHelperController.this.mIsRequireCheck = true;
                settingService.execute();
            }
        });
        tipsDialog.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                PermissionHelperController.this.permissionsDenied();
                PermissionHelperController.this.unregisterNotify();
            }
        });
        dialogLinkManager.showDialog((BaseDialog)tipsDialog);
    }

    private void permissionsGranted() {
        IPermissionListener listener2 = PermissionHelperUtil.getPermissionListener(this.mListenerKey);
        if (listener2 != null) {
            listener2.onPermissionGranted(this.mPermissions);
        }
        this.unregisterNotify();
    }

    private void permissionsDenied() {
        IPermissionListener listener2 = PermissionHelperUtil.getPermissionListener(this.mListenerKey);
        if (listener2 != null) {
            listener2.onPermissionDenied(this.mPermissions);
        }
    }

    private void unregisterNotify() {
        NotificationCenter.getGlobalInstance().unregister(NotificationIdDef.PERMISSION_ON_RESUME, (INotify)this);
    }

    private void reportPermissionEvent(String functionId) {
        if (Build.VERSION.SDK_INT >= 23) {
            String pageId = "";
            if (PermissionHelperUtil.permissionLocation(this.mPermissions)) {
                pageId = "2";
            } else if (PermissionHelperUtil.permissionContact(this.mPermissions)) {
                pageId = "3";
            } else if (PermissionHelperUtil.permissionRecordAudio(this.mPermissions)) {
                pageId = "4";
            } else if (PermissionHelperUtil.permissionCamera(this.mPermissions)) {
                pageId = "5";
            } else if (PermissionHelperUtil.permissionStorage(this.mPermissions)) {
                pageId = "1";
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025229").put("page_id", pageId).put("function_id", functionId));
        }
    }
}

