/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission.checker;

import android.content.Context;
import android.database.Cursor;
import android.provider.ContactsContract;
import com.yy.appbase.permission.checker.PermissionTest;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;

public class ContactsReadTest
implements PermissionTest {
    private static ContactsReadTestInner sTestInner = new ContactsReadTestInner();

    public ContactsReadTest(Context context) {
    }

    public ContactsReadTest() {
    }

    @Override
    public boolean test() throws Throwable {
        return sTestInner.test();
    }

    private static class ContactsReadTestInner
    implements PermissionTest,
    INotify {
        private volatile boolean sHasPer = true;
        private volatile boolean sHasTest = false;

        ContactsReadTestInner() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test() throws Throwable {
            if (this.sHasTest) {
                return this.sHasPer;
            }
            Cursor cursor = null;
            try {
                boolean result = false;
                cursor = RuntimeContext.sApplicationContext.getContentResolver().query(ContactsContract.Contacts.CONTENT_URI, new String[]{"display_name"}, null, null, null);
                if (cursor != null) {
                    this.sHasPer = cursor.getCount() != 0;
                    this.sHasTest = true;
                } else {
                    this.sHasPer = false;
                    this.sHasTest = true;
                }
                boolean bl = result;
                return bl;
            }
            catch (Throwable e) {
                this.sHasPer = false;
                this.sHasTest = true;
                boolean bl = false;
                return bl;
            }
            finally {
                this.sHasTest = true;
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Exception e) {
                        MLog.error((Object)"ContactsReadTest", (Throwable)e);
                    }
                }
            }
        }

        public void notify(Notification notification) {
            if (notification == null || notification.id != NotificationDef.N_FOREGROUND_CHANGE) {
                return;
            }
            if (notification.extObj instanceof Boolean && !((Boolean)notification.extObj).booleanValue()) {
                this.sHasTest = false;
            }
        }
    }
}

