/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.permission;

import android.app.Activity;
import android.os.Build;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.yy.appbase.permission.LRequest;
import com.yy.appbase.permission.MRequest;
import com.yy.appbase.permission.Request;
import com.yy.appbase.permission.SettingService;
import com.yy.appbase.permission.setting.PermissionSetting;
import com.yy.appbase.permission.source.AppActivitySource;
import com.yy.appbase.permission.source.Source;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import java.util.List;

public class AndPermission {
    private static final String TAG = "AndPermission";
    private static final RequestFactory FACTORY;
    private static AppActivitySource.IPermissionRequestRegister sRegisterManager;
    private static SparseArray<Source.PermissionListener> sPermissionListeners;

    public static boolean hasAlwaysDeniedPermission(@NonNull Activity activity, @NonNull List<String> deniedPermissions) {
        if (activity == null) {
            return false;
        }
        return AndPermission.hasAlwaysDeniedPermission((Source)new AppActivitySource(activity, sRegisterManager), deniedPermissions);
    }

    private static boolean hasAlwaysDeniedPermission(@NonNull Source source, @NonNull List<String> deniedPermissions) {
        for (String permission : deniedPermissions) {
            if (source.isShowRationalePermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Activity activity, String ... deniedPermissions) {
        if (activity == null) {
            return false;
        }
        return AndPermission.hasAlwaysDeniedPermission((Source)new AppActivitySource(activity, sRegisterManager), deniedPermissions);
    }

    private static boolean hasAlwaysDeniedPermission(@NonNull Source source, String ... deniedPermissions) {
        for (String permission : deniedPermissions) {
            if (source.isShowRationalePermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static List<String> hasPermissionDenied(@NonNull Activity activity, String ... permissions) {
        if (activity == null) {
            return null;
        }
        Request request = AndPermission.with(activity).permission(permissions);
        return request.hasPermissionDenied();
    }

    public static List<String> hasPermissionDeniedWithDoubleCheck(@NonNull Activity activity, String ... permissions) {
        if (activity == null) {
            return null;
        }
        Request request = AndPermission.with(activity).permission(permissions);
        return request.hasPermissionDeniedWithDoubleCheck();
    }

    @NonNull
    public static SettingService permissionSetting(@NonNull Activity activity) {
        return new PermissionSetting(new AppActivitySource(activity, sRegisterManager));
    }

    @NonNull
    public static Request with(@NonNull Activity activity) {
        return FACTORY.create(new AppActivitySource(activity, sRegisterManager));
    }

    private AndPermission() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (SettingFlags.getBoolean((String)"andPermissionFix", (boolean)true) && (permissions == null || permissions.length == 0)) {
            return;
        }
        SparseArray<Source.PermissionListener> sparseArray = sPermissionListeners;
        synchronized (sparseArray) {
            MLog.info((Object)TAG, (String)"onRequestPermissionsResult %s,  %s, %s", (Object[])new Object[]{requestCode, permissions, sPermissionListeners});
            Source.PermissionListener listener2 = (Source.PermissionListener)sPermissionListeners.get(requestCode);
            if (listener2 != null) {
                listener2.onRequestPermissionsResult(permissions);
                if (SettingFlags.getBoolean((String)"andPermissionFix", (boolean)true)) {
                    sPermissionListeners.remove(requestCode);
                }
            }
        }
    }

    static {
        sPermissionListeners = new SparseArray(5);
        FACTORY = Build.VERSION.SDK_INT >= 23 ? new MRequestFactory() : new LRequestFactory();
        sRegisterManager = new AppActivitySource.IPermissionRequestRegister(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegisterCall(int requestCode, Source.PermissionListener listener2) {
                MLog.info((Object)AndPermission.TAG, (String)"onRegisterCall %s, %s", (Object[])new Object[]{requestCode, listener2});
                SparseArray sparseArray = sPermissionListeners;
                synchronized (sparseArray) {
                    sPermissionListeners.put(requestCode, (Object)listener2);
                    MLog.info((Object)AndPermission.TAG, (String)"onRegisterCall %s, %s, %s", (Object[])new Object[]{requestCode, listener2, sPermissionListeners});
                }
            }
        };
    }

    @RequiresApi(api=23)
    private static class MRequestFactory
    implements RequestFactory {
        private MRequestFactory() {
        }

        @Override
        public Request create(Source source) {
            return new MRequest(source);
        }
    }

    private static class LRequestFactory
    implements RequestFactory {
        private LRequestFactory() {
        }

        @Override
        public Request create(Source source) {
            return new LRequest(source);
        }
    }

    private static interface RequestFactory {
        public Request create(Source var1);
    }
}

