/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.paneldialog;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ScaleAnimation;
import com.yy.appbase.R;
import com.yy.appbase.service.web.IWebPageCallback;
import com.yy.appbase.ui.webview.WebViewPage;
import com.yy.framework.core.ui.BasePanel;

class InnerWebViewPanel
extends BasePanel {
    private WebViewPage mWebViewPage;

    public InnerWebViewPanel(Context context) {
        super(context);
        this.createView();
        this.setShowAnim(this.createShowAnim());
        this.setHideAnim(this.createHideAnim());
    }

    private void createView() {
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.room_panel_dialog_web_view, (ViewGroup)this, false);
        this.mWebViewPage = (WebViewPage)contentView.findViewById(R.id.webview_page);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebViewPage.setClipToOutline(true);
        }
        this.setContent(contentView);
        this.mWebViewPage.setWebPageCallback(new IWebPageCallback(){

            @Override
            public void exitWebView() {
                InnerWebViewPanel.this.hide(true);
            }
        });
        this.mWebViewPage.setBackground(0);
    }

    public void setData(String url) {
        this.mWebViewPage.setData("", url);
    }

    protected void onShow() {
        super.onShow();
        this.dimBg(true);
    }

    protected void onHide() {
        super.onHide();
        this.dimBg(false);
        if (this.mWebViewPage != null) {
            this.mWebViewPage.destroy();
        }
    }

    private void dimBg(boolean isShow) {
        ValueAnimator animator = isShow ? ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.5f}) : ValueAnimator.ofFloat((float[])new float[]{0.5f, 0.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int alpha = (int)(((Float)animation.getAnimatedValue()).floatValue() * 255.0f);
                InnerWebViewPanel.this.setBackgroundColor(Color.argb((int)alpha, (int)0, (int)0, (int)0));
            }
        });
        animator.start();
    }

    private Animation createShowAnim() {
        AnimationSet aniSet = new AnimationSet(false);
        ScaleAnimation scaleAnim = new ScaleAnimation(0.5f, 1.0f, 0.5f, 1.0f, 1, 0.5f, 1, 0.5f);
        AlphaAnimation alpha = new AlphaAnimation(0.5f, 1.0f);
        aniSet.addAnimation((Animation)alpha);
        aniSet.addAnimation((Animation)scaleAnim);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        aniSet.setDuration(200L);
        return aniSet;
    }

    private Animation createHideAnim() {
        AnimationSet aniSet = new AnimationSet(false);
        AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
        aniSet.addAnimation((Animation)alpha);
        aniSet.setFillAfter(true);
        aniSet.setAnimationListener((Animation.AnimationListener)this);
        aniSet.setDuration(200L);
        return aniSet;
    }
}

