/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.localprecent;

import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import java.util.Random;

public class LocalPercent {
    private static final String TAG = "LocalPercent";
    private static final Random sRandom = new Random();

    public static Random getRandom() {
        return sRandom;
    }

    public static boolean getA(String key) {
        return StringUtils.equalsIgnoreCase((String)LocalPercent.getTest((String)key).desc, (String)"A");
    }

    public static boolean getB(String key) {
        return StringUtils.equalsIgnoreCase((String)LocalPercent.getTest((String)key).desc, (String)"B");
    }

    public static boolean getC(String key) {
        return StringUtils.equalsIgnoreCase((String)LocalPercent.getTest((String)key).desc, (String)"C");
    }

    public static boolean getD(String key) {
        return StringUtils.equalsIgnoreCase((String)LocalPercent.getTest((String)key).desc, (String)"D");
    }

    public static ABTest getTest(String key) {
        if (StringUtils.isNotEmpty((String)key)) {
            String lastTest = LocalPercent.getLastABTest(key);
            if (StringUtils.isEmpty((String)lastTest)) {
                lastTest = LocalPercent.randomABStr(key);
            } else {
                MLog.info((Object)TAG, (String)"getLastABTest key: %s, ab: %s", (Object[])new Object[]{key, lastTest});
            }
            if (StringUtils.isNotEmpty((String)lastTest)) {
                SettingFlags.setStringValue((String)key, (String)lastTest);
            }
            try {
                return ABTest.valueOf(lastTest);
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (String)"getTest valueOf ABTest error", (Throwable)ex, (Object[])new Object[0]);
            }
        }
        return ABTest.NONE;
    }

    public static ABTest randomAB(String key) {
        String value = LocalPercent.randomABStr(key);
        try {
            return ABTest.valueOf(value);
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (String)"getTest valueOf ABTest error", (Throwable)ex, (Object[])new Object[0]);
            return ABTest.NONE;
        }
    }

    private static String randomABStr(String key) {
        String lastTest = "";
        try {
            String[] parts = key.split("\\|");
            if (parts.length < 2) {
                throw new RuntimeException("getTest key = " + key + " format error");
            }
            int start = 0;
            Section match = null;
            int target = sRandom.nextInt(100);
            MLog.info((Object)TAG, (String)"get random key=%s, ab percent=%d", (Object[])new Object[]{key, target});
            for (int i = 1; i < parts.length; ++i) {
                String p = parts[i];
                String[] percent = p.split("_");
                if (percent.length != 2) {
                    throw new RuntimeException("getTest sub key = " + key + " format error");
                }
                Section s = new Section();
                s.setAb(percent[0]);
                s.setStart(start);
                s.setEnd((start += Integer.parseInt(percent[1])) - 1);
                MLog.info((Object)TAG, (String)"find section i:%d, start: %d, end: %d, start: %d, percent: %s", (Object[])new Object[]{i, s.start, s.end, start, percent[1]});
                if (target < s.start || target > s.end) continue;
                match = s;
                break;
            }
            lastTest = match != null ? match.ab.toUpperCase() : ABTest.NONE.desc.toUpperCase();
            MLog.info((Object)TAG, (String)"save local ab key: %s, value: %s", (Object[])new Object[]{key, lastTest});
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (String)("getTest key: " + key + " error"), (Throwable)ex, (Object[])new Object[0]);
        }
        return lastTest;
    }

    private static String getLastABTest(String key) {
        return SettingFlags.getStringValue((String)key, (String)"");
    }

    public static enum ABTest {
        NONE("NONE"),
        A("A"),
        B("B"),
        C("C"),
        D("D");

        String desc;

        private ABTest(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    private static class Section {
        private String ab;
        private int start;
        private int end;

        private Section() {
        }

        public String getAb() {
            return this.ab;
        }

        public void setAb(String ab) {
            this.ab = ab;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }
    }
}

