/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.image;

import android.content.Context;
import android.net.Uri;
import android.widget.ImageView;
import androidx.collection.ArrayMap;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.PerformanceData;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.http.adapter.netfactory.ImageLoaderNetworkFactory;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageLoaderSetup;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceUtil;
import com.yy.base.utils.FP;
import com.yy.base.utils.LowEndMachineOptUtil;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.networkinterceptor.DispatchType;
import com.yy.grace.networkinterceptor.flowdispatcher.GlobalNetworkDispatcher;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\u001c\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u0010\u001e\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0007J&\u0010!\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010#\u0012\u0004\u0012\u00020\u00040\"2\u000e\u0010$\u001a\n\u0018\u00010%j\u0004\u0018\u0001`&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010,\u001a\u00020\u0019H\u0007J\b\u0010-\u001a\u00020\fH\u0002J\u0012\u0010.\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010/\u001a\u00020\fH\u0002J\u0018\u00100\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u00101\u001a\u000202H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/yy/appbase/image/ImageLoadHelper;", "", "()V", "ACT_NAME", "", "ALBUM_SCENE_NAME", "AVATAR_SCENE_NAME", "GAME_SCENE_NAME", "HEIF", "TAG", "WEBP_URL", "isNeedStat", "", "mEmptyUrlFixFlag", "Ljava/lang/Boolean;", "mHeifMock", "mTest", "Lcom/yy/appbase/abtest/IAB;", "mUseWebpFlag", "sSceneSwitchMap", "Landroidx/collection/ArrayMap;", "statInfoMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/yy/appbase/image/ImageLoadHelper$ImageLoadHiidoData;", "beginImageLoadHiidoMonitor", "", "checkCanUseHeif", "imageView", "Landroid/widget/ImageView;", "url", "checkCanUseWebp", "checkNeedAddQuality", "originUrl", "getErrorMsg", "Lkotlin/Pair;", "Lcom/bumptech/glide/load/DataSource;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getQualityByNetworkType", "", "network", "getSource", "getUrlWithQuality", "initImageLoader", "isHeifMock", "isOssImageProcessHost", "matchExperiment", "onImageSizeReady", "size", "", "ImageLoadHiidoData", "appbase_release"})
public final class ImageLoadHelper {
    private static final String TAG = "ImageLoadHelper";
    private static final String ACT_NAME = "imageloadperf";
    private static final String HEIF = "heif";
    private static final String GAME_SCENE_NAME = "ikxd";
    private static final String AVATAR_SCENE_NAME = "uurl";
    private static final String ALBUM_SCENE_NAME = "album";
    private static final String WEBP_URL = "format,webp";
    private static final boolean mHeifMock = false;
    private static Boolean mEmptyUrlFixFlag;
    private static Boolean mUseWebpFlag;
    private static final ConcurrentHashMap<String, ImageLoadHiidoData> statInfoMap;
    private static final ArrayMap<String, Boolean> sSceneSwitchMap;
    private static IAB mTest;
    private static boolean isNeedStat;
    public static final ImageLoadHelper INSTANCE;

    @JvmStatic
    public static final void initImageLoader() {
        ImageLoader.ImageLoaderDelegate imageLoaderDelegate2 = new ImageLoader.ImageLoaderDelegate(){

            public boolean canAnim() {
                return RuntimeContext.getPhoneType() != 1;
            }

            @NotNull
            public ImageLoader.ImgFormat canUseFormat(@Nullable ImageView imageView, @Nullable String url, @NotNull ImageLoader.ImgFormat wantFormat) {
                Intrinsics.checkParameterIsNotNull((Object)wantFormat, (String)"wantFormat");
                ImageLoader.ImgFormat resultFormat = wantFormat;
                if (StringUtils.isEmpty((String)url)) {
                    return ImageLoader.ImgFormat.ORIGIN;
                }
                if (wantFormat == ImageLoader.ImgFormat.HEIF) {
                    if (ImageLoadHelper.access$checkCanUseHeif(ImageLoadHelper.INSTANCE, imageView, url)) {
                        return resultFormat;
                    }
                    resultFormat = ImageLoader.ImgFormat.WEBP;
                }
                if (resultFormat == ImageLoader.ImgFormat.WEBP) {
                    if (ImageLoadHelper.access$isOssImageProcessHost(ImageLoadHelper.INSTANCE, url)) {
                        return ImageLoadHelper.access$checkCanUseWebp(ImageLoadHelper.INSTANCE, imageView, url) ? resultFormat : ImageLoader.ImgFormat.RESIZE;
                    }
                    MLog.debug((Object)"ImageLoadHelper", (String)("use origin, is not ossProcessHost, url: " + url), (Object[])new Object[0]);
                }
                return ImageLoader.ImgFormat.ORIGIN;
            }

            public boolean isBusinessTarget(@Nullable String url) {
                return URLUtils.isOurHostByUrl((String)url);
            }

            @NotNull
            public String getBackup(@Nullable String url) {
                String string2 = GlobalNetworkDispatcher.dispatcher((DispatchType)DispatchType.IMAGELOADER).getRewriteHostUrl(url, GraceUtil.getGrace());
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GlobalNetworkDispatcher\n\u2026rl, GraceUtil.getGrace())");
                return string2;
            }

            public boolean fixEmptyUrl() {
                if (ImageLoadHelper.access$getMEmptyUrlFixFlag$p(ImageLoadHelper.INSTANCE) == null) {
                    ImageLoadHelper.access$setMEmptyUrlFixFlag$p(ImageLoadHelper.INSTANCE, SettingFlags.getBoolean((String)"imageemptyurl2", (boolean)true));
                }
                Boolean bl = ImageLoadHelper.access$getMEmptyUrlFixFlag$p(ImageLoadHelper.INSTANCE);
                return (bl != null ? bl : false) || RuntimeContext.isInGray();
            }
        };
        ImageLoader.init((Context)RuntimeContext.sApplicationContext, (ImageLoaderSetup)ImageLoader.setup().isDebug(RuntimeContext.sIsDebuggable).loaderFactory((ModelLoaderFactory)new ImageLoaderNetworkFactory()).recycleSwitch(SettingFlags.getBoolean((String)"recycleimageOn", (boolean)true)).bigImgAutoRecycle(SettingFlags.getBoolean((String)"bigimagerecycle", (boolean)true)).bigRecycleSizeMultiplier(RuntimeContext.getPhoneType() == 1 ? 3 : 5).build(), (ImageLoader.ImageLoaderDelegate)imageLoaderDelegate2);
    }

    private final boolean checkCanUseWebp(ImageView imageView, String url) {
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        if (mUseWebpFlag == null) {
            mUseWebpFlag = SettingFlags.getBoolean((String)"usewebp", (boolean)true);
        }
        if (Intrinsics.areEqual((Object)mUseWebpFlag, (Object)true)) {
            if (imageView instanceof RecycleImageView && !((RecycleImageView)imageView).autoTransformToWebp()) {
                MLog.debug((Object)TAG, (String)"checkCanUseWebp false, imageView not support", (Object[])new Object[0]);
                return false;
            }
            if (ImageUtil.isJpg((String)url) || ImageUtil.isPng((String)url) || ImageUtil.isWebPUrl((String)url) || ImageUtil.isGif((String)url)) {
                return true;
            }
            MLog.debug((Object)TAG, (String)"checkCanUseWebp false, not support url", (Object[])new Object[0]);
        }
        return false;
    }

    private final boolean checkCanUseHeif(ImageView imageView, String url) {
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        if (this.isHeifMock()) {
            return true;
        }
        Boolean heifSwitch = (Boolean)sSceneSwitchMap.get((Object)this.getSource(url));
        if (heifSwitch == null) {
            heifSwitch = true;
        }
        if (heifSwitch.booleanValue() && RuntimeContext.sPhoneType != 1) {
            heifSwitch = this.matchExperiment();
        }
        return heifSwitch;
    }

    @JvmStatic
    @Deprecated(message="\u5df2\u5e9f\u5f03\uff0c\u76ee\u524d\u6ca1\u6709\u4f7f\u7528")
    @NotNull
    public static final String checkNeedAddQuality(@NotNull String originUrl) {
        Intrinsics.checkParameterIsNotNull((Object)originUrl, (String)"originUrl");
        boolean enableQuality = SettingFlags.getBoolean((String)"image_quality_switch", (boolean)false);
        return enableQuality ? INSTANCE.getUrlWithQuality(originUrl) : originUrl;
    }

    private final boolean matchExperiment() {
        if (mTest == null && NewABDefine.HEIF_SUPPORT.isTestValid()) {
            mTest = NewABDefine.HEIF_SUPPORT.getTest();
        }
        return Intrinsics.areEqual((Object)mTest, (Object)NAB.B);
    }

    @JvmStatic
    public static final void beginImageLoadHiidoMonitor() {
        if (!isNeedStat) {
            MLog.debug((Object)TAG, (String)"beginImageLoadMonitor ignore, no need stat", (Object[])new Object[0]);
            return;
        }
        ImageLoader.addMonitor((ImageLoader.IMonitor)new ImageLoader.IMonitor(){

            public void onSuccess(int id2, @Nullable String url, int size, boolean isFirstResource, @Nullable DataSource dataSource, @Nullable PerformanceData performanceData) {
                block2: {
                    Object object = url;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (object == null || object.length() == 0) {
                        return;
                    }
                    PerformanceData performanceData2 = performanceData;
                    PerformanceData performanceData3 = performanceData;
                    MLog.debug((Object)"ImageLoadHelper", (String)("load success, id: " + id2 + ", size: " + size + ", dataSource: " + dataSource + ", decodeTime: " + (performanceData2 != null ? Double.valueOf(performanceData2.decodeTime) : null) + ", fetchTime: " + (performanceData3 != null ? Double.valueOf(performanceData3.fetchTime) : null) + ", url: " + url), (Object[])new Object[0]);
                    if (dataSource == null || performanceData == null) {
                        return;
                    }
                    ImageLoadHiidoData imageLoadHiidoData = (ImageLoadHiidoData)ImageLoadHelper.access$getStatInfoMap$p(ImageLoadHelper.INSTANCE).get(url);
                    if (imageLoadHiidoData == null) break block2;
                    object = imageLoadHiidoData;
                    bl = false;
                    bl2 = false;
                    Object $this$run = object;
                    boolean bl3 = false;
                    StatisContent statisContent = new StatisContent();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    StatisContent $this$with = statisContent;
                    boolean bl6 = false;
                    $this$with.put("act", "imageloadperf");
                    $this$with.put("load_result", 1);
                    $this$with.put("load_time", System.currentTimeMillis() - ((ImageLoadHiidoData)$this$run).getStartTime());
                    $this$with.put("url", url);
                    $this$with.put("width", ((ImageLoadHiidoData)$this$run).getWidth());
                    $this$with.put("height", ((ImageLoadHiidoData)$this$run).getHeight());
                    $this$with.put("format", ((ImageLoadHiidoData)$this$run).getFormat());
                    $this$with.put("is_heif_url", ((ImageLoadHiidoData)$this$run).isHeifUrl());
                    $this$with.put("bitmap_size", size);
                    $this$with.put("source", ImageLoadHelper.access$getSource(ImageLoadHelper.INSTANCE, url));
                    $this$with.put("data_source", dataSource.name());
                    $this$with.put("file_size", ((ImageLoadHiidoData)$this$run).getFileSize());
                    $this$with.put("fetch_time", (long)performanceData.fetchTime);
                    $this$with.put("decode_time", (long)performanceData.decodeTime);
                    $this$with.put("hdid", HiidoUtils.getHdid());
                    HiidoStatis.reportContent((StatisContent)$this$with);
                    ImageLoadHiidoData cfr_ignored_0 = (ImageLoadHiidoData)ImageLoadHelper.access$getStatInfoMap$p(ImageLoadHelper.INSTANCE).remove(url);
                }
            }

            public void onClear(int id2) {
            }

            public void onError(int id2, @Nullable String url, @Nullable Exception e) {
                block3: {
                    Object object = url;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (object == null || object.length() == 0) {
                        return;
                    }
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.error((Object)"ImageLoadHelper", (String)("load fail, id: " + id2 + ", url: " + url), (Throwable)e, (Object[])new Object[0]);
                    }
                    ImageLoadHiidoData imageLoadHiidoData = (ImageLoadHiidoData)ImageLoadHelper.access$getStatInfoMap$p(ImageLoadHelper.INSTANCE).get(url);
                    if (imageLoadHiidoData == null) break block3;
                    object = imageLoadHiidoData;
                    bl = false;
                    bl2 = false;
                    Object $this$run = object;
                    boolean bl3 = false;
                    Pair shortErrMsg = ImageLoadHelper.access$getErrorMsg(ImageLoadHelper.INSTANCE, e);
                    StatisContent statisContent = new StatisContent();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    StatisContent $this$with = statisContent;
                    boolean bl6 = false;
                    $this$with.put("act", "imageloadperf");
                    $this$with.put("load_result", 2);
                    $this$with.put("url", ((ImageLoadHiidoData)$this$run).getUrl());
                    $this$with.put("width", ((ImageLoadHiidoData)$this$run).getWidth());
                    $this$with.put("height", ((ImageLoadHiidoData)$this$run).getHeight());
                    $this$with.put("format", ((ImageLoadHiidoData)$this$run).getFormat());
                    $this$with.put("is_heif_url", ((ImageLoadHiidoData)$this$run).isHeifUrl());
                    $this$with.put("source", ImageLoadHelper.access$getSource(ImageLoadHelper.INSTANCE, url));
                    $this$with.put("error_msg", (String)shortErrMsg.getSecond());
                    Object object2 = (DataSource)shortErrMsg.getFirst();
                    if (object2 == null || (object2 = object2.toString()) == null) {
                        object2 = "";
                    }
                    $this$with.put("data_source", (String)object2);
                    $this$with.put("hdid", HiidoUtils.getHdid());
                    HiidoStatis.reportContent((StatisContent)$this$with);
                    ImageLoadHiidoData cfr_ignored_0 = (ImageLoadHiidoData)ImageLoadHelper.access$getStatInfoMap$p(ImageLoadHelper.INSTANCE).remove(url);
                }
            }

            public void onStart(int id2, boolean loadImage, @Nullable String url, int width, int height) {
                CharSequence charSequence = url;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    return;
                }
                ((Map)ImageLoadHelper.access$getStatInfoMap$p(ImageLoadHelper.INSTANCE)).put(url, new ImageLoadHiidoData(id2, url, width, height, 0L, System.currentTimeMillis(), 0L, 80, null));
            }
        });
    }

    private final Pair<DataSource, String> getErrorMsg(Exception e) {
        DataSource dataSource;
        String shortErrMsg;
        block3: {
            shortErrMsg = "";
            dataSource = null;
            Exception exception = e;
            if (exception == null) break block3;
            Exception exception2 = exception;
            boolean bl = false;
            boolean bl2 = false;
            Exception $this$run = exception2;
            boolean bl3 = false;
            if (e instanceof GlideException) {
                List list = ((GlideException)e).getCauses();
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Throwable it = (Throwable)element$iv;
                        boolean bl4 = false;
                        if (!(it instanceof GlideException)) continue;
                        String str = String.valueOf(it.getMessage());
                        shortErrMsg = shortErrMsg + StringsKt.replace$default((String)str, (String)"call GlideException#logRootCauses(String) for more detail", (String)"", (boolean)false, (int)4, null);
                        dataSource = ((GlideException)it).dataSource;
                    }
                }
            }
        }
        return new Pair((Object)dataSource, (Object)shortErrMsg);
    }

    @JvmStatic
    public static final void onImageSizeReady(@NotNull String url, long size) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            ImageLoadHiidoData imageLoadHiidoData = statInfoMap.get(url);
            if (imageLoadHiidoData == null) break block0;
            ImageLoadHiidoData imageLoadHiidoData2 = imageLoadHiidoData;
            boolean bl = false;
            boolean bl2 = false;
            ImageLoadHiidoData $this$run = imageLoadHiidoData2;
            boolean bl3 = false;
            $this$run.setFileSize(size);
        }
    }

    private final boolean isHeifMock() {
        return mHeifMock && RuntimeContext.sIsDebuggable;
    }

    private final String getSource(String url) {
        Uri uri = Uri.parse((String)url);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(url)");
        List pathSegments = uri.getPathSegments();
        if (FP.empty((Collection)pathSegments)) {
            return "";
        }
        if (pathSegments.contains(HEIF) && Intrinsics.areEqual((Object)((String)pathSegments.get(0)), (Object)HEIF) ^ true) {
            Object e = pathSegments.get(pathSegments.indexOf(HEIF) + 3);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"pathSegments[pathSegments.indexOf(HEIF) + 3]");
            return (String)e;
        }
        if (pathSegments.contains("blob")) {
            Object e = pathSegments.get(pathSegments.indexOf("blob") + 4);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"pathSegments[pathSegments.indexOf(\"blob\") + 4]");
            return (String)e;
        }
        if (Intrinsics.areEqual((Object)((String)pathSegments.get(0)), (Object)HEIF) && pathSegments.size() >= 3) {
            Object e = pathSegments.get(2);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"pathSegments[2]");
            return (String)e;
        }
        Object e = pathSegments.get(0);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"pathSegments[0]");
        return (String)e;
    }

    private final boolean isOssImageProcessHost(String url) {
        boolean result;
        boolean isStartO;
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        boolean bl3 = isStartO = StringsKt.startsWith$default((String)url, (String)"http://o-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"https://o-", (boolean)false, (int)2, null);
        if (isStartO && StringsKt.contains$default((CharSequence)url, (CharSequence)".ihago.net", (boolean)false, (int)2, null)) {
            return true;
        }
        if (isStartO && StringsKt.contains$default((CharSequence)url, (CharSequence)".moschat.com", (boolean)false, (int)2, null)) {
            return true;
        }
        if (isStartO && StringsKt.contains$default((CharSequence)url, (CharSequence)".olaparty.com", (boolean)false, (int)2, null)) {
            return true;
        }
        if (isStartO && StringsKt.contains$default((CharSequence)url, (CharSequence)".vparty.net", (boolean)false, (int)2, null)) {
            return true;
        }
        boolean bl4 = result = StringsKt.startsWith$default((String)url, (String)"http://kaixindou.kaixindou.net/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"https://kaixindou.kaixindou.net/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"http://kaixindou-yd.kaixindou.net/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"https://kaixindou-yd.kaixindou.net/", (boolean)false, (int)2, null);
        if (result) {
            return true;
        }
        return isStartO && URLUtils.isOurHostByUrl((String)url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int getQualityByNetworkType(String network) {
        String string2 = network;
        switch (string2.hashCode()) {
            case 1684: {
                if (!string2.equals("3g")) return 100;
                return 75;
            }
            case 1653: {
                if (!string2.equals("2g")) return 100;
                return 50;
            }
        }
        return 100;
    }

    private final String getUrlWithQuality(String url) {
        String string2;
        if (StringsKt.contains$default((CharSequence)url, (CharSequence)WEBP_URL, (boolean)false, (int)2, null)) {
            String network;
            String string3 = network = NetworkUtils.getNetworkName((Context)RuntimeContext.sApplicationContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"network");
            int quality = this.getQualityByNetworkType(string3);
            if (quality == 100) {
                string2 = url;
            } else {
                String string4 = new StringBuilder(url).insert(StringsKt.indexOf$default((CharSequence)url, (String)WEBP_URL, (int)0, (boolean)false, (int)6, null) + WEBP_URL.length(), "/quality,Q_" + quality).toString();
                string2 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder(url)\n     \u2026              .toString()");
            }
        } else {
            string2 = url;
        }
        return string2;
    }

    private ImageLoadHelper() {
    }

    static {
        ImageLoadHelper imageLoadHelper;
        INSTANCE = imageLoadHelper = new ImageLoadHelper();
        statInfoMap = new ConcurrentHashMap();
        sSceneSwitchMap = new ArrayMap(3);
        isNeedStat = SystemUtils.isShowEnvSetting();
        ((Map)sSceneSwitchMap).put(GAME_SCENE_NAME, SettingFlags.getBoolean((String)"heif_game_switch", (boolean)true));
        ((Map)sSceneSwitchMap).put(AVATAR_SCENE_NAME, SettingFlags.getBoolean((String)"heif_uurl_switch", (boolean)true));
        ((Map)sSceneSwitchMap).put(ALBUM_SCENE_NAME, SettingFlags.getBoolean((String)"heif_album_switch", (boolean)true));
        Random random = new Random();
        int percent = random.nextInt(1000) + 1;
        if (percent > SettingFlags.getIntValue((String)"image_stat_sampling", (int)100)) {
            isNeedStat = false;
        }
        if (SettingFlagBaseKeys.isForceCloseReport()) {
            isNeedStat = false;
        }
        isNeedStat = LowEndMachineOptUtil.INSTANCE.getImageLoadMonitorStatSwitch();
    }

    public static final /* synthetic */ boolean access$checkCanUseHeif(ImageLoadHelper $this, ImageView imageView, String url) {
        return $this.checkCanUseHeif(imageView, url);
    }

    public static final /* synthetic */ boolean access$isOssImageProcessHost(ImageLoadHelper $this, String url) {
        return $this.isOssImageProcessHost(url);
    }

    public static final /* synthetic */ boolean access$checkCanUseWebp(ImageLoadHelper $this, ImageView imageView, String url) {
        return $this.checkCanUseWebp(imageView, url);
    }

    public static final /* synthetic */ Boolean access$getMEmptyUrlFixFlag$p(ImageLoadHelper $this) {
        ImageLoadHelper imageLoadHelper = $this;
        return mEmptyUrlFixFlag;
    }

    public static final /* synthetic */ void access$setMEmptyUrlFixFlag$p(ImageLoadHelper $this, Boolean bl) {
        ImageLoadHelper imageLoadHelper = $this;
        mEmptyUrlFixFlag = bl;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getStatInfoMap$p(ImageLoadHelper $this) {
        ImageLoadHelper imageLoadHelper = $this;
        return statInfoMap;
    }

    public static final /* synthetic */ String access$getSource(ImageLoadHelper $this, String url) {
        return $this.getSource(url);
    }

    public static final /* synthetic */ Pair access$getErrorMsg(ImageLoadHelper $this, Exception e) {
        return $this.getErrorMsg(e);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003JO\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010&\u001a\u00020\u0005J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u001a\u0010\u000b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/yy/appbase/image/ImageLoadHelper$ImageLoadHiidoData;", "", "index", "", "url", "", "width", "height", "fileSize", "", "startTime", "successTime", "(ILjava/lang/String;IIJJJ)V", "getFileSize", "()J", "setFileSize", "(J)V", "getHeight", "()I", "getIndex", "isHeifUrl", "getStartTime", "getSuccessTime", "setSuccessTime", "getUrl", "()Ljava/lang/String;", "getWidth", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "getFormat", "hashCode", "toString", "appbase_release"})
    public static final class ImageLoadHiidoData {
        private final int isHeifUrl;
        private final int index;
        @NotNull
        private final String url;
        private final int width;
        private final int height;
        private long fileSize;
        private final long startTime;
        private long successTime;

        public final int isHeifUrl() {
            return this.isHeifUrl;
        }

        @NotNull
        public final String getFormat() {
            if (StringsKt.contains$default((CharSequence)this.url, (CharSequence)"/format,webp", (boolean)false, (int)2, null)) {
                return "webp";
            }
            Uri uri = Uri.parse((String)this.url);
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(url)");
            String lastPathSegment = uri.getLastPathSegment();
            if (lastPathSegment != null && StringsKt.contains$default((CharSequence)lastPathSegment, (CharSequence)ImageLoadHelper.HEIF, (boolean)false, (int)2, null)) {
                return ImageLoadHelper.HEIF;
            }
            return "origin";
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final long getFileSize() {
            return this.fileSize;
        }

        public final void setFileSize(long l) {
            this.fileSize = l;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        public final long getSuccessTime() {
            return this.successTime;
        }

        public final void setSuccessTime(long l) {
            this.successTime = l;
        }

        public ImageLoadHiidoData(int index, @NotNull String url, int width, int height, long fileSize, long startTime, long successTime) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.index = index;
            this.url = url;
            this.width = width;
            this.height = height;
            this.fileSize = fileSize;
            this.startTime = startTime;
            this.successTime = successTime;
            this.isHeifUrl = StringsKt.contains$default((CharSequence)this.url, (CharSequence)ImageLoadHelper.HEIF, (boolean)false, (int)2, null) ? 1 : 2;
        }

        public /* synthetic */ ImageLoadHiidoData(int n, String string2, int n2, int n3, long l, long l2, long l3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 4) != 0) {
                n2 = 0;
            }
            if ((n4 & 8) != 0) {
                n3 = 0;
            }
            if ((n4 & 0x10) != 0) {
                l = 0L;
            }
            if ((n4 & 0x20) != 0) {
                l2 = -1L;
            }
            if ((n4 & 0x40) != 0) {
                l3 = -1L;
            }
            this(n, string2, n2, n3, l, l2, l3);
        }

        public final int component1() {
            return this.index;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        public final int component3() {
            return this.width;
        }

        public final int component4() {
            return this.height;
        }

        public final long component5() {
            return this.fileSize;
        }

        public final long component6() {
            return this.startTime;
        }

        public final long component7() {
            return this.successTime;
        }

        @NotNull
        public final ImageLoadHiidoData copy(int index, @NotNull String url, int width, int height, long fileSize, long startTime, long successTime) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            return new ImageLoadHiidoData(index, url, width, height, fileSize, startTime, successTime);
        }

        public static /* synthetic */ ImageLoadHiidoData copy$default(ImageLoadHiidoData imageLoadHiidoData, int n, String string2, int n2, int n3, long l, long l2, long l3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = imageLoadHiidoData.index;
            }
            if ((n4 & 2) != 0) {
                string2 = imageLoadHiidoData.url;
            }
            if ((n4 & 4) != 0) {
                n2 = imageLoadHiidoData.width;
            }
            if ((n4 & 8) != 0) {
                n3 = imageLoadHiidoData.height;
            }
            if ((n4 & 0x10) != 0) {
                l = imageLoadHiidoData.fileSize;
            }
            if ((n4 & 0x20) != 0) {
                l2 = imageLoadHiidoData.startTime;
            }
            if ((n4 & 0x40) != 0) {
                l3 = imageLoadHiidoData.successTime;
            }
            return imageLoadHiidoData.copy(n, string2, n2, n3, l, l2, l3);
        }

        @NotNull
        public String toString() {
            return "ImageLoadHiidoData(index=" + this.index + ", url=" + this.url + ", width=" + this.width + ", height=" + this.height + ", fileSize=" + this.fileSize + ", startTime=" + this.startTime + ", successTime=" + this.successTime + ")";
        }

        public int hashCode() {
            String string2 = this.url;
            long l = this.fileSize;
            long l2 = this.startTime;
            long l3 = this.successTime;
            return (((((this.index * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + this.width) * 31 + this.height) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ImageLoadHiidoData)) break block3;
                    ImageLoadHiidoData imageLoadHiidoData = (ImageLoadHiidoData)object;
                    if (this.index != imageLoadHiidoData.index || !Intrinsics.areEqual((Object)this.url, (Object)imageLoadHiidoData.url) || this.width != imageLoadHiidoData.width || this.height != imageLoadHiidoData.height || this.fileSize != imageLoadHiidoData.fileSize || this.startTime != imageLoadHiidoData.startTime || this.successTime != imageLoadHiidoData.successTime) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

