/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http.cronet.manager;

import android.content.Context;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.listener.AbstractBizTag;
import com.yy.base.okhttp.listener.BizTag;
import com.yy.base.okhttp.listener.NetStatMetrics;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.networkinterceptor.flowdispatcher.config.CdnConfig;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface INetStat {
    public static final int SUCCESS = 0;
    public static final int FAIL = 1;
    public static final int CANCEL = 2;
    public static final int OTHER = -1;
    public static final int GET = 0;
    public static final int POST = 1;
    public static final String DNSSTART = "dnsstart";
    public static final String DNSEND = "dnsend";
    public static final String CONNSTART = "connstart";
    public static final String SECURECONNSTART = "secureconnstart";
    public static final String SECURECONNEND = "secureconnend";
    public static final String CONNEND = "connend";
    public static final String CONNACQUIRED = "connacquired";
    public static final String REQHEADERSTART = "reqheaderstart";
    public static final String REQHEADEREND = "reqheaderend";
    public static final String RESPHEADERSTART = "respheaderstart";
    public static final String RESPHEADEREND = "respheaderend";
    public static final String RESPBODYSTART = "respbodystart";
    public static final String REQEND = "reqend";
    public static final String REMOTEIP = "remoteip";
    public static final String PROTOCOL_SOURCE = "protocol";
    public static final String REUSE = "reuse";
    public static final String FAILOVER = "failover";
    public static final String CDN_NAME = "cdnname";
    public static final String REDIRECTS = "redirects";
    public static final String RECEIVEDBYTECOUNT = "receivedbytecount";
    public static final String QUIC_STATUS = "quicstatus";

    public void stat(NetStatMetrics var1, int var2);

    public static void statReal(NetStatMetrics netStatMetrics, String type2) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", QUIC_STATUS);
        String status = (netStatMetrics.getFinishedReason() == 0 ? 0 : (netStatMetrics.getFinishedReason() == 1 ? 1 : 2)) + "";
        statContent.put("status", status);
        statContent.put("code", netStatMetrics.getCode());
        String method = netStatMetrics.getMethod();
        statContent.put("method", "post".equalsIgnoreCase(method) ? 1 : ("get".equalsIgnoreCase(method) ? 0 : -1));
        statContent.put("bodylength", netStatMetrics.getReceivedByteCount());
        statContent.put("temp_1", netStatMetrics.getTotalTimeMs());
        int bizType = -1;
        AbstractBizTag abstractBizTag = netStatMetrics.getBizTag();
        BizTag bizTag = null;
        if (abstractBizTag instanceof BizTag) {
            bizTag = (BizTag)abstractBizTag;
            bizType = bizTag.businessType;
        }
        statContent.put("biztype", bizType + "");
        int n = 1;
        if (netStatMetrics.getFinishedReason() == 1) {
            n = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) ? 1 : 0;
        }
        statContent.put("temp_2", n);
        statContent.put("temp_3", netStatMetrics.isRetry() ? 1 : 0);
        statContent.put("temp_4", bizTag != null && bizTag.isFile ? 1 : 0);
        statContent.put("url", netStatMetrics.getUrl());
        statContent.put("errmsg", netStatMetrics.getException() != null ? netStatMetrics.getException().toString() : "");
        statContent.put("type", type2);
        statContent.put(DNSSTART, String.valueOf(netStatMetrics.getDnsStart()));
        statContent.put(DNSEND, String.valueOf(netStatMetrics.getDnsEnd()));
        statContent.put(CONNSTART, String.valueOf(netStatMetrics.getConnectStart()));
        statContent.put(SECURECONNSTART, String.valueOf(netStatMetrics.getSecureConnStart()));
        statContent.put(SECURECONNEND, String.valueOf(netStatMetrics.getSecureConnEnd()));
        statContent.put(CONNEND, String.valueOf(netStatMetrics.getConnectEnd()));
        statContent.put(CONNACQUIRED, String.valueOf(netStatMetrics.getConnacquired()));
        statContent.put(REQHEADERSTART, String.valueOf(netStatMetrics.getRequestHeaderStart()));
        statContent.put(REQHEADEREND, String.valueOf(netStatMetrics.getRequestHeaderEnd()));
        statContent.put(RESPHEADERSTART, String.valueOf(netStatMetrics.getResponeHeaderStart()));
        statContent.put(RESPHEADEREND, String.valueOf(netStatMetrics.getResponeHeaderEnd()));
        statContent.put(RESPBODYSTART, String.valueOf(netStatMetrics.getResponseBodyStart()));
        statContent.put(REQEND, String.valueOf(netStatMetrics.getRequestEnd()));
        statContent.put(REMOTEIP, String.valueOf(netStatMetrics.getRemoteIp()));
        statContent.put("source", String.valueOf(netStatMetrics.getProtocol()));
        statContent.put(REUSE, netStatMetrics.getSocketReused() ? "1" : "0");
        statContent.put(FAILOVER, bizTag != null && bizTag.failOver ? "1" : "0");
        statContent.put(REDIRECTS, String.valueOf(netStatMetrics.getRedirectsTimes()));
        statContent.put("contentencoding", String.valueOf(netStatMetrics.getContentEncoding()));
        statContent.put("sname", netStatMetrics.getSname());
        statContent.put("ymic_method", netStatMetrics.getYmicMethod());
        statContent.put(CDN_NAME, String.valueOf(CdnConfig.getCdnHostNickName((String)netStatMetrics.getUrl())));
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)"FTQuicNet", (String)("hiido stat type = " + type2), (Object[])new Object[0]);
        }
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public static void logStat(NetStatMetrics netStatMetrics, String netType) {
        BizTag bizTag = null;
        AbstractBizTag abstractBizTag = netStatMetrics.getBizTag();
        if (abstractBizTag instanceof BizTag) {
            bizTag = (BizTag)abstractBizTag;
        }
        int businessType = bizTag != null ? bizTag.businessType : -1;
        boolean isFile = bizTag != null && bizTag.isFile;
        boolean failover = bizTag != null && bizTag.failOver;
        String cdnName = CdnConfig.getCdnHostNickName((String)netStatMetrics.getUrl());
        FeatureLog.i((String)"FTQuicNet", (String)("\nnetType = " + netType + "\nbusinessType = " + businessType + "\nurl = " + netStatMetrics.getUrl() + "\ncode = " + netStatMetrics.getCode() + "\nrequestMethod = " + netStatMetrics.getMethod() + "\nbodyLength = " + netStatMetrics.getReceivedByteCount() + "\nsource = " + netStatMetrics.getProtocol() + "\nexpendTime = " + netStatMetrics.getTotalTimeMs() + "\nisRetry = " + netStatMetrics.isRetry() + "\nisFile = " + isFile + "\nremoteIp = " + netStatMetrics.getRemoteIp() + "\nreuse = " + netStatMetrics.getSocketReused() + "\nfailover = " + failover + "\ncdnname = " + cdnName + "\nsname = " + netStatMetrics.getSname() + "\nymicMethod = " + netStatMetrics.getYmicMethod() + "\ncontentEncoding = " + netStatMetrics.getContentEncoding() + "\nfinishedReason = " + (netStatMetrics.getFinishedReason() == 0 ? "sucess" : (netStatMetrics.getFinishedReason() == 2 ? "cancel" : "fail")) + "\n" + (netStatMetrics.getException() != null ? "errMsg = " + netStatMetrics.getException().toString() : "")), (Object[])new Object[0]);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetType {
        public static final int CRONET = 0;
        public static final int OKHTTP = 1;
        public static final int TLS_V_1_3 = 2;
        public static final int CRONET_TLS_V_1_3 = 3;
    }
}

