/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http.adapter.netfactory;

import androidx.annotation.NonNull;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import com.yy.appbase.http.adapter.netfactory.config.TimeoutConfig;
import com.yy.appbase.image.ImageLoadHelper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.Call;
import com.yy.grace.Request;
import com.yy.grace.Response;
import com.yy.grace.ResponseBody;
import com.yy.grace.exception.CancelException;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.grace.networkinterceptor.ibigbossconfig.okhttpconfig.TimeOutConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GraceStreamFetcher
implements DataFetcher<InputStream> {
    private final GlideUrl mGlideUrl;
    private InputStream mInputStream;
    private ResponseBody mResponseBody;
    private Call<ResponseBody> mCall;

    public GraceStreamFetcher(GlideUrl url) {
        this.mGlideUrl = url;
    }

    public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super InputStream> callback) {
        this.fetchImageData(callback);
    }

    public void cleanup() {
        Call<ResponseBody> local;
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
                this.mInputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.mResponseBody != null) {
            this.mResponseBody.close();
            this.mResponseBody = null;
        }
        if ((local = this.mCall) != null) {
            local.disconnect();
        }
    }

    public void cancel() {
        Call<ResponseBody> local = this.mCall;
        if (local != null) {
            local.cancel();
        }
    }

    @NonNull
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @NonNull
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }

    private String transformRequestUrl() {
        return this.mGlideUrl.toStringUrl();
    }

    private Request.Builder<ResponseBody> requestBuilder(String requestUrl) {
        Request.Builder requestBuilder = new Request.Builder<ResponseBody>(){}.url(requestUrl);
        for (Map.Entry headItem : this.mGlideUrl.getHeaders().entrySet()) {
            String headKey = (String)headItem.getKey();
            String headValue = (String)headItem.getValue();
            if (StringUtils.isEmpty((String)headKey) || headValue == null) continue;
            if (headKey.equals("User-Agent")) {
                headValue = headValue.replace('\u3000', ' ');
            }
            if (headKey.equals("X-Auth-Token")) {
                requestBuilder.addHeader(headKey, "");
                continue;
            }
            requestBuilder.addHeader(headKey, headValue);
        }
        return requestBuilder;
    }

    private void fetchImageData(@NonNull DataFetcher.DataCallback<? super InputStream> callback) {
        String requestUrl = this.transformRequestUrl();
        TimeOutConfig timeOutConfig = TimeoutConfig.getTimeOutConfig();
        Request request = this.requestBuilder(requestUrl).tag((Object)new ImageRequestTag()).group((Request.Group)BizScenc.IMAGELOADER).connectTimeout((long)timeOutConfig.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)timeOutConfig.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)timeOutConfig.writeTimeout, TimeUnit.MILLISECONDS).build();
        this.mCall = GraceUtil.getGrace().newCall(request);
        Call<ResponseBody> call = this.mCall;
        try {
            Response response = this.mCall.execute();
            this.handleDataReady((Response<ResponseBody>)response, callback, requestUrl, call);
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)"ImageOkHttpStreamFetcher", (String)"request url success:%s", (Object[])new Object[]{requestUrl});
            }
        }
        catch (Exception e) {
            String errInfo;
            if (RuntimeContext.sIsDebuggable && call != null && !call.isCanceled()) {
                e.printStackTrace();
            }
            if (!(e instanceof CancelException)) {
                MLog.error((Object)"grace", (String)"execute fail", (Throwable)e, (Object[])new Object[0]);
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)"ImageOkHttpStreamFetcher", (String)"request url fail:%s", (Object[])new Object[]{requestUrl});
                }
            } else if (RuntimeContext.isInGray()) {
                MLog.info((Object)"ImageOkHttpStreamFetcher", (String)"request url canceled:%s", (Object[])new Object[]{requestUrl});
            }
            this.handleLoadFailed((errInfo = e.toString()).contains("404") ? 404 : NetworkUtils.getErrorCodeByExc((Throwable)e), callback, requestUrl, call);
        }
    }

    private void handleDataReady(Response<ResponseBody> response, DataFetcher.DataCallback<? super InputStream> callback, String requestUrl, Call<ResponseBody> call) {
        if (response.isSuccessful()) {
            this.mResponseBody = (ResponseBody)response.body();
            MLog.debug((Object)"grace", (String)("handleDataReady " + this.mResponseBody), (Object[])new Object[0]);
            if (this.mResponseBody != null) {
                long contentLength = this.mResponseBody.contentLength();
                InputStream inputStream = this.mResponseBody.byteStream();
                MLog.debug((Object)"grace", (String)("contentLength " + contentLength + " inputStream " + inputStream), (Object[])new Object[0]);
                this.mInputStream = ContentLengthInputStream.obtain((InputStream)inputStream, (long)contentLength);
                ImageLoadHelper.onImageSizeReady(this.mGlideUrl.toStringUrl(), contentLength);
            }
            callback.onDataReady((Object)this.mInputStream);
        } else {
            MLog.debug((Object)"grace", (String)("handleDataReady error " + this.mResponseBody), (Object[])new Object[0]);
            this.handleLoadFailed(response.code(), callback, requestUrl, call);
        }
    }

    private void handleLoadFailed(int code, DataFetcher.DataCallback<? super InputStream> callback, String requestUrl, Call call) {
        MLog.info((Object)"ImageLoader", (String)("is cancel: " + call.isCanceled() + ", load Error url:" + this.mGlideUrl.toStringUrl()), (Object[])new Object[0]);
        if (!call.isCanceled()) {
            callback.onLoadFailed((Exception)new IOException("Request failed with code: " + code));
        }
        call.disconnect();
    }

    public static class ImageRequestTag {
    }
}

