/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http.adapter.netfactory;

import androidx.annotation.NonNull;
import com.yy.appbase.http.adapter.netfactory.config.TimeoutConfig;
import com.yy.appbase.http.utils.HostUtil;
import com.yy.appbase.http.utils.LogUtil;
import com.yy.base.net.NetworkConnection;
import com.yy.base.okhttp.GraceUtil;
import com.yy.grace.Call;
import com.yy.grace.Request;
import com.yy.grace.Response;
import com.yy.grace.ResponseBody;
import com.yy.grace.networkinterceptor.ibigbossconfig.okhttpconfig.TimeOutConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GraceNetworkConnection
implements NetworkConnection,
NetworkConnection.Connected {
    @NonNull
    private final Request.Builder<ResponseBody> mRequestBuilder;
    private Request<ResponseBody> mRequest;
    private Response<ResponseBody> mResponse;
    private Call<ResponseBody> mCall;
    private String mHost;
    private Request.Group mGroup;
    private Object mTag;

    public GraceNetworkConnection(@NonNull String url, Request.Group group2) {
        LogUtil.i("NetworkConnection", "use OkHttp3NetworkConnection");
        this.mHost = HostUtil.getHostInUrl(url);
        this.mRequestBuilder = new Request.Builder<ResponseBody>(){}.url(url);
        this.mGroup = group2;
    }

    public void addHeader(String name, String value) {
        this.mRequestBuilder.addHeader(name, value);
    }

    public NetworkConnection.Connected execute() throws IOException {
        TimeOutConfig timeOutConfig = TimeoutConfig.getTimeOutConfig();
        this.mRequest = this.mTag != null ? this.mRequestBuilder.tag(this.mTag).group(this.mGroup).connectTimeout((long)timeOutConfig.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)timeOutConfig.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)timeOutConfig.writeTimeout, TimeUnit.MILLISECONDS).build() : this.mRequestBuilder.group(this.mGroup).connectTimeout((long)timeOutConfig.connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)timeOutConfig.readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)timeOutConfig.writeTimeout, TimeUnit.MILLISECONDS).build();
        this.mCall = GraceUtil.getGrace().newCall(this.mRequest);
        this.mResponse = this.mCall.execute();
        LogUtil.i("NetworkConnection", "OkHttp3  connect execute ");
        return this;
    }

    public void release() {
        this.mRequest = null;
        if (this.mResponse != null && this.mResponse.body() != null) {
            ((ResponseBody)this.mResponse.body()).close();
        }
        this.mResponse = null;
    }

    public Map<String, List<String>> getRequestProperties() {
        if (this.mRequest != null) {
            return this.mRequest.headers().toMultimap();
        }
        return this.mRequestBuilder.build().headers().toMultimap();
    }

    public String getRequestProperty(String key) {
        if (this.mRequest != null) {
            return this.mRequest.header(key);
        }
        return this.mRequestBuilder.build().header(key);
    }

    public String networkLibType() {
        return "okhttp";
    }

    public String host() {
        return this.mHost;
    }

    public void tag(Object o) {
        this.mTag = o;
    }

    public int getResponseCode() throws IOException {
        if (this.mResponse == null) {
            throw new IOException("Please invoke execute first!");
        }
        return this.mResponse.code();
    }

    public InputStream getInputStream() throws IOException {
        if (this.mResponse == null) {
            throw new IOException("Please invoke execute first!");
        }
        ResponseBody body = (ResponseBody)this.mResponse.body();
        if (body == null) {
            throw new IOException("no body found on mResponse!");
        }
        return body.byteStream();
    }

    public boolean setRequestMethod(@NonNull String method) {
        this.mRequestBuilder.method(method, null);
        return true;
    }

    public Map<String, List<String>> getResponseHeaderFields() {
        return this.mResponse == null ? null : this.mResponse.raw().getResponseHeaderFields();
    }

    public long getContentLength() throws IOException {
        if (this.mResponse == null) {
            throw new IOException("Please invoke execute first!");
        }
        ResponseBody body = (ResponseBody)this.mResponse.body();
        if (body == null) {
            throw new IOException("no body found on mResponse!");
        }
        return body.contentLength();
    }

    public String getResponseHeaderField(String name) {
        return this.mResponse == null ? null : this.mResponse.raw().header(name);
    }

    public void cancel() {
        if (this.mCall != null) {
            this.mCall.cancel();
        }
    }
}

