/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http;

import android.os.Debug;
import androidx.annotation.NonNull;
import com.google.gson.JsonParseException;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.DefaultNullCall;
import com.yy.appbase.http.IHttpRequestPreventDuplicater;
import com.yy.appbase.http.IHttpRequestSender;
import com.yy.appbase.http.INetCustomRespCallback;
import com.yy.appbase.http.INetOriginRespByteArrayCallback;
import com.yy.appbase.http.INetOriginRespByteArrayHeaderCallback;
import com.yy.appbase.http.INetOriginRespCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.INetRespOriginJsonParseCallback;
import com.yy.appbase.http.adapter.netfactory.CDNMetric;
import com.yy.appbase.http.adapter.netfactory.DownloadNetworkFactory;
import com.yy.appbase.http.cronet.manager.NetParam;
import com.yy.appbase.http.cronet.manager.NetParamImpl;
import com.yy.appbase.http.cronet.manager.NetworkStatImpl;
import com.yy.appbase.http.utils.NetConfigUtils;
import com.yy.appbase.http.wrap.NetRequestImpl;
import com.yy.appbase.http.wrap.get.AbstractGetBuilder;
import com.yy.appbase.http.wrap.post.AbstractPostBuilder;
import com.yy.appbase.http.wrap.post.AbstractPostByteProtoBuilder;
import com.yy.appbase.http.wrap.post.AbstractPostJsonBuilder;
import com.yy.appbase.http.wrap.post.AbstractPostStringBuilder;
import com.yy.appbase.http.ws.WsStatusDelegate;
import com.yy.appbase.localprecent.LocalPercent;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.net.NetworkConnection;
import com.yy.base.okhttp.GraceUtil;
import com.yy.base.okhttp.listener.NetStatMetrics;
import com.yy.base.okhttp.request.OkHttpStatDelegate;
import com.yy.base.okhttp.request.RequestCall;
import com.yy.base.okhttp.stat.NetStat;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Should;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Grace;
import com.yy.grace.ILog;
import com.yy.grace.MediaType;
import com.yy.grace.Request;
import com.yy.grace.RequestBody;
import com.yy.grace.Response;
import com.yy.grace.ResponseBody;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.grace.networkinterceptor.NetConfigParse;
import com.yy.grace.networkinterceptor.flowdispatcher.util.HostUtil;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.proto.GlobalBanInterface;
import com.yy.hiyo.proto.callback.ICheckTokenListener;
import com.yy.mobile.http.BaseNetwork;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpUtil {
    private static final String TAG = "HttpUtil";
    private static final String TAG_RETURN_CHECK = "HttpUtil_ReturnCheck";
    private static final int ERROR_INFO_MAX_LEN = 200;
    public static final int HTTP_GET = 1;
    public static final int HTTP_POST = 2;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_PLAIN_CHARSET_UTF_8 = "text/plain;charset=utf-8";
    private static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=utf-8";
    private static final String APPLICATION_PROTO = "application/proto";
    private static final MediaType TEXT_PLAIN_CHARSET_UTF_8_MediaType = MediaType.parse((String)"text/plain;charset=utf-8");
    private static final MediaType APPLICATION_JSON_CHARSET_UTF_8_MediaType = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType APPLICATION_PROTO_MediaType = MediaType.parse((String)"application/proto");
    private static final NetworkStatImpl mTestNetStatImpl = new NetworkStatImpl();
    private static final NetParam mTestNetParam = new NetParamImpl();
    private static RequestCall.IMonitorCallBack sCallBack;
    private static ICheckTokenListener mICheckTokenListener;
    private static IHttpRequestPreventDuplicater sRequestPreventDuplicater;
    private static IHttpRequestSender sHttpRequestSender;
    private static int mTokenSwitch;

    private static boolean enableReportMetricForCDNType(String bizType) {
        return StringUtils.equalsIgnoreCase((String)bizType, (String)(BizScenc.DOWNLOAD.group() + "")) || StringUtils.equalsIgnoreCase((String)bizType, (String)(BizScenc.IMAGELOADER.group() + "")) || StringUtils.equalsIgnoreCase((String)bizType, (String)(BizScenc.GENERAL_DOWNLOAD.group() + "")) || StringUtils.equalsIgnoreCase((String)bizType, (String)(BizScenc.VIDEO.group() + ""));
    }

    private static void initGrace() {
        NetConfigParse.setOnParseNetConfig(NetConfigUtils::parseNetWorkJson);
        Grace.setDebugFlag((boolean)RuntimeContext.sIsDebuggable);
        boolean enableTls1v3 = SettingFlags.getBoolean((String)"grace_enable_tls_1_3", (boolean)true);
        Grace.setEnableTlsV1_3((boolean)enableTls1v3);
        Grace.setOnStat((Grace.OnStat)new Grace.OnStat(){

            public void stat(HashMap<String, String> statContent, String act) {
                String url;
                String string2 = url = statContent != null ? statContent.get("url") + "" : "";
                if (HttpUtil.enableReportHiido(url)) {
                    StatisContent statisContent = new StatisContent();
                    statisContent.put("act", act);
                    for (Map.Entry<String, String> entry : statContent.entrySet()) {
                        statisContent.put(entry.getKey(), entry.getValue());
                    }
                    if (!statisContent.containsKey("json_map")) {
                        IAB iab = NewABDefine.PRE_CONNECTION.getTest();
                        HashMap<String, String> map = new HashMap<String, String>(2);
                        if (iab != null) {
                            map.put("ab_preconn", iab.getHiidoValue());
                        }
                        map.put("ab_login_preconn", LocalPercent.getTest("login_pre_connection|a_50|b_50").getDesc());
                        statisContent.put("json_map", JsonParser.toJson(map));
                    }
                    String value = statisContent.toString();
                    MLog.debug((Object)HttpUtil.TAG, (String)value, (Object[])new Object[0]);
                    HiidoStatis.reportContent((StatisContent)statisContent);
                }
                String bizType = statContent.get("biztype");
                String status = statContent.get("status");
                if (!StringUtils.equalsIgnoreCase((String)status, (String)"2") && HttpUtil.enableReportMetricForCDNType(bizType)) {
                    String useTime = statContent.get("temp_1") + "";
                    String code = "0";
                    if (StringUtils.equalsIgnoreCase((String)status, (String)"1")) {
                        code = statContent.get("code");
                    }
                    MLog.debug((Object)HttpUtil.TAG, (String)("metric code " + code + " status " + status + " bizType " + bizType), (Object[])new Object[0]);
                    String remoteIp = statContent.get("remoteip");
                    CDNMetric.onMetric(HostUtil.getHostInUrl((String)url), remoteIp, Long.parseLong(useTime), code, bizType);
                }
            }

            public boolean isSwitchOn() {
                return true;
            }
        });
        Grace.setILog((ILog)new ILog(){

            public void i(Object obj, String format, Object ... args) {
                MLog.info((Object)obj, (String)format, (Object[])args);
            }

            public void d(Object obj, String format, Object ... args) {
                MLog.debug((Object)obj, (String)format, (Object[])args);
            }

            public void e(Object obj, String format, Object ... args) {
                MLog.error((Object)obj, (String)format, (Object[])args);
            }

            public void i(Object obj, String args) {
                MLog.info((Object)obj, (String)args, (Object[])new Object[0]);
            }

            public void d(Object obj, String args) {
                MLog.debug((Object)obj, (String)args, (Object[])new Object[0]);
            }

            public void e(Object obj, String args) {
                MLog.error((Object)obj, (String)args, (Object[])new Object[0]);
            }
        });
        Grace.setOnMetric((Grace.OnMetric)new Grace.OnMetric(){

            public void onStart(Request.Group group2, int i, String s, String s1, Map<String, String> map) {
                if (sCallBack != null && HttpUtil.enableReportMetric(group2)) {
                    sCallBack.onStart(i, s, s1, map);
                    MLog.debug((Object)HttpUtil.TAG, (String)("metric onStart group " + group2 + " url " + s), (Object[])new Object[0]);
                }
            }

            public void onCancel(Request.Group group2, int i, String s, String s1, Map<String, String> map) {
                if (sCallBack != null && HttpUtil.enableReportMetric(group2)) {
                    sCallBack.onCancel(i, s, s1, map);
                }
                MLog.debug((Object)HttpUtil.TAG, (String)("metric onCancel group " + group2 + " url " + s), (Object[])new Object[0]);
            }

            public void onFailure(Request.Group group2, int i, String s, String s1, Throwable throwable, Map<String, String> map) {
                if (sCallBack != null && HttpUtil.enableReportMetric(group2)) {
                    sCallBack.onFailure(i, s, s1, throwable, map);
                }
                MLog.debug((Object)HttpUtil.TAG, (String)("metric onFailure group " + group2 + " url " + s + " e " + throwable), (Object[])new Object[0]);
            }

            public void onResponse(Request.Group group2, int i, String s, String s1, long l, Map<String, String> map) {
                if (sCallBack != null && HttpUtil.enableReportMetric(group2)) {
                    sCallBack.onResponse(i, s, s1, l, map);
                }
                MLog.debug((Object)HttpUtil.TAG, (String)("metric onResponse group " + group2 + " url " + s), (Object[])new Object[0]);
            }
        });
    }

    public static void initGraceMetric(RequestCall.IMonitorCallBack callBack) {
        sCallBack = callBack;
    }

    private static boolean enableReportMetric(Request.Group group2) {
        return group2 != BizScenc.DOWNLOAD && group2 != BizScenc.IMAGELOADER && group2 != BizScenc.VIDEO && group2 != BizScenc.GAME_SERVICE && group2 != BizScenc.GENERAL_DOWNLOAD && group2 != BizScenc.WEB && group2 != BizScenc.NORMAL_LOGIN && group2 != BizScenc.UDB;
    }

    private static boolean enableReportHiido(String url) {
        boolean enableReportHiidoWhite = SettingFlags.getBoolean((String)"key_enable_report_hiido_white", (boolean)true);
        if (!enableReportHiidoWhite) {
            return mTestNetParam.isNeedStatus();
        }
        boolean enableReportUrl = false;
        if (StringUtils.isNotEmpty((String)url)) {
            if (url.contains("i.ihago.net")) {
                enableReportUrl = true;
            } else if (url.contains("turnover.ihago.net")) {
                enableReportUrl = true;
            }
        }
        return mTestNetParam.isNeedStatus() || enableReportUrl;
    }

    public static void setCheckTokenListener(ICheckTokenListener checkTokenListener) {
        mICheckTokenListener = checkTokenListener;
    }

    public static void setRequestPreventDuplicaterr(IHttpRequestPreventDuplicater preventDuplicaterr) {
        sRequestPreventDuplicater = preventDuplicaterr;
    }

    public static AbstractGetBuilder get() {
        return NetRequestImpl.getInstance().get();
    }

    public static AbstractPostBuilder post() {
        return NetRequestImpl.getInstance().post();
    }

    public static AbstractPostStringBuilder postString() {
        return NetRequestImpl.getInstance().postString();
    }

    public static AbstractPostJsonBuilder postJson() {
        return NetRequestImpl.getInstance().postJson();
    }

    public static AbstractPostByteProtoBuilder postByteProto() {
        return NetRequestImpl.getInstance().postByteProto();
    }

    public static <Data> void httpReq(String url, Map<String, String> param, int type2, INetRespCallback<Data> callback) {
        HttpUtil.httpReq(url, param, type2, callback, (Map<String, String>)null);
    }

    public static void httpReqPostByteProto(String url, byte[] postContent, Map<String, String> head, INetOriginRespByteArrayHeaderCallback callback) {
        if (head == null) {
            head = new HashMap<String, String>();
        }
        head.put(CONTENT_TYPE, APPLICATION_PROTO);
        HttpUtil.httpReq(url, postContent, null, 2, callback, head);
    }

    public static <Data> void httpReqPostString(String url, String postContent, Map<String, String> head, INetRespCallback<Data> callback) {
        if (head == null) {
            head = new HashMap<String, String>();
        }
        head.put(CONTENT_TYPE, TEXT_PLAIN_CHARSET_UTF_8);
        HttpUtil.httpReq(url, postContent.getBytes(), null, 2, callback, head);
    }

    public static <Data> void httpReqPostForJson(String url, String postContent, Map<String, String> head, INetRespCallback<Data> callback) {
        if (head == null) {
            head = new HashMap<String, String>();
        }
        head.put(CONTENT_TYPE, APPLICATION_JSON_CHARSET_UTF_8);
        HttpUtil.httpReq(url, postContent.getBytes(), null, 2, callback, head);
    }

    public static <Data> void httpReq(String url, Map<String, String> param, int type2, INetRespCallback<Data> callback, Map<String, String> headDataToAdd) {
        HttpUtil.httpReq(url, null, param, type2, callback, headDataToAdd);
    }

    private static <Data> void httpReq(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback<Data> callback, Map<String, String> headDataToAdd) {
        if (url != null && !HttpUtil.checkToken(url, callback, headDataToAdd)) {
            return;
        }
        IHttpRequestPreventDuplicater requestPreventDuplicater = sRequestPreventDuplicater;
        if (requestPreventDuplicater != null) {
            if (sHttpRequestSender == null) {
                sHttpRequestSender = new IHttpRequestSender(){

                    @Override
                    public <T> void httpReq(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback<T> callback, Map<String, String> headDataToAdd) {
                        MyCallBack<T> myCallBack = new MyCallBack<T>(callback, url);
                        HttpUtil.httpReq(url, postContent, param, type2, myCallBack, headDataToAdd);
                    }
                };
            }
            requestPreventDuplicater.httpReq(url, postContent, param, type2, callback, headDataToAdd, sHttpRequestSender);
        } else {
            MyCallBack<Data> myCallBack = new MyCallBack<Data>(callback, url);
            HttpUtil.httpReq(url, postContent, param, type2, myCallBack, headDataToAdd);
        }
    }

    static void httpReq(String url, byte[] postContent, Map<String, String> param, int type2, AbMyCallBack callback, Map<String, String> headDataToAdd) {
        HashMap<String, String> paramReal = new HashMap<String, String>();
        if (param != null) {
            paramReal.putAll(param);
        }
        HashMap<String, String> headReal = new HashMap<String, String>();
        if (headDataToAdd != null) {
            headReal.putAll(headDataToAdd);
        }
        YYTaskExecutor.execute(() -> HttpUtil.httpReqReal(url, postContent, paramReal, type2, callback, headReal));
    }

    private static <Data> boolean checkToken(String url, INetRespCallback<Data> callback, Map<String, String> headDataToAdd) {
        if (callback != null && callback.needToken() && HttpUtil.checkTokenSwitch() && (mICheckTokenListener == null || !mICheckTokenListener.isTokenValid())) {
            if (SystemUtils.isShowEnvSetting() && mICheckTokenListener == null) {
                YYTaskExecutor.execute(() -> {
                    throw new RuntimeException("mICheckTokenListener is null!");
                });
            }
            MLog.warn((Object)TAG, (String)"token \u672a\u6709\u6548\uff0chttp \u4e0d\u80fd\u8bf7\u6c42:%s", (Object[])new Object[]{url});
            IllegalStateException e = new IllegalStateException("token \u672a\u6709\u6548\uff0chttp \u4e0d\u80fd\u8bf7\u6c42. " + url + (headDataToAdd == null ? "" : headDataToAdd.toString()));
            if (YYTaskExecutor.isMainThread()) {
                callback.onError(new DefaultNullCall(url), e, 100);
            } else {
                YYTaskExecutor.postToMainThread(() -> callback.onError(new DefaultNullCall(url), e, 100));
            }
            if (RuntimeContext.sIsDebuggable && AccountUtil.getUid() > 0L) {
                MLog.error((Object)TAG, (Throwable)e);
                YYTaskExecutor.execute(() -> {
                    throw e;
                });
            }
        }
        return true;
    }

    private static boolean checkTokenSwitch() {
        if (mTokenSwitch == 0 && SettingFlags.containKey((String)"close_token_check")) {
            mTokenSwitch = SettingFlags.getBoolean((String)"close_token_check", (boolean)false) ? -1 : 1;
        }
        return mTokenSwitch != -1;
    }

    private static <Data> void httpReqReal(String url, byte[] postContent, Map<String, String> param, int type2, AbMyCallBack<Data> callback, Map<String, String> headDataToAdd) {
        if (url == null || !url.startsWith("http")) {
            MLog.info((Object)TAG, (String)("url not valid" + url), (Object[])new Object[0]);
            return;
        }
        if (param == null) {
            param = new HashMap<String, String>();
        }
        if (headDataToAdd == null) {
            headDataToAdd = new HashMap<String, String>();
        }
        Request.Builder requestBodyBuilder = new Request.Builder<ResponseBody>(){}.url(url).group((Request.Group)BizScenc.HTTP_SERVICE).addHeader(headDataToAdd);
        if (type2 == 1) {
            requestBodyBuilder.get().addQueryParam(param);
        } else if (type2 == 2) {
            if (StringUtils.equalsIgnoreCase((String)headDataToAdd.get(CONTENT_TYPE), (String)TEXT_PLAIN_CHARSET_UTF_8)) {
                requestBodyBuilder.post(RequestBody.create((MediaType)TEXT_PLAIN_CHARSET_UTF_8_MediaType, (byte[])postContent));
            } else if (StringUtils.equalsIgnoreCase((String)headDataToAdd.get(CONTENT_TYPE), (String)APPLICATION_JSON_CHARSET_UTF_8)) {
                requestBodyBuilder.post(RequestBody.create((MediaType)APPLICATION_JSON_CHARSET_UTF_8_MediaType, (byte[])postContent));
            } else if (StringUtils.equalsIgnoreCase((String)headDataToAdd.get(CONTENT_TYPE), (String)APPLICATION_PROTO)) {
                requestBodyBuilder.post(RequestBody.create((MediaType)APPLICATION_PROTO_MediaType, (byte[])postContent));
            } else {
                requestBodyBuilder.method("POST", param);
            }
        }
        HttpUtil.execute((Request.Builder<ResponseBody>)requestBodyBuilder, callback);
    }

    public static <Data> void httpReq(final String url, final Map<String, String> param, final int type2, INetRespCallback<Data> callback, RetryData retryDataOrigin) {
        final RetryData retryData = retryDataOrigin;
        HashMap<String, String> heads = null;
        if (retryData != null && retryData.curUseIp && retryData.curRetryTimes > 0) {
            heads = new HashMap<String, String>();
            heads.put("Host", retryData.ipHost);
        }
        AbMyCallBack myCallBack = new AbMyCallBack<Data>(callback, url){

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable e) {
                String curError;
                String string2 = curError = e != null ? e.toString() : "";
                if (StringUtils.isNotEmpty((String)curError) && curError.length() > 200) {
                    curError = curError.substring(0, 200);
                }
                if (retryData == null || retryData.curRetryTimes >= retryData.maxRetryTimes) {
                    if (retryData != null) {
                        retryData.errorInfo = retryData.errorInfo != null ? retryData.errorInfo + "__" + curError : curError;
                    }
                    super.onFailure(call, e);
                    return;
                }
                boolean useIp = HttpUtil.useIp(curError);
                retryData.errorInfo = retryData.errorInfo != null ? retryData.errorInfo + "__" + curError : curError;
                ++retryData.curRetryTimes;
                if (useIp) {
                    String retryUrl = url;
                    if (StringUtils.isNotEmpty((String)retryData.backIPUrl) && StringUtils.isNotEmpty((String)retryData.ipHost)) {
                        retryData.curUseIp = true;
                        retryUrl = retryData.backIPUrl;
                    } else if (StringUtils.isNotEmpty((String)retryData.backUrl)) {
                        retryData.curUseIp = false;
                        retryUrl = retryData.backUrl;
                    } else if (retryData.useHttpRetry && StringUtils.isNotEmpty((String)url)) {
                        retryData.curUseIp = false;
                        retryUrl = url.replace("https://", "http://");
                    } else {
                        retryData.curUseIp = false;
                    }
                    HttpUtil.httpReq(retryUrl, (Map<String, String>)param, type2, this.callback, retryData);
                } else {
                    HttpUtil.httpReq(url, (Map<String, String>)param, type2, this.callback, retryData);
                }
            }

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                GlobalBanInterface.INSTANCE.interceptHttpResponse(response, (Object)url);
            }
        };
        if (retryData != null) {
            myCallBack.setNeedRetryUseProxy(false);
        }
        HttpUtil.httpReq(url, null, param, type2, myCallBack, heads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGetSyncForPing(String url) {
        String result = "";
        Response response = null;
        try {
            response = GraceUtil.getGrace().newCall(new Request.Builder<ResponseBody>(){}.url(url).get().build()).execute();
            if (response.body() != null) {
                result = ((ResponseBody)response.body()).string();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null && response.body() != null) {
                ((ResponseBody)response.body()).close();
            }
        }
        return result;
    }

    private static boolean useIp(String curErrorInfo) {
        boolean result = false;
        if (StringUtils.isNotEmpty((String)curErrorInfo)) {
            if (curErrorInfo.contains("java.net.ConnectException")) {
                result = true;
            } else if (curErrorInfo.contains("java.net.UnknownHostException")) {
                result = true;
            } else if (curErrorInfo.contains("java.net.SocketTimeoutException")) {
                result = true;
            } else if (curErrorInfo.contains("javax.net.ssl.SSLHandshakeException")) {
                result = true;
            }
        }
        return result;
    }

    public static <Data> void httpReqEx(String url, Object data2, Map<String, String> params, int type2, INetRespCallback<Data> callback) {
        if (data2 != null) {
            Runnable command = () -> {
                String jsonStr = JsonParser.toJson((Object)data2);
                HashMap<String, String> paramTemp = params;
                if (paramTemp == null) {
                    paramTemp = new HashMap<String, String>();
                }
                paramTemp.put("data", jsonStr);
                HttpUtil.httpReq(url, paramTemp, type2, callback);
            };
            if (SettingFlags.getBoolean((String)"keynetopenthreadopt", (boolean)true)) {
                YYTaskExecutor.execute((Runnable)command, (long)0L, (int)5);
            } else {
                YYTaskExecutor.execute((Runnable)command);
            }
        } else {
            HttpUtil.httpReq(url, params, type2, callback);
        }
    }

    static <Data> void onResponseParse(final String url, byte[] response, final int id2, final INetRespCallback<Data> callback, Map<String, List<String>> responseHeader, IParseDataStatCallBack statCallBack) {
        if (response == null) {
            MLog.error((Object)TAG, (String)(" response is null, url = " + url), (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onError(new DefaultNullCall(url), new Exception("response is null"), id2);
                    }
                }
            });
            if (statCallBack != null) {
                statCallBack.onError();
            }
            return;
        }
        Runnable command = () -> {
            try {
                BaseResponseBean parseData = new BaseResponseBean();
                INetRespCallback originCallback = null;
                if (callback instanceof INetCustomRespCallback) {
                    originCallback = ((INetCustomRespCallback)callback).getOriginCallback();
                }
                if (originCallback == null) {
                    originCallback = callback;
                }
                if (originCallback instanceof INetOriginRespByteArrayHeaderCallback) {
                    parseData.data = response;
                    INetOriginRespByteArrayHeaderCallback iNetOriginRespByteArrayHeaderCallback = (INetOriginRespByteArrayHeaderCallback)callback;
                    iNetOriginRespByteArrayHeaderCallback.onResponse(StringUtils.byteToStringUtf8((byte[])response), parseData, id2, responseHeader);
                } else if (originCallback instanceof INetOriginRespByteArrayCallback) {
                    parseData.data = response;
                    HttpUtil.onResponseCallback(StringUtils.byteToStringUtf8((byte[])response), parseData, id2, callback, url);
                } else if (originCallback instanceof INetOriginRespCallback) {
                    parseData.data = StringUtils.byteToStringUtf8((byte[])response);
                    HttpUtil.onResponseCallback((String)parseData.data, parseData, id2, callback, url);
                } else {
                    Class cls;
                    if (originCallback instanceof INetRespOriginJsonParseCallback) {
                        INetRespOriginJsonParseCallback iNetRespOriginJsonParseCallback = (INetRespOriginJsonParseCallback)originCallback;
                        cls = HttpUtil.getActualTypeArgument(iNetRespOriginJsonParseCallback.getClass());
                        Should.notNull(cls, (String)"\u63d0\u4f9b\u7684\u539f\u59cbClass\u4e0d\u80fd\u4e3anull");
                    } else {
                        cls = BaseResponseBean.class;
                    }
                    if (callback != null) {
                        if (cls != String.class) {
                            ParameterizedType parameterizedType = null;
                            Type[] types = originCallback.getClass().getGenericInterfaces();
                            if (types.length >= 1) {
                                parameterizedType = (ParameterizedType)types[0];
                            } else {
                                Type type2 = originCallback.getClass().getGenericSuperclass();
                                if (type2 instanceof ParameterizedType) {
                                    parameterizedType = (ParameterizedType)type2;
                                } else {
                                    throw new InvalidParameterException("url " + url + ", callback " + originCallback);
                                }
                            }
                            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                            ParameterizedTypeImpl type3 = new ParameterizedTypeImpl(cls, actualTypeArguments);
                            if (cls == BaseResponseBean.class) {
                                parseData = (BaseResponseBean)JsonParser.parseJsonTye((String)StringUtils.byteToStringUtf8((byte[])response), (Type)type3);
                                if (parseData == null) {
                                    MLog.error((Object)TAG, (String)("response = " + response + "  url = " + url), (Object[])new Object[0]);
                                    parseData = new BaseResponseBean();
                                }
                            } else {
                                parseData.data = JsonParser.parseJsonTye((String)StringUtils.byteToStringUtf8((byte[])response), (Type)type3);
                            }
                        } else {
                            parseData.data = response;
                        }
                        HttpUtil.onResponseCallback(StringUtils.byteToStringUtf8((byte[])response), parseData, id2, callback, url);
                    }
                }
                if (statCallBack != null) {
                    statCallBack.onSuccess();
                }
            }
            catch (Exception e) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.error((Object)TAG, (String)("\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!!! url = " + url + "  response = " + StringUtils.byteToStringUtf8((byte[])response) + "  e = " + e), (Object[])new Object[0]);
                }
                if (statCallBack != null) {
                    statCallBack.onError();
                }
                if (YYTaskExecutor.isMainThread()) {
                    if (callback != null) {
                        callback.onError(new DefaultNullCall(url), e, id2);
                    }
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onError(new DefaultNullCall(url), e, id2);
                        }
                    }
                });
            }
        };
        if (SettingFlags.getBoolean((String)"keynetopenthreadopt", (boolean)true)) {
            YYTaskExecutor.execute((Runnable)command, (long)0L, (int)5);
        } else {
            YYTaskExecutor.execute((Runnable)command);
        }
    }

    private static Class<?> getActualTypeArgument(Class<?> clazz) {
        Type type2;
        Class entitiClass = null;
        Type[] types = clazz.getGenericInterfaces();
        if (types.length > 0 && (type2 = types[0]) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            entitiClass = (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return entitiClass;
    }

    private static <Data> void onResponseCallback(String response, BaseResponseBean<Data> data2, int id2, @NonNull INetRespCallback<Data> callback, String url) {
        MLog.debug((Object)TAG, (String)("onResponseCallback response " + response + " data " + data2 + " url " + url), (Object[])new Object[0]);
        if (YYTaskExecutor.isMainThread()) {
            callback.onResponse(response, data2, id2);
        } else {
            YYTaskExecutor.postToMainThread(() -> callback.onResponse(response, data2, id2));
        }
    }

    private static <Data> void onErrorCallback(DefaultNullCall call, Exception e, int id2, @NonNull INetRespCallback<Data> callback) {
        MLog.debug((Object)TAG, (String)("onErrorCallback e " + e), (Object[])new Object[0]);
        if (callback == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            callback.onError(call, e, id2);
        } else {
            YYTaskExecutor.postToMainThread(() -> callback.onError(call, e, id2));
        }
    }

    private static <Data> void execute(Request.Builder<ResponseBody> requestBuilder, final AbMyCallBack<Data> callBack) {
        String finalSMethod;
        String finalSName;
        final Request request = requestBuilder.build();
        Runnable checkReturn = null;
        String sName = "";
        String sMethod = "";
        if (SystemUtils.isShowEnvSetting() && !Debug.isDebuggerConnected() && RuntimeContext.sIsForeground) {
            if (request.headers() != null) {
                sName = request.headers().get("X-Ymicro-Api-Service-Name");
                sMethod = request.headers().get("X-Ymicro-Api-Method-Name");
            }
            finalSName = sName;
            finalSMethod = sMethod;
            MLog.info((Object)TAG_RETURN_CHECK, (String)"request:%s, sName:%s, sMethod:%s", (Object[])new Object[]{request.url(), sName, sMethod});
            checkReturn = new Runnable(){

                @Override
                public void run() {
                    if (SystemUtils.isShowEnvSetting() && !Debug.isDebuggerConnected() && RuntimeContext.sIsForeground) {
                        throw new RuntimeException("http request not return:" + request.url() + ",sName:" + finalSName + ",sMethod:" + finalSMethod);
                    }
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)checkReturn, (long)100000L);
        }
        finalSName = sName;
        finalSMethod = sMethod;
        final Runnable finalCheckReturn = checkReturn;
        GraceUtil.getGrace().newCall(request).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)HttpUtil.TAG_RETURN_CHECK, (String)"request:%s, sName:%s, sMethod:%s, onResponse:%d", (Object[])new Object[]{request.url(), finalSName, finalSMethod, response != null ? response.code() : -1});
                    if (finalCheckReturn != null) {
                        YYTaskExecutor.removeRunnableFromMainThread((Runnable)finalCheckReturn);
                    }
                }
                if (callBack != null) {
                    callBack.onResponse(call, response);
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)HttpUtil.TAG_RETURN_CHECK, (String)"request:%s, sName:%s, sMethod:%s, onFailure:%s", (Object[])new Object[]{request.url(), finalSName, finalSMethod, throwable});
                    if (finalCheckReturn != null) {
                        YYTaskExecutor.removeRunnableFromMainThread((Runnable)finalCheckReturn);
                    }
                }
                if (callBack != null) {
                    callBack.onFailure(call, throwable);
                }
            }
        });
    }

    public static void downloadFile(String url, String path, Callback<File> callback) {
        GraceUtil.downloadFile((String)url, (String)path, callback);
    }

    static {
        mTokenSwitch = 0;
        if (RuntimeContext.sIsDebuggable && YYTaskExecutor.isMainThread()) {
            throw new RuntimeException("not init HttpUtil in Main Thread,becuase ANR!");
        }
        HttpUtil.initGrace();
        WsStatusDelegate.init();
        BaseNetwork.setConnectionFactory((NetworkConnection.Factory)DownloadNetworkFactory.sDownloadNetworkFactory());
        OkHttpStatDelegate.setOnStat((OkHttpStatDelegate.OnStat)new OkHttpStatDelegate.OnStat(){

            public void onStat(NetStatMetrics metrics) {
                if (mTestNetParam.isNeedStatus()) {
                    YYTaskExecutor.execute(() -> mTestNetStatImpl.stat(metrics, 1));
                }
            }

            public boolean isStatSwitchOn() {
                return mTestNetParam.isNeedStatus();
            }
        });
        NetStat.setOnNetStat(mTestNetParam::isNeedStatus);
    }

    public static class RetryData {
        int maxRetryTimes = 0;
        int curRetryTimes = 0;
        boolean curUseIp = false;
        boolean useHttpRetry = false;
        volatile String backIPUrl;
        volatile String ipHost;
        String backUrl;
        public String errorInfo;

        public RetryData(int retryTimes, boolean useHttp) {
            this.maxRetryTimes = retryTimes;
            this.useHttpRetry = useHttp;
        }

        public RetryData(int retryTimes, String backIPUrl, String ipHost) {
            this.maxRetryTimes = retryTimes;
            this.backIPUrl = backIPUrl;
            this.ipHost = ipHost;
        }

        public void update(String backIPUrl, String ipHost) {
            this.backIPUrl = backIPUrl;
            this.ipHost = ipHost;
        }

        public RetryData(int retryTimes, String backUrl) {
            this.maxRetryTimes = retryTimes;
            this.backUrl = backUrl;
        }

        public int getCurRetryTimes() {
            return this.curRetryTimes;
        }
    }

    private static abstract class AbMyCallBack<Data>
    implements Callback<ResponseBody> {
        INetRespCallback<Data> callback;
        private boolean retryed = false;
        private String url;
        private boolean retryUseProxy = true;

        public AbMyCallBack(INetRespCallback<Data> callback, String url) {
            this.callback = callback;
            this.url = url;
        }

        public void setNeedRetryUseProxy(boolean useProxy) {
            this.retryUseProxy = useProxy;
        }

        public void onFailure(Call<ResponseBody> call, Throwable e) {
            boolean isRetry;
            String errMsg = e.toString();
            MLog.debug((Object)HttpUtil.TAG, (String)("onFailure method " + call.request().method() + " url " + call.request().url().toString() + " exception " + e), (Object[])new Object[0]);
            MLog.error((Object)HttpUtil.TAG, (String)"onFailure:%s error:%s", (Object[])new Object[]{this.url, errMsg});
            Exception exception = e instanceof Exception ? (Exception)e : new Exception(e);
            boolean bl = isRetry = this.retryUseProxy && this.retryed;
            if (isRetry) {
                RequestCall.onRetryError((String)this.url, (Exception)exception, (String)this.url);
            }
            String backupUrl = null;
            if (this.retryUseProxy && !this.retryed && NetworkUtils.isErrorNeedRetry((Throwable)exception)) {
                backupUrl = RequestCall.getRetryUrl((String)this.url, (String)call.request().url().toString());
            }
            if (StringUtils.isEmpty(backupUrl)) {
                HttpUtil.onErrorCallback(new DefaultNullCall(call.request().url().toString()), exception, -1, this.callback);
            } else {
                this.retryed = true;
                Request.Builder builder = call.request().newBuilder().url(backupUrl);
                HttpUtil.execute((Request.Builder<ResponseBody>)builder, this);
                if (this.retryUseProxy) {
                    RequestCall.onOriginError((String)this.url, (Exception)exception);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(final Call<ResponseBody> call, Response<ResponseBody> response) {
            MLog.debug((Object)HttpUtil.TAG, (String)("onResponse method " + call.request().method() + " url " + call.request().url().toString()), (Object[])new Object[0]);
            final boolean isRetry = this.retryUseProxy && this.retryed;
            try {
                if (call.isCanceled()) {
                    HttpUtil.onErrorCallback(new DefaultNullCall(response.request().url().toString()), new Exception("canceled!"), -1, this.callback);
                    return;
                }
                HttpUtil.onResponseParse(this.url, ((ResponseBody)response.body()).bytes(), -1, this.callback, response.raw().getResponseHeaderFields(), new IParseDataStatCallBack(){

                    @Override
                    public void onSuccess() {
                        if (isRetry) {
                            RequestCall.onRetrySuccess((String)call.request().url().toString(), (String)url);
                        }
                    }

                    @Override
                    public void onError() {
                        RequestCall.onRetryError((String)call.request().url().toString(), (Exception)new JsonParseException(""), (String)url);
                    }
                });
            }
            catch (Exception e) {
                HttpUtil.onErrorCallback(new DefaultNullCall(response.request().url().toString()), e, -1, this.callback);
            }
            finally {
                if (response.body() != null) {
                    ((ResponseBody)response.body()).close();
                }
            }
        }
    }

    static class MyCallBack<Data>
    extends AbMyCallBack {
        public MyCallBack(INetRespCallback<Data> callback, String url) {
            super(callback, url);
        }
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class raw;
        private final Type[] args;

        public ParameterizedTypeImpl(Class raw, Type[] args) {
            this.raw = raw;
            this.args = args != null ? args : new Type[]{};
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.args;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }

    private static interface IParseDataStatCallBack {
        public void onSuccess();

        public void onError();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestType {
    }
}

