/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http;

import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.http.adapter.netfactory.GraceStreamFetcher;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.mobile.http.BaseNetwork;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HttpInterceptor
implements Interceptor {
    public static IHttpRequestMonitor sHttpRequestMonitor;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request;
        String url;
        HttpUrl httpUrl;
        Request originalRequest = chain.request();
        Request.Builder build = originalRequest.newBuilder();
        CommonHttpHeader.fillHttpHeadMap(chain.request().url(), build, originalRequest.headers());
        boolean needReplaceHttp = true;
        if (chain.request().tag() instanceof GraceStreamFetcher.ImageRequestTag) {
            build.removeHeader("X-Auth-Token");
            if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"HttpInterceptor", (String)"remove X-Auth-Token %s!", (Object[])new Object[]{"image"});
            }
            needReplaceHttp = false;
        } else if (chain.request().tag() instanceof BaseNetwork.RequestTag) {
            httpUrl = chain.request().url();
            String string2 = url = httpUrl != null && httpUrl.url() != null ? httpUrl.url().toString() : "";
            if (url != null && url.startsWith("http://")) {
                build.removeHeader("X-Auth-Token");
                if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"HttpInterceptor", (String)"remove X-Auth-Token %s!", (Object[])new Object[]{url});
                }
            }
            needReplaceHttp = false;
        } else {
            httpUrl = chain.request().url();
            String string3 = url = httpUrl != null && httpUrl.url() != null ? httpUrl.url().toString() : "";
            if (url != null && SystemUtils.isShowEnvSetting() && url.startsWith("http://project.sysop.duowan.com")) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.error((Object)"HttpInterceptor", (String)"http request %s, be careful!", (Object[])new Object[]{url});
                }
                if (sHttpRequestMonitor != null) {
                    sHttpRequestMonitor.onHttpRequest(url);
                }
                needReplaceHttp = false;
            }
            if (url != null && url.startsWith("http://") && (url.endsWith(".pkg") || url.endsWith(".patch"))) {
                build.removeHeader("X-Auth-Token");
                if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"HttpInterceptor", (String)"remove X-Auth-Token %s!", (Object[])new Object[]{url});
                }
                needReplaceHttp = false;
            }
        }
        HttpUrl originHttpUrl = chain.request().url();
        String oldUrl = originHttpUrl.toString();
        String oldUrlHost = originHttpUrl.host();
        String newUrl = URLUtils.replaceUrl((String)oldUrl, (String)oldUrlHost);
        if (newUrl.startsWith("http://") && needReplaceHttp) {
            newUrl = URLUtils.replaceHttpByConfig((String)newUrl, (String)oldUrlHost);
            MLog.debug((Object)"HttpInterceptor", (String)"http request %s, be careful, newUrl:%s!", (Object[])new Object[]{oldUrl, newUrl});
            if (sHttpRequestMonitor != null && newUrl.startsWith("http://")) {
                sHttpRequestMonitor.onHttpRequest(oldUrl);
            }
        }
        if (StringUtils.equal((String)oldUrl, (String)newUrl)) {
            request = build.build();
        } else {
            request = build.url(newUrl).build();
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"HttpInterceptor", (String)("originHttpUrl: " + oldUrl + ", originHost: " + originHttpUrl.host() + ", newUrl: " + newUrl), (Object[])new Object[0]);
            }
        }
        Response response = chain.proceed(request);
        if (SystemUtils.isShowEnvSetting() && newUrl != null && !newUrl.contains("/ymicro/api")) {
            PerfActionLog.add((String)"Net_url:%s", (Object[])new Object[]{newUrl});
        }
        return response;
    }

    public static void setHttpRequestMonitor(IHttpRequestMonitor monitor) {
        sHttpRequestMonitor = monitor;
    }

    public static interface IHttpRequestMonitor {
        public void onHttpRequest(String var1);
    }
}

