/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http;

import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.http.adapter.netfactory.GraceStreamFetcher;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.grace.HttpUrl;
import com.yy.grace.Request;
import com.yy.grace.RequestInterceptor;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.hiyo.proto.ProtoExtendDelegate;
import com.yy.mobile.http.BaseNetwork;

public class GraceInterceptor
extends RequestInterceptor {
    private static final String TAG = "GraceInterceptor";
    public static IHttpRequestMonitor sHttpRequestMonitor;

    public Request<?> intercept(Request<?> request) {
        String oldUrlHost;
        HttpUrl originHttpUrl;
        String oldUrl;
        String newUrl;
        String url;
        HttpUrl httpUrl;
        Request.Builder build = request.newBuilder();
        Request.Group group2 = request.group();
        int groupValue = group2 != null ? group2.group() : BizScenc.NONE.group();
        CommonHttpHeader.fillHttpHeadMap(request.url(), build, request.headers(), groupValue);
        if (sHttpRequestMonitor != null) {
            sHttpRequestMonitor.onStart(request);
        }
        boolean needReplaceHttp = true;
        if (request.tag() instanceof GraceStreamFetcher.ImageRequestTag) {
            build.removeHeader("X-Auth-Token");
            needReplaceHttp = false;
            MLog.debug((Object)TAG, (String)"remove X-Auth-Token %s!", (Object[])new Object[]{"image"});
        } else if (request.tag() instanceof BaseNetwork.RequestTag) {
            httpUrl = request.url();
            String string2 = url = httpUrl != null ? httpUrl.url().toString() : "";
            if (url.startsWith("http://")) {
                build.removeHeader("X-Auth-Token");
                MLog.debug((Object)TAG, (String)"remove X-Auth-Token %s!", (Object[])new Object[]{url});
            }
            needReplaceHttp = false;
        } else {
            httpUrl = request.url();
            String string3 = url = httpUrl != null ? httpUrl.url().toString() : "";
            if (url.startsWith("http://") && (url.endsWith(".pkg") || url.endsWith(".patch"))) {
                build.removeHeader("X-Auth-Token");
                needReplaceHttp = false;
                MLog.debug((Object)TAG, (String)"remove X-Auth-Token %s!", (Object[])new Object[]{url});
            } else if (SystemUtils.isShowEnvSetting() && url.startsWith("http://project.sysop.duowan.com")) {
                needReplaceHttp = false;
            }
        }
        if (groupValue == BizScenc.HTTP_RPC.group() || groupValue == BizScenc.HTTP_SERVICE.group() || groupValue == BizScenc.UDB.group() || groupValue == BizScenc.NORMAL_LOGIN.group()) {
            long startTime = -1L;
            if (RuntimeContext.sIsDebuggable) {
                startTime = System.currentTimeMillis();
            }
            String pcid = ProtoExtendDelegate.getPcid();
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)("start get pcid time " + startTime + " pcid " + pcid + " url " + request.url().url().toString()), (Object[])new Object[0]);
            }
            if (StringUtils.isNotEmpty((String)pcid)) {
                build.addHeader("X-Pcid", pcid);
            }
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)("get pcid use time " + (System.currentTimeMillis() - startTime) + " pcid " + pcid + " url " + request.url().url().toString()), (Object[])new Object[0]);
            }
        }
        if ((newUrl = URLUtils.replaceUrl((String)(oldUrl = (originHttpUrl = request.url()).toString()), (String)(oldUrlHost = originHttpUrl.host()))).startsWith("http://") && needReplaceHttp) {
            newUrl = URLUtils.replaceHttpByConfig((String)newUrl, (String)oldUrlHost);
            MLog.debug((Object)"HttpInterceptor", (String)"http request %s, be careful, newUrl:%s!", (Object[])new Object[]{oldUrl, newUrl});
            if (sHttpRequestMonitor != null && newUrl.startsWith("http://")) {
                sHttpRequestMonitor.onHttpRequest(oldUrl);
            }
        }
        if (SystemUtils.isShowEnvSetting() && newUrl != null && !newUrl.contains("/ymicro/api")) {
            PerfActionLog.add((String)"Net_url:%s", (Object[])new Object[]{newUrl});
        }
        if (StringUtils.equal((String)oldUrl, (String)newUrl)) {
            return build.build();
        }
        return build.url(newUrl).build();
    }

    public static void setHttpRequestMonitor(IHttpRequestMonitor monitor) {
        sHttpRequestMonitor = monitor;
    }

    public static interface IHttpRequestMonitor {
        public void onHttpRequest(String var1);

        public void onStart(Request var1);
    }
}

