/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.envsetting.uriprovider;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.DebugDevUriProver;
import com.yy.appbase.envsetting.uriprovider.DebugTestUriProvider;
import com.yy.appbase.envsetting.uriprovider.DefaultServiceIdc;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CustomerServiceDomainConfig;
import com.yy.appbase.unifyconfig.config.UidBelongServiceConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.hiyo.proto.ProtoManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class UriProvider {
    private static final String TAG = "UriProvider";
    private static final String KEY_HAGO_SERVICE_PRE_RELEASE_REGISTER_HOST = "hagoservicepreregisterhost";
    private static final String KEY_HAGO_SERVICE_REGISTER_HOST = "hago_service_register_host";
    private static final String KEY_HAGO_SERVICE_REGISTER_HOST_BACKUP = "hago_service_register_host_back";
    private static final String KEY_HAGO_SERVICE_LOCAL_HOST = "hago_service_local_host";
    private static final String KEY_HAGO_IDC = "hago_service_idc";
    private static final String KEY_HAGO_WEBGAME_HOST = "hago_webgame_host";
    private static final String KEY_HAGO_TURNOVER_HOST = "hago_turnover_host";
    private static final String IHAGO_HOST_PRODUCT = "https://i.ihago.net";
    public static final String DEFAULT_MAIN_HOST_SUFFIX = ".ihago.net";
    private static final String IHAGO_HOST_TEST = "https://i-test.ihago.net";
    public static final String DEFAULT_WEB_MAIN_HOST_WITH_HTTPS_PREFIX = "https://www.ihago.net";
    private static String LOGIN_HOST = "https://i.ihago.net/uaas";
    private static String IKXD_SVR_HOST = "https://service.ihago.net";
    private static String IKXD_API_HOST = "https://api.ihago.net";
    private static String IHAGO_HOST = "https://i.ihago.net";
    private static String PATH_GETGAMELIST_A = "/gameMeta/getGameListA";
    private static String PATH_GETGAMELIST_B = "/gameMeta/go/getGameListB";
    private static final String REVENUE_HOST = "turnover.ihago.net";
    private static String REVENUE_HOST_TEST = DebugTestUriProvider.REVENUE_OLA_PARTY_HOST_TEST;
    private static volatile String sLocalHost = null;
    private static volatile String sRegisterHostOrigin = null;
    private static volatile String sRegisterHostBackUp = null;
    private static volatile String sPreReleaseRegisterHost = null;
    private static volatile int sRegisterIdc = -1;
    private static volatile String sWebGameHost = null;
    private static volatile String sTurnoverHost = null;
    private static volatile boolean sUseRegisterHostBackUpNormal = false;
    private static volatile boolean sUseRegisterHostBackUpWs = false;
    private static DefaultServiceIdc sDefaultServiceIdc = new DefaultServiceIdc();
    public static final String TERMS_OF_SERVICE = "https://www.ihago.net/a/license/nt-user-policy-android.html";
    public static final String PRIVACY_POLICY = "https://www.ihago.net/a/license/nt-register-policy-android.html";
    public static final String FEEDBACK_POST_NEW_URL = "https://imobfeedback.duowan.com/userFeedbackSec";
    public static String LoginReportAnti = LOGIN_HOST + "/anti/report";
    public static String LoginSMSRequest = LOGIN_HOST + "/sms/sendCode";
    public static String LoginWithSMSCode = LOGIN_HOST + "/login/smsAuth";
    public static String LoginRefreshAuth = LOGIN_HOST + "/login/refreshAuth";
    public static String LoginWithThirdPlatform = LOGIN_HOST + "/login/thirdpartyAuth";
    public static String LoginOlaPartyAuthApp = LOGIN_HOST + "/login/authApp";
    public static String LoginBindThirdPlatform = LOGIN_HOST + "/bind/thirdpartyBind";
    public static String LoginQueryThirdPlatform = LOGIN_HOST + "/bind/getThirdpartyInfo";
    public static String LoginReportLocation = IKXD_SVR_HOST + "/uinfo/login";
    public static String LoginGuestAuth = LOGIN_HOST + "/login/guestAuth";
    public static String LoginWhatsappRequest = LOGIN_HOST + "/sms/needWhatsapp";
    public static String LoginWithPwd = LOGIN_HOST + "/login/passwordAuth";
    public static String LoginSetPwd = LOGIN_HOST + "/login/setPassowrd";
    public static String LoginResetPwd = LOGIN_HOST + "/login/resetPassowrd";
    public static String LOGIN_IP_HOST = "i.ihago.net";
    public static String THIRDPARTYAUTH_LOGIN_IP_ONE = "http://47.75.242.132/uaas/login/thirdpartyAuth";
    public static final String THIRDPARTYAUTH_LOGIN_IP_TWO = "http://47.52.230.226/uaas/login/thirdpartyAuth";
    public static String GUEST_LOGIN_IP_ONE = "http://47.75.242.132/uaas/login/guestAuth";
    public static final String GUEST_LOGIN_IP_TWO = "http://47.52.230.226/uaas/login/guestAuth";
    public static String SMS_GET_IP_ONE = "http://47.75.242.132/uaas/sms/sendCode";
    public static final String SMS_GET_IP_TWO = "http://47.52.230.226/uaas/sms/sendCode";
    public static String PHONE_LOGIN_IP_ONE = "http://47.75.242.132/uaas/login/smsAuth";
    public static String PHONE_LOGIN_PWD_IP_ONE = "http://47.75.242.132/uaas/login/passwordAuth";
    public static final String PHONE_LOGIN_IP_TWO = "http://47.52.230.226/uaas/login/smsAuth";
    public static String PHONE_LOGIN_PWD_IP_TWO = "http://47.52.230.226/uaas/login/passwordAuth";
    public static String ALIYUN_STS = "/ualbum/alioss/uploadToken";
    public static String API_GAME_MASTER = IKXD_API_HOST + "/gameInfo/getGameMaster";
    public static String GAME_MASTER = IKXD_API_HOST + "/gameInfo/isMaster";
    public static String GAME_HISTORY = IKXD_SVR_HOST + "/gameInfo/getUserMostPlayGames";
    public static String GET_USER_INFO = IKXD_SVR_HOST + "/uinfo/get_uinfo_byver";
    public static String UPDATE_USER_INFO = IKXD_SVR_HOST + "/uinfo/update_uinfo";
    public static String GET_LIKE_LIST = IKXD_SVR_HOST + "/like/get_liked_user?data=";
    public static String GET_LIKE_COUNT = IKXD_SVR_HOST + "/like/get_like_num";
    public static String GET_MY_LIKE_LIST = IKXD_SVR_HOST + "/like/get_admirers";
    public static String LIKE_CLICK = IKXD_SVR_HOST + "/like/like_one";
    public static String GET_LIKE_STATUS = IKXD_SVR_HOST + "/like/get_like_stat";
    public static String GET_RELATIONSHIP = IKXD_SVR_HOST + "/relation/check_relation";
    public static String REMOVE_FRIEND = IKXD_SVR_HOST + "/relation/remove_friend";
    public static String BLOCK = IKXD_SVR_HOST + "/relation/add_black_list";
    public static String UNBLOCK = IKXD_SVR_HOST + "/relation/remove_black_list";
    public static String UPDATE_AVATAR = IKXD_SVR_HOST + "/uinfo/update_avatar";
    public static String UPDATE_ALBUM = IKXD_SVR_HOST + "/ualbum/user_album/update";
    public static String GET_ALBUM = IKXD_SVR_HOST + "/ualbum/user_album/get";
    public static String GET_BLACK_LIST = IKXD_SVR_HOST + "/relation/get_black_list";
    public static String GET_USERINFO_BY_THIRDPARTY_ACCOUNT_PATH = "/uinfo/get_uinfo_by_account?data=";
    public static String UAAS_TRANSN_OPENID = LOGIN_HOST + "/service/batchGetUidByOpenid";
    public static String SET_LOCATION_PRIVACY = IKXD_SVR_HOST + "/uinfo/hide_location";
    public static String UPLOAD_INVITE_CODE = IKXD_API_HOST + "/activity/hagogame/relatedForInviteCode";
    public static String UPLOAD_RELATION = IKXD_API_HOST + "/relation/invite";
    public static final String SEARCH_FRIEND = "/ikxd_search/friend_list";
    public static final String ADD_FRIEND = "/relation/add_friend";
    public static final String FRIEND_LIST = "/relation/get_friend_list";
    public static final String FRIEND_REQ_LIST = "/relation/get_friend_msgs";
    public static final String SET_FRIEND_REQ_LIST_STATUS = "/relation/batch_set_verify";
    public static final String SET_FRIEND_REQ_STATUS = "/relation/set_friend_verify";
    public static final String GET_FRIEND_FROM_UID = "/relation/get_friend_num";
    public static final String CHECK_UPLOAD_CONTACT = "/addrlist/check";
    public static final String UPLOAD_CONTACT = "/addrlist/upload";
    public static final String CONTACT_FRIENDS = "/addrlist/friends";
    public static String POST_CONTACT_REGISTER_PUSH = "/addrlist/push?data=";
    public static final String CHECK_FACEBOOK_UPLOAD = "/addrlist/fb_check";
    public static final String UPLOAD_FACEBOOK = "/addrlist/fb_upload";
    public static final String POST_FB_REGISTER_PUSH = "/addrlist/fb_push";
    public static final String CHECK_ZALO_UPLOAD = "/addrlist/zalo_check";
    public static final String UPLOAD_ZALO = "/addrlist/zalo_upload";
    public static final String POST_ZALO_REGISTER_PUSH = "/addrlist/zalo_push";
    public static String GAME_RESULT_POST = IKXD_API_HOST + "/gameRoom/report";
    public static String GAME_MATCH_POST = IKXD_API_HOST + "/gameRoom/match";
    public static String GAME_JOIN_POST = IKXD_API_HOST + "/gameRoom/join";
    public static String GAME_LEAVE_POST = IKXD_API_HOST + "/gameRoom/leave";
    public static String GAME_FORCEEXIT_POST = IKXD_API_HOST + "/gameRoom/forceExit";
    public static String GAME_GET_GAME_WIN_DATA = IKXD_API_HOST + "/gameInfo/middlePageInfo";
    public static String GAME_GET_COOPERATION_RANK = "/gameInfo/getCooperationRank";
    public static String GAME_RESULT_LIKE = IKXD_API_HOST + "/like/glike_one";
    public static String GAME_GET_MULTI_MODE_WIN_PLAY_DATA = "/gameInfo/transition/multiModeMiddleInfo";
    public static String SHARE_FIND_FRIEND_GUIDE_TYPE = IKXD_API_HOST + "/gameInfo/shareFofriendtmpl";
    public static String SHARE_FIND_FRIEND = IKXD_API_HOST + "/gameInfo/shareFofriendCard";
    public static final String GET_GAME_LIST_BY_MODE = "/gameMeta/go/getListByMode";
    public static final String SAMESCREEN_DATA_REPORT = "/single/sameScreen/report";
    public static final String GET_SINGLE_GAME_BEST_HISTORY = "/single/bestHistory";
    public static final String GET_SINGLE_GAME_BEST_WEEKLY = "/single/bestWeek";
    public static final String REPORT_SINGLE_GAME_START = "/single/join";
    public static final String REPORT_INDIE_GAME_START = "/gameRoom/join";
    private static final String SINGLE_GAME_RESULT_PATH = "/single/report";
    private static final String SINGLE_GAME_EXCITATION_INFO = "/single/excitInfo";
    public static final String SINGLE_GAME_HOMEPAGE_ENTRANCE = "/single/entranceInfo";
    public static final String SINGLE_GAME_LIST_MIDDLE_PAGE_INFO = "/single/middlePageInfo";
    public static final String SINGLE_GAME_LIST_BARRAGE_INFO = "/single/middleBullet";
    public static final String REPORT_INFO_SUBMIT = "/inform_against/submit";
    public static final String REPORT_FEEDBACK_SUBMIT = "/inform_against/appeal";
    public static final String REPORT_SUBMIT_VOICE = "/inform_against/submit_voice";
    public static final String AGAINST_QUERY_IM = "/inform_against/query_user_appeal?data=";
    public static final String SINGLE_GAME_RANK = "/a/indonesiasinglegamerank/index.html?gameid=%s&bannerImgColor=%s&viewColor=%s&h=%d&lang=%s";
    private static final String GAME_LOAD_PAGE_PATH = "/appconfig/load_page";
    public static final String PROFILE_UPLOAD_INS_PHOTOS = "/ualbum/ins_album/update";
    public static final String PROFILE_GET_INS_PHOTOS = "/ualbum/ins_album/get";
    public static final String PROFILE_INS_BIND = "/ualbum/ins_album/bind";
    public static final String PROFILE_INS_UNBIND = "/ualbum/ins_album/unbind";
    public static final String PROFILE_GET_INS_STATUS = "/ualbum/ins_album/get_ins_status";
    public static final String PROFILE_GET_DRESS_UP_AVATAR = "/activity/dressup/home";
    public static final String GAME_RESULT_DRESS_UP_INFO = "/activity/dressup/results_page";
    public static final String DRESS_UP_ADD_FRIEND = "/activity/dressup/make_friends";
    public static final String IM_DRESS_UP_INFO = "/activity/dressup/im_page";
    public static final String DEL_DRESS_UP_INFO = "/activity/dressup/del_ornament";
    public static final String PROFILE_CENTER_GET_DRESS_UP_INFO = "/activity/dressup/personal";
    public static String TJG_REPORT = IKXD_API_HOST + "/collect/log";
    public static final String HOME_RECOMMEND_BANNER = "/boss/recGame ";
    public static String SHORT_URL_SERVICE_URL = "https://d.ihago.net/_gen?url=";
    private static String BOSS_URL_BASE = "https://api.ihago.net/appconfig";
    public static final String BOSS_URL_SUFFIX = "/boss_config/get";
    public static String FACE_DANCE_SHARE = "/a/indonesiasharepage/xxlShare.html?uid=%d&videoId=%s&langCode=%s";
    public static String HOME_GUIDE_EXPERIMENT_DATA = IKXD_API_HOST + "/boss/home_guide";
    public static String VOICE_ROOM_BEANS_LIST = "/a/hago-wallet/history.html?";
    private static final String WEBAPI_HOST_PREFIX = "https://webapi.ihago.net";
    public static String WEB_PRELOAD_CONFIG_URL = "https://webapi.ihago.net/app/config";
    public static String WEB_PRELOAD_PATCH_CONFIG_URL = "https://webapi.ihago.net/app/patchConfig";
    public static String PRODUCT_WEB_DRESSUP_URL = "https://www.ihago.net/a/hago-dressup/index.html";
    public static String TEST_WEB_DRESSUP_URL = DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-dressup/index.html";
    public static String GOOGLE_MAP_GEOCODE = "https://maps.googleapis.com/maps/api/geocode/json";
    public static String HOME_DATA_LIST;
    public static String HOME_DATA_LIST_B;
    public static String GAME_ONLINE_COUNT;
    public static String GAME_FRIEND_WIN;
    public static String GAME_USER_WIN;
    public static String GAME_USER_PK;
    public static String HOME_NEW_GAMES;
    public static String HOME_AD_DIALOG;
    public static String BULLET_SCRREN_URL;
    public static String GAME_RESULT_TIPS;
    public static String VOICE_ROOM_GAME_LIST;
    public static String GAME_RULE;
    public static String RECOMMEND_IM_GAME_LIST;
    public static final String TENOR_BASE_URL = "https://api.tenor.com/v1/";
    public static final String GOOGLE_AUTH_URL = "https://accounts.google.com/o/oauth2/token";
    public static final String APP_GOOGLE_PLAY_URI = "https://play.google.com/store/apps/details?id=com.live.party";
    public static String GOOGLE_SERVICE_GOOGLE_PLAY_URI;
    public static String FACEBOOK_GOOGLE_PLAY_URI;
    public static String[] THIRD_HOSTS;
    public static final String FAMILY_TREASURY_SOURCE_FAMILY_PAGE = "hagoFamilyPage";
    public static final String FAMILY_TREASURY_SOURCE_VOICE_TEXT = "voiceTextActivities";
    public static final String HOME_ACTIVITY_HALF_POP_WINDOW_DEV = "https://test.ihago.net/a/time-limited-opening/index.html";
    public static final String HOME_ACTIVITY_HALF_POP_WINDOW_PRO = "https://www.ihago.net/a/time-limited-opening/index.html";
    private static volatile String sBossDomain;
    private static volatile IDomainInterceptor sDomainInterceptor;
    public static final int LuckyWheel = 1;
    public static final int Gif = 4;
    public static final int BigWinner = 7;

    public UriProvider() {
        if (RuntimeContext.isHagoPartySdk()) {
            ProtoManager.setDefaultUrl((String)"https://openapi-863.ihago.net");
        }
    }

    public static void init(EnvSettingType uriSetting) {
        sDefaultServiceIdc.init(uriSetting);
        sLocalHost = SettingFlags.getStringValue((String)KEY_HAGO_SERVICE_LOCAL_HOST);
        sRegisterHostOrigin = SettingFlags.getStringValue((String)KEY_HAGO_SERVICE_REGISTER_HOST);
        sRegisterHostBackUp = SettingFlags.getStringValue((String)KEY_HAGO_SERVICE_REGISTER_HOST_BACKUP);
        sPreReleaseRegisterHost = SettingFlags.getStringValue((String)KEY_HAGO_SERVICE_PRE_RELEASE_REGISTER_HOST);
        sRegisterIdc = SettingFlags.getIntValue((String)KEY_HAGO_IDC);
        sWebGameHost = SettingFlags.getStringValue((String)KEY_HAGO_WEBGAME_HOST);
        sTurnoverHost = SettingFlags.getStringValue((String)KEY_HAGO_TURNOVER_HOST);
        MLog.info((Object)TAG, (String)"env:%s", (Object[])new Object[]{uriSetting});
        if (uriSetting == EnvSettingType.Dev) {
            if (RuntimeContext.isHagoPartySdk()) {
                ProtoManager.setDefaultUrl((String)"https://openapi-test-863.ihago.net");
            }
            UriProvider.initDevUri();
        } else if (uriSetting == EnvSettingType.Product) {
            if (RuntimeContext.isHagoPartySdk()) {
                ProtoManager.setDefaultUrl((String)"https://openapi-863.ihago.net");
            }
            UriProvider.initProductUri();
        } else if (uriSetting == EnvSettingType.Test) {
            if (RuntimeContext.isHagoPartySdk()) {
                ProtoManager.setDefaultUrl((String)"https://openapi-test-863.ihago.net");
            }
            UriProvider.initTestUri();
        }
        UriProvider.initUrls();
        String registerWsHostToUse = null;
        if (UriProvider.hasUpdateUrl()) {
            registerWsHostToUse = UriProvider.getWsRegisterHost();
        } else {
            sRegisterHostOrigin = null;
            sPreReleaseRegisterHost = null;
            sRegisterHostBackUp = null;
        }
        if (StringUtils.isNotEmpty((String)registerWsHostToUse)) {
            if (uriSetting == EnvSettingType.Dev) {
                registerWsHostToUse = "ws://" + registerWsHostToUse;
            }
            ProtoManager.updateWsUrl((String)registerWsHostToUse);
        }
        if (sDomainInterceptor != null) {
            sDomainInterceptor.onEnvUpdate();
        }
    }

    public static void switchToRegisterHostBackUp(boolean ws, boolean normal) {
        if (normal) {
            sUseRegisterHostBackUpNormal = true;
        }
        if (ws) {
            sUseRegisterHostBackUpWs = true;
        }
        UriProvider.init(EnvSettings.instance().getUriSettingValue());
    }

    public static void switchToRegisterHostOrigin(boolean ws, boolean normal) {
        if (normal) {
            sUseRegisterHostBackUpNormal = false;
        }
        if (ws) {
            sUseRegisterHostBackUpWs = false;
        }
        UriProvider.init(EnvSettings.instance().getUriSettingValue());
    }

    public static boolean isUseRegisterHostBackUpNormal() {
        return sUseRegisterHostBackUpNormal;
    }

    public static boolean isUseRegisterHostBackUpWs() {
        return sUseRegisterHostBackUpWs;
    }

    public static String getRegisterHostOrigin() {
        return sRegisterHostOrigin;
    }

    public static String getRegisterHostBackUp() {
        return sRegisterHostBackUp;
    }

    public static boolean isMainServerIndonesia() {
        return sRegisterHostOrigin != null && sRegisterHostOrigin.startsWith("i-863");
    }

    public static String getBackupUrl(String originUrl) {
        if (StringUtils.isEmpty((String)originUrl)) {
            return null;
        }
        if (!SettingFlags.getBoolean((String)"normalhttpproxyback", (boolean)true)) {
            return null;
        }
        if (originUrl.endsWith("/d/_ping")) {
            return null;
        }
        String revenueHost = UriProvider.getRevenueHost();
        boolean registerHostBackupEmpty = StringUtils.isEmpty((String)sRegisterHostBackUp);
        boolean registerHostOriginEmpty = StringUtils.isEmpty((String)sRegisterHostOrigin);
        boolean revenueHostEmpty = StringUtils.isEmpty((String)revenueHost);
        if (!registerHostOriginEmpty && originUrl.startsWith("https://" + sRegisterHostOrigin)) {
            return originUrl.replace("https://" + sRegisterHostOrigin, "https://" + sRegisterHostBackUp);
        }
        if (!registerHostOriginEmpty && originUrl.startsWith("http://" + sRegisterHostOrigin)) {
            return originUrl.replace("http://" + sRegisterHostOrigin, "http://" + sRegisterHostBackUp);
        }
        if (!registerHostBackupEmpty && originUrl.startsWith("https://" + sRegisterHostBackUp)) {
            return originUrl.replace("https://" + sRegisterHostBackUp, "https://" + sRegisterHostOrigin);
        }
        if (!registerHostBackupEmpty && originUrl.startsWith("http://" + sRegisterHostBackUp)) {
            return originUrl.replace("http://" + sRegisterHostBackUp, "http://" + sRegisterHostOrigin);
        }
        if (!revenueHostEmpty && originUrl.startsWith("http") && originUrl.contains(revenueHost)) {
            try {
                String backupPlaceholder;
                String replaceHost;
                URL originUri = new URL(originUrl);
                String actualHost = originUri.getHost();
                if (StringUtils.isEmpty((String)actualHost)) {
                    actualHost = revenueHost;
                }
                if (!StringUtils.equal((String)(replaceHost = URLUtils.replaceHost((String)(backupPlaceholder = "proxy-turnover.ihago.net"))), (String)backupPlaceholder)) {
                    return originUrl.replaceFirst(actualHost, replaceHost);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static boolean hasUpdateUrl() {
        return !TextUtils.isEmpty((CharSequence)sLocalHost) && !TextUtils.isEmpty((CharSequence)sRegisterHostOrigin) && sRegisterIdc > 0;
    }

    public static boolean hasRegisterHost() {
        return UriProvider.hasUpdateUrl();
    }

    public static void updateUrl(String localHost, String preRegisterHost, String registerHost, String registerHostBackUp, int idc, String webGameHost, String turnoverHost) {
        if (!TextUtils.isEmpty((CharSequence)registerHost) && !TextUtils.isEmpty((CharSequence)localHost) && idc > 0) {
            SettingFlags.setStringValue((String)KEY_HAGO_SERVICE_PRE_RELEASE_REGISTER_HOST, (String)preRegisterHost);
            SettingFlags.setStringValue((String)KEY_HAGO_SERVICE_REGISTER_HOST, (String)registerHost);
            SettingFlags.setStringValue((String)KEY_HAGO_SERVICE_LOCAL_HOST, (String)localHost);
            SettingFlags.setStringValue((String)KEY_HAGO_SERVICE_REGISTER_HOST_BACKUP, (String)registerHostBackUp);
            SettingFlags.setIntValue((String)KEY_HAGO_IDC, (int)idc);
            MLog.info((Object)TAG, (String)("registerHost:" + registerHost + "\n localHost:" + localHost + "\n idc:" + idc), (Object[])new Object[0]);
            UriProvider.init(EnvSettings.instance().getUriSettingValue());
        } else {
            MLog.error((Object)TAG, (String)("parse host error:" + registerHost + idc), (Object[])new Object[0]);
        }
        SettingFlags.setStringValue((String)KEY_HAGO_WEBGAME_HOST, (String)webGameHost);
        SettingFlags.setStringValue((String)KEY_HAGO_TURNOVER_HOST, (String)turnoverHost);
        sWebGameHost = webGameHost;
        sTurnoverHost = turnoverHost;
        MLog.info((Object)TAG, (String)"update web game host:%s, turnoverHost: %s", (Object[])new Object[]{webGameHost, turnoverHost});
    }

    public static void clearUrl() {
        SettingFlags.removeKey((String)KEY_HAGO_SERVICE_PRE_RELEASE_REGISTER_HOST);
        SettingFlags.removeKey((String)KEY_HAGO_SERVICE_REGISTER_HOST);
        SettingFlags.removeKey((String)KEY_HAGO_SERVICE_LOCAL_HOST);
        SettingFlags.removeKey((String)KEY_HAGO_SERVICE_REGISTER_HOST_BACKUP);
        SettingFlags.removeKey((String)KEY_HAGO_IDC);
        SettingFlags.removeKey((String)KEY_HAGO_WEBGAME_HOST);
        SettingFlags.removeKey((String)KEY_HAGO_TURNOVER_HOST);
        UriProvider.init(EnvSettings.instance().getUriSettingValue());
    }

    public static String getRegisterHost() {
        if (sUseRegisterHostBackUpNormal && StringUtils.isNotEmpty((String)sRegisterHostBackUp)) {
            return sRegisterHostBackUp;
        }
        return sRegisterHostOrigin;
    }

    private static String getWsRegisterHost() {
        if (StringUtils.equal((String)sPreReleaseRegisterHost, (String)sRegisterHostOrigin) && sUseRegisterHostBackUpWs && StringUtils.isNotEmpty((String)sRegisterHostBackUp)) {
            return sRegisterHostBackUp;
        }
        if (StringUtils.isNotEmpty((String)sPreReleaseRegisterHost)) {
            return sPreReleaseRegisterHost;
        }
        return sRegisterHostOrigin;
    }

    public static String getWebGameHost() {
        return sWebGameHost;
    }

    public static ArrayList<String> getPreConnectionHostList() {
        ArrayList<String> hosts = new ArrayList<String>(UriProvider.getNeedUseHostList());
        String preReleaseHost = SettingFlags.getStringValue((String)KEY_HAGO_SERVICE_PRE_RELEASE_REGISTER_HOST);
        String registerHost = SettingFlags.getStringValue((String)KEY_HAGO_SERVICE_REGISTER_HOST);
        String localHost = SettingFlags.getStringValue((String)KEY_HAGO_SERVICE_LOCAL_HOST);
        String registerBackup = SettingFlags.getStringValue((String)KEY_HAGO_SERVICE_REGISTER_HOST_BACKUP);
        hosts.add(preReleaseHost);
        hosts.add(registerHost);
        hosts.add(localHost);
        hosts.add(registerBackup);
        MLog.debug((Object)TAG, (String)("before PreConnection HostList " + hosts.toString()), (Object[])new Object[0]);
        LinkedHashSet<String> set = new LinkedHashSet<String>(hosts.size());
        set.addAll(hosts);
        hosts.clear();
        hosts.addAll(set);
        MLog.debug((Object)TAG, (String)("after PreConnection HostList " + hosts.toString()), (Object[])new Object[0]);
        return hosts;
    }

    public static ArrayList<String> getNeedUseHostList() {
        ArrayList<String> hosts = new ArrayList<String>();
        if (LOGIN_HOST != null) {
            String loginHost = LOGIN_HOST.replace("/uaas", "");
            hosts.add(UriProvider.getHostInner(loginHost));
        }
        hosts.add("www.ihago.net");
        if (StringUtils.isNotEmpty((String)sRegisterHostOrigin)) {
            hosts.add(sRegisterHostOrigin);
        }
        if (StringUtils.isNotEmpty((String)sRegisterHostBackUp)) {
            hosts.add(sRegisterHostBackUp);
        }
        if (StringUtils.isNotEmpty((String)sPreReleaseRegisterHost)) {
            hosts.add(sPreReleaseRegisterHost);
        }
        if (UriProvider.getIdc() == 863) {
            String revenue = "yjd-turnover.ihago.net";
            hosts.add(revenue);
        }
        return hosts;
    }

    public static boolean inUseDnsHostList(String hostName) {
        if (StringUtils.equal((String)hostName, (String)sRegisterHostOrigin)) {
            return true;
        }
        if (StringUtils.equal((String)hostName, (String)sRegisterHostBackUp)) {
            return true;
        }
        if (StringUtils.equal((String)hostName, (String)sPreReleaseRegisterHost)) {
            return true;
        }
        if (StringUtils.equal((String)hostName, (String)UriProvider.getHostInner(LOGIN_HOST))) {
            return true;
        }
        return URLUtils.isOurHost((String)hostName);
    }

    private static String getHostInner(String url) {
        if (StringUtils.isNotEmpty((String)url)) {
            if (url.startsWith("https://")) {
                return url.substring(8);
            }
            return url.substring(7);
        }
        return "";
    }

    private static void initDevUri() {
        if (UriProvider.hasUpdateUrl()) {
            String registerHost = UriProvider.getRegisterHost();
            int idc = sRegisterIdc;
            String schema = "http://";
            IKXD_SVR_HOST = schema + registerHost;
            IKXD_API_HOST = schema + registerHost;
            SHORT_URL_SERVICE_URL = schema + registerHost + "/d/_gen?url=";
            BOSS_URL_BASE = IKXD_SVR_HOST + BOSS_URL_SUFFIX;
            MLog.info((Object)TAG, (String)("updateUrl success,host:" + registerHost + " idc:" + idc), (Object[])new Object[0]);
        } else {
            IKXD_SVR_HOST = DebugDevUriProver.IKXD_SVR_HOST;
            IKXD_API_HOST = DebugDevUriProver.IKXD_API_HOST;
            SHORT_URL_SERVICE_URL = DebugDevUriProver.SHORT_URL_SERVICE_URL;
            BOSS_URL_BASE = IKXD_API_HOST + BOSS_URL_SUFFIX;
        }
        WEB_PRELOAD_CONFIG_URL = DebugDevUriProver.WEB_PRELOAD_CONFIG_URL;
        WEB_PRELOAD_PATCH_CONFIG_URL = DebugDevUriProver.WEB_PRELOAD_PATCH_CONFIG_URL;
        IHAGO_HOST = IHAGO_HOST_TEST;
    }

    private static void initProductUri() {
        if (UriProvider.hasUpdateUrl()) {
            String registerHost = UriProvider.getRegisterHost();
            int idc = sRegisterIdc;
            String schema = "https://";
            IKXD_SVR_HOST = schema + registerHost;
            LOGIN_HOST = "https://i.ihago.net/uaas";
            IKXD_API_HOST = schema + registerHost;
            SHORT_URL_SERVICE_URL = schema + registerHost + "/d/_gen?url=";
            BOSS_URL_BASE = IKXD_SVR_HOST + BOSS_URL_SUFFIX;
            MLog.info((Object)TAG, (String)("updateUrl success,host:" + registerHost + " idc:" + idc), (Object[])new Object[0]);
        } else {
            IKXD_SVR_HOST = "https://service.ihago.net";
            LOGIN_HOST = "https://i.ihago.net/uaas";
            IKXD_API_HOST = "https://api.ihago.net";
            SHORT_URL_SERVICE_URL = "https://d.ihago.net/_gen?url=";
            BOSS_URL_BASE = IKXD_API_HOST + "/appconfig";
        }
        WEB_PRELOAD_CONFIG_URL = "https://webapi.ihago.net/app/config";
        WEB_PRELOAD_PATCH_CONFIG_URL = "https://webapi.ihago.net/app/patchConfig";
        IHAGO_HOST = IHAGO_HOST_PRODUCT;
    }

    private static void initTestUri() {
        if (UriProvider.hasUpdateUrl()) {
            String registerHost = UriProvider.getRegisterHost();
            int idc = sRegisterIdc;
            String schema = "https://";
            IKXD_SVR_HOST = schema + registerHost;
            IKXD_API_HOST = schema + registerHost;
            LOGIN_HOST = "https://i-test.ihago.net/uaas";
            SHORT_URL_SERVICE_URL = schema + registerHost + "/d/_gen?url=";
            BOSS_URL_BASE = IKXD_SVR_HOST + BOSS_URL_SUFFIX;
            MLog.info((Object)TAG, (String)("updateUrl success,host:" + registerHost + " idc:" + idc), (Object[])new Object[0]);
        } else {
            IKXD_SVR_HOST = DebugTestUriProvider.IKXD_SVR_HOST;
            LOGIN_HOST = "https://i-test.ihago.net/uaas";
            IKXD_API_HOST = DebugTestUriProvider.IKXD_API_HOST;
            SHORT_URL_SERVICE_URL = DebugTestUriProvider.SHORT_URL_SERVICE_URL;
            BOSS_URL_BASE = IKXD_API_HOST + BOSS_URL_SUFFIX;
        }
        WEB_PRELOAD_CONFIG_URL = DebugTestUriProvider.WEB_PRELOAD_CONFIG_URL;
        WEB_PRELOAD_PATCH_CONFIG_URL = DebugTestUriProvider.WEB_PRELOAD_PATCH_CONFIG_URL;
        IHAGO_HOST = IHAGO_HOST_TEST;
    }

    private static void initUrls() {
        LoginSMSRequest = LOGIN_HOST + "/sms/sendCode";
        LoginWithSMSCode = LOGIN_HOST + "/login/smsAuth";
        LoginRefreshAuth = LOGIN_HOST + "/login/refreshAuth";
        LoginReportAnti = LOGIN_HOST + "/anti/report";
        LoginWithThirdPlatform = LOGIN_HOST + "/login/thirdpartyAuth";
        LoginBindThirdPlatform = LOGIN_HOST + "/bind/thirdpartyBind";
        LoginOlaPartyAuthApp = LOGIN_HOST + "/login/authApp";
        LoginQueryThirdPlatform = LOGIN_HOST + "/bind/getThirdpartyInfo";
        LoginReportLocation = IKXD_SVR_HOST + "/uinfo/login";
        LoginWhatsappRequest = LOGIN_HOST + "/sms/needWhatsapp";
        LoginGuestAuth = LOGIN_HOST + "/login/guestAuth";
        LoginWithPwd = LOGIN_HOST + "/login/passwordAuth";
        LoginSetPwd = LOGIN_HOST + "/login/setPassowrd";
        LoginResetPwd = LOGIN_HOST + "/login/resetPassowrd";
        UAAS_TRANSN_OPENID = LOGIN_HOST + "/service/batchGetUidByOpenid";
        API_GAME_MASTER = IKXD_API_HOST + "/gameInfo/getGameMaster";
        GAME_HISTORY = IKXD_API_HOST + "/gameInfo/getUserMostPlayGames";
        GET_USER_INFO = IKXD_SVR_HOST + "/uinfo/get_uinfo_byver";
        UPDATE_USER_INFO = IKXD_SVR_HOST + "/uinfo/update_uinfo";
        GET_LIKE_LIST = IKXD_SVR_HOST + "/like/get_liked_user?data=";
        GET_LIKE_COUNT = IKXD_SVR_HOST + "/like/get_like_num";
        GET_MY_LIKE_LIST = IKXD_SVR_HOST + "/like/get_admirers";
        LIKE_CLICK = IKXD_SVR_HOST + "/like/like_one";
        GET_LIKE_STATUS = IKXD_SVR_HOST + "/like/get_like_stat";
        GET_RELATIONSHIP = IKXD_SVR_HOST + "/relation/check_relation";
        REMOVE_FRIEND = IKXD_SVR_HOST + "/relation/remove_friend";
        BLOCK = IKXD_SVR_HOST + "/relation/add_black_list";
        UNBLOCK = IKXD_SVR_HOST + "/relation/remove_black_list";
        UPDATE_AVATAR = IKXD_SVR_HOST + "/uinfo/update_avatar";
        UPDATE_ALBUM = IKXD_SVR_HOST + "/ualbum/user_album/update";
        GET_ALBUM = IKXD_SVR_HOST + "/ualbum/user_album/get";
        GET_BLACK_LIST = IKXD_SVR_HOST + "/relation/get_black_list";
        GAME_MASTER = IKXD_API_HOST + "/gameInfo/isMaster";
        SET_LOCATION_PRIVACY = IKXD_SVR_HOST + "/uinfo/hide_location";
        GAME_RESULT_POST = IKXD_API_HOST + "/gameRoom/report";
        GAME_JOIN_POST = IKXD_API_HOST + REPORT_INDIE_GAME_START;
        GAME_MATCH_POST = IKXD_API_HOST + "/gameRoom/match";
        GAME_LEAVE_POST = IKXD_API_HOST + "/gameRoom/leave";
        GAME_FORCEEXIT_POST = IKXD_API_HOST + "/gameRoom/forceExit";
        GAME_GET_GAME_WIN_DATA = IKXD_API_HOST + "/gameInfo/middlePageInfo";
        GAME_RESULT_LIKE = IKXD_API_HOST + "/like/glike_one";
        HOME_DATA_LIST = IKXD_API_HOST + PATH_GETGAMELIST_A;
        HOME_DATA_LIST_B = IKXD_API_HOST + PATH_GETGAMELIST_B;
        GAME_ONLINE_COUNT = IKXD_API_HOST + "/gameInfo/getOnlineCount";
        GAME_FRIEND_WIN = IKXD_API_HOST + "/gameInfo/getFriendWinInfo";
        GAME_USER_WIN = IKXD_API_HOST + "/gameInfo/getDayWinInfo";
        GAME_USER_PK = IKXD_API_HOST + "/gameInfo/getCurrentPKInfo";
        HOME_NEW_GAMES = IKXD_API_HOST + "/gameMeta/popups";
        HOME_AD_DIALOG = IKXD_API_HOST + "/gameMeta/v2/popups/list";
        UPLOAD_INVITE_CODE = IKXD_API_HOST + "/activity/hagogame/relatedForInviteCode";
        UPLOAD_RELATION = IKXD_API_HOST + "/relation/invite";
        SHARE_FIND_FRIEND_GUIDE_TYPE = IKXD_API_HOST + "/gameInfo/shareFofriendtmpl";
        SHARE_FIND_FRIEND = IKXD_API_HOST + "/gameInfo/shareFofriendCard";
        HOME_GUIDE_EXPERIMENT_DATA = IKXD_API_HOST + "/boss/home_guide";
        TJG_REPORT = IKXD_API_HOST + "/collect/log";
    }

    public static String getIkxdApiHost() {
        return IKXD_API_HOST;
    }

    public static String getIkxdSvrHost() {
        return IKXD_SVR_HOST;
    }

    public static String generateApiUrl(String path) {
        return UriProvider.getIkxdApiHost() + path;
    }

    public static String generateGameListApiUrl(String path) {
        return UriProvider.getIkxdApiHost() + path;
    }

    public static String getSingleGameRankUrl(String gameId, String bgColor, String viewColor) {
        int idc = SettingFlags.getIntValue((String)KEY_HAGO_IDC);
        String lang = SystemUtils.getLangAndCountry();
        if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Dev) {
            return StringUtils.formatWitUSLocal((String)(DebugDevUriProver.SINGLE_GAME_RANK_HOST + SINGLE_GAME_RANK), (Object[])new Object[]{gameId, bgColor, viewColor, idc, lang});
        }
        if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product) {
            return StringUtils.formatWitUSLocal((String)"https://www.ihago.net/a/indonesiasinglegamerank/index.html?gameid=%s&bannerImgColor=%s&viewColor=%s&h=%d&lang=%s", (Object[])new Object[]{gameId, bgColor, viewColor, idc, lang});
        }
        if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Test) {
            return StringUtils.formatWitUSLocal((String)(DebugTestUriProvider.SINGLE_GAME_RANK_HOST + SINGLE_GAME_RANK), (Object[])new Object[]{gameId, bgColor, viewColor, idc, lang});
        }
        return StringUtils.formatWitUSLocal((String)"https://www.ihago.net/a/indonesiasinglegamerank/index.html?gameid=%s&bannerImgColor=%s&viewColor=%s&h=%d&lang=%s", (Object[])new Object[]{gameId, bgColor, viewColor, idc, lang});
    }

    public static String getSingleGameResultUrl() {
        return IKXD_API_HOST + SINGLE_GAME_RESULT_PATH;
    }

    public static String getSingleGameExcitationInfo() {
        return IKXD_API_HOST + SINGLE_GAME_EXCITATION_INFO;
    }

    public static String getCooperationRank() {
        return IKXD_API_HOST + GAME_GET_COOPERATION_RANK;
    }

    public static String getSingleGameMiddlePageInfo() {
        return IKXD_API_HOST + SINGLE_GAME_LIST_MIDDLE_PAGE_INFO;
    }

    public static String getSingleGameBarrageInfo() {
        return IKXD_API_HOST + SINGLE_GAME_LIST_BARRAGE_INFO;
    }

    public static String getGameMultiModeWinPlayDataUrl() {
        return IKXD_API_HOST + GAME_GET_MULTI_MODE_WIN_PLAY_DATA;
    }

    public static String getResultTipsConfig() {
        return IKXD_API_HOST + GAME_RESULT_TIPS;
    }

    public static String getVoiceRoomGameList() {
        return IKXD_API_HOST + VOICE_ROOM_GAME_LIST;
    }

    public static String getGameLoadingImageUrl() {
        if (UriProvider.hasUpdateUrl()) {
            return IKXD_SVR_HOST + GAME_LOAD_PAGE_PATH;
        }
        if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product) {
            return "https://service.ihago.net/appconfig/load_page";
        }
        return DebugTestUriProvider.GameLoadingImageUrl + GAME_LOAD_PAGE_PATH;
    }

    public static int getIdc() {
        return SettingFlags.getIntValue((String)KEY_HAGO_IDC);
    }

    public static String getRechargeRecordUrl() {
        String lang = SystemUtils.getLang();
        long uid = AccountUtil.getUid();
        int idc = UriProvider.getIdc();
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/pay-bills/index.html";
        if (type2 == EnvSettingType.Test) {
            host = DebugTestUriProvider.RechargeRecordUrl;
        }
        return StringUtils.formatWitUSLocal((String)"%s?h=%s&uid=%s&lang=%s&country=%s", (Object[])new Object[]{host, idc, uid, lang, AccountUtil.registerCountry()});
    }

    public static String getDiamondRuleUrl() {
        String lang = SystemUtils.getLang();
        long uid = AccountUtil.getUid();
        int idc = UriProvider.getIdc();
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/exchange-appshare/caption.html";
        if (type2 == EnvSettingType.Test) {
            host = DebugTestUriProvider.DiamondRuleUrl;
        }
        return StringUtils.formatWitUSLocal((String)"%s?h=%s&uid=%s&lang=%s&country=%s", (Object[])new Object[]{host, idc, uid, lang, AccountUtil.registerCountry()});
    }

    public static String getHelpCenterUrl() {
        String lang = SystemUtils.getLang();
        String region = AccountUtil.registerCountry();
        String locale = AccountUtil.realCountry();
        int idc = UriProvider.getIdc();
        String url = "https://www.ihago.net/b/olaparty-help-center/index.html";
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        if (type2 == EnvSettingType.Test) {
            url = DebugTestUriProvider.HelpCenterUrl;
        }
        return StringUtils.formatWitUSLocal((String)"%s?h=%s&region=%s&locale=%s&lang=%s&collection=Payment-and-Purchase", (Object[])new Object[]{url, idc, region, locale, lang});
    }

    public static String getWebDiamondUrl() {
        String lang = SystemUtils.getLang();
        int idc = UriProvider.getIdc();
        String url = "https://www.ihago.net/a/exchange-appshare-v2/index.html";
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        if (type2 == EnvSettingType.Test) {
            url = DebugTestUriProvider.WebDiamondUrl;
        }
        return StringUtils.formatWitUSLocal((String)"%s?h=%s&lang=%s&country=%s", (Object[])new Object[]{url, idc, lang, AccountUtil.registerCountry()});
    }

    public static String getDomain() {
        if (UriProvider.hasRegisterHost()) {
            return IKXD_API_HOST;
        }
        return sDefaultServiceIdc.domain(SystemUtils.getHagoCountry());
    }

    public static String getTurnoverHost() {
        return sTurnoverHost;
    }

    public static String getRevenueHost() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            return REVENUE_HOST_TEST;
        }
        return REVENUE_HOST;
    }

    public static String getRevenueDomain() {
        return "https://%s-" + UriProvider.getRevenueHost();
    }

    public static String getWhatsAppStickerReportInvite() {
        return IKXD_API_HOST + "/activity/emoji/inviteRelation";
    }

    public static String getGameRuleUrl() {
        return IKXD_API_HOST + GAME_RULE;
    }

    public static String getRecommendImGameListUrl() {
        return IKXD_API_HOST + RECOMMEND_IM_GAME_LIST;
    }

    public static String getUidServiceCountryCode(long uid) {
        if (uid == AccountUtil.getUid()) {
            return AccountUtil.registerCountry();
        }
        AConfigData data2 = UnifyConfig.INSTANCE.getConfigData(BssCode.UID_BELONG_SERVICE);
        if (data2 instanceof UidBelongServiceConfig) {
            return ((UidBelongServiceConfig)data2).countryCode(uid);
        }
        return AccountUtil.registerCountry();
    }

    public static String getBeansUrl() {
        String lang = SystemUtils.getLang();
        long uid = AccountUtil.getUid();
        int idc = UriProvider.getIdc();
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/hago-wallet/index.html";
        if (type2 == EnvSettingType.Test) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-wallet/index.html";
        }
        return StringUtils.formatWitUSLocal((String)"%s?uid=%s&%s", (Object[])new Object[]{host, uid, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getGoldCoinsShopUrl(String appEntry, String itemId, boolean getReward, String source, boolean highLight) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/hago-coin/index.html";
        if (type2 == EnvSettingType.Test) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-coin/index.html";
        }
        String getRewardParam = getReward ? "&getReward=1" : "";
        String itemIdParam = TextUtils.isEmpty((CharSequence)itemId) ? "" : "&itemId=" + itemId;
        String sourceParam = TextUtils.isEmpty((CharSequence)source) ? "" : "&source=" + source;
        String highLightParam = highLight ? "&taskEntryHighlight=1" : "";
        return StringUtils.formatWitUSLocal((String)"%s?appEntry=%s%s%s%s%s&%s", (Object[])new Object[]{host, TextUtils.isEmpty((CharSequence)appEntry) ? "sidebar" : appEntry, getRewardParam, itemIdParam, sourceParam, highLightParam, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getOldGoldCoinsShopUrl(String itemId, boolean highLight) {
        String highLightParam;
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/hago-coin/index.html";
        if (type2 == EnvSettingType.Test) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-coin/index.html";
        }
        String string2 = highLightParam = highLight ? "&taskEntryHighlight=1" : "";
        if (TextUtils.isEmpty((CharSequence)itemId)) {
            return StringUtils.formatWitUSLocal((String)"%s?%s%s", (Object[])new Object[]{host, highLightParam, UriProvider.appendCommonWebUrlParams()});
        }
        return StringUtils.formatWitUSLocal((String)"%s?itemId=%s%s&%s", (Object[])new Object[]{host, itemId, highLightParam, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getContributionUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/voice-rank-half/index.html";
        if (type2 == EnvSettingType.Test) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/voice-rank-half/index.html";
        }
        return StringUtils.formatWitUSLocal((String)"%s?%s", (Object[])new Object[]{host, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getContributionExplainUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/voice-rank/modal.html";
        if (type2 == EnvSettingType.Test) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/voice-rank/modal.html";
        }
        return StringUtils.formatWitUSLocal((String)"%s?%s", (Object[])new Object[]{host, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getGangUpUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/kaihei-intro/index.html";
        }
        return StringUtils.formatWitUSLocal((String)"%s?%s", (Object[])new Object[]{host, UriProvider.appendCommonWebUrlParams()});
    }

    public static String appendCommonWebUrlParams() {
        int idc = UriProvider.getIdc();
        String lang = SystemUtils.getLangAndCountry();
        String region = AccountUtil.registerCountry();
        String locale = AccountUtil.realCountry();
        return StringUtils.formatWitUSLocal((String)"h=%d&lang=%s&region=%s&locale=%s", (Object[])new Object[]{idc, lang, region, locale});
    }

    public static String getCustomerServiceUrl() {
        String test;
        String domainName = null;
        CustomerServiceDomainConfig configData2 = (CustomerServiceDomainConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.CUSTOMER_SERVICE_DOMAIN);
        if (configData2 != null) {
            domainName = configData2.getDomain();
            SettingFlags.setStringValue((String)"key_customer_service_domain", (String)domainName);
        }
        if (TextUtils.isEmpty(domainName)) {
            domainName = SettingFlags.getStringValue((String)"key_customer_service_domain", (String)"");
        }
        if (TextUtils.isEmpty((CharSequence)domainName)) {
            domainName = "https://kf.ihago.net/a/page/im.html?";
        }
        String string2 = test = EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product ? "" : "test";
        if (!StringUtils.isEmpty((String)domainName) && !domainName.endsWith("?")) {
            domainName = domainName + "&";
        }
        String url = StringUtils.formatWitUSLocal((String)"%sft=app&appid=%d&&client=android&uid=%d&ticket=%s&%s&mid=%s&fid=&lg=%s", (Object[])new Object[]{domainName, AppKeysDef.getHelpCenterAppId(), AccountUtil.getUid(), CommonHttpHeader.getAuthToken(), UriProvider.appendCommonWebUrlParams(), test, SystemUtils.getSystemLanguage()});
        return url;
    }

    public static String completeCustomerServiceUrl(String url) {
        String test;
        if (url.contains("lang=") && url.contains("region=")) {
            return url;
        }
        String string2 = test = EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product ? "" : "test";
        if (!StringUtils.isEmpty((String)url) && !url.endsWith("?")) {
            url = url + "&";
        }
        String newUrl = StringUtils.formatWitUSLocal((String)"%sft=app&appid=%d&&client=android&uid=%d&ticket=%s%s&mid=%s&fid=&lg=%s", (Object[])new Object[]{url, AppKeysDef.getHelpCenterAppId(), AccountUtil.getUid(), CommonHttpHeader.getAuthToken(), UriProvider.appendCommonWebUrlParams(), test, SystemUtils.getSystemLanguage()});
        return newUrl;
    }

    public static String getAnchorDataCenterUrl(String originUrl) {
        return StringUtils.formatWitUSLocal((String)"%s?%s", (Object[])new Object[]{originUrl, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getRecommendBannerUrl() {
        return IKXD_API_HOST + HOME_RECOMMEND_BANNER;
    }

    public static String getUserDressUpInfo() {
        return IKXD_API_HOST + PROFILE_GET_DRESS_UP_AVATAR;
    }

    public static String getGameResultDressUpInfo() {
        return IKXD_API_HOST + GAME_RESULT_DRESS_UP_INFO;
    }

    public static String getProfileCenterGetDressUpInfo() {
        return IKXD_API_HOST + PROFILE_CENTER_GET_DRESS_UP_INFO;
    }

    public static String getDressUpAddFriend() {
        return IKXD_API_HOST + DRESS_UP_ADD_FRIEND;
    }

    public static String getIMDressUpInfo() {
        return IKXD_API_HOST + IM_DRESS_UP_INFO;
    }

    public static String getDelDressupUrl() {
        return IKXD_API_HOST + DEL_DRESS_UP_INFO;
    }

    public static String getPrivilegeUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/hago-decorator/index.html";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-decorator/index.html";
        }
        return StringUtils.formatWitUSLocal((String)"%s?%s", (Object[])new Object[]{host, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getDressUpSharePlatformUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/show-sharepage/index.html";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/show-sharepage/index.html";
        }
        host = host + "?" + UriProvider.appendCommonWebUrlParams();
        return host;
    }

    public static String getDressUpIMToUrl(String code) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/show/index.html?code=%s&%s#/gray";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/show/index.html?code=%s&%s#/gray";
        }
        host = StringUtils.formatWitUSLocal((String)host, (Object[])new Object[]{code, UriProvider.appendCommonWebUrlParams()});
        return host;
    }

    public static String getMedalPageUrl(long uid, long medalId) {
        String url = UriProvider.isProductEnv() ? "https://www.ihago.net/a/medal-system/index.html?%s#/detail?uid=%s&id=%s" : DebugTestUriProvider.TEST_HAGO_NET + "/a/medal-system/index.html?%s#/detail?uid=%s&id=%s";
        return StringUtils.formatWitUSLocal((String)url, (Object[])new Object[]{UriProvider.appendCommonWebUrlParams(), uid, medalId});
    }

    public static String getMedalListUrl(long uid) {
        String url = UriProvider.isProductEnv() ? "https://www.ihago.net/a/medal-system/index.html?%s#/uid=%s" : DebugTestUriProvider.TEST_HAGO_NET + "/a/medal-system/index.html?%s#/uid=%s";
        return StringUtils.formatWitUSLocal((String)url, (Object[])new Object[]{UriProvider.appendCommonWebUrlParams(), uid});
    }

    public static String getHagoShowApplyUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/show/index.html";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/show/index.html";
        }
        return host + "?" + UriProvider.appendCommonWebUrlParams() + "#/gray";
    }

    public static String getBossConfigUrl() {
        if (UriProvider.hasRegisterHost()) {
            return BOSS_URL_BASE;
        }
        String domain = UriProvider.getDomain();
        if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product && StringUtils.isNotEmpty((String)sBossDomain)) {
            domain = sBossDomain;
        }
        return domain + BOSS_URL_SUFFIX;
    }

    public static String getHiidoS2sUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "http://google-conversion.hiido.com/conversion/app/2.0";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.HiidoS2sUrl;
        }
        return host;
    }

    public static final String getTenorReportConfig() {
        if (RuntimeContext.sIsDebuggable) {
            return DebugTestUriProvider.TEST_HAGO_NET + "/a/gif-compliant/";
        }
        return "https://www.ihago.net/a/gif-compliant/";
    }

    public static final String getCalculatorRuleUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/counter-rule/index.html";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/counter-rule/index.html";
        }
        return host;
    }

    public static final String getShortCutLearnMoreUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://hazel.ihago.net/a/Shortcut/";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.ShortCutLearnMoreUrl;
        }
        return host;
    }

    public static final String getCalculatorHatRuleUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/counter-rule/index.html?from=hat";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/counter-rule/index.html?from=hat";
        }
        return host;
    }

    public static final String getTeamRankUrl(String channelId) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/game-rank/index.html?cid=" + channelId;
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/game-rank/index.html?cid=" + channelId;
        }
        return host;
    }

    public static final String getMedalsWallUrl(long uid) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/medal-wall/index.html?uid=" + uid;
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/medal-wall/index.html?uid=" + uid;
        }
        host = StringUtils.formatWitUSLocal((String)host, (Object[])new Object[]{UriProvider.appendCommonWebUrlParams()});
        return host;
    }

    public static final String getRadioVideoPermissionUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/video-anchor-qa/index.html";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/video-anchor-qa/index.html";
        }
        return host;
    }

    public static final String getUserVipInstrument() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/talent-explanation-dialog/index.html";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/talent-explanation-dialog/index.html";
        }
        return host;
    }

    public static final String getRadioIncomeUrl(long uid, String roomId) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/video-live-income/index.html?anchorUid=%s&roomId=%s", uid, roomId);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/video-live-income/index.html?anchorUid=%s&roomId=%s", uid, roomId);
        }
        return host;
    }

    public static final String getRateGuideComplainUrl(int popOrder, int source) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/gp-grade-pop/index.html?order=%s&source=%s";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.RateGuideComplainUrl;
        }
        return String.format(host, popOrder, source);
    }

    public static final String getSocialMatchUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/social-match/index.html";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = DebugTestUriProvider.TEST_HAGO_NET + "/a/social-match/index.html";
        }
        return host;
    }

    public static String getFamilyMemberUrl(String roomId) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/hago-family/index.html?page=members&familyId=%s", roomId);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-family/index.html?page=members&familyId=%s", roomId);
        }
        return host;
    }

    public static String getFamilyRuleUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/hago-family/index.html?page=rules", new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-family/index.html?page=rules", new Object[0]);
        }
        return host;
    }

    public static String getFamilyDetailUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/hago-family/index.html?page=detail&useNativeDetail=true", new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-family/index.html?page=detail&useNativeDetail=true", new Object[0]);
        }
        return host;
    }

    public static String getFamilyIndexUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/hago-family/index.html?useNativeDetail=true", new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-family/index.html?useNativeDetail=true", new Object[0]);
        }
        return host;
    }

    public static String getFamilyRankUrl(String roomId) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/hago-family/index.html?page=rank&familyId=%s", roomId);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-family/index.html?page=rank&familyId=%s", roomId);
        }
        return host;
    }

    public static String getFamilyDisbandUrl(String roomId) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/family-dismiss/index.html?familyId=%s", roomId);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/family-dismiss/index.html?familyId=%s", roomId);
        }
        return host;
    }

    public static final String getReportDeeplinkUrl() {
        return IHAGO_HOST + "/report/deeplink/clientReport";
    }

    public static final String getNonLoginReportUrl() {
        return IHAGO_HOST + "/report/push/clientReport?";
    }

    public static final String getLoginHost() {
        return LOGIN_HOST;
    }

    private static boolean isProductEnv() {
        return EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product;
    }

    public static String getRulesAndPolicies(String from) {
        String url = UriProvider.isProductEnv() ? "https://www.ihago.net/a/olaparty-security-explanation/index.html" : DebugTestUriProvider.TEST_HAGO_NET + "/a/olaparty-security-explanation/index.html";
        return StringUtils.formatWitUSLocal((String)"%s?source=%s&%s", (Object[])new Object[]{url, from, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getShareTagUrl(String tagId, String bgImgUrl, String title, String desc, String channel) {
        String url = UriProvider.isProductEnv() ? "https://www.ihago.net/a/ugc-tag-share/index.html" : DebugTestUriProvider.TEST_HAGO_NET + "/a/ugc-tag-share/index.html";
        url = StringUtils.formatWitUSLocal((String)"%s?tagId=%s&title=%s&image=%s&desc=%s&%s&uid=%d&channel=%s#/home", (Object[])new Object[]{url, tagId, title, bgImgUrl, desc, UriProvider.appendCommonWebUrlParams(), AccountUtil.getUid(), channel});
        return url;
    }

    public static String getSharePostUrl(String postId, String bgImgUrl, String title, String desc, String channel, int titleNo) {
        String url = UriProvider.isProductEnv() ? "https://www.ihago.net/a/ugc-tag-share/index.html" : DebugTestUriProvider.TEST_OLA_PARTY_HOST + "/a/ugc-tag-share/index.html";
        url = StringUtils.formatWitUSLocal((String)"%s?postId=%s&title=%s&image=%s&desc=%s&%s&uid=%d&channel=%s&titleNo=%s#/detail", (Object[])new Object[]{url, postId, title, bgImgUrl, desc, UriProvider.appendCommonWebUrlParams(), AccountUtil.getUid(), channel, titleNo});
        return url;
    }

    public static String getShareGameCardUrl(String bgImgUrl, String title, String desc, String extend, long uid, String gameId, int type2) {
        String host;
        String url;
        if (UriProvider.isProductEnv()) {
            url = "https://www.ihago.net/a/ar-game-landing/index.html";
            host = DEFAULT_WEB_MAIN_HOST_WITH_HTTPS_PREFIX;
        } else {
            url = DebugTestUriProvider.TEST_HAGO_NET + "/a/ar-game-landing/index.html";
            host = DebugTestUriProvider.TEST_HAGO_NET;
        }
        url = URLUtils.replaceUrl((String)url, (String)host);
        return StringUtils.formatWitUSLocal((String)"%s?title=%s&image=%s&desc=%s&extend=%s&uid=%s&gameId=%s&type=%s&%s", (Object[])new Object[]{url, title, bgImgUrl, desc, extend, uid, gameId, type2, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getDailyTaskUrl() {
        String url = UriProvider.isProductEnv() ? "https://www.ihago.net/a/hago-coin/index.html?page=task&entryId=1" : DebugTestUriProvider.TEST_HAGO_NET + "/a/hago-coin/index.html?page=task&entryId=1";
        return StringUtils.formatWitUSLocal((String)"%s&source=myMenu&%s", (Object[])new Object[]{url, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getTaskUrlFromBonusDialog() {
        String url = UriProvider.isProductEnv() ? "https://www.ihago.net/a/hago-coin/index.html?page=task&entryId=5" : "https://test.ihago.net/a/hago-coin/index.html?page=task&entryId=5";
        return StringUtils.formatWitUSLocal((String)"%s&source=subsidyModal&%s", (Object[])new Object[]{url, UriProvider.appendCommonWebUrlParams()});
    }

    public static String getVideoPkRankingUrl(String pkId, long uid) {
        String url = UriProvider.isProductEnv() ? String.format("https://www.ihago.net/a/show-pk-rank/index.html?anchorUid=%s&pkId=%s", uid, pkId) : String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/show-pk-rank/index.html?anchorUid=%s&pkId=%s", uid, pkId);
        return url;
    }

    public static String getAudioPkRankingUrl(String pkId, String cid) {
        String url = UriProvider.isProductEnv() ? String.format("https://www.ihago.net/a/cross-room-pk-rank/index.html?roomid=%s&pkid=%s", cid, pkId) : String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/cross-room-pk-rank/index.html?roomid=%s&pkid=%s", cid, pkId);
        return url;
    }

    public static String getAudioInnerPkRankingUrl(String pkId, String tf) {
        String url = UriProvider.isProductEnv() ? String.format("https://www.ihago.net/a/cross-room-pk-rank/index.html?inner=1&pkid=%s&tf=%s", pkId, tf) : String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/cross-room-pk-rank/index.html?inner=1&pkid=%s&tf=%s", pkId, tf);
        return url;
    }

    public static String fansClubListUrl() {
        String url = UriProvider.isProductEnv() ? String.format("https://www.ihago.net/a/show-fans-club/index.html", new Object[0]) : String.format("https://test.ihago.net/a/show-fans-club/index.html", new Object[0]);
        return url;
    }

    public static String fansClubCardUrl(long anchorUid) {
        String url = UriProvider.isProductEnv() ? String.format("https://www.ihago.net/a/show-fans-club/join.html?anchor_uid=%s", anchorUid) : String.format("https://test.ihago.net/a/show-fans-club/join.html?anchor_uid=%s", anchorUid);
        return url;
    }

    public static String fansClubFAQUrl() {
        String url = UriProvider.isProductEnv() ? String.format("https://www.ihago.net/a/show-fans-club/faq.html", new Object[0]) : String.format("https://test.ihago.net/a/show-fans-club/faq.html", new Object[0]);
        return url;
    }

    public static String fansClubMembersUrl(long anchorUid) {
        String url = UriProvider.isProductEnv() ? String.format("https://www.ihago.net/a/show-fans-club/clubmember.html?anchor_uid=%s", anchorUid) : String.format("https://test.ihago.net/a/show-fans-club/clubmember.html?anchor_uid=%s", anchorUid);
        return url;
    }

    public static String getFamilyTreasuryUrl(String familyId, String source) {
        String url = UriProvider.isProductEnv() ? String.format("https://www.ihago.net/a/family-treasury/index.html?fid=%s&source=%s", familyId, source) : String.format("https://test.ihago.net/a/family-treasury/index.html?fid=%s&source=%s", familyId, source);
        return url;
    }

    public static String getHomeActivityHalfPopWindowHtml() {
        String url = UriProvider.isProductEnv() ? HOME_ACTIVITY_HALF_POP_WINDOW_PRO : HOME_ACTIVITY_HALF_POP_WINDOW_DEV;
        return url;
    }

    public static void updateLoginDomain(String loginDomain) {
        if (StringUtils.isEmpty((String)loginDomain)) {
            return;
        }
        LOGIN_HOST = "https://" + loginDomain + "/uaas";
        if (SystemUtils.isShowEnvSetting()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u767b\u9646\u4f7f\u7528Google\u8fd4\u56de\u57df\u540d", (int)1);
        }
    }

    public static void updateLoginIp(String loginDomain, String ip) {
        if (StringUtils.isEmpty((String)loginDomain) || StringUtils.isEmpty((String)ip)) {
            return;
        }
        LOGIN_IP_HOST = loginDomain;
        THIRDPARTYAUTH_LOGIN_IP_ONE = "http://" + ip + "/uaas/login/thirdpartyAuth";
        GUEST_LOGIN_IP_ONE = "http://" + ip + "/uaas/login/guestAuth";
        SMS_GET_IP_ONE = "http://" + ip + "/uaas/sms/sendCode";
        PHONE_LOGIN_IP_ONE = "http://" + ip + "/uaas/login/smsAuth";
        PHONE_LOGIN_PWD_IP_ONE = "http://" + ip + "/uaas/login/passwordAuth";
    }

    public static void updateBossDomain(String bossDomain) {
        sBossDomain = "https://" + bossDomain;
    }

    public static String getHost() {
        return IHAGO_HOST;
    }

    public static void setDomainInterceptor(IDomainInterceptor interceptor) {
        sDomainInterceptor = interceptor;
    }

    public static String getAccountFreezeDialogUrl(int scene) {
        String url = UriProvider.isProductEnv() ? "https://www.ihago.net/a/silent-alert/index.html?scene={%d}" : "https://test.ihago.net/a/silent-alert/index.html?scene={%d}";
        url = String.format(url, scene);
        MLog.debug((Object)"FreezeDialogScene", (String)url, (Object[])new Object[0]);
        return url;
    }

    public static String getHomeNewUserPopWindowHtml() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/scene-layer/index.html", new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/scene-layer/index.html", new Object[0]);
        }
        return host;
    }

    public static String getAmongUsGuideHtml(String path) {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/kaihei-rule-modal/" + path, new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/kaihei-rule-modal/" + path, new Object[0]);
        }
        return host;
    }

    public static String getTeamUpGuideUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/mbll-activity/tutorial.html", new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/mbll-activity/tutorial.html", new Object[0]);
        }
        return host;
    }

    public static String getFullScreenTaskEntranceUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/family-task/index.html?isFull=true", new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/family-task/index.html?isFull=true", new Object[0]);
        }
        return host;
    }

    public static String getHalfScreenTaskEntranceUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/family-task/index.html", new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/family-task/index.html", new Object[0]);
        }
        return host;
    }

    public static String getFamilyPartyActivityHelpUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = "https://www.ihago.net/a/hago-family/#/rules?type=question&topic=party";
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = "https://test.ihago.net/a/hago-family/#/rules?type=question&topic=party";
        }
        return host;
    }

    public static String getStarLevelRule() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = StringUtils.formatWitUSLocal((String)"https://www.ihago.net/a/host-level/index.html?%s", (Object[])new Object[]{UriProvider.appendCommonWebUrlParams()});
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = StringUtils.formatWitUSLocal((String)(DebugTestUriProvider.TEST_HAGO_NET + "/a/host-level/index.html?%s"), (Object[])new Object[]{UriProvider.appendCommonWebUrlParams()});
        }
        return host;
    }

    public static String getAudioPkRule() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = StringUtils.formatWitUSLocal((String)"https://www.ihago.net/a/cross-room-pk-rank/rule.html", (Object[])new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = StringUtils.formatWitUSLocal((String)(DebugTestUriProvider.TEST_HAGO_NET + "/a/cross-room-pk-rank/rule.html"), (Object[])new Object[0]);
        }
        return host;
    }

    public static String getInnerPkRule() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = StringUtils.formatWitUSLocal((String)"https://www.ihago.net/a/cross-room-pk-rank/rule.html?inner=1", (Object[])new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = StringUtils.formatWitUSLocal((String)(DebugTestUriProvider.TEST_HAGO_NET + "/a/cross-room-pk-rank/rule.html?inner=1"), (Object[])new Object[0]);
        }
        return host;
    }

    public static String getUserLevelPageUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/user-level/index.html", new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/user-level/index.html", new Object[0]);
        }
        return host;
    }

    public static String getUserLevelUpgradeUrl() {
        EnvSettingType type2 = EnvSettings.instance().getUriSettingValue();
        String host = String.format("https://www.ihago.net/a/user-level/upgrade.html", new Object[0]);
        if (type2 == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
            host = String.format(DebugTestUriProvider.TEST_HAGO_NET + "/a/user-level/upgrade.html", new Object[0]);
        }
        return host;
    }

    public static String getPrivacyPolicyUrl() {
        if (UriProvider.isProductEnv()) {
            return "https://www.ihago.net/a/olaparty-license/register-policy-android.html";
        }
        return DebugTestUriProvider.TEST_HAGO_NET + "/a/olaparty-license/register-policy-android.html";
    }

    public static String getTermsOfServiceUrl() {
        if (UriProvider.isProductEnv()) {
            return "https://www.ihago.net/a/olaparty-license/register-user-android.html";
        }
        return DebugTestUriProvider.TEST_HAGO_NET + "/a/olaparty-license/register-user-android.html";
    }

    static {
        BULLET_SCRREN_URL = "/appconfig/bullet_screen";
        GAME_RESULT_TIPS = "/boss/app_get_results_page";
        VOICE_ROOM_GAME_LIST = "/gameMeta/v2/roomGameList";
        GAME_RULE = "/rmgr/game_rule";
        RECOMMEND_IM_GAME_LIST = "/gameMeta/go/getIMGameList";
        GOOGLE_SERVICE_GOOGLE_PLAY_URI = "https://play.google.com/store/apps/details?id=com.google.android.gms";
        FACEBOOK_GOOGLE_PLAY_URI = "https://play.google.com/store/apps/details?id=com.facebook.katana";
        THIRD_HOSTS = new String[]{".tenor.com", ".google.com"};
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FreezeDialogScene {
    }

    public static interface IDomainInterceptor {
        public void onEnvUpdate();
    }
}

