/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.deeplink;

import android.net.Uri;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.SettingFlags;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import okhttp3.Call;

public enum DeepLinkRequestManager {
    INSTANCE;

    public static final String TAG = "DeepLinkRequestManager";
    private static final String ADD_WHATSAPP_STICKER = "whatsAppSticker";
    private final MutableLiveData<Uri> mDeepLinkUri = new MutableLiveData();
    private final SparseArray<String> mDeepLinkMap = new SparseArray();

    public void reportInviteCode(String inviteCode) {
        if (TextUtils.isEmpty((CharSequence)inviteCode)) {
            return;
        }
        HttpUtil.httpReqEx(UriProvider.UPLOAD_INVITE_CODE + "?inviteCode=" + inviteCode, null, null, 2, new INetRespCallback<Object>(){

            @Override
            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
                MLog.info((Object)DeepLinkRequestManager.TAG, (String)response, (Object[])new Object[0]);
            }

            @Override
            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)DeepLinkRequestManager.TAG, (Throwable)e);
            }
        });
    }

    public void reportRelationship(String uid, String url, boolean isOldUser) {
        if (TextUtils.isEmpty((CharSequence)uid)) {
            return;
        }
        RelationParam param = new RelationParam();
        param.uid = Long.parseLong(uid);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            param.url = URLEncoder.encode(url);
        }
        param.old = isOldUser;
        HttpUtil.httpReqEx(UriProvider.UPLOAD_RELATION, param, null, 2, new INetRespCallback<Object>(){

            @Override
            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
                MLog.info((Object)DeepLinkRequestManager.TAG, (String)response, (Object[])new Object[0]);
            }

            @Override
            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)DeepLinkRequestManager.TAG, (Throwable)e);
            }
        });
    }

    public void reportSpecialActive(String activeId, String inviteUid, String inviteCode) {
        if (ADD_WHATSAPP_STICKER.equals(activeId)) {
            this.reportWhatsAppStickerInvite(inviteUid);
        }
    }

    private void reportWhatsAppStickerInvite(String inviteUid) {
        MLog.info((Object)TAG, (String)"reportWhatsAppStickerInvite inviteUid: %s ", (Object[])new Object[]{inviteUid});
        if (TextUtils.isEmpty((CharSequence)inviteUid)) {
            return;
        }
        String data2 = "{\"shareUid\":" + inviteUid + "}";
        try {
            data2 = URLEncoder.encode(data2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            MLog.info((Object)TAG, (String)"reportWhatsAppStickerInvite UnsupportedEncodingException: %s", (Object[])new Object[]{e});
        }
        String url = UriProvider.getWhatsAppStickerReportInvite() + "?data=" + data2;
        HttpUtil.httpReq(url, null, 1, new INetRespCallback<Object>(){

            @Override
            public void onError(Call call, Exception e, int id2) {
                MLog.info((Object)DeepLinkRequestManager.TAG, (String)"reportWhatsAppStickerInvite ex: %s", (Object[])new Object[]{e});
            }

            @Override
            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
                MLog.info((Object)DeepLinkRequestManager.TAG, (String)"reportWhatsAppStickerInvite suc: %s", (Object[])new Object[]{response});
            }
        });
    }

    @NonNull
    public LiveData<Uri> getDeepLinkUri() {
        return this.mDeepLinkUri;
    }

    public void saveSource(String source, String campaign) {
        long uid = AccountUtil.getUid() > 0L ? AccountUtil.getUid() : 0L;
        SettingFlags.setStringValue((String)("key_dp_report_source" + uid), (String)(source == null ? "" : source));
        SettingFlags.setStringValue((String)("key_dp_report_campaign" + uid), (String)(campaign == null ? "" : campaign));
        SettingFlags.setStringValue((String)"key_dp_report_campaign", (String)(campaign == null ? "" : campaign));
    }

    public void setDeepLinkUri(@Nullable Uri uri) {
        this.mDeepLinkUri.postValue((Object)uri);
    }

    public void putDeepLinkUri(int type2, @Nullable String uriString) {
        this.mDeepLinkMap.put(type2, (Object)uriString);
    }

    public void removeDeepLinkUri(int type2) {
        this.mDeepLinkMap.remove(type2);
    }

    @Nullable
    public String getDeepLinkUri(int type2) {
        return (String)this.mDeepLinkMap.get(type2);
    }

    @DontProguardClass
    public static class RelationParam {
        public long uid;
        public String url;
        public boolean old;
    }
}

