/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.db;

import android.content.Context;
import com.getkeepsafe.relinker.ReLinker;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.MyObjectBox;
import com.yy.appbase.service.IDBService;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import io.objectbox.BoxStore;
import io.objectbox.BoxStoreBuilder;
import io.objectbox.android.AndroidObjectBrowser;
import io.objectbox.exception.DbException;
import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Set;

public class DataBox
implements IDBService {
    private static final String DB_PREFIX = "db_";
    private volatile BoxStore mCurUserBoxStore;
    private volatile BoxStore mGlobalBoxStore;
    private final HashMap<Class, MyBox> mCurUserBoxs = new HashMap();
    private final HashMap<Class, MyBox> mGlobalBoxs = new HashMap();
    private final HashMap<Long, BoxStore> mBoxsMap = new HashMap();
    private volatile long mCurUid = -1L;
    private boolean mInitUserBoxStoreExc = false;
    private boolean mInitGlobalBoxStoreExc = false;
    private static boolean sLoadLibrary = false;

    public DataBox() {
        DataBox.loadLibrary();
        long uid = AccountUtil.getUid();
        if (uid > 0L) {
            this.mCurUid = uid;
            this.initUserDb(uid);
        }
        this.initGlobalDb();
    }

    public static synchronized void loadLibrary() {
        if (!sLoadLibrary) {
            try {
                ReLinker.loadLibrary((Context)RuntimeContext.sApplicationContext, (String)"objectbox-jni", null, null);
                sLoadLibrary = true;
            }
            catch (Exception e) {
                MLog.error((Object)"DataBox", (String)"loadLibrary error", (Throwable)e, (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initUserDb(long uid) {
        HashMap<Long, BoxStore> hashMap = this.mBoxsMap;
        synchronized (hashMap) {
            this.mCurUserBoxStore = this.mBoxsMap.get(uid);
        }
        if (this.mCurUserBoxStore == null) {
            this.moveOldUserDb(uid);
            File dir = this.getUserDbDir(uid);
            BoxStoreBuilder builder = MyObjectBox.builder();
            try {
                this.mCurUserBoxStore = builder.directory(dir).build();
            }
            catch (DbException e) {
                this.mInitUserBoxStoreExc = true;
                this.statDbInitError(false, e);
            }
            catch (UnsatisfiedLinkError e) {
                this.mInitUserBoxStoreExc = true;
                this.statDbInitError(false, e);
            }
            if (RuntimeContext.sIsDebuggable) {
                new AndroidObjectBrowser(this.mCurUserBoxStore).start(RuntimeContext.sApplicationContext);
            }
        }
        MLog.info((Object)"DataBox", (String)("initUserDb uid:" + uid), (Object[])new Object[0]);
    }

    private void statDbInitError(boolean global, Throwable e) {
        String errorInfo;
        String string2 = errorInfo = e != null ? e.toString() : "";
        if (errorInfo.contains("Could not open env for DB (30) (error code 30)")) {
            SettingFlags.setBoolean((String)"hasstorageper", (boolean)false);
        }
        boolean notInternalStoragePermission = false;
        if (errorInfo.contains("io.objectbox.exception.DbException: Incoming property ID") || errorInfo.contains("is not compatible to its previous definition. Check its type")) {
            this.clearDbInner(global);
        } else if (errorInfo.contains("io.objectbox.exception.DbException: Could not create directory")) {
            notInternalStoragePermission = true;
        }
        if (!notInternalStoragePermission && RuntimeContext.isInGray() && !SettingFlags.getBoolean((String)"databoxexcep", (boolean)false)) {
            final RuntimeException runtimeException = new RuntimeException(e);
            SettingFlags.setBoolean((String)"databoxexcep", (boolean)true);
            SettingFlags.commit();
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    throw runtimeException;
                }
            }, (long)2000L);
        } else {
            if (errorInfo != null && errorInfo.length() > 200) {
                errorInfo = errorInfo.substring(0, 199);
            }
            HiidoStatis.reportAppMonitorReturnCode((String)"dbuserboxcrash", (long)0L, (String)"0");
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("sfield", errorInfo);
            statContent.put("perftype", "dbuserboxcrash");
            HiidoStatis.reportContent((StatisContent)statContent);
        }
    }

    private void initGlobalDb() {
        File dir = FileStorageUtils.getInstance().getDirAndCreate(true, "db_global");
        BoxStoreBuilder builder = MyObjectBox.builder();
        try {
            this.mGlobalBoxStore = builder.directory(dir).build();
        }
        catch (DbException e) {
            this.mInitGlobalBoxStoreExc = true;
            this.statDbInitError(true, e);
        }
        catch (UnsatisfiedLinkError e) {
            this.mInitGlobalBoxStoreExc = true;
            this.statDbInitError(true, e);
        }
        if (RuntimeContext.sIsDebuggable && this.mGlobalBoxStore != null) {
            AndroidObjectBrowser objectBrowser = new AndroidObjectBrowser(this.mGlobalBoxStore);
            objectBrowser.start(RuntimeContext.sApplicationContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loginOut() {
        HashMap<Constable, Object> hashMap = this.mBoxsMap;
        synchronized (hashMap) {
            this.mBoxsMap.put(this.mCurUid, this.mCurUserBoxStore);
        }
        this.mCurUid = -1L;
        this.mCurUserBoxStore = null;
        hashMap = this.mCurUserBoxs;
        synchronized (hashMap) {
            if (this.mCurUserBoxs.size() > 0) {
                Set<Class> keys = this.mCurUserBoxs.keySet();
                for (Class key : keys) {
                    this.mCurUserBoxs.get(key).onDestroy();
                }
                this.mCurUserBoxs.clear();
            }
        }
    }

    private void moveOldUserDb(long uid) {
        boolean hasMoved = SettingFlags.getBoolean((String)("databoxold_move_" + uid), (boolean)false);
        if (hasMoved) {
            return;
        }
        File oldDir = this.getOldUserDbDir(uid);
        if (oldDir != null && YYFileUtils.isDirExisted((File)oldDir)) {
            File dir = this.getUserDbDir(uid);
            boolean result = oldDir.renameTo(dir);
            if (!result) {
                MLog.info((Object)"DataBox", (String)"rename error!", (Object[])new Object[0]);
                try {
                    YYFileUtils.copyDirectoryContents((File)oldDir, (File)dir, (boolean)false);
                    MLog.info((Object)"DataBox", (String)"rename success2!", (Object[])new Object[0]);
                }
                catch (IOException e) {
                    MLog.error((Object)"DataBox", (Throwable)e);
                }
            } else {
                MLog.info((Object)"DataBox", (String)"rename success!", (Object[])new Object[0]);
            }
        }
        SettingFlags.setBoolean((String)("databoxold_move_" + uid), (boolean)true);
    }

    private File getOldUserDbDir(long uid) {
        return new File(FileStorageUtils.getInstance().getInternalCacheRootDir() + File.separator + DB_PREFIX + uid);
    }

    private File getUserDbDir(long uid) {
        return FileStorageUtils.getInstance().getDirAndCreate(true, DB_PREFIX + uid);
    }

    private void loginInInner() {
        this.loginOut();
        long uid = AccountUtil.getUid();
        if (uid != this.mCurUid) {
            this.mCurUid = uid;
            this.initUserDb(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MyBox boxForGlobal(Class<? extends BaseDBBean> entityClass) {
        DataBox dataBox = this;
        synchronized (dataBox) {
            if (this.mGlobalBoxStore == null) {
                if (RuntimeContext.sIsDebuggable || !this.mInitGlobalBoxStoreExc) {
                    return null;
                }
                MyBox box = this.mGlobalBoxs.get(entityClass);
                if (box == null) {
                    box = new MyBox(null);
                    this.mGlobalBoxs.put(entityClass, box);
                }
                return box;
            }
        }
        dataBox = this;
        synchronized (dataBox) {
            MyBox box = this.mGlobalBoxs.get(entityClass);
            if (box == null) {
                box = new MyBox(this.mGlobalBoxStore.boxFor(entityClass));
                this.mGlobalBoxs.put(entityClass, box);
            }
            return box;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MyBox boxForCurUser(Class<? extends BaseDBBean> entityClass) {
        BoxStore curUserBoxStore = this.mCurUserBoxStore;
        if (curUserBoxStore == null) {
            if (RuntimeContext.sIsDebuggable || !this.mInitUserBoxStoreExc) {
                return null;
            }
            HashMap<Class, MyBox> hashMap = this.mCurUserBoxs;
            synchronized (hashMap) {
                MyBox box = this.mCurUserBoxs.get(entityClass);
                if (box == null) {
                    box = new MyBox(null);
                    this.mCurUserBoxs.put(entityClass, box);
                }
                return box;
            }
        }
        HashMap<Class, MyBox> hashMap = this.mCurUserBoxs;
        synchronized (hashMap) {
            MyBox box = this.mCurUserBoxs.get(entityClass);
            if (box == null) {
                box = new MyBox(curUserBoxStore.boxFor(entityClass));
                this.mCurUserBoxs.put(entityClass, box);
            }
            return box;
        }
    }

    @Override
    public void logOut() {
        this.loginOut();
    }

    @Override
    public void loginIn() {
        this.loginInInner();
    }

    public void clearDb() {
        if (!RuntimeContext.sIsDebuggable) {
            return;
        }
        this.clearDbInner(false);
        this.clearDbInner(true);
    }

    public void clearDbInner(boolean global) {
        try {
            if (!global) {
                File oldDir = this.getOldUserDbDir(AccountUtil.getUid());
                YYFileUtils.delete((File)this.getUserDbDir(AccountUtil.getUid()));
                if (oldDir != null) {
                    YYFileUtils.delete((File)oldDir);
                }
            } else {
                File dir = FileStorageUtils.getInstance().getDirAndCreate(true, "db_global");
                YYFileUtils.delete((File)dir);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"Databox", (Throwable)e);
        }
    }
}

