/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.data;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.UserRegionHelper;
import com.yy.appbase.db.StringsConverter;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import io.objectbox.annotation.Convert;
import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.annotation.Index;
import io.objectbox.annotation.Transient;
import io.objectbox.annotation.Uid;
import java.util.List;

@DontProguardClass
@Entity
public class UserInfoBean
extends BaseDBBean {
    @Id
    long id;
    @Index
    long uid;
    long vid;
    String avatar;
    int weight;
    int height;
    String country;
    String province;
    String city;
    long zodiac;
    String birthday;
    String nick;
    int sex;
    String sign;
    @SerializedName(value="sex_mutable")
    @Uid(value=6804841847905180923L)
    int mSexMutable;
    @SerializedName(value="bind_account")
    @Uid(value=9201544132250538523L)
    String mBindAccount;
    @SerializedName(value="account_type")
    @Uid(value=4410057940391255212L)
    String mAccountType;
    int relationship;
    @SerializedName(value="last_login_location")
    @Uid(value=2049688738833970185L)
    String mLastLoginLocation;
    @SerializedName(value="location_tude")
    @Transient
    String mLocationTude;
    @SerializedName(value="location_city")
    @Transient
    String mLocationCity;
    @SerializedName(value="hide_location")
    @Uid(value=4274043665413723650L)
    long mHideLocation;
    @SerializedName(value="hide_recomm")
    @Uid(value=2589793796866282502L)
    long mHideRecomm;
    long hn;
    long firstLoginTime;
    long lastLastLoginTime;
    long vlv;
    long ovid;
    @Convert(converter=StringsConverter.class, dbType=String.class)
    List<String> album;
    String extend;
    String extendMap;
    String hometown;
    String job;
    long ver;
    long atype;
    long om;
    @SerializedName(value="block_time")
    @Transient
    long mBlockTime;
    @Transient
    boolean isLiked;
    @Transient
    boolean hasUpdatedFromServer;
    @Transient
    long lastUpdateTime;
    @SerializedName(value="update_type")
    int mUpdateType;
    @Transient
    int ageLevel;
    String region;
    @SerializedName(value="labels")
    @Transient
    List<Integer> mLabels;
    String label;
    @Transient
    List<String> certifications;
    String certification;
    @Transient
    long shadowUid;
    public static final int FEMALE = 0;
    public static final int MALE = 1;

    public long getBlockTime() {
        return this.mBlockTime;
    }

    public void setBlockTime(long blockTime) {
        this.mBlockTime = blockTime;
    }

    public UserInfoBean() {
    }

    public UserInfoBean(UserInfoBean bean) {
        if (bean != null) {
            this.setSex(bean.getSex());
            this.setNick(bean.getNick());
            this.setSign(bean.getSign());
            this.setBirthday(bean.getBirthday());
            this.setAvatar(bean.getAvatar());
            this.setLiked(bean.isLiked());
            this.setUid(bean.getUid());
            this.setVid(bean.getVid());
            this.setAccountType(bean.getAccountType());
            this.setBindAccount(bean.getBindAccount());
            this.setCity(bean.getCity());
            this.setCountry(bean.getCountry());
            this.setHeight(bean.getHeight());
            this.setProvince(bean.getProvince());
            this.setRelationship(bean.getRelationship());
            this.setSexMutable(bean.getSexMutable());
            this.setWeight(bean.getWeight());
            this.setZodiac(bean.getZodiac());
            this.setLastLoginLocation(bean.getLastLoginLocation());
            this.setLocationTude(bean.getLocationTude());
            this.setLocationCity(bean.getLocationCity());
            this.setExtend(bean.getExtend());
            this.setHideLocation(bean.getHideLocation());
            this.setHideRecomm(bean.getHideRecomm());
            this.setHn(bean.getHn());
            this.setHometown(bean.getHometown());
            this.setJob(bean.getJob());
            this.setOm(bean.getOm());
            this.ver = bean.getUserVer();
            this.setFirstLoginTime(bean.getFirstLoginTime());
            this.setLastLastLoginTime(bean.getLastLastLoginTime());
            this.setVlv(bean.getVlv());
            this.setOvid(bean.getOvid());
            this.setRegion(bean.getRegion());
            this.setLabel(bean.getLabel());
            this.setCertification(this.certification);
            this.shadowUid = bean.shadowUid;
        }
    }

    public UserInfoBean(UserInfoKS bean) {
        if (bean != null) {
            this.setSex(bean.sex);
            this.setNick(bean.nick);
            this.setSign(bean.sign);
            this.setBirthday(bean.birthday);
            this.setAvatar(bean.avatar);
            this.setUid(bean.uid);
            this.setVid(bean.vid);
            this.setLastLoginLocation(bean.lastLoginLocation);
            this.setLocationTude(bean.locationTude);
            this.setHideRecomm(bean.hideRecomm);
            this.setHn(bean.hn);
            this.setHideLocation(bean.hideLocation);
            this.setHometown(bean.hometown);
            this.setJob(bean.job);
            this.setOm(bean.om);
            this.setVlv(bean.getVlv());
            this.setOvid(bean.getOvid());
            this.shadowUid = bean.getShadowUid();
        }
    }

    @Override
    public Object getIndex() {
        return this.uid;
    }

    @Override
    public long getLongIndex() {
        return this.uid;
    }

    @Override
    protected long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id2) {
        this.id = id2;
    }

    public String getBindAccount() {
        return this.mBindAccount;
    }

    public void setBindAccount(String bindAccount) {
        this.mBindAccount = bindAccount;
    }

    public String getAccountType() {
        return this.mAccountType;
    }

    public void setAccountType(String accountType) {
        this.mAccountType = accountType;
    }

    public int getRelationship() {
        return this.relationship;
    }

    public void setRelationship(int relationship) {
        this.relationship = relationship;
    }

    public long getUid() {
        return this.uid;
    }

    public void setUid(long mUid) {
        this.uid = mUid;
    }

    public String getAvatar() {
        return this.avatar == null ? "" : this.avatar;
    }

    public void setAvatar(String mAvatar) {
        this.avatar = mAvatar;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int mWeight) {
        this.weight = mWeight;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int mHeight) {
        this.height = mHeight;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String mCountry) {
        this.country = mCountry;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String mProvince) {
        this.province = mProvince;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String mCity) {
        this.city = mCity;
    }

    public long getZodiac() {
        return this.zodiac;
    }

    public void setZodiac(long zodiac) {
        this.zodiac = zodiac;
    }

    public String getBirthday() {
        return this.birthday == null ? "" : this.birthday;
    }

    public void setBirthday(String mBirthday) {
        this.birthday = mBirthday;
    }

    public String getNick() {
        return this.nick == null ? "" : this.nick;
    }

    public void setNick(String mNick) {
        this.nick = mNick;
    }

    public int getSex() {
        return this.sex;
    }

    public void setSex(int mSex) {
        this.sex = mSex;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public String getHometown() {
        return this.hometown;
    }

    public void setHometown(String hometown) {
        this.hometown = hometown;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String mSign) {
        this.sign = mSign;
    }

    public int getSexMutable() {
        return this.mSexMutable;
    }

    public void setSexMutable(int mSexMutable) {
        this.mSexMutable = mSexMutable;
    }

    public boolean isLiked() {
        return this.isLiked;
    }

    public void setLiked(boolean liked) {
        this.isLiked = liked;
    }

    public String getLastLoginLocation() {
        return this.mLastLoginLocation;
    }

    public void setLastLoginLocation(String lastLoginLocation) {
        this.mLastLoginLocation = lastLoginLocation;
    }

    public long getVid() {
        return this.vid;
    }

    public void setVid(long vid) {
        this.vid = vid;
    }

    @Deprecated
    public String getLocationTude() {
        return this.mLocationTude;
    }

    @Deprecated
    public void setLocationTude(String locationTude) {
        this.mLocationTude = locationTude;
    }

    public String getLocationCity() {
        return this.mLocationCity;
    }

    public void setLocationCity(String locationCity) {
        this.mLocationCity = locationCity;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public boolean hasUpdatedFromServer() {
        return this.hasUpdatedFromServer;
    }

    public void setHasUpdatedFromServer(boolean has) {
        this.hasUpdatedFromServer = has;
    }

    public void setUpdateTimeFromServer(long time) {
        this.lastUpdateTime = time;
    }

    public int getUpdateType() {
        return this.mUpdateType;
    }

    public long getHideLocation() {
        return this.mHideLocation;
    }

    public void setHideLocation(long hideLocation) {
        this.mHideLocation = hideLocation;
    }

    public long getHideRecomm() {
        return this.mHideRecomm;
    }

    public void setHideRecomm(long hideRecomm) {
        this.mHideRecomm = hideRecomm;
    }

    public long getHn() {
        return this.hn;
    }

    public void setHn(long hn) {
        this.hn = hn;
    }

    public long getAtype() {
        return this.atype;
    }

    public void setLocalAvatar(String mAvatar) {
        if (!TextUtils.isEmpty((CharSequence)mAvatar)) {
            this.setAvatar(mAvatar);
        }
    }

    public void setLocalNick(String mNick) {
        if (!TextUtils.isEmpty((CharSequence)mNick)) {
            this.setNick(mNick);
        }
    }

    public void setLocalSex(int gender) {
        if (gender >= 0) {
            this.setSex(gender);
        }
    }

    public List<String> getAlbum() {
        return this.album;
    }

    public void setAlbum(List<String> album) {
        this.album = album;
    }

    public long getUserVer() {
        return this.ver;
    }

    public long getOm() {
        return this.om;
    }

    public void setOm(long om) {
        this.om = om;
    }

    @Override
    public int getMaxStoreNum() {
        return 300;
    }

    public long getFirstLoginTime() {
        return this.firstLoginTime;
    }

    public void setFirstLoginTime(long firstLoginTime) {
        this.firstLoginTime = firstLoginTime;
    }

    public long getLastLastLoginTime() {
        return this.lastLastLoginTime;
    }

    public void setLastLastLoginTime(long lastLastLoginTime) {
        this.lastLastLoginTime = lastLastLoginTime;
    }

    public long getVlv() {
        return this.vlv;
    }

    public void setVlv(long vlv) {
        this.vlv = vlv;
    }

    public long getOvid() {
        return this.ovid;
    }

    public void setOvid(long ovid) {
        this.ovid = ovid;
    }

    public String getRegion() {
        if (!FP.empty((CharSequence)this.region)) {
            return this.region;
        }
        return UserRegionHelper.getRegionByUid(this.uid);
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public boolean canDelete() {
        return this.uid != AccountUtil.getUid();
    }

    public List<Integer> getLabels() {
        return this.mLabels;
    }

    public void setLabels(List<Integer> labels) {
        this.mLabels = labels;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCertification() {
        return this.certification;
    }

    public void setCertification(String certification) {
        this.certification = certification;
    }

    public List<String> getCertifications() {
        return this.certifications;
    }

    public void setCertifications(List<String> certifications) {
        this.certifications = certifications;
    }

    public long getShadowUid() {
        return this.shadowUid;
    }

    public void setShadowUid(long shadowUid) {
        this.shadowUid = shadowUid;
    }

    public long getVer() {
        return this.ver;
    }

    public void setVer(long ver) {
        this.ver = ver;
    }

    public void setAtype(long atype) {
        this.atype = atype;
    }

    public void setUpdateType(int updateType) {
        this.mUpdateType = updateType;
    }

    public static interface Relationship {
        public static final int STRANGER = 0;
        public static final int FRIEND = 1;
        public static final int IN_MY_BLACK_LIST = 2;
    }
}

