/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.data;

import androidx.annotation.NonNull;
import com.yy.appbase.data.BaseDBBean;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import io.objectbox.Box;
import io.objectbox.Property;
import io.objectbox.android.AndroidScheduler;
import io.objectbox.reactive.DataObserver;
import io.objectbox.reactive.DataSubscription;
import io.objectbox.reactive.SubscriptionBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class MyBox<T extends BaseDBBean> {
    private static final String TAG = "MyBox";
    private final ArrayList<T> mItemsDb = new ArrayList();
    private final ArrayList<T> mItemsMem = new ArrayList();
    private final IQueueTaskExecutor mExecutor = YYTaskExecutor.createAQueueExcuter();
    private final ArrayList<Runnable> mToRunAfterLoad = new ArrayList();
    private volatile boolean mLoaded = false;
    private volatile Box<T> mBox;
    private final HashMap<DataObserver<Class<T>>, DataSubscription> mDataSubscriptionList;

    public MyBox(Box<T> box) {
        this.mBox = box;
        this.mDataSubscriptionList = new HashMap();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        this.mExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cloneable cloneable = MyBox.this.mItemsDb;
                synchronized (cloneable) {
                    MyBox.this.mItemsDb.clear();
                }
                cloneable = MyBox.this.mDataSubscriptionList;
                synchronized (cloneable) {
                    for (DataSubscription subscription : MyBox.this.mDataSubscriptionList.values()) {
                        if (subscription == null || subscription.isCanceled()) continue;
                        subscription.cancel();
                    }
                    MyBox.this.mDataSubscriptionList.clear();
                }
                MyBox.this.mBox = null;
            }
        }, 0L);
        ArrayList<T> arrayList = this.mItemsMem;
        synchronized (arrayList) {
            this.mItemsMem.clear();
        }
        this.mLoaded = false;
    }

    public void init() {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MyBox.this.load();
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (SystemUtils.isShowEnvSetting() && this.mBox != null) {
            PerfActionLog.add((String)("DataBox_" + this.mBox + "_load"), (Object[])new Object[0]);
        }
        List arrayList = null;
        if (this.mBox != null) {
            arrayList = this.mBox.getAll();
        }
        this.deleteIfExceed(arrayList);
        ArrayList<T> arrayList2 = this.mItemsMem;
        synchronized (arrayList2) {
            if (arrayList != null && arrayList.size() > 0) {
                this.mItemsDb.addAll(arrayList);
                this.mItemsMem.addAll(arrayList);
            }
            ArrayList<Runnable> arrayList3 = this.mToRunAfterLoad;
            synchronized (arrayList3) {
                if (this.mToRunAfterLoad.size() > 0) {
                    for (Runnable command : this.mToRunAfterLoad) {
                        command.run();
                    }
                    this.mToRunAfterLoad.clear();
                }
                this.mLoaded = true;
            }
        }
    }

    private void deleteIfExceed(List<T> arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            BaseDBBean item = (BaseDBBean)arrayList.get(0);
            if (item == null) {
                return;
            }
            int maxNum = item.getMaxStoreNum();
            if (arrayList.size() <= maxNum) {
                return;
            }
            int deleteNum = arrayList.size() - maxNum;
            ArrayList<BaseDBBean> itemsToDelete = new ArrayList<BaseDBBean>(deleteNum);
            for (BaseDBBean tempItem : arrayList) {
                if (deleteNum <= 0) break;
                if (!tempItem.canDelete()) continue;
                itemsToDelete.add(tempItem);
                --deleteNum;
            }
            if (deleteNum > 0) {
                for (BaseDBBean tempItem : arrayList) {
                    if (deleteNum <= 0) break;
                    if (tempItem.canDelete()) continue;
                    itemsToDelete.add(tempItem);
                    --deleteNum;
                }
            }
            for (BaseDBBean tempItem : itemsToDelete) {
                arrayList.remove(tempItem);
            }
            if (this.mBox != null && itemsToDelete.size() > 0) {
                MLog.info((Object)TAG, (String)"deleteIfExceed itemsToDelete.size()=%d", (Object[])new Object[]{itemsToDelete.size()});
                this.mBox.remove(itemsToDelete);
                if (SystemUtils.isShowEnvSetting() && this.mBox != null) {
                    PerfActionLog.add((String)("DataBox_" + this.mBox + "_remove"), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(Runnable command) {
        if (command == null) {
            return;
        }
        if (this.mLoaded) {
            command.run();
        } else {
            ArrayList<Runnable> arrayList = this.mToRunAfterLoad;
            synchronized (arrayList) {
                if (this.mLoaded) {
                    command.run();
                } else {
                    this.mToRunAfterLoad.add(command);
                }
            }
        }
    }

    public void addItemNoUpdate(final List<T> tasks) {
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    MyBox.this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            Box box = MyBox.this.mBox;
                            if (box != null) {
                                box.put((Collection)tasks);
                            }
                        }
                    }, 0L);
                }
            }
        };
        this.executeCommand(command);
    }

    public void queryItem(final Property<T> property, final Object value, final IGetItemsCallBack<T> callBack) {
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                4 var1_1 = this;
                synchronized (var1_1) {
                    MyBox.this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            Box box = MyBox.this.mBox;
                            if (box != null) {
                                List list = null;
                                if (value instanceof Long) {
                                    list = box.query().equal(property, ((Long)value).longValue()).build().find();
                                } else if (value instanceof String) {
                                    list = box.query().equal(property, (String)value).build().find();
                                } else if (value instanceof Integer) {
                                    list = box.query().equal(property, (long)((Integer)value).intValue()).build().find();
                                }
                                List finalList = list;
                                YYTaskExecutor.postToMainThread(() -> callBack.onLoaded((ArrayList)finalList));
                            }
                        }
                    }, 0L);
                }
            }
        };
        this.executeCommand(command);
    }

    public void subscribe(@NonNull Class<T> task2, boolean callWhenSubscribe, @NonNull DataObserver<Class<T>> boxChangeListener) {
        this.executeCommand(() -> {
            Box<T> box = this.mBox;
            if (box == null) {
                MLog.error((Object)TAG, (String)("request subscribe for " + task2 + ", but box is destroyed!! "), (Object[])new Object[0]);
                if (RuntimeContext.sIsDebuggable) {
                    throw new IllegalStateException("box is destroyed!!");
                }
                return;
            }
            SubscriptionBuilder subscriptionBuilder = box.getStore().subscribe(task2);
            if (!callWhenSubscribe) {
                subscriptionBuilder.onlyChanges();
            }
            DataSubscription subscription = subscriptionBuilder.on(AndroidScheduler.mainThread()).observer(boxChangeListener);
            HashMap<DataObserver<Class<T>>, DataSubscription> hashMap = this.mDataSubscriptionList;
            synchronized (hashMap) {
                DataSubscription preSub = this.mDataSubscriptionList.put(boxChangeListener, subscription);
                if (preSub != null && !subscription.isCanceled()) {
                    preSub.cancel();
                }
            }
        });
    }

    public void unsubscribe(@NonNull Class<T> task2, @NonNull DataObserver<Class<T>> boxChangeListener) {
        this.executeCommand(() -> {
            Box<T> box = this.mBox;
            if (box == null) {
                MLog.warn((Object)TAG, (String)("request unsubscribe for " + task2 + ", but box is destroyed!! "), (Object[])new Object[0]);
                return;
            }
            HashMap<DataObserver<Class<T>>, DataSubscription> hashMap = this.mDataSubscriptionList;
            synchronized (hashMap) {
                DataSubscription subscription = this.mDataSubscriptionList.remove(boxChangeListener);
                if (subscription != null && !subscription.isCanceled()) {
                    subscription.cancel();
                }
            }
        });
    }

    public void addItem(T task2) {
        this.updateItem(task2, true);
    }

    public void addItems(List<T> tasks) {
        this.updateItems(tasks, true);
    }

    public void deleteItem(T task2) {
        if (task2 == null) {
            return;
        }
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(task2);
        this.deleteItems(list);
    }

    public void deleteItems(final List<T> tasks) {
        if (tasks == null || tasks.size() <= 0) {
            return;
        }
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList arrayList = MyBox.this.mItemsMem;
                synchronized (arrayList) {
                    ArrayList arrayListToDelete = MyBox.this.findList(tasks, MyBox.this.mItemsMem, null, null);
                    if (arrayListToDelete != null) {
                        MyBox.this.mItemsMem.removeAll(arrayListToDelete);
                    }
                    MyBox.this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            Box box;
                            ArrayList arrayListToDelete = MyBox.this.findList(tasks, MyBox.this.mItemsDb, null, null);
                            if (arrayListToDelete != null) {
                                MyBox.this.mItemsDb.removeAll(arrayListToDelete);
                            }
                            if ((box = MyBox.this.mBox) != null && arrayListToDelete != null && arrayListToDelete.size() > 0) {
                                box.remove((Collection)arrayListToDelete);
                                if (SystemUtils.isShowEnvSetting() && MyBox.this.mBox != null) {
                                    PerfActionLog.add((String)("DataBox_" + box + "_remove"), (Object[])new Object[0]);
                                }
                            }
                        }
                    }, 0L);
                }
            }
        };
        this.executeCommand(command);
    }

    private ArrayList<T> findList(List<T> itemsToFind, List<T> items, List<T> itemsFinded, List<T> itemsUnfinded) {
        if (itemsToFind == null || itemsToFind.size() <= 0) {
            return new ArrayList(0);
        }
        if (items == null || items.size() <= 0) {
            if (itemsUnfinded != null) {
                itemsUnfinded.addAll(itemsToFind);
            }
            return new ArrayList(0);
        }
        ArrayList<BaseDBBean> resultList = new ArrayList<BaseDBBean>();
        BaseDBBean itemResult = null;
        Object findIndex = null;
        int isLongTypeIndex = -1;
        for (BaseDBBean itemToFind : itemsToFind) {
            if (itemToFind == null) continue;
            itemResult = null;
            findIndex = itemToFind.getIndex();
            long findIndexLong = Long.MIN_VALUE;
            if (isLongTypeIndex == -1) {
                if (findIndex instanceof Long) {
                    isLongTypeIndex = 1;
                    findIndexLong = (Long)findIndex;
                } else {
                    isLongTypeIndex = 0;
                }
            } else if (isLongTypeIndex == 1 && findIndex instanceof Long) {
                findIndexLong = (Long)findIndex;
            }
            for (BaseDBBean item : items) {
                if (item == null) continue;
                if (itemToFind == item) {
                    itemResult = item;
                    break;
                }
                if (findIndexLong != Long.MIN_VALUE && item.getLongIndex() != Long.MIN_VALUE) {
                    if (item.getLongIndex() != findIndexLong) continue;
                    itemResult = item;
                    break;
                }
                if ((findIndex == null || !findIndex.equals(item.getIndex())) && (findIndex != null || item.getIndex() != null)) continue;
                itemResult = item;
                break;
            }
            if (itemResult != null) {
                resultList.add(itemResult);
                if (itemsFinded == null) continue;
                itemsFinded.add(itemToFind);
                continue;
            }
            if (itemsUnfinded == null) continue;
            itemsUnfinded.add(itemToFind);
        }
        return resultList;
    }

    private ArrayList<T> findListByIndexs(List<? extends Object> indexs, List<T> items) {
        if (indexs == null || indexs.size() <= 0 || items == null || items.size() <= 0) {
            return new ArrayList(0);
        }
        ArrayList<BaseDBBean> resultList = new ArrayList<BaseDBBean>();
        int isLongTypeIndex = -1;
        block0: for (Object object : indexs) {
            if (object == null) continue;
            long findIndexLong = Long.MIN_VALUE;
            if (isLongTypeIndex == -1) {
                if (object instanceof Long) {
                    isLongTypeIndex = 1;
                    findIndexLong = (Long)object;
                } else {
                    isLongTypeIndex = 0;
                }
            } else if (isLongTypeIndex == 1 && object instanceof Long) {
                findIndexLong = (Long)object;
            }
            for (BaseDBBean item : items) {
                if (item == null) continue;
                if (findIndexLong != Long.MIN_VALUE && item.getLongIndex() != Long.MIN_VALUE) {
                    if (item.getLongIndex() != findIndexLong) continue;
                    resultList.add(item);
                    continue block0;
                }
                if (object == item.getIndex()) {
                    resultList.add(item);
                    continue block0;
                }
                if (object == null || !object.equals(item.getIndex())) continue;
                resultList.add(item);
                continue block0;
            }
        }
        return resultList;
    }

    public void deleteByIndexs(List<? extends Object> indexs) {
        if (indexs == null || indexs.size() <= 0) {
            return;
        }
        this.getItemsByIndexs(indexs, new IGetItemsCallBack(){

            public void onLoaded(ArrayList datas) {
                if (datas != null && datas.size() > 0) {
                    MyBox.this.deleteItems(datas);
                }
            }
        });
    }

    public void deleteAll() {
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList arrayList = MyBox.this.mItemsMem;
                synchronized (arrayList) {
                    MyBox.this.mItemsMem.clear();
                    MyBox.this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MyBox.this.mItemsDb.clear();
                            Box box = MyBox.this.mBox;
                            if (box != null) {
                                box.removeAll();
                            }
                        }
                    }, 0L);
                }
            }
        };
        this.executeCommand(command);
    }

    public void updateItem(T task2, boolean addIfNoExist) {
        if (task2 == null) {
            return;
        }
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(task2);
        this.updateItems(list, addIfNoExist);
    }

    private void updateItemsInList(ArrayList<T> arrayList, ArrayList<T> newItems, ArrayList<T> oldItemsInList) {
        ArrayList<T> arrayListFinded = newItems;
        ArrayList<T> arrayListFindFromItemsMem = oldItemsInList;
        if (arrayListFinded != null && arrayListFinded.size() > 0) {
            BaseDBBean item = null;
            BaseDBBean itemToUpdate = null;
            int index = -1;
            for (int i = 0; i < arrayListFinded.size(); ++i) {
                item = (BaseDBBean)arrayListFinded.get(i);
                if (item == (itemToUpdate = (BaseDBBean)arrayListFindFromItemsMem.get(i)) || (index = arrayList.indexOf(itemToUpdate)) < 0) continue;
                item.setId(itemToUpdate.getId());
                arrayList.remove(itemToUpdate);
                arrayList.add(index, item);
            }
        }
    }

    public void updateItems(List<T> tasks, final boolean addIfNoExist) {
        if (tasks == null || tasks.size() == 0) {
            return;
        }
        final ArrayList<T> items = new ArrayList<T>(tasks);
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object oldUser = null;
                ArrayList arrayList = MyBox.this.mItemsMem;
                synchronized (arrayList) {
                    ArrayList arrayListFinded = new ArrayList(items.size() > 12 ? 12 : items.size());
                    ArrayList arrayListToAdd = new ArrayList(items.size() > 12 ? 12 : items.size());
                    ArrayList arrayListFindFromItemsMem = MyBox.this.findList(items, MyBox.this.mItemsMem, arrayListFinded, arrayListToAdd);
                    MyBox.this.updateItemsInList(MyBox.this.mItemsMem, arrayListFinded, arrayListFindFromItemsMem);
                    if (arrayListToAdd.size() > 0 && addIfNoExist) {
                        MyBox.this.mItemsMem.addAll(arrayListToAdd);
                    }
                    MyBox.this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            Box box;
                            ArrayList arrayListFinded = new ArrayList(items.size() > 12 ? 12 : items.size());
                            ArrayList arrayListToAdd = new ArrayList(items.size() > 12 ? 12 : items.size());
                            ArrayList arrayListFindFromItemsMem = MyBox.this.findList(items, MyBox.this.mItemsDb, arrayListFinded, arrayListToAdd);
                            if (arrayListToAdd.size() > 0 && addIfNoExist) {
                                MyBox.this.mItemsDb.addAll(arrayListToAdd);
                            }
                            MyBox.this.updateItemsInList(MyBox.this.mItemsDb, arrayListFinded, arrayListFindFromItemsMem);
                            if (arrayListToAdd.size() > 0 && addIfNoExist) {
                                for (BaseDBBean task2 : arrayListToAdd) {
                                    if (task2 == null) continue;
                                    task2.setId(0L);
                                }
                            }
                            if ((box = MyBox.this.mBox) != null) {
                                if (addIfNoExist) {
                                    ArrayList itemsToPut = new ArrayList(arrayListFinded.size() + arrayListToAdd.size());
                                    itemsToPut.addAll(arrayListFinded);
                                    itemsToPut.addAll(arrayListToAdd);
                                    box.put(itemsToPut);
                                } else {
                                    box.put(arrayListFinded);
                                }
                                if (SystemUtils.isShowEnvSetting() && MyBox.this.mBox != null) {
                                    PerfActionLog.add((String)("DataBox_" + box + "_update"), (Object[])new Object[0]);
                                }
                            }
                        }
                    }, 0L);
                }
            }
        };
        this.executeCommand(command);
    }

    public ArrayList<T> getItemsFromMem(List<? extends Object> indexs) {
        if (indexs == null || indexs.size() <= 0) {
            return null;
        }
        return this.getTheItems(indexs, null);
    }

    public List<T> getAllFromMem() {
        return new ArrayList<T>(this.mItemsMem);
    }

    public void getAll(final IGetItemsCallBack<T> callBack) {
        boolean loaded = this.mLoaded;
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ArrayList result = new ArrayList();
                ArrayList arrayList = MyBox.this.mItemsMem;
                synchronized (arrayList) {
                    result.addAll(MyBox.this.mItemsMem);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onLoaded(result);
                        }
                    }
                });
            }
        };
        this.executeCommand(command);
    }

    public void getRecent(final IGetItemsCallBack callBack, final int size) {
        boolean loaded = this.mLoaded;
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ArrayList result = new ArrayList();
                ArrayList arrayList = MyBox.this.mItemsMem;
                synchronized (arrayList) {
                    if (MyBox.this.mItemsMem.size() > size) {
                        int index;
                        for (int i = index = MyBox.this.mItemsMem.size() - size; i < MyBox.this.mItemsMem.size(); ++i) {
                            result.add(MyBox.this.mItemsMem.get(i));
                        }
                    } else {
                        result.addAll(MyBox.this.mItemsMem);
                    }
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onLoaded(result);
                        }
                    }
                });
            }
        };
        this.executeCommand(command);
    }

    public void getItemByIndex(Object index, IGetItemsCallBack callBack) {
        if (index == null) {
            return;
        }
        ArrayList<Object> uidsList = new ArrayList<Object>(1);
        uidsList.add(index);
        this.getItemsByIndexs(uidsList, callBack);
    }

    public void getItemsByIndexs(Object[] indexs, IGetItemsCallBack callBack) {
        if (indexs == null || indexs.length <= 0) {
            return;
        }
        ArrayList<Object> uidsList = new ArrayList<Object>(indexs.length);
        for (Object uid : indexs) {
            uidsList.add(uid);
        }
        this.getItemsByIndexs(uidsList, callBack);
    }

    public void getItemsByIndexs(List<? extends Object> indexs, IGetItemsCallBack callBack) {
        if (indexs == null || indexs.size() == 0) {
            return;
        }
        this.getTheItems(indexs, callBack);
    }

    private ArrayList<T> getTheItems(List<? extends Object> uidsList, final IGetItemsCallBack callBack) {
        if (uidsList == null || uidsList.size() == 0) {
            return null;
        }
        final ArrayList<? extends Object> uids = new ArrayList<Object>(uidsList);
        final ArrayList result = new ArrayList(uids.size() > 12 ? 12 : uids.size());
        Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object item = null;
                ArrayList arrayList = MyBox.this.mItemsMem;
                synchronized (arrayList) {
                    ArrayList find = MyBox.this.findListByIndexs(uids, MyBox.this.mItemsMem);
                    if (find != null) {
                        result.addAll(find);
                    }
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onLoaded(result);
                        }
                    }
                });
            }
        };
        this.executeCommand(command);
        return result;
    }

    public static interface IGetItemsCallBack<T> {
        public void onLoaded(ArrayList<T> var1);
    }
}

