/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.data;

import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.IBbsNoticeListItem;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import io.objectbox.annotation.Entity;
import io.objectbox.annotation.Id;
import io.objectbox.annotation.Index;
import io.objectbox.annotation.Transient;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import net.ihago.bbs.srv.entity.PostSecType;
import net.ihago.bbs.srv.entity.SourceType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
public class BbsNoticeDBBean
extends BaseDBBean
implements IBbsNoticeListItem {
    @Id
    public long id;
    String ppostId;
    @Index
    String postId;
    int postType;
    int pposttype;
    int type;
    long uid;
    int sex;
    String nick;
    String avatar;
    int age;
    String city;
    String content;
    int atType;
    long ts;
    int ptype;
    String pcontent;
    String pextend;
    boolean isReaded;
    String info;
    int jumpType;
    int ppostsource;
    String channelid;
    String channelname;
    int channelop;
    int pushSource;
    String reserveStr;
    int reserveInt;
    long reserveLong;
    @Transient
    ArrayList<Long> likeUserUidList;
    @Transient
    ArrayList<Long> mentionedUidList;
    @Transient
    ArrayList<String> mentionedNickList;
    @Transient
    ArrayList<Integer> mentionedIndexList;
    String likeUserUidStr;
    int typeId;
    String jumpUrl;
    String title;
    String url;
    String inviteAvatar;
    String inviteFriendData;
    int showLines = 3;
    public static final int BBS_NOTICE_JUMP_POST_DETAIL = 0;
    public static final int BBS_NOTICE_JUMP_PUBLISH_POST = 1;
    public static final int BBS_NOTICE_JUMP_URI = 2;
    public static final int BBS_NOTICE_LIKE = 0;
    public static final int BBS_NOTICE_COMMENT = 1;
    public static final int BBS_NOTICE_REPLY = 2;
    public static final int BBS_INVITE_FRIEND = 10;
    public static final int BBS_NOTICE_FOLLOW = 1000;
    long currentMills = System.currentTimeMillis();

    public ArrayList<Long> getLikeUserUidList() {
        return this.likeUserUidList;
    }

    public void setLikeUserUidList(ArrayList<Long> likeUserUidList) {
        this.likeUserUidList = likeUserUidList;
    }

    public String getLikeUserUidStr() {
        return this.likeUserUidStr;
    }

    public void setLikeUserUidStr(String likeUserUidStr) {
        this.likeUserUidStr = likeUserUidStr;
    }

    public ArrayList<Long> getMentionedUidList() {
        return this.mentionedUidList;
    }

    public void setMentionedUidList(ArrayList<Long> mentionedUidList) {
        this.mentionedUidList = mentionedUidList;
    }

    public ArrayList<String> getMentionedNickList() {
        return this.mentionedNickList;
    }

    public void setMentionedNickList(ArrayList<String> mentionedNickList) {
        this.mentionedNickList = mentionedNickList;
    }

    public ArrayList<Integer> getMentionedIndexList() {
        return this.mentionedIndexList;
    }

    public void setMentionedIndexList(ArrayList<Integer> mentionedIndexList) {
        this.mentionedIndexList = mentionedIndexList;
    }

    @Override
    public long getTime() {
        return this.ts;
    }

    public static BbsNoticeDBBean fromJson(String jsonContent) {
        if (StringUtils.isEmpty((String)jsonContent)) {
            return null;
        }
        BbsNoticeDBBean bbsNoticeDBBean = new BbsNoticeDBBean();
        try {
            JSONObject postObject = JsonParser.obtainJSONObject((String)jsonContent);
            bbsNoticeDBBean.ppostId = postObject.optString("ppostid", "");
            bbsNoticeDBBean.postId = postObject.optString("postid", "");
            bbsNoticeDBBean.postType = postObject.optInt("posttype");
            bbsNoticeDBBean.pposttype = postObject.optInt("pposttype");
            bbsNoticeDBBean.type = postObject.optInt("type");
            bbsNoticeDBBean.uid = postObject.optLong("uid");
            bbsNoticeDBBean.sex = postObject.optInt("sex");
            bbsNoticeDBBean.content = postObject.optString("content", "");
            bbsNoticeDBBean.atType = postObject.optInt("at_type", 0);
            bbsNoticeDBBean.nick = postObject.optString("nick", "");
            bbsNoticeDBBean.avatar = postObject.optString("avatar", "");
            bbsNoticeDBBean.ts = postObject.optLong("ts");
            bbsNoticeDBBean.ptype = postObject.optInt("ptype");
            bbsNoticeDBBean.pcontent = postObject.optString("pcontent", "");
            bbsNoticeDBBean.pextend = postObject.optString("pextend", "");
            bbsNoticeDBBean.isReaded = false;
            bbsNoticeDBBean.jumpType = 0;
            bbsNoticeDBBean.info = postObject.optString("info", "");
            bbsNoticeDBBean.uid = postObject.optLong("uid");
            bbsNoticeDBBean.ppostsource = postObject.optInt("ppostsource");
            bbsNoticeDBBean.channelid = postObject.optString("channelid");
            bbsNoticeDBBean.channelname = postObject.optString("channelname");
            bbsNoticeDBBean.channelop = postObject.optInt("channelop");
            bbsNoticeDBBean.jumpUrl = postObject.optString("jump_url");
            JSONArray userArray = postObject.optJSONArray("users");
            bbsNoticeDBBean.age = DateUtils.getAge((String)postObject.optString("birthday"));
            if (userArray != null) {
                StringBuilder likeUserUidStr = new StringBuilder();
                ArrayList<Long> userUidList = new ArrayList<Long>();
                int length = userArray.length();
                for (int i = 0; i < length; ++i) {
                    JSONObject userJson = userArray.optJSONObject(i);
                    if (userJson == null || !userJson.has("uid")) continue;
                    userUidList.add(userJson.optLong("uid"));
                    likeUserUidStr.append(userJson.optLong("uid")).append(",");
                }
                bbsNoticeDBBean.setLikeUserUidStr(likeUserUidStr.toString());
                bbsNoticeDBBean.setLikeUserUidList(userUidList);
            }
            bbsNoticeDBBean.typeId = postObject.optInt("id", 0);
            bbsNoticeDBBean.showLines = postObject.optInt("show_lines", 3);
        }
        catch (JSONException e) {
            MLog.info((Object)"BbsNoticeDBBean", (String)"from %s", (Object[])new Object[]{e.toString()});
        }
        return bbsNoticeDBBean;
    }

    public static BbsNoticeDBBean copy(BbsNoticeDBBean bean) {
        BbsNoticeDBBean newBean = new BbsNoticeDBBean();
        newBean.setPpostId(bean.ppostId);
        newBean.setPostId(bean.postId);
        newBean.setPostType(bean.postType);
        newBean.setPposttype(bean.pposttype);
        newBean.setType(bean.type);
        newBean.setUid(bean.uid);
        newBean.setSex(bean.sex);
        newBean.setNick(bean.nick);
        newBean.setAvatar(bean.avatar);
        newBean.setContent(bean.content);
        newBean.setTs(bean.ts);
        newBean.setPtype(bean.ptype);
        newBean.setPcontent(bean.pcontent);
        newBean.setPextend(bean.pextend);
        newBean.setReaded(bean.isReaded);
        newBean.setInfo(bean.info);
        newBean.setJumpType(bean.jumpType);
        newBean.setReserveStr(bean.reserveStr);
        newBean.setReserveInt(bean.reserveInt);
        newBean.setReserveLong(bean.reserveLong);
        newBean.setPpostsource(bean.ppostsource);
        newBean.setChannelid(bean.channelid);
        newBean.setChannelname(bean.channelname);
        newBean.setChannelop(bean.channelop);
        newBean.setJumpUrl(bean.jumpUrl);
        newBean.setShowLines(bean.showLines);
        return newBean;
    }

    public boolean isTextType() {
        return this.ptype == PostSecType.POST_SEC_TYPE_TEXT.getValue();
    }

    public boolean isImageType() {
        return this.ptype == PostSecType.POST_SEC_TYPE_IMAGES.getValue();
    }

    public boolean isVideoType() {
        return this.ptype == PostSecType.POST_SEC_TYPE_VEDIO.getValue();
    }

    public boolean isVoiceType() {
        return this.ptype == PostSecType.POST_SEC_TYPE_VOICE.getValue();
    }

    public boolean isNoticeLike() {
        return this.type == 0;
    }

    public boolean isShowAtInfo() {
        return this.type == 1 || this.type == 2;
    }

    public boolean isNoticeComment() {
        return this.type == 1;
    }

    public boolean isNoticeReply() {
        return this.type == 2;
    }

    public boolean isInviteFriendType() {
        return this.type == 10;
    }

    public boolean isNoticeFollow() {
        return this.type == 1000;
    }

    public String getPpostId() {
        return this.ppostId;
    }

    public String getPostId() {
        return this.postId;
    }

    public int getType() {
        return this.type;
    }

    public long getUid() {
        return this.uid;
    }

    public int getSex() {
        return this.sex;
    }

    public int getAge() {
        return this.age;
    }

    public String getNick() {
        return this.nick;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getContent() {
        return this.content;
    }

    public long getTs() {
        return this.ts;
    }

    public int getPtype() {
        return this.ptype;
    }

    public String getPcontent() {
        return this.pcontent;
    }

    public String getPextend() {
        return this.pextend;
    }

    public boolean isReaded() {
        return this.isReaded;
    }

    public void setReaded(boolean readed) {
        this.isReaded = readed;
    }

    public String getInfo() {
        return this.info;
    }

    public String getReserveStr() {
        return this.reserveStr;
    }

    public int getReserveInt() {
        return this.reserveInt;
    }

    public long getReserveLong() {
        return this.reserveLong;
    }

    public void setPpostId(String ppostId) {
        this.ppostId = ppostId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public void setType(int type2) {
        this.type = type2;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCity() {
        return this.city;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setTs(long ts) {
        this.ts = ts;
    }

    public void setPtype(int ptype) {
        this.ptype = ptype;
    }

    public void setPcontent(String pcontent) {
        this.pcontent = pcontent;
    }

    public void setPextend(String pextend) {
        this.pextend = pextend;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setReserveStr(String reserveStr) {
        this.reserveStr = reserveStr;
    }

    public void setReserveInt(int reserveInt) {
        this.reserveInt = reserveInt;
    }

    public void setReserveLong(long reserveLong) {
        this.reserveLong = reserveLong;
    }

    public int getPostType() {
        return this.postType;
    }

    public void setPostType(int postType) {
        this.postType = postType;
    }

    public int getPposttype() {
        return this.pposttype;
    }

    public void setPposttype(int pposttype) {
        this.pposttype = pposttype;
    }

    public int getJumpType() {
        return this.jumpType;
    }

    public void setJumpType(int jumpType) {
        this.jumpType = jumpType;
    }

    public int getPpostsource() {
        return this.ppostsource;
    }

    public void setPpostsource(int ppostsource) {
        this.ppostsource = ppostsource;
    }

    public String getChannelname() {
        return this.channelname;
    }

    public void setChannelname(String channelname) {
        this.channelname = channelname;
    }

    public String getChannelid() {
        return this.channelid;
    }

    public void setChannelid(String channelid) {
        this.channelid = channelid;
    }

    public int getChannelop() {
        return this.channelop;
    }

    public void setChannelop(int channelop) {
        this.channelop = channelop;
    }

    public String getJumpUrl() {
        return this.jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getCurrentMills() {
        return this.currentMills;
    }

    @Override
    public Object getIndex() {
        if (this.isNoticeLike() || this.ppostsource == SourceType.GroupSpace.getValue()) {
            return this.postId + this.ts;
        }
        if (StringUtils.isNotEmpty((String)this.postId)) {
            return this.postId;
        }
        return this.ts;
    }

    @Override
    protected long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id2) {
        this.id = id2;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public String getInviteAvatar() {
        return this.inviteAvatar;
    }

    public void setInviteAvatar(String inviteAvatar) {
        this.inviteAvatar = inviteAvatar;
    }

    public String getInviteFriendData() {
        return this.inviteFriendData;
    }

    public void setInviteFriendData(String inviteFriendData) {
        this.inviteFriendData = inviteFriendData;
    }

    public void setShowLines(int lines) {
        this.showLines = lines;
    }

    public int getShowLines() {
        return this.showLines;
    }

    public int getAtType() {
        return this.atType;
    }

    public void setAtType(int atType) {
        this.atType = atType;
    }

    public int getPushSource() {
        return this.pushSource;
    }

    public void setPushSource(int pushSource) {
        this.pushSource = pushSource;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BbsNoticeType {
    }
}

