/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.constant;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.guid.GuidFactory;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class CommonPerfUtils {
    private static final int MAX_ERROR_INFO = 300;

    public static void statThirdpartyLoginStartEvent(int type2, boolean isUdbLogin) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("ifield", type2);
        statContent.put("ifieldtwo", 1);
        if (isUdbLogin) {
            statContent.put("perftype", "uloginrequest");
        } else {
            statContent.put("perftype", "loginrequest");
        }
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public static void statLoginEvent(int type2, boolean success, int retryTimes, String errorInfo, int useTime, String successUrl, String errorCode) {
        if (errorCode == null) {
            errorCode = "";
        }
        try {
            if (type2 == 1 || !success && StringUtils.isNotEmpty((String)errorInfo) && NetworkUtils.isNetworkStrictlyAvailable((Context)RuntimeContext.sApplicationContext)) {
                if (StringUtils.isNotEmpty((String)errorInfo) && errorInfo.length() > 300) {
                    errorInfo = errorInfo.substring(0, 300);
                }
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", type2);
                statContent.put("ifieldtwo", success ? 1 : 0);
                statContent.put("ifieldthree", retryTimes);
                statContent.put("ifieldfour", NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext));
                statContent.put("ifieldfive", useTime);
                statContent.put("sfield", GuidFactory.getInstance().getGuid());
                statContent.put("sfieldtwo", errorInfo);
                statContent.put("sfieldthree", successUrl);
                statContent.put("perftype", "loginrequest");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
            if (type2 == 3 || type2 == 1) {
                HiidoStatis.reportAppMonitorReturnCodeNow((String)(type2 == 3 ? "hylogin/refreshtoken" : "hylogin/request"), (long)useTime, (String)(success ? "0" : errorCode));
            }
        }
        catch (Exception e) {
            MLog.error((Object)"LoginRequestStatHelper", (Throwable)e);
        }
    }

    public static void statUdbLoginEvent(int type2, boolean success, String errorInfo, int useTime, String errorCode) {
        if (errorCode == null) {
            errorCode = "";
        }
        try {
            if (type2 == 1 || !success && StringUtils.isNotEmpty((String)errorInfo) && NetworkUtils.isNetworkStrictlyAvailable((Context)RuntimeContext.sApplicationContext)) {
                if (StringUtils.isNotEmpty((String)errorInfo) && errorInfo.length() > 300) {
                    errorInfo = errorInfo.substring(0, 300);
                }
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", type2);
                statContent.put("ifieldtwo", success ? 1 : 0);
                statContent.put("ifieldfour", NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext));
                statContent.put("ifieldfive", useTime);
                statContent.put("sfield", GuidFactory.getInstance().getGuid());
                statContent.put("sfieldtwo", errorInfo);
                statContent.put("perftype", "uloginrequest");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
            if (type2 == 3 || type2 == 1) {
                HiidoStatis.reportAppMonitorReturnCodeNow((String)(type2 == 3 ? "hyulogin/refreshtoken" : "hyulogin/request"), (long)useTime, (String)(success ? "0" : errorCode));
            }
        }
        catch (Exception e) {
            MLog.error((Object)"LoginRequestStatHelper", (Throwable)e);
        }
    }

    public static void statCrashProtect(Throwable e, final String eString) {
        if (e == null) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                String errorInofo = eString;
                if (errorInofo != null && errorInofo.length() > 200) {
                    errorInofo = errorInofo.substring(0, 199);
                }
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", 1);
                statContent.put("sfield", errorInofo);
                statContent.put("sfieldtwo", String.valueOf(AccountUtil.getUid()));
                statContent.put("perftype", "crashprotect");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        };
        YYTaskExecutor.execute((Runnable)command, (long)1000L);
    }

    public static int getErrorCodeByExc(Exception e) {
        return NetworkUtils.getErrorCodeByExc((Throwable)e);
    }

    public static class RequestTypeDef {
        public static final int LOGIN_WITH_THIRDPARTY = 1;
        public static final int LOGIN_WITH_GUEST = 2;
        public static final int REFRESH_TOKEN = 3;
        public static final int LOGIN_WITH_VERIFICATION_CODE = 4;
        public static final int LOGIN_WITH_THIRDPARTY_START = 10;
    }
}

