/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.common.helper;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.logger.MLog;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J(\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0004J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/yy/appbase/common/helper/RecyclerViewScrollRecorder;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "()V", "curRecyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "itemVisibleChangeListener", "Lcom/yy/appbase/common/helper/RecyclerViewScrollRecorder$OnItemVisibleChangeListener;", "lastEnd", "", "lastStart", "preloadListener", "Lcom/yy/appbase/common/helper/RecyclerViewScrollRecorder$OnPreloadListener;", "clear", "", "dealItemVisible", "firstVisible", "lastVisible", "dealPreload", "layoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "dy", "visibleItemCount", "init", "recyclerView", "onScrolled", "dx", "setItemVisibleChangeListener", "listener", "setPreloadListener", "Companion", "OnItemVisibleChangeListener", "OnPreloadListener", "appbase_release"})
public final class RecyclerViewScrollRecorder
extends RecyclerView.OnScrollListener {
    private RecyclerView curRecyclerView;
    private int lastStart = -1;
    private int lastEnd = -1;
    private OnItemVisibleChangeListener itemVisibleChangeListener;
    private OnPreloadListener preloadListener;
    @NotNull
    public static final String TAG = "RecyclerViewScrollRecorder";
    public static final Companion Companion = new Companion(null);

    public final void init(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        RecyclerView recyclerView2 = this.curRecyclerView = recyclerView;
        if (recyclerView2 == null) {
            Intrinsics.throwNpe();
        }
        recyclerView2.addOnScrollListener((RecyclerView.OnScrollListener)this);
    }

    public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
        LinearLayoutManager layoutManager;
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        super.onScrolled(recyclerView, dx, dy);
        RecyclerView.LayoutManager layoutManager2 = recyclerView.getLayoutManager();
        if (!(layoutManager2 instanceof LinearLayoutManager)) {
            layoutManager2 = null;
        }
        if ((layoutManager = (LinearLayoutManager)layoutManager2) != null) {
            int firstVisible = layoutManager.findFirstVisibleItemPosition();
            int lastVisible = layoutManager.findLastVisibleItemPosition();
            int visibleItemCount = lastVisible - firstVisible + 1;
            if (lastVisible == 0) {
                visibleItemCount = 0;
            }
            if (visibleItemCount != 0) {
                this.dealItemVisible(firstVisible, lastVisible);
            }
            this.dealPreload(layoutManager, dy, lastVisible, visibleItemCount);
        }
    }

    private final void dealItemVisible(int firstVisible, int lastVisible) {
        if (this.itemVisibleChangeListener == null) {
            return;
        }
        int visibleItemCount = lastVisible - firstVisible;
        if (visibleItemCount > 0) {
            if (this.lastStart == -1) {
                this.lastStart = firstVisible;
                this.lastEnd = lastVisible;
            } else {
                int i;
                int n;
                if (firstVisible != this.lastStart) {
                    if (firstVisible > this.lastStart) {
                        int n2 = this.lastStart;
                        n = firstVisible;
                        while (n2 < n) {
                            OnItemVisibleChangeListener onItemVisibleChangeListener = this.itemVisibleChangeListener;
                            if (onItemVisibleChangeListener != null) {
                                onItemVisibleChangeListener.onScrollToInvisible(i);
                            }
                            ++i;
                        }
                    } else {
                        n = this.lastStart;
                        for (i = firstVisible; i < n; ++i) {
                            OnItemVisibleChangeListener onItemVisibleChangeListener = this.itemVisibleChangeListener;
                            if (onItemVisibleChangeListener == null) continue;
                            onItemVisibleChangeListener.onScrollToVisible(i);
                        }
                    }
                    this.lastStart = firstVisible;
                }
                if (lastVisible != this.lastEnd) {
                    if (lastVisible > this.lastEnd) {
                        n = lastVisible;
                        for (i = this.lastEnd; i < n; ++i) {
                            OnItemVisibleChangeListener onItemVisibleChangeListener = this.itemVisibleChangeListener;
                            if (onItemVisibleChangeListener == null) continue;
                            onItemVisibleChangeListener.onScrollToVisible(i + 1);
                        }
                    } else {
                        n = this.lastEnd;
                        for (i = lastVisible; i < n; ++i) {
                            OnItemVisibleChangeListener onItemVisibleChangeListener = this.itemVisibleChangeListener;
                            if (onItemVisibleChangeListener == null) continue;
                            onItemVisibleChangeListener.onScrollToInvisible(i + 1);
                        }
                    }
                    this.lastEnd = lastVisible;
                }
            }
        }
    }

    private final void dealPreload(LinearLayoutManager layoutManager, int dy, int lastVisible, int visibleItemCount) {
        block1: {
            int itemCount;
            int hasMoreCount;
            if (dy <= 0 || (hasMoreCount = (itemCount = layoutManager.getItemCount()) - lastVisible - 1) > visibleItemCount / 2) break block1;
            MLog.debug((Object)TAG, (String)("hasMoreCount = " + hasMoreCount + ", visibleItemCount = " + visibleItemCount), (Object[])new Object[0]);
            MLog.debug((Object)TAG, (String)"trigger loadMore", (Object[])new Object[0]);
            OnPreloadListener onPreloadListener = this.preloadListener;
            if (onPreloadListener != null) {
                onPreloadListener.onPreloadNextPage();
            }
        }
    }

    public final void setItemVisibleChangeListener(@Nullable OnItemVisibleChangeListener listener2) {
        this.itemVisibleChangeListener = listener2;
    }

    public final void setPreloadListener(@NotNull OnPreloadListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.preloadListener = listener2;
    }

    public final void clear() {
        RecyclerView recyclerView = this.curRecyclerView;
        if (recyclerView != null) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
        }
        this.curRecyclerView = null;
        this.itemVisibleChangeListener = null;
        this.preloadListener = null;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/yy/appbase/common/helper/RecyclerViewScrollRecorder$OnItemVisibleChangeListener;", "", "onScrollToInvisible", "", "position", "", "onScrollToVisible", "appbase_release"})
    public static interface OnItemVisibleChangeListener {
        public void onScrollToVisible(int var1);

        public void onScrollToInvisible(int var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/yy/appbase/common/helper/RecyclerViewScrollRecorder$OnPreloadListener;", "", "onPreloadNextPage", "", "appbase_release"})
    public static interface OnPreloadListener {
        public void onPreloadNextPage();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/appbase/common/helper/RecyclerViewScrollRecorder$Companion;", "", "()V", "TAG", "", "appbase_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

