/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.badger.impl;

import android.annotation.TargetApi;
import android.content.AsyncQueryHandler;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import com.yy.appbase.badger.Badger;
import com.yy.appbase.badger.BroadcastHelper;
import com.yy.appbase.badger.ShortcutBadgeException;
import java.util.Arrays;
import java.util.List;

public class AsusHomeBadger
implements Badger {
    private static final String INTENT_ACTION = "android.intent.action.BADGE_COUNT_UPDATE";
    private static final String INTENT_EXTRA_BADGE_COUNT = "badge_count";
    private static final String INTENT_EXTRA_PACKAGENAME = "badge_count_package_name";
    private static final String INTENT_EXTRA_ACTIVITY_NAME = "badge_count_class_name";
    private static final String PROVIDER_CONTENT_URI = "content://com.android.badge/";
    private static final String PROVIDER_COLUMNS_BADGE_COUNT = "badge_count";
    private static final String PROVIDER_COLUMNS_PACKAGE_NAME = "package_name";
    private static final String PROVIDER_COLUMNS_ACTIVITY_NAME = "activity_name";
    private static final String ASUS_LAUNCHER_PROVIDER_NAME = "com.android.badge";
    private final Uri mUri = Uri.parse((String)"content://com.android.badge/");
    private AsyncQueryHandler mQueryHandler;
    private static final String SONY_INTENT_ACTION = "com.sonyericsson.home.action.UPDATE_BADGE";
    private static final String SONY_INTENT_EXTRA_PACKAGE_NAME = "com.sonyericsson.home.intent.extra.badge.PACKAGE_NAME";
    private static final String SONY_INTENT_EXTRA_ACTIVITY_NAME = "com.sonyericsson.home.intent.extra.badge.ACTIVITY_NAME";
    private static final String SONY_INTENT_EXTRA_MESSAGE = "com.sonyericsson.home.intent.extra.badge.MESSAGE";
    private static final String SONY_INTENT_EXTRA_SHOW_MESSAGE = "com.sonyericsson.home.intent.extra.badge.SHOW_MESSAGE";

    @Override
    public void executeBadge(Context context, ComponentName componentName, int badgeCount) throws ShortcutBadgeException {
        if (Build.VERSION.SDK_INT >= 11) {
            this.executeBadgeByBroadcast(context, componentName, badgeCount);
        } else {
            Intent intent = new Intent(INTENT_ACTION);
            intent.putExtra("badge_count", badgeCount);
            intent.putExtra(INTENT_EXTRA_PACKAGENAME, componentName.getPackageName());
            intent.putExtra(INTENT_EXTRA_ACTIVITY_NAME, componentName.getClassName());
            intent.putExtra("badge_vip_count", 0);
            BroadcastHelper.sendDefaultIntentExplicitly(context, intent);
        }
    }

    private void executeBadgeByBroadcast(Context context, ComponentName componentName, int badgeCount) {
        Intent intent = new Intent(SONY_INTENT_ACTION);
        intent.putExtra(SONY_INTENT_EXTRA_PACKAGE_NAME, componentName.getPackageName());
        intent.putExtra(SONY_INTENT_EXTRA_ACTIVITY_NAME, componentName.getClassName());
        intent.putExtra(SONY_INTENT_EXTRA_MESSAGE, String.valueOf(badgeCount));
        intent.putExtra(SONY_INTENT_EXTRA_SHOW_MESSAGE, badgeCount > 0);
        context.sendBroadcast(intent);
    }

    @Override
    public List<String> getSupportLaunchers() {
        return Arrays.asList("com.asus.launcher");
    }

    @TargetApi(value=11)
    private void executeBadgeByContentProvider(Context context, ComponentName componentName, int badgeCount) {
        if (badgeCount < 0) {
            return;
        }
        ContentValues contentValues = this.createContentValues(badgeCount, componentName);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            if (this.mQueryHandler == null) {
                this.mQueryHandler = new AsyncQueryHandler(context.getApplicationContext().getContentResolver()){};
            }
            this.insertBadgeAsync(contentValues);
        } else {
            this.insertBadgeSync(context, contentValues);
        }
    }

    private void insertBadgeAsync(ContentValues contentValues) {
        this.mQueryHandler.startInsert(0, null, this.mUri, contentValues);
    }

    private void insertBadgeSync(Context context, ContentValues contentValues) {
        context.getApplicationContext().getContentResolver().insert(this.mUri, contentValues);
    }

    private ContentValues createContentValues(int badgeCount, ComponentName componentName) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("badge_count", Integer.valueOf(badgeCount));
        contentValues.put(PROVIDER_COLUMNS_PACKAGE_NAME, componentName.getPackageName());
        contentValues.put(PROVIDER_COLUMNS_ACTIVITY_NAME, componentName.getClassName());
        return contentValues;
    }

    private static boolean asusBadgeContentProviderExists(Context context) {
        boolean exists = false;
        ProviderInfo info = context.getPackageManager().resolveContentProvider(ASUS_LAUNCHER_PROVIDER_NAME, 0);
        if (info != null) {
            exists = true;
        }
        return exists;
    }
}

