/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.badger;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.badger.Badger;
import com.yy.appbase.badger.ShortcutBadgeException;
import com.yy.appbase.badger.impl.AdwHomeBadger;
import com.yy.appbase.badger.impl.ApexHomeBadger;
import com.yy.appbase.badger.impl.AsusHomeBadger;
import com.yy.appbase.badger.impl.DefaultBadger;
import com.yy.appbase.badger.impl.EverythingMeHomeBadger;
import com.yy.appbase.badger.impl.HuaweiHomeBadger;
import com.yy.appbase.badger.impl.NewHtcHomeBadger;
import com.yy.appbase.badger.impl.NovaHomeBadger;
import com.yy.appbase.badger.impl.OPPOHomeBader;
import com.yy.appbase.badger.impl.SamsungHomeBadger;
import com.yy.appbase.badger.impl.SonyHomeBadger;
import com.yy.appbase.badger.impl.TranssionHomeBadger;
import com.yy.appbase.badger.impl.VivoHomeBadger;
import com.yy.appbase.badger.impl.XiaoMiHomeBadger;
import com.yy.appbase.badger.impl.YandexLauncherBadger;
import com.yy.appbase.badger.impl.ZTEHomeBadger;
import com.yy.appbase.badger.impl.ZukHomeBadger;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class ShortcutBadger {
    private static final String TAG = "ShortcutBadger";
    private static final List<Class<? extends Badger>> BADGERS = new LinkedList<Class<? extends Badger>>();
    private static Reference<Notification> sCurrentNotificationRef = null;
    private static Badger sShortcutBadger;
    private static ComponentName sComponentName;

    public static void setCurrentNotification(@NonNull Notification notification) {
        MLog.debug((Object)TAG, (String)"setCurrentNotification", (Object[])new Object[0]);
        sCurrentNotificationRef = new WeakReference<Notification>(notification);
    }

    @Nullable
    public static Notification getCurrentNotification() {
        if (sCurrentNotificationRef != null) {
            Notification n = sCurrentNotificationRef.get();
            MLog.debug((Object)TAG, (String)("getCurrentNotification is not null: " + (n != null)), (Object[])new Object[0]);
            return n;
        }
        return null;
    }

    public static void applyCount(Context context, int badgeCount) {
        YYTaskExecutor.execute(() -> {
            try {
                ShortcutBadger.applyCountOrThrow(context, badgeCount);
            }
            catch (ShortcutBadgeException e) {
                MLog.error((Object)TAG, (String)"applyCount error", (Throwable)e, (Object[])new Object[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyCountOrThrow(Context context, int badgeCount) throws ShortcutBadgeException {
        Class<ShortcutBadger> clazz = ShortcutBadger.class;
        synchronized (ShortcutBadger.class) {
            try {
                boolean launcherReady;
                if (sShortcutBadger == null && !(launcherReady = ShortcutBadger.initBadger(context))) {
                    MLog.debug((Object)TAG, (String)"Unable to execute badge", (Object[])new Object[0]);
                }
                sShortcutBadger.executeBadge(context, sComponentName, badgeCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    public static void removeCount(Context context) {
        ShortcutBadger.applyCount(context, 0);
    }

    @SuppressLint(value={"LoopUsage"})
    private static boolean initBadger(Context context) {
        Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (launchIntent == null) {
            MLog.error((Object)TAG, (String)("Unable to find launch intent for package " + context.getPackageName()), (Object[])new Object[0]);
            return false;
        }
        sComponentName = launchIntent.getComponent();
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        List resolveInfos = context.getPackageManager().queryIntentActivities(intent, 65536);
        if (!resolveInfos.isEmpty()) {
            ResolveInfo resolveInfoDefault = context.getPackageManager().resolveActivity(intent, 65536);
            ShortcutBadger.validateInfoList(resolveInfoDefault, resolveInfos);
            for (ResolveInfo resolveInfo : resolveInfos) {
                String currentHomePackage = resolveInfo.activityInfo.packageName;
                for (Class<? extends Badger> badger : BADGERS) {
                    Badger shortcutBadger = null;
                    try {
                        shortcutBadger = badger.newInstance();
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                    }
                    if (shortcutBadger == null || !shortcutBadger.getSupportLaunchers().contains(currentHomePackage)) continue;
                    if (!ShortcutBadger.isLauncherVersionSupported(context, currentHomePackage)) break;
                    sShortcutBadger = shortcutBadger;
                    break;
                }
                if (sShortcutBadger == null) continue;
                break;
            }
        }
        if (sShortcutBadger == null) {
            sShortcutBadger = Build.MANUFACTURER.equalsIgnoreCase("ZUK") ? new ZukHomeBadger() : (Build.MANUFACTURER.equalsIgnoreCase("OPPO") ? new OPPOHomeBader() : (Build.MANUFACTURER.equalsIgnoreCase("VIVO") ? new VivoHomeBadger() : (Build.MANUFACTURER.equalsIgnoreCase("ZTE") ? new ZTEHomeBadger() : new DefaultBadger())));
        }
        return true;
    }

    private static boolean isLauncherVersionSupported(Context context, String currentHomePackage) {
        if (!"com.yandex.launcher".equals(currentHomePackage)) {
            return true;
        }
        return YandexLauncherBadger.isVersionSupported(context);
    }

    private static void validateInfoList(ResolveInfo defaultActivity, List<ResolveInfo> resolveInfos) {
        int indexToSwapWith = 0;
        int resolveInfosSize = resolveInfos.size();
        for (int i = 0; i < resolveInfosSize; ++i) {
            ResolveInfo resolveInfo = resolveInfos.get(i);
            String currentActivityName = resolveInfo.activityInfo.packageName;
            if (!currentActivityName.equals(defaultActivity.activityInfo.packageName)) continue;
            indexToSwapWith = i;
        }
        Collections.swap(resolveInfos, 0, indexToSwapWith);
    }

    private ShortcutBadger() {
    }

    static {
        BADGERS.add(AdwHomeBadger.class);
        BADGERS.add(ApexHomeBadger.class);
        BADGERS.add(DefaultBadger.class);
        BADGERS.add(NewHtcHomeBadger.class);
        BADGERS.add(NovaHomeBadger.class);
        BADGERS.add(SonyHomeBadger.class);
        BADGERS.add(AsusHomeBadger.class);
        BADGERS.add(HuaweiHomeBadger.class);
        BADGERS.add(OPPOHomeBader.class);
        BADGERS.add(SamsungHomeBadger.class);
        BADGERS.add(ZukHomeBadger.class);
        BADGERS.add(VivoHomeBadger.class);
        BADGERS.add(ZTEHomeBadger.class);
        BADGERS.add(EverythingMeHomeBadger.class);
        BADGERS.add(YandexLauncherBadger.class);
        BADGERS.add(XiaoMiHomeBadger.class);
        BADGERS.add(TranssionHomeBadger.class);
    }
}

