/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.animation.IScaleViewHolder;
import com.yy.appbase.animation.ViewHelper;
import com.yy.base.utils.FP;
import java.util.List;

public abstract class AnimationAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int SCROLL_UP = 1;
    public static final int SCROLL_DOWN = 2;
    private RecyclerView.Adapter<RecyclerView.ViewHolder> mAdapter;
    private int mDuration = 300;
    private Interpolator mInterpolator = new LinearInterpolator();
    private int mLastPosition = -1;
    private int mStartPosition = -1;
    private boolean isFirstOnly = true;
    private int direction = 2;
    private SparseBooleanArray mPartialUpdateItems = new SparseBooleanArray();

    public AnimationAdapter(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        this.mAdapter = adapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    public void registerAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        super.registerAdapterDataObserver(observer);
        this.mAdapter.registerAdapterDataObserver(observer);
    }

    public void unregisterAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        super.unregisterAdapterDataObserver(observer);
        this.mAdapter.unregisterAdapterDataObserver(observer);
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        this.mAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        this.mAdapter.onViewDetachedFromWindow(holder);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, @SuppressLint(value={"RecyclerView"}) int position) {
        this.mAdapter.onBindViewHolder(holder, position);
        if (position > this.mLastPosition) {
            this.direction = 2;
        } else if (position < this.mLastPosition) {
            this.direction = 1;
        }
        this.mLastPosition = position;
        int adapterPosition = holder.getAdapterPosition();
        if (adapterPosition > this.mStartPosition) {
            if (!this.mPartialUpdateItems.get(position, false)) {
                if (holder instanceof IScaleViewHolder && !((IScaleViewHolder)holder).supportScale()) {
                    return;
                }
                Object[] animators = this.getAnimatorValuesHolders(holder.itemView, this.direction);
                if (!FP.empty((Object[])animators)) {
                    ObjectAnimator anim2 = ObjectAnimator.ofPropertyValuesHolder((Object)holder.itemView, (PropertyValuesHolder[])animators);
                    anim2.setInterpolator((TimeInterpolator)this.mInterpolator);
                    anim2.setDuration((long)this.mDuration).start();
                }
            }
            if (this.isFirstOnly) {
                this.mStartPosition = adapterPosition;
            }
        } else {
            ViewHelper.clear(holder.itemView);
        }
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull List<Object> payloads) {
        this.mPartialUpdateItems.put(position, !payloads.isEmpty());
        if (!FP.empty(payloads)) {
            this.mAdapter.onBindViewHolder(holder, position, payloads);
        } else {
            super.onBindViewHolder(holder, position, payloads);
        }
        this.mPartialUpdateItems.put(position, false);
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        this.mAdapter.onViewRecycled(holder);
        super.onViewRecycled(holder);
    }

    public int getItemCount() {
        return this.mAdapter.getItemCount();
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setStartPosition(int start) {
        this.mStartPosition = start;
    }

    public void resetLastPosition() {
        this.mLastPosition = -1;
    }

    @Nullable
    protected abstract Animator[] getAnimators(View var1, int var2);

    @Nullable
    protected abstract PropertyValuesHolder[] getAnimatorValuesHolders(View var1, int var2);

    public void setFirstOnly(boolean firstOnly) {
        this.isFirstOnly = firstOnly;
    }

    public int getItemViewType(int position) {
        return this.mAdapter.getItemViewType(position);
    }

    public RecyclerView.Adapter<RecyclerView.ViewHolder> getWrappedAdapter() {
        return this.mAdapter;
    }

    public long getItemId(int position) {
        return this.mAdapter.getItemId(position);
    }
}

