/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.account.accountsync;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.yy.appbase.account.accountsync.Constant;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.AccountAsyncConfig;
import com.yy.base.utils.DateUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class AccountHelp {
    public static void addCount(Context context) {
        AccountManager accountManager = (AccountManager)context.getSystemService("account");
        Account[] accounts = accountManager.getAccountsByType(Constant.ACCOUNT.TYPE.getDesc());
        if (accounts.length > 0) {
            return;
        }
        Account account = new Account(Constant.ACCOUNT.NAME.getDesc(), Constant.ACCOUNT.TYPE.getDesc());
        accountManager.addAccountExplicitly(account, Constant.ACCOUNT.PASSWORD.getDesc(), new Bundle());
    }

    public static void autoSync() {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.ACCOUNT_ASYNC_TIME);
        long accountSyncTime = 86400L;
        if (config != null && config instanceof AccountAsyncConfig) {
            accountSyncTime = ((AccountAsyncConfig)config).getAccountAsyncTime();
        }
        Account account = new Account(Constant.ACCOUNT.NAME.getDesc(), Constant.ACCOUNT.TYPE.getDesc());
        ContentResolver.setIsSyncable((Account)account, (String)"com.yy.account.hago.provider", (int)1);
        ContentResolver.setSyncAutomatically((Account)account, (String)"com.yy.account.hago.provider", (boolean)true);
        ContentResolver.addPeriodicSync((Account)account, (String)"com.yy.account.hago.provider", (Bundle)new Bundle(), (long)accountSyncTime);
    }

    public static void accountTract(int syncCount) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("ifield", syncCount);
        statContent.put("sfield", DateUtils.getNow());
        statContent.put("sfieldtwo", Build.MODEL);
        statContent.put("perftype", "account_sync");
        HiidoStatis.reportContent((StatisContent)statContent);
    }
}

