/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.abtest;

import android.content.Context;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.abtest.ABConfig;
import com.yy.appbase.abtest.IUserAbTestService;
import com.yy.appbase.abtest.UserAbTest;
import com.yy.appbase.abtest.oldab.OAB;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkChangeListener;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.ihago.rec.srv.home.GetGrayReq;
import net.ihago.rec.srv.home.GetGrayRes;
import net.ihago.rec.srv.home.GrayConfig;

public class UserAbTestController
extends DefaultController
implements IUserAbTestService {
    private static final String TAG = "UserAbTestController";
    private final Map<String, ABConfig> userAbMap = new ConcurrentHashMap<String, ABConfig>();
    private final List<ICommonCallback<Map<String, ABConfig>>> callbacks = new CopyOnWriteArrayList<ICommonCallback<Map<String, ABConfig>>>();
    private boolean isFinish = false;
    private RetryTask retryTask = new RetryTask();
    private Runnable retryRunnable = new Runnable(){

        @Override
        public void run() {
            if (AccountUtil.getUid() > 0L) {
                UserAbTestController.this.requestUserAbTest();
            }
        }
    };

    public UserAbTestController(Environment env) {
        super(env);
        for (String abTest : UserAbTest.userAbTestKeys) {
            this.userAbMap.put(abTest, ABConfig.obtain(abTest, OAB.A, OAB.B));
        }
        this.retryTask.setTask(this.retryRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAccountChange() {
        if (AccountUtil.getUid() <= 0L) {
            HiidoStatis.removeAbTestFlag((String[])UserAbTest.userAbTestKeys);
            Map<String, ABConfig> map = this.userAbMap;
            synchronized (map) {
                for (ABConfig abConfig : this.userAbMap.values()) {
                    abConfig.setTestAndSave(null);
                }
            }
            this.isFinish = false;
            this.retryTask.reset();
        } else {
            this.requestUserAbTest();
        }
    }

    @Override
    public void requestUserAbTest() {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        if (this.isFinish) {
            return;
        }
        GetGrayReq getGrayReq = new GetGrayReq.Builder().Names(Arrays.asList(UserAbTest.userAbTestKeys)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getGrayReq, (IProtoCallback)new IProtoCallback<GetGrayRes>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NonNull GetGrayRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)UserAbTestController.TAG, (String)"requestUserAbTest message:%b, code:%d, msg:%s", (Object[])new Object[]{message != null, code, msg});
                if (message != null && ProtoManager.isSuccessCode((long)code)) {
                    List configList = message.Configs;
                    if (configList != null && !configList.isEmpty()) {
                        for (GrayConfig config : configList) {
                            if (config == null) continue;
                            String group2 = config.Group;
                            String name = config.Name;
                            MLog.info((Object)UserAbTestController.TAG, (String)"requestUserAbTest name:%s, group:%s", (Object[])new Object[]{name, group2});
                            if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)group2)) continue;
                            HiidoStatis.putAbTestFlag((String)name, (String)group2);
                            Map map = UserAbTestController.this.userAbMap;
                            synchronized (map) {
                                ABConfig config1 = (ABConfig)((Object)UserAbTestController.this.userAbMap.get(config.Name));
                                if (config1 != null) {
                                    config1.setTestAndSave(OAB.create(group2));
                                }
                            }
                        }
                    }
                    for (ICommonCallback callback : UserAbTestController.this.callbacks) {
                        callback.onSuccess(UserAbTestController.this.userAbMap, new Object[0]);
                    }
                    UserAbTestController.this.isFinish = true;
                } else {
                    for (ICommonCallback callback : UserAbTestController.this.callbacks) {
                        callback.onFail(-1, "http response not valid!!!", new Object[0]);
                    }
                }
                if (!UserAbTestController.this.isFinish) {
                    UserAbTestController.this.retryTask.retry();
                } else {
                    UserAbTestController.this.retryTask.finish();
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)UserAbTestController.TAG, (String)"requestUserAbTest retryWhenTimeout", (Object[])new Object[0]);
                for (ICommonCallback callback : UserAbTestController.this.callbacks) {
                    callback.onFail(-2, "retryWhenTimeout!!!", new Object[0]);
                }
                if (!UserAbTestController.this.isFinish) {
                    UserAbTestController.this.retryTask.retry();
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)UserAbTestController.TAG, (String)"requestUserAbTest retryWhenError, reason:%s, code:%d", (Object[])new Object[]{reason, code});
                for (ICommonCallback callback : UserAbTestController.this.callbacks) {
                    callback.onFail(-3, "retryWhenError!!!", new Object[0]);
                }
                if (!UserAbTestController.this.isFinish) {
                    UserAbTestController.this.retryTask.retry();
                }
                return false;
            }
        });
    }

    @Override
    public ABConfig getAbTest(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        return this.userAbMap.get(key);
    }

    @Override
    public void registerCallback(ICommonCallback<Map<String, ABConfig>> callback) {
        if (callback != null && !this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    @Override
    public void unRegisterCallback(ICommonCallback<Map<String, ABConfig>> callback) {
        if (callback != null) {
            this.callbacks.remove(callback);
        }
    }

    @Override
    public boolean isFinish() {
        return this.isFinish;
    }

    public static final class RetryTask {
        private static final int DEFAULT_MAX_RETRY = 3;
        private int mCurrentRetry = 0;
        private int mMaxRetryTime = 3;
        private Runnable task;
        private NetworkChangeListener netWorkListener = new NetworkChangeListener(){

            public void onChange(int networkTyp, NetworkInfo info) {
                if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    NetworkUtils.removeNetworkChangeListener((NetworkChangeListener)this);
                    this.retry();
                }
            }
        };

        public void retry() {
            if (this.mCurrentRetry > this.mMaxRetryTime) {
                return;
            }
            if (this.task != null) {
                if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    ++this.mCurrentRetry;
                    this.task.run();
                } else {
                    NetworkUtils.addNetworkChangeListener((NetworkChangeListener)this.netWorkListener);
                }
            }
        }

        public void reset() {
            this.mCurrentRetry = 0;
        }

        public void finish() {
            NetworkUtils.removeNetworkChangeListener((NetworkChangeListener)this.netWorkListener);
        }

        public void setMaxRetryTime(int mMaxRetryTime) {
            this.mMaxRetryTime = mMaxRetryTime;
        }

        public void setTask(Runnable task2) {
            this.task = task2;
        }
    }
}

